 .TITLE	"banner 1.0"

;****************************************************************************
;*		Banner 1.0 - Scrolling led display software                 *
;*			Copyright 12/1997 by Mario Prato     		    *
;*			   E-Mail mprato@iqsnet.it			    *
;****************************************************************************



;****************************************************************************
; Hardware description:
;
; Micro Z80A  clock 4MHz
; Rom   27C64 0000h-1FFFh (8  Kbytes)
; Ram   62256 8000h-FFFFh (32 Kbytes)
;
; output port
; bits 7 6 5 4 3 2 1 0
;      | | | | | | | |___ rs232 out
;      | | | | | | |_____ m5450 clock
;      | | | | | |_______ m5450 data1
;      | | | | |_________ m5450 data2
;      | | | |___________ row 0
;      | | |_____________ row 1
;      | |_______________ row 2
;      |_________________ not connected
;
; input port
; bits 7 6 5 4 3 2 1 0
;      | | | | | | | |___ rs232 input
;      | | | | | | |_____ dip switch 
;      | | | | | |	  connect to ground to enter programming mode
;      | | | | | |_______ not connected
;      | | | | |_________ not connected
;      | | | |___________ not connected
;      | | |_____________ not connected
;      | |_______________ not connected
;      |_________________ not connected
;
;
;****************************************************************************


 .ORG	0000h			; Start of ROM

;****************************************************************************
; Equ's and variables

stack		.EQU	60000
port		.EQU	1			; i/o port address
mem1		.EQU	65000
ibuf		.EQU	33000			; text loading area	
refresh		.EQU	550			; refresh delay time
velocita	.EQU	1			; scrolling speed
repeat		.EQU	1
rit232		.EQU	10			; delay time for 9600 bps rx
rit232_1	.EQU	11			; delay time for 9600 bps tx

;****************************************************************************


reset				; power-up reset
	ld	sp,stack	; for 32k of ram
	
	ld	ix,mem1		; reset of display buffer
	ld	b,50
	ld	a,0
reset1
	ld	(ix),a
	inc	ix
	djnz	reset1
	call	out54

	in	a,(port)	; check dip switch
	bit	1,a		; if closed jump to configure
	jr	nz,startloop 	; if not, start scrolling

	call	rx232		; wait for a char
	call	help		; print out command's help
	jp	vcommand	; jump to command selection


startloop
	ld	iy,ibuf		; start of text aera
loop	ld	a,(iy)		; load the char
	cp	'#'		; check if is a command
	jp	z,command
	inc	iy		; inc char pointer
	call	sendchar	; send to display buffer
	jp	loop		; endless loop	


;****************************************************************************

command				; commands select
	inc	iy		; load command after #
	ld	a,(iy)
	set	5,a		; make lowercase
	cp	'b'
	jp	z,blinkbuf	; blink
	cp	'n'
	jp	z,negbuf    	; negative blinking
	cp	'h'
	jp	z,haltbuf	; stop the scroll

	cp	'e'
	jp	z,reset		; start over
	jp	loop

;****************************************************************************

negbuf				; negative blinking
	ld	b,10
negbuf2
	push	bc		; save bc
	ld	ix,mem1		; start of display buffer
	ld	b,50		; number of columns
	ld	a,0
negbuf1	
	ld	a,(ix)		; load byte
	xor	255		; negate all bits
	ld	(ix),a		; store
	inc	ix
	djnz	negbuf1
	ld	b,20		; refresh loops
negbuf3
	push	bc
	call	out54
	pop	bc
	djnz	negbuf3		; refresh loop
	pop	bc
	djnz	negbuf2		; repeat 10 times
	inc	iy
	jp	loop

;****************************************************************************

blinkbuf			; make 10 blink on display
	ld	b,10
blinkbuf2
	push	bc
	ld	hl,40000	; delay loop
	call	delay_1	
	ld	b,20		; refresh loop
blinkbuf3
	push	bc
	call	out54
	pop	bc
	djnz	blinkbuf3
	pop	bc
	djnz	blinkbuf2
	inc	iy	
	jp	loop
	
	

;****************************************************************************

haltbuf				;stop the scroll
	ld	b,100
haltbuf1
	push	bc
	call	out54
	pop	bc
	djnz	haltbuf1
	inc	iy 
	jp	loop

;****************************************************************************

sendchar			; take a character and send it to display buffer
     	sub     32       	; convert from ascii
	ret	c
	ld	b,6		; 6 columns
	ld	h,0
	ld	l,a	
	push	hl
	pop	de		; de = hl
	add	hl,de
	add	hl,de
	add	hl,de
	add	hl,de
	add	hl,de		; de=de*6
	ld	de,table	; add result to start of char table 
	add	hl,de		; now hl contains the address of current char
sendchar_1
	ld	a,(hl)
	ld	(mem1),a
	push	af
	push	hl	
	push	bc
	ld	b,repeat
sendchar_2
	push	bc
	call	out54
	pop	bc
	djnz	sendchar_2
	call	delay		; scrooling speed
	call	shift
	pop	bc
	pop	hl
	pop	af
	inc	hl
	djnz	sendchar_1
	ret

;****************************************************************************

shift				; shift character buffer 
	ld	hl,mem1+49	; start of buffer
	ld	de,mem1+48  	; start of buffer - 1
	ld	b,49		; n. of byte to be shifted
shift_1
	ld	a,(de)		; load byte
	ld	(hl),a		; and store it
	dec	hl
	dec	de
	djnz	shift_1		; loop until finished
	ret

;****************************************************************************
	
res54	; reset m5450's outputs

	ld	a,01111110b	;data=1, clock=1
	out 	(port),a
	ld	a,01111100b	;data=1, clock=0
	out	(port),a
	ld	b,36		
res54_1 
	ld	a,01110010b	;data=0, clock=1
	out	(port),a	
	ld	a,01110000b	;data=0, clock=0
	out	(port),a
	djnz	res54_1
	ret

;****************************************************************************	

out54	;multiplex led outputs
	ld	c,0		; row counter
	ld	d,00000001b	; bit mask   \00000001b
rowsend				; send all a row
				; start bit
	ld	b,25		; counter
	ld	ix,mem1		; memory space for m5450 n.1
	
				; all rows off
	ld	a,01111110b	; data=1, clock=1
	out 	(port),a
	ld	a,01111100b	; data=1, clock=0
	out	(port),a
rowsend_2
	ld	e,01110010b	; initial value out port
	ld	a,(ix)		; m5450 1
	and	d
	jr	z,out54_1 	; bit = 0		
	set	2,e		
out54_1	
	ld	a,(ix+25)	; m5450 2
	and	d
	jr	z,out54_2	; bit = 0
	set	3,e
out54_2	
	ld	a,e		; send data
	out	(port),a	
	res	1,a		; clock falling edge
	out	(port),a
	inc 	ix
	djnz	rowsend_2

	ld	b,11
out54_4	
	ld	a,01110010b	; send data
	out	(port),a	
	ld	a,01110000b	; clock falling edge 
	out	(port),a
	djnz	out54_4

	ld	a,c
	rla		
	rla
	rla
	rla
	out	(port),a	; turn on the row 
	call	pause		; wait some time
	ld	a,d
	rlca	
	ld	d,a
        ld      a,01110000b
	out	(port),a	; turn off row
	
	inc	c
	ld	a,c
	cp	7
	ret	z		
	jp	rowsend

;****************************************************************************

pause		; make a pause
	ld	hl,refresh
	jp	delay_1

;****************************************************************************

delay		; make a delay (what difference between pause and delay?)
	ld	hl,velocita
delay_1
	dec	hl
	ld	a,h
	or	l
	jr	nz,delay_1
	ret

;****************************************************************************

rx232			; Get one byte from RS232 
	push	hl			
	push	de
	push	bc
	ld	hl,rit232		; delay 
	ld	b,8			; number of bits 
rx1	call	sample			; get in port status
	jr	c,rx1			; jump if low
	push	hl			 
	ld	hl,rit232/2		; get a sample in the middle 
	call	ritardo			; wait 
	pop	hl			 
	call	sample			 
	jr	c,rx1			; jump if not start bit
rx2	call	ritardo			 
	call	sample			 
	rr	c			 
	djnz	rx2			 
	ld	hl,rit232/2		 
	call	ritardo			
	ld	a,c			; return byte 
	pop	bc			 
	pop	de
	pop	hl
	ret
sample
	in	a,(port)		 
	and	01h			; check input port bit
	scf				; set carry if zero
	ret	z			 
	ccf				
	ret


;****************************************************************************

tx232				; send a byte from Rs232
	push	hl			
	push	de
	push	bc
	
	ld	c,a			; save value
	ld	hl,rit232_1		 
;	call	ritardo			 
;	call	ritardo			 
	ld	b,11			
	xor	a			
	call	outb			 
	call	ritardo			 
tx2
	scf				 
	rr	c			 
	call	outb			
	call	ritardo			 
	djnz	tx2			 
	pop	bc			 
	pop	de
	pop	hl
	ret

outb	jr	c,outb1
	ld	a,01110001b		; High
	jr	outb2
outb1
	ld	a,01110000b		; Low
outb2
	out     (port),a                ; output the bit
	ret

;****************************************************************************

ritardo
	; kill time, value in hl
	; approx time is 6.5*hl	micro-seconds for 4 mhz	clock
	push	hl			; save hl
	push	af			; save a
rit1
	dec	hl			; dec the count
	ld	a,l			; get l
	or	h			; or with h
	jr	nz,rit1		; loop till both are zero
	pop	af			; restore a
	pop	hl			; restore hl
	ret

;****************************************************************************

crlf			; send cr + lf
	ld	a,10	;lf
	call	tx232
	ld	a,13	;cr
	call	tx232
	ret			

;****************************************************************************

help			; send help text
	ld	hl,helptext
	call	sendtext
	ret

;****************************************************************************

vcommand		;riceve un comando dalla seriale
	call	rx232
	set	5,a	; traslate all in lowercase
	cp	'h'	; help message
	jr	nz,vcm1
	call	help
	jr	vcommand
vcm1	cp	'c'	; Upload
	jr	nz,vcm2
	call	carica
	jr	vcommand
vcm2	cp	's'	; download
	jr	nz,vcm3
	call	scarica
	jr	vcommand
vcm3	cp	'r'	; reset
	jr	nz,vcm4
	jp	startloop
vcm4	call	error
	jp	vcommand
	
;****************************************************************************

carica			; load text into backed-up memory
	ld	hl,caricatext
	call	sendtext
carica4 
	ld	hl,ibuf
carica1
	call	rx232
	ld	(hl),a
	cp	'#'
	jr	z,carica2
	inc	hl
	jr	carica1	
carica2
	call	rx232
	inc	hl
	ld	(hl),a
	inc	hl
	cp	'e'		;end of file		
	jr	nz,carica1

	ld	hl,caricatext1
	call	sendtext
	ret


;****************************************************************************

scarica			;send text over serial line
	call	crlf
	ld	hl,ibuf
scarica1
	ld	a,(hl)
	cp	'#'
	jr	z,scarica2
	call	tx232
	inc	hl
	jr	scarica1	
scarica2
	call	tx232
	inc	hl
	ld	a,(hl)
	cp	'e'		; end of file		
	jr	nz,scarica1
	call	tx232		; end of file
	ret

;****************************************************************************

error		; error message
	ld	hl,errortext
	call	sendtext
	ret

;****************************************************************************

sendtext	; send a text strings
	call	crlf
sendtext2
	ld	a,(hl)
	cp	0		; check if it's the end
	jr	z,sendtext1
	call	tx232		; send text over serial line
	inc	hl
	jr	sendtext2
sendtext1
	call	crlf
	ret
;****************************************************************************

errortext
	.text	"Error ! " 
	.byte 0

caricatext
	.text	"Ready to receive text..."
	.byte	0

caricatext1
	.text	"Text loaded."
	.byte	0

iibuf 	; old strings used during tune-up of system, please leave it
	; during compilation! thanks.
	.text 	"Autoscuola IL VOLANTE#b"
	.text 	"1234567890#n"
	.text 	"ABCDEFGHILMNOPQRSTUVZXYW"
	.text	"abcdefghilmnopqrstuvzyxw"
	.text 	"**** Autoscuola IL VOLANTE #h****"
	.text	"**** Auguri di Buon Natale e Felice Anno Nuovo"              #e"

helptext		; strings used to help users

	.text	"Commands:" 
	.byte 10 
	.byte 13
	.text	"R) Reset" 
	.byte 10 
	.byte 13
	.text	"H) Help" 
	.byte 10 
	.byte 13
	.text	"S) Download text" 
	.byte 10 
	.byte 13
	.text	"C) Upload text" 
	.byte 10 
	.byte 13
	
	.byte 0	

table	; here starts the character table
	; about a day of work without any errors!
	; same character set of Hitachi's LCD displays

; space  
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
	
; !
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   01001111b
     .byte   00000000b
     .byte   00000000b

; "
     .byte   00000000b
     .byte   00000000b
     .byte   00000111b
     .byte   00000000b
     .byte   00000111b
     .byte   00000000b

; #
     .byte   00000000b
     .byte   00010100b
     .byte   01111111b
     .byte   00010100b
     .byte   01111111b
     .byte   00010100b

; $
     .byte   00000000b
     .byte   00100100b
     .byte   00101010b
     .byte   01111111b
     .byte   00101010b
     .byte   00010010b

; %
     .byte   00000000b
     .byte   00100011b
     .byte   00010011b
     .byte   00001000b
     .byte   01100100b
     .byte   01100010b

; &
     .byte   00000000b
     .byte   00110110b
     .byte   01001001b
     .byte   01010101b
     .byte   00100010b
     .byte   01010000b

; '
     .byte   00000000b
     .byte   00000000b
     .byte   00000101b
     .byte   00000011b
     .byte   00000000b
     .byte   00000000b

; (
     .byte   00000000b
     .byte   00000000b
     .byte   00011100b
     .byte   00100010b
     .byte   01000001b
     .byte   00000000b

; )
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   00100010b
     .byte   00011100b
     .byte   00000000b

; *
     .byte   00000000b
     .byte   00010100b
     .byte   00001000b
     .byte   00111110b
     .byte   00001000b
     .byte   00010100b

; +
     .byte   00000000b
     .byte   00001000b
     .byte   00001000b
     .byte   00111110b
     .byte   00001000b
     .byte   00001000b

; ,
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   01010000b
     .byte   00110000b
     .byte   00000000b

; -
     .byte   00000000b
     .byte   00001000b
     .byte   00001000b
     .byte   00001000b
     .byte   00001000b
     .byte   00001000b

; .
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   01100000b
     .byte   01100000b
     .byte   00000000b

; /
     .byte   00000000b
     .byte   00100000b
     .byte   00010000b
     .byte   00001000b
     .byte   00000100b
     .byte   00000010b
   
; 0
     .byte   00000000b
     .byte   00111110b
     .byte   01010001b
     .byte   01001001b
     .byte   01000101b
     .byte   00111110b

; 1
     .byte   00000000b
     .byte   00000000b
     .byte   01000010b
     .byte   01111111b
     .byte   01000000b
     .byte   00000000b

; 2
     .byte   00000000b
     .byte   01000010b
     .byte   01100001b
     .byte   01010001b
     .byte   01001001b
     .byte   01000110b

; 3
     .byte   00000000b
     .byte   00100001b
     .byte   01000001b
     .byte   01000101b
     .byte   01001011b
     .byte   00110001b

; 4
     .byte   00000000b
     .byte   00011000b
     .byte   00010100b
     .byte   00010010b
     .byte   01111111b
     .byte   00010000b

; 5
     .byte   00000000b
     .byte   00100111b
     .byte   01000101b
     .byte   01000101b
     .byte   01000101b
     .byte   00111001b

; 6
     .byte   00000000b
     .byte   00111100b
     .byte   01001010b
     .byte   01001001b
     .byte   01001001b
     .byte   00110000b

; 7
     .byte   00000000b
     .byte   00000001b
     .byte   00000001b
     .byte   01111001b
     .byte   00000101b
     .byte   00000011b

; 8
     .byte   00000000b
     .byte   00110110b
     .byte   01001001b
     .byte   01001001b
     .byte   01001001b
     .byte   00110110b

; 9
     .byte   00000000b
     .byte   00000110b
     .byte   01001001b
     .byte   01001001b
     .byte   00101001b
     .byte   00011110b

; :
     .byte   00000000b
     .byte   00000000b
     .byte   00110110b
     .byte   00110110b
     .byte   00000000b
     .byte   00000000b

; ;
     .byte   00000000b
     .byte   00000000b
     .byte   01010110b
     .byte   00110110b
     .byte   00000000b
     .byte   00000000b

; <
     .byte   00000000b
     .byte   00001000b
     .byte   00010100b
     .byte   00100010b
     .byte   01000001b
     .byte   00000000b

; =
     .byte   00000000b
     .byte   00010100b
     .byte   00010100b
     .byte   00010100b
     .byte   00010100b
     .byte   00010100b

; >
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   00100010b
     .byte   00010100b
     .byte   00001000b

; ?
     .byte   00000000b
     .byte   00000010b
     .byte   00000001b
     .byte   01010001b
     .byte   00001001b
     .byte   00000110b

; @
     .byte   00000000b
     .byte   00110010b
     .byte   01001001b
     .byte   01001001b
     .byte   01111001b
     .byte   00111110b

; A
     .byte   00000000b
     .byte   01111110b
     .byte   00010001b
     .byte   00010001b
     .byte   00010001b
     .byte   01111110b

; B
     .byte   00000000b
     .byte   01000001b
     .byte   01111111b
     .byte   01001001b
     .byte   01001001b
     .byte   00110110b

; C
     .byte   00000000b
     .byte   00111110b
     .byte   01000001b
     .byte   01000001b
     .byte   01000001b
     .byte   00100010b

; D
     .byte   00000000b
     .byte   01000001b
     .byte   01111111b
     .byte   01000001b
     .byte   01000001b
     .byte   00111110b

; E
     .byte   00000000b
     .byte   01111111b
     .byte   01001001b
     .byte   01001001b
     .byte   01001001b
     .byte   01001001b

; F
     .byte   00000000b
     .byte   01111111b
     .byte   00001001b
     .byte   00001001b
     .byte   00001001b
     .byte   00000001b

; G
     .byte   00000000b
     .byte   00111110b
     .byte   01000001b
     .byte   01000001b
     .byte   01001001b
     .byte   01111010b

; H
     .byte   00000000b
     .byte   01111111b
     .byte   00001000b
     .byte   00001000b
     .byte   00001000b
     .byte   01111111b

; I
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   01111111b
     .byte   01000001b
     .byte   00000000b

; J
     .byte   00000000b
     .byte   00100000b
     .byte   01000000b
     .byte   01000001b
     .byte   00111111b
     .byte   00000001b

; K
     .byte   00000000b
     .byte   01111111b
     .byte   00001000b
     .byte   00010100b
     .byte   00100010b
     .byte   01000001b

; L
     .byte   00000000b
     .byte   01111111b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b

; M
     .byte   00000000b
     .byte   01111111b
     .byte   00000010b
     .byte   00001100b
     .byte   00000010b
     .byte   01111111b

; N
     .byte   00000000b
     .byte   01111111b
     .byte   00000110b
     .byte   00001000b
     .byte   00110000b
     .byte   01111111b

; O
     .byte   00000000b
     .byte   00111110b
     .byte   01000001b
     .byte   01000001b
     .byte   01000001b
     .byte   00111110b

; P
     .byte   00000000b
     .byte   01111111b
     .byte   00001001b
     .byte   00001001b
     .byte   00001001b
     .byte   00000110b

; Q
     .byte   00000000b
     .byte   00111110b
     .byte   01000001b
     .byte   01010001b
     .byte   00100001b
     .byte   01011110b

; R
     .byte   00000000b
     .byte   01111111b
     .byte   00001001b
     .byte   00011001b
     .byte   00101001b
     .byte   01000110b

; S
     .byte   00000000b
     .byte   00100110b
     .byte   01001001b
     .byte   01001001b
     .byte   01001001b
     .byte   00110010b

; T
     .byte   00000000b
     .byte   00000001b
     .byte   00000001b
     .byte   01111111b
     .byte   00000001b
     .byte   00000001b

; U
     .byte   00000000b
     .byte   00111111b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b
     .byte   00111111b

; V
     .byte   00000000b
     .byte   00011111b
     .byte   00100000b
     .byte   01000000b
     .byte   00100000b
     .byte   00011111b

; W
     .byte   00000000b
     .byte   01111111b
     .byte   00100000b
     .byte   00011000b
     .byte   00100000b
     .byte   01111111b

; X
     .byte   00000000b
     .byte   01100011b
     .byte   00010100b
     .byte   00001000b
     .byte   00010100b
     .byte   01100011b

; Y
     .byte   00000000b
     .byte   00000111b
     .byte   00001000b
     .byte   01110000b
     .byte   00001000b
     .byte   00000111b

; Z
     .byte   00000000b
     .byte   01100001b
     .byte   01010001b
     .byte   01001001b
     .byte   01000101b
     .byte   01000011b

; [
     .byte   00000000b
     .byte   00000000b
     .byte   01111111b
     .byte   01000001b
     .byte   01000001b
     .byte   00000000b

; \
     .byte   00000000b
     .byte   00000010b
     .byte   00000100b
     .byte   00001000b
     .byte   00010000b
     .byte   00100000b

; ]
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   01000001b
     .byte   01111111b
     .byte   00000000b

; ^
     .byte   00000000b
     .byte   00000100b
     .byte   00000010b
     .byte   00000001b
     .byte   00000010b
     .byte   00000100b

; _
     .byte   00000000b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b
     .byte   01000000b

; `
     .byte   00000000b
     .byte   00000001b
     .byte   00000010b
     .byte   00000100b
     .byte   00000000b
     .byte   00000000b

; a 
     .byte   00000000b
     .byte   00100000b
     .byte   01010100b
     .byte   01010100b
     .byte   01010100b
     .byte   01111000b

; b
     .byte   00000000b
     .byte   01111111b
     .byte   01001000b
     .byte   01000100b
     .byte   01000100b
     .byte   00111000b

; c
     .byte   00000000b
     .byte   00111000b
     .byte   01000100b
     .byte   01000100b
     .byte   01000100b
     .byte   00000000b

; d
     .byte   00000000b
     .byte   00111000b
     .byte   01000100b
     .byte   01000100b
     .byte   01001000b
     .byte   01111111b

; e
     .byte   00000000b
     .byte   00111000b
     .byte   01010100b
     .byte   01010100b
     .byte   01010100b
     .byte   00011000b

; f
     .byte   00000000b
     .byte   00000000b
     .byte   00001000b
     .byte   01111110b
     .byte   00001001b
     .byte   00000010b

; g
     .byte   00000000b
     .byte   00001100b
     .byte   01010010b
     .byte   01010010b
     .byte   01001100b
     .byte   00111110b

; h
     .byte   00000000b
     .byte   01111111b
     .byte   00001000b
     .byte   00000100b
     .byte   00000100b
     .byte   01111000b

; i
     .byte   00000000b
     .byte   00000000b
     .byte   01000100b
     .byte   01111101b
     .byte   01000000b
     .byte   00000000b

; j
     .byte   00000000b
     .byte   00100000b
     .byte   01000000b
     .byte   01000100b
     .byte   00111101b
     .byte   00000000b

; k
     .byte   00000000b
     .byte   00000000b
     .byte   01111111b
     .byte   00010000b
     .byte   00101000b
     .byte   01000100b

; l
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   01111111b
     .byte   01000000b
     .byte   00000000b

; m
     .byte   00000000b
     .byte   01111100b
     .byte   00000100b
     .byte   01111000b
     .byte   00000100b
     .byte   01111000b

; n
     .byte   00000000b
     .byte   01111100b
     .byte   00001000b
     .byte   00000100b
     .byte   00000100b
     .byte   01111000b

; o
     .byte   00000000b
     .byte   00111000b
     .byte   01000100b
     .byte   01000100b
     .byte   01000100b
     .byte   00111000b

; p
     .byte   00000000b
     .byte   01111110b
     .byte   00001100b
     .byte   00010010b
     .byte   00010010b
     .byte   00001100b

; q
     .byte   00000000b
     .byte   00001100b
     .byte   00010010b
     .byte   00010010b
     .byte   00001100b
     .byte   01111110b

; r
     .byte   00000000b
     .byte   01111100b
     .byte   00001000b
     .byte   00000100b
     .byte   00000100b
     .byte   00001000b

; s
     .byte   00000000b
     .byte   01011000b
     .byte   01010100b
     .byte   01010100b
     .byte   01010100b
     .byte   01100100b

; t
     .byte   00000000b
     .byte   00000100b
     .byte   00111111b
     .byte   01000100b
     .byte   01000000b
     .byte   00100000b

; u
     .byte   00000000b
     .byte   00111100b
     .byte   01000000b
     .byte   01000000b
     .byte   00111100b
     .byte   01000000b

; v
     .byte   00000000b
     .byte   00011100b
     .byte   00100000b
     .byte   01000000b
     .byte   00100000b
     .byte   00011100b

; w
     .byte   00000000b
     .byte   00111100b
     .byte   01000000b
     .byte   00110000b
     .byte   01000000b
     .byte   00111100b

; x
     .byte   00000000b
     .byte   01000100b
     .byte   00101000b
     .byte   00010000b
     .byte   00101000b
     .byte   01000100b

; y
     .byte   00000000b
     .byte   00001100b
     .byte   01010000b
     .byte   01010000b
     .byte   01001000b
     .byte   00111100b

; z
     .byte   00000000b
     .byte   01000100b
     .byte   01100100b
     .byte   01010100b
     .byte   01001100b
     .byte   01000100b

; {
     .byte   00000000b
     .byte   00000000b
     .byte   00001000b
     .byte   00110110b
     .byte   01000001b
     .byte   00000000b

; |
     .byte   00000000b
     .byte   00000000b
     .byte   00000000b
     .byte   01110111b
     .byte   00000000b
     .byte   00000000b

; }
     .byte   00000000b
     .byte   00000000b
     .byte   01000001b
     .byte   00110110b
     .byte   00001000b
     .byte   00000000b

; ~
     .byte   00000000b
     .byte   00000010b
     .byte   00000001b
     .byte   00000010b
     .byte   00000100b
     .byte   00000010b



 .END 

