#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <dos.h>
#include <io.h>
#define MAXINST        32768
#define MAX_ADDRESS    16384
#define MAX_DATA       16384
#define COMMENT_INDENT 40
#define ASCII_INDENT   16

static char drive[ _MAX_DRIVE ];
static char dir[ _MAX_DIR ];
static char fname[ _MAX_FNAME ];
static char ext[ _MAX_EXT ];

typedef struct {
        short   type;
        short   size;
        int     opcode,opcodeSize;
        unsigned char     highBitOpCode;
        int     parm1,parm2;
        char    nameStr[10];
        char    parm1Str[10],parm2Str[10];
} INSTRUCTION;

typedef struct {
        char    relocName[20];
        int     relocData;
        int     addrCheck;
} RELOC_ENTRY;

RELOC_ENTRY addrReloc[MAX_ADDRESS];
RELOC_ENTRY dataReloc[MAX_ADDRESS];
static INSTRUCTION insts[MAXINST];
static int  instructionCount;

int  readBrainFile(char *str)
{
        static FILE *file;
        static char buffer[80],*ptr,*tptr,tempStr[10],tmp[10];
        static int  temp,currentInst;

        file=fopen(str,"rt");
        if(file==NULL) return(0);

        currentInst=-1;
        while( fgets(buffer,80,file)!=NULL )
        {
          if(buffer[0]==';' || buffer[0]=='/') continue;
          currentInst++;
          instructionCount++;
          if(currentInst>MAXINST) {
            cprintf("\r\nToo many instructions in BRAINFILE.\r\n");
            return(0);
          }

          ptr=buffer;

          strncpy(tempStr,ptr,10);
          tptr=tempStr;
          while(isxdigit(*tptr)) tptr++;

          ptr=tptr;
          insts[currentInst].size=0;
          insts[currentInst].opcodeSize=0;
          while(toupper(*ptr)=='X') {
            insts[currentInst].size++;
            ptr++;
          }
          if(isxdigit(*ptr)) {  // 32 bit opcode!
            strncpy(tmp,ptr,2);
            tmp[2]=0;
            insts[currentInst].highBitOpCode=(unsigned char)strtol(tmp,NULL,16);
            if(!insts[currentInst].highBitOpCode) {
              cprintf("Invalid 32Bit opcode!\r\n");
              exit(1);
            }
            insts[currentInst].opcodeSize+=2;
          } else insts[currentInst].highBitOpCode=0;

          tptr=0;

          ptr=buffer;
          temp=strtol(tempStr,NULL,16);
          sprintf(tmp,"%X",temp);
          if(strlen(tmp)<4) insts[currentInst].opcodeSize+=2;
          else insts[currentInst].opcodeSize+=4;
          insts[currentInst].size+=insts[currentInst].opcodeSize;
          insts[currentInst].opcode=temp;
          insts[currentInst].type=0;

          while(*ptr!=32 && *ptr!='\r' && *ptr!='\n' && *ptr!=0) ptr++;
          if(*ptr=='\r' || *ptr=='\n' || *ptr==0) continue;
          while(*ptr==32) ptr++;
          strncpy(insts[currentInst].nameStr,ptr,10);
          tptr=insts[currentInst].nameStr;
          while(*tptr!=32 && *tptr!='\r' && *tptr!='\n') tptr++;
          *tptr=0;      // 0-terminate instruction

          insts[currentInst].type=1;

          while(*ptr!=32 && *ptr!='\r' && *ptr!='\n' && *ptr!=0) ptr++;
          if(*ptr=='\r' || *ptr=='\n' || *ptr==0) continue;
          while(*ptr==32) ptr++;
          strncpy(insts[currentInst].parm1Str,ptr,10);
          tptr=insts[currentInst].parm1Str;
          while(*tptr!=',' && *tptr!='\r' && *tptr!='\n' && *tptr!=0 && *tptr!=32) tptr++;
          *tptr=0;      // 0-terminate instruction

          insts[currentInst].type=2;

          while(*ptr!=32 && *ptr!='\r' && *ptr!=',' && *ptr!=0) ptr++;
          if(*ptr=='\r' || *ptr=='\n' || *ptr==0) continue;
          if(*ptr==',') ptr++;
          while(*ptr==32) ptr++;
          strncpy(insts[currentInst].parm2Str,ptr,10);
          tptr=insts[currentInst].parm2Str;
          while(*tptr!=0 && *tptr!=32 && *tptr!='\r' && *tptr!='\n') tptr++;
          *tptr=0;      // 0-terminate instruction

          insts[currentInst].type=3;
        }
        instructionCount--;
        return(1);
}

static char *readBuf;
static char fileName[80],outFile[80],tmpParm1[30],tmpParm2[30];
static char tmpStr[10];
static long fileLen;
static unsigned short thisShortCode;
static unsigned char  thisByteCode,tmpByte,lowArg,highArg,oldCode;
static unsigned char  data8Bit;
static unsigned short data16Bit;
static int  w,p,found,q,orgOffset,o,currentAddr,currentData,fileOff;
static signed char relativeAddr;

int  findDataReloc(int data)
{
        static int s;

        for(s=0;s<currentData;s++)
          if(dataReloc[s].relocData==data) return(s);

        sprintf(dataReloc[currentData].relocName,
                "$%02X",data);
        dataReloc[currentData].relocData=data;
        currentData++;
        return(currentData-1);
}

int  findAddrReloc(int addr)
{
        static int s;

        for(s=0;s<currentAddr;s++)
          if(addrReloc[s].relocData==addr) return(s);

        sprintf(addrReloc[currentAddr].relocName,
                "Lb%d",currentAddr);
        addrReloc[currentAddr].relocData=addr;
        addrReloc[currentAddr].addrCheck=0;
        currentAddr++;
        return(currentAddr-1);
}

static int usedLow8Bit;

void fillParm(char *srcParm,char *dstParm)
{
        static int relocNr;

        memset(dstParm,0,30);
        for(w=o=0;w<strlen(srcParm);w++,o++)
        {
         if(srcParm[w]=='%')
           switch(toupper(srcParm[w+1]))
           {
             case 'D':relocNr=findDataReloc(data8Bit);
                      strcat(&dstParm[o],dataReloc[relocNr].relocName);
                      o+=strlen(dataReloc[relocNr].relocName)-1;
                      usedLow8Bit=1;
                      w++;break;
             case 'A':relocNr=findDataReloc(data16Bit);
                      strcat(&dstParm[o],dataReloc[relocNr].relocName);
                      o+=strlen(dataReloc[relocNr].relocName)-1;
                      w++;break;
             case 'J':relocNr=findAddrReloc(data16Bit);
                      strcat(&dstParm[o],addrReloc[relocNr].relocName);
                      o+=strlen(addrReloc[relocNr].relocName)-1;
                      w++;break;
             case 'R':relativeAddr=(signed char)data8Bit;
                      relocNr=findAddrReloc(orgOffset+insts[q].opcodeSize+relativeAddr);
                      strcat(&dstParm[o],addrReloc[relocNr].relocName);
                      o+=strlen(addrReloc[relocNr].relocName)-1;
                      w++;break;
           }
         else dstParm[o]=srcParm[w];
        }
}

void main(int argc,char *argv[])
{
        FILE *file,*tmpFile;
        static char buf2fer[120],relocWarning;
        static struct dosdate_t dDate;
        static struct dostime_t dTime;

        cprintf("BRAINFILE Disassembler 1.0\r\n");

        if(argc!=2) {
          char drive[_MAX_DRIVE];
          char dir[_MAX_DIR];
          char fname[_MAX_FNAME];
          char ext[_MAX_EXT];

          _splitpath(argv[0],drive,dir,fname,ext);
          cprintf("Usage: %s [INFILE.EXT]\r\n",fname);
          return;
        }
        strcpy(fileName,argv[1]);

        _splitpath(argv[1],drive,dir,fname,ext);
        sprintf(outFile,"%s%s%s.DIS",drive,dir,fname);

        file=fopen(fileName,"rb");
        if(file==NULL) {
          cprintf("Unable to open binary source file [%s].\r\n",fileName);
          return;
        }
        fseek(file,0L,SEEK_END);
        fileLen=ftell(file);
        fseek(file,0L,SEEK_SET);

        readBuf=(char *)malloc(fileLen);
        if(readBuf==NULL) {
          cprintf("Unable to allocate %d bytes readBuffer\r\n",fileLen);
          return;
        }
        fread(readBuf,1,fileLen,file);
        fclose(file);

        file=fopen("$DISASM$.TMP","wt");
        if(file==NULL) {
          cprintf("Unable to open tmpfile for writing.\r\n");
          return;
        }
        cprintf("%d bytes read.\r\n",fileLen);

        cprintf("Reading brainfile...\r");
        if(!readBrainFile("DISASM.BRN")) {
          cprintf("Unable to read BRAIN file DISASM.BRN\r\n");
          return;
        }
        cprintf("\r\n");

        currentAddr=currentData=0;

        cprintf("Disassembling...\r\n");
        oldCode=0;
        for(p=0;p<fileLen;p++)
        {
          relocWarning=0;
          for(w=0;w<currentAddr;w++)
            if(!addrReloc[w].addrCheck || addrReloc[w].addrCheck==2)
            {
              if(addrReloc[w].relocData>p) addrReloc[w].addrCheck=2;
              if(addrReloc[w].relocData<=p && addrReloc[w].addrCheck==2)
              {
                if(p!=addrReloc[w].relocData) relocWarning=1;
                p=addrReloc[w].relocData;
                addrReloc[w].addrCheck=1;
              }
            }
          thisByteCode=(unsigned char )readBuf[p];
          tmpByte=(unsigned char )readBuf[p+1];
          thisShortCode=thisByteCode;
          thisShortCode<<=8;
          thisShortCode|=tmpByte;
          orgOffset=p;

          for(q=found=w=0;q<instructionCount;q++)
          {
            if(insts[q].opcodeSize>2)
            {
              if(insts[q].opcodeSize>4) {
                if(insts[q].opcode==thisShortCode &&
                   insts[q].highBitOpCode==readBuf[p+3])
                {
                  found=1;
                  w=q;
                  break;
                }
              }
              else {
                if(insts[q].opcode==thisShortCode) {
                  found=1;
                  w=q;
                }
              }
            }
            else {
              if(insts[q].opcode==thisByteCode) {
                found=1;
                w=q;
                break;
              }
            }
          }
          if(!found) {
            cprintf("*WARNING* opcode %X NOT found!\r\n",thisByteCode);
            continue;
          }
          q=w;
          if(insts[q].opcode==insts[oldCode].opcode &&
             insts[q].opcode==readBuf[p+2] &&
              (insts[q].opcode==0xFF || !insts[q].opcode))
          {
//          p++;
            continue;
          }
          oldCode=q;

          lowArg=highArg=-1;

          if(insts[q].size!=insts[q].opcodeSize)
          {
            if(insts[q].opcodeSize>2) w=p+2;
            else w=p+1;
            lowArg =readBuf[w++];
            highArg=readBuf[w++];
            data8Bit=lowArg;
            data16Bit=highArg;
            data16Bit<<=8;
            data16Bit|=lowArg;

            usedLow8Bit=0;
            fillParm(insts[q].parm1Str,tmpParm1);
            if(usedLow8Bit) data8Bit=highArg;
            fillParm(insts[q].parm2Str,tmpParm2);
          } else {
            strcpy(tmpParm1,insts[q].parm1Str);
            strcpy(tmpParm2,insts[q].parm2Str);
          }

          fprintf(file,"%08d",p);
          fileOff=ftell(file);

          for(w=0;w<8;w++) fprintf(file," ");

          p+=(insts[q].size/2)-1;
          switch(insts[q].type)
          {
            case 0:
            case 1:fprintf(file,"%-8s",insts[q].nameStr);break;
            case 2:fprintf(file,"%-8s%s",insts[q].nameStr,
                                          tmpParm1);break;
            case 3:fprintf(file,"%-8s%s,%s",insts[q].nameStr,
                                             tmpParm1,
                                             tmpParm2);break;
          }

          if(relocWarning)
          {
            o=ftell(file);
            for(w=0;w<(COMMENT_INDENT-13)-(o-fileOff);w++)
             fprintf(file," ");
            fprintf(file,";**WARNING**");
          }

          o=ftell(file);
          for(w=0;w<COMMENT_INDENT-(o-fileOff);w++)
           fprintf(file," ");

          fileOff=ftell(file);

          fprintf(file,"; ");

          fprintf(file,"%04X ",orgOffset);

          for(w=0;w<(insts[q].size/2);w++)
            fprintf(file,"%02X",(unsigned char)readBuf[orgOffset+w]);

          o=ftell(file);
          for(w=0;w<ASCII_INDENT-(o-fileOff);w++)
           fprintf(file," ");

          for(w=0;w<(insts[q].size/2);w++)
            if(isprint(readBuf[orgOffset+w]))
              fprintf(file,"%c",(unsigned char)readBuf[orgOffset+w]);
            else
              fprintf(file,".");

          fprintf(file,"\n",p);
          if(strnicmp(insts[q].nameStr,"RET",3)==0)
            fprintf(file,"\n");
        }
        fclose(file);

        tmpFile=fopen("$DISASM$.TMP","rt");
        if(file==NULL) {
          cprintf("Unable to open tmpfile for reading.\r\n");
          return;
        }
        file=fopen(outFile,"wt");
        if(file==NULL) {
          cprintf("Unable to open %s writing.\r\n",outFile);
          return;
        }

        for(w=0;w<currentAddr;w++)
          strcat(addrReloc[w].relocName,":");

        _dos_getdate(&dDate);
        _dos_gettime(&dTime);

        fprintf(file,";Ŀ\n");
        fprintf(file,"; DISASSEMBLED FILE - DONE WITH DISASM 1.0 \n");
        fprintf(file,"; Date: %2d-%02d-%04d  Time: %02d:%02d             \n",dDate.day,dDate.month,dDate.year,dTime.hour,dTime.minute);
        fprintf(file,"; (c) 1996 Channex aka Lasse S. Tassing     \n");
        fprintf(file,"; Email: ltassing.ite.dk                    \n");
        fprintf(file,";\n");
        fprintf(file,"\n; [CODE]\n");
        fprintf(file,"; LABEL INSTR.  PARAMETER(s)              ADR/OPCODE    ASCII\n\n");

        while( fgets(buf2fer,120,tmpFile)!=NULL )
        {
          if(strlen(buf2fer)<2) {
            fprintf(file,"\n");
            continue;
          }
          strncpy(tmpStr,buf2fer,8);
          memset(buf2fer,32,15);
          memmove(buf2fer,buf2fer+8,100);
          q=atoi(tmpStr);
          for(w=0;w<currentAddr;w++)
          {
            if(addrReloc[w].relocData==q)
            {
              memcpy(buf2fer,addrReloc[w].relocName,strlen(addrReloc[w].relocName));
              addrReloc[w].relocData=0;
            }
          }
          fprintf(file,"%s",buf2fer);
        }
        for(w=0;w<currentAddr;w++)
        {
          if(addrReloc[w].relocData!=0)
           fprintf(file,"%s\n",addrReloc[w].relocName);
        }

        fclose(file);
        fclose(tmpFile);
        unlink("$DISASM$.TMP");
        cprintf("Done!\r\n");
}
