;F800 BIOS PROM Version 2.0 - 2.1
; 2.1 added fake out in CSTS to make ISIS work with "paste as input" (uses address 0x3c as flag)
; 2.0 created from dissassembly of ISIS boot prom, added IO for emulator
;     added vector for RESTART(breakpoint) and LIST STATUS

; Byte References

B_C8	equ	0C8h	;  'H'+128  -56
B_04	equ	04h	;  4
B_FF	equ	0FFh	;  -1
B_CD	equ	0CDh	;  'M'+128  -51
B_0D	equ	0Dh	;  13
B_41	equ	41h	;  'A'  65
B_02	equ	02h	;  2
B_1A	equ	1Ah	;  26
B_00	equ	00h	;  0
B_3D	equ	3Dh	;  '='  61
B_20	equ	20h	;  ' '  32
B_0F	equ	0Fh	;  15
B_01	equ	01h	;  1
B_D2	equ	0D2h	;  'R'+128  -46
B_E1	equ	0E1h	;  'a'+128  -31
B_E2	equ	0E2h	;  'b'+128  -30
B_C7	equ	0C7h	;  'G'+128  -57
B_3C	equ	3Ch	;  '<'  60
B_3A	equ	3Ah	;  ':'  58
B_0C	equ	0Ch	;  12
B_24	equ	24h	;  '$'  36
B_03	equ	03h	;  3
B_F5	equ	0F5h	;  'u'+128  -11
B_F4	equ	0F4h	;  't'+128  -12
B_CC	equ	0CCh	;  'L'+128  -52
B_F7	equ	0F7h	;  'w'+128  -9
B_F6	equ	0F6h	;  'v'+128  -10
B_13	equ	13h	;  19
B_12	equ	12h	;  18
B_E8	equ	0E8h	;  'h'+128  -24
B_27	equ	27h	;  '''  39
B_28	equ	28h	;  '('  40
B_25	equ	25h	;  '%'  37
B_FA	equ	0FAh	;  'z'+128  -6
B_05	equ	05h	;  5
B_50	equ	50h	;  'P'  80
B_11	equ	11h	;  17
B_10	equ	10h	;  16
B_08	equ	08h	;  8
B_EE	equ	0EEh	;  'n'+128  -18
B_F1	equ	0F1h	;  'q'+128  -15
B_EB	equ	0EBh	;  'k'+128  -21
B_30	equ	30h	;  '0'  48
B_C0	equ	0C0h	;  '@'+128  -64
B_40	equ	40h	;  '@'  64
B_15	equ	15h	;  21
B_14	equ	14h	;  20
B_FD	equ	0FDh	;  '}'+128  -3
B_E9	equ	0E9h	;  'i'+128  -23
B_17	equ	17h	;  23
B_16	equ	16h	;  22
B_18	equ	18h	;  24
B_90	equ	90h	;  -112
B_70	equ	70h	;  'p'  112
B_0A	equ	0Ah	;  10
B_06	equ	06h	;  6
B_07	equ	07h	;  7
B_2C	equ	2Ch	;  ','  44
B_FC	equ	0FCh	;  '|'+128  -4
B_FE	equ	0FEh	;  '~'+128  -2
B_DC	equ	0DCh	;  '\'+128  -36
B_E0	equ	0E0h	;  '`'+128  -32
B_7F	equ	7Fh	;  127
B_61	equ	61h	;  'a'  97
B_7B	equ	7Bh	;  '{'  123
B_DF	equ	0DFh	;  '_'+128  -33
B_C1	equ	0C1h	;  'A'+128  -63
B_F9	equ	0F9h	;  'y'+128  -7
B_F8	equ	0F8h	;  'x'+128  -8

; Displacement References


; Word References
MONITOR	EQU	0F800H
MEMTOP	equ	0004h	;  4
IOBYT	equ	0003h	;  3

W_0002	equ	0002h	;  2
W_0010	equ	0010h	;  16
W_0005	equ	0005h	;  5
W_0000	equ	0000h	;  0
W_000C	equ	000Ch	;  12
W_FF00	EQU	0FF00H; -256

; Unclassified Symbols (read from file)
;   (probably same value as another symbol; or, never used)


; Undefined Label References 
;   (probably from data as program; or, to outside program area)

XTBL	equ	(MONITOR-24)
CILOC	equ	XTBL
COLOC	equ	XTBL+3
R1LOC	equ	XTBL+6
R2LOC	equ	XTBL+9
P1LOC	equ	XTBL+12
P2LOC	equ	XTBL+15
L1LOC	equ	XTBL+18
CSLOC	equ	XTBL+21


DIAGMN	equ	0EB00h	; undefined label

	ORG	MONITOR

	jmp	START0
	jmp	CI
	jmp	RI
	jmp	CO
	jmp	PO
	jmp	LO
	jmp	CSTS
	jmp	IOCHK
	jmp	IOSET
	jmp	MEMCHK
	jmp	IODEF
	jmp	IOCDR1
	DB	003h,001h
	jmp	UI
	jmp	UO
	jmp	UPPS
	DB	013h,'(','C',')','I','N','T'
	DB	'E','L',' ','C','O','R','P'
	DB	'1','9','7','9'
	jmp	IOCCOM
	jmp	IOCDR2
	JMP	RESTART		; jmp at 0000 to here
	JMP	LSTS		;CPM 2.2 list status

ERROR	lhld 	MEMTOP
	mvi	l,B_C8
	sphl
	call	COMC
	DB	'#'

START0	mvi	a,B_04
	out	B_FF
START	ei
	call	CRLF
	call	COMC
	DB	'.'
	CALL	TI
	cpi	B_0D
	jz	START
	sui	B_41
	jm	ERROR
	mvi	c,B_02
	lxi	de,START
	push	de
	lxi	hl,CTBL
	cpi	B_1A
	jp	ERROR
	mov	e,a
	mvi	d,B_00
	dad	de
	dad	de
	mov	a,m
	inx	hl
	mov	h,m
	mov	l,a
	pchl

CTBL	DW	ASSIGN
	DW	ERROR
	DW	ERROR
	DW	DISP
	DW	EOF
	DW	FILL
	DW	GOTO
	DW	HEXN
	DW	ERROR
	DW	ERROR
	DW	ERROR
	DW	ERROR
	DW	MOVE
	DW	NULL
	DW	ERROR
	DW	ERROR
	DW	QUERY
	DW	READ
	DW	SUBS
	DW	ERROR
	DW	ERROR
	DW	ERROR
	DW	WRITE
	DW	X
	DW	ERROR
	DW	Z

ASSIGN	call	TI
	lxi	hl,LTBL
	mvi	c,B_04
AS0	cmp	m
	inx	hl
	jz	AS1
	inx	hl
	inx	hl
	inx	hl
	dcr	c
	jnz	AS0
	jmp	ERROR
AS1	mov	b,m
	inx	hl
	mov	e,m
	inx	hl
	mov	d,m
	xchg	
ALUP1	call	TI
	cpi	B_3D
	jnz	ALUP1
ALUP2	call	TI
	cpi	B_20
	jz	ALUP2
	mvi	c,B_04
AS2	cmp	m
	inx	hl
	jz	AS3
	inx	hl
	dcr	c
	jnz	AS2
	jmp	ERROR
AS3
ALUP3	call	TI
	cpi	B_0D
	jnz	ALUP3
	lda 	IOBYT
	ana	b
	ora	m
	sta	IOBYT
	ret
LTBL	DB	043h,0FCh
	DW	ACT
	DB	052h,0F3h
	DW	ART
	DB	050h,0CFh
	DW	APT
	DB	04Ch,03Fh
	DW	ALT
ACT	DB	054h,000h,043h,001h,042h,002h,031h
	DB	003h
ART	DB	054h,000h,050h,004h,031h,008h,032h
	DB	00Ch
APT	DB	054h,000h,050h,010h,031h,020h,032h
	DB	030h
ALT	DB	054h,000h,043h,040h,04Ch,080h,031h
	DB	0C0h

DISP	call	EXPR
	pop	de
	pop	hl
DI0	call	LCRLF
	call	DADR
DI1	mvi	c,B_20
	call	LOM
	mov	a,m
	call	DBYTE
	call	HILO
	jc	DI2
	mov	a,l
	ani	B_0F
	jnz	DI1
	jmp	DI0
DI2	call	LCRLF
	mvi	c,B_00
	call	LOM
	ret

EOF	dcr	c
	call	EXPR
	call	POC
	DB	':'
	xra	a
	mov	d,a
	call	PBYTE
	pop	hl
	call	PADR
	mvi	a,B_01
	call	PBYTE
	xra	a
	sub	d
	call	PBYTE
	jmp	NU0

FILL	inr	c
	call	EXPR
	pop	bc
	pop	de
	pop	hl
FI0	mov	m,c
	call	HILO
	jnc	FI0
	ret

GOTO	lhld 	MEMTOP
	mvi	l,B_D2
	xthl
	call	PCHK
	jz	GO0
	call	PA0
	xchg	
	lhld 	MEMTOP
	mvi	l,B_E1
	mov	m,d
	dcx	hl
	mov	m,e
GO0	jc	GO4
	lxi	de,W_0002
GO1	call	COMC
	DB	'-'
	call	PARAM
	push	hl
	inr	d
	jc	GO2
	dcr	e
	jnz	GO1
GO2	jnc	ERROR
	lhld 	MEMTOP
	mvi	l,B_E2
GO3	pop	bc
	mov	m,c
	inx	hl
	mov	m,b
	inx	hl
	ldax	bc
	mov	m,a
	inx	hl
	mvi	a,B_C7
	stax	bc
	dcr	d
	jnz	GO3
GO4	call	CRLF
	ret

HEXN	call	EXPR
	call	CRLF
	pop	de
	pop	hl
	push	hl
	dad	de
	call	LADR
	call	BLK
	pop	hl
	mov	a,l
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	call	LADR
	ret
MOVE	inr	c
	call	EXPR
	pop	bc
	pop	de
	pop	hl
MV0	mov	a,m
	stax	bc
	inx	bc
	call	HILO
	jnc	MV0
	ret

NULL	call	TI
	cpi	B_0D
	jnz	ERROR
NU0	mvi	b,B_3C
NLEADX	call	POC
	DB	000h
	dcr	b
	jnz	NLEADX
	ret

QUERY	call	TI
	cpi	B_0D
	jnz	ERROR
	mvi	b,B_04
	lxi	hl,LTBL
Q0	call	CRLF
	mov	c,m
	call	COM
	call	COMC
	DB	'='
	inx	hl
	mov	a,m
	cma
	mov	c,a
	inx	hl
	mov	e,m
	inx	hl
	mov	d,m
	inx	hl
	xchg	
	lda 	IOBYT
	ana	c
	push	bc
	mvi	b,B_04
Q1	mov	c,m
	inx	hl
	cmp	m
	jz	Q2
	inx	hl
	dcr	b
	jnz	Q1
Q2	call	COM
	xchg	
	pop	bc
	dcr	b
	jnz	Q0
	ret

READ	dcr	c
	call	EXPR
	call	CRLF
RED0	call	RIX
	cpi	B_3A
	jnz	RED0
	xra	a
	mov	d,a
	call	BYTE
	jz	RED3
	mov	e,a
	call	BYTE
	mov	h,a
	call	BYTE
	mov	l,a
	call	BYTE
	mov	c,e
	push	hl
	lxi	hl,W_FF00
	dad	sp
RED1	call	BYTE
	mov	m,a
	inx	hl
	dcr	e
	jnz	RED1
	call	BYTE
	jnz	ERROR
	pop	de
	xthl
	xchg	
	dad	de
	mvi	b,B_00
	dad	bc
	xchg	
	xthl
RED2	dcx	hl
	mov	a,m
	dcx	de
	stax	de
	dcr	c
	jnz	RED2
	jmp	RED0
RED3	push	bc
	call	BYTE
	mov	b,a
	call	BYTE
	mov	c,a
	ora	b
	jz	RED4
	lhld 	MEMTOP
	mvi	l,B_E1
	mov	m,b
	dcx	hl
	mov	m,c
RED4	pop	bc
	call	BYTE
	call	BYTE
	jnz	ERROR
	pop	hl
	ret

SUBS	call	PARAM
	rc
SU0	mov	a,m
	call	LBYTE
	call	COMC
	DB	'-'
	call	PCHK
	rc
	jz	SU1
	xchg	
	call	PA0
	xchg	
	mov	m,e
	rc
SU1	inx	hl
	jmp	SU0

WRITE	call	EXPR
	call	CRLF
	pop	de
	pop	hl
WR0	call	POC
	DB	':'
	lxi	bc,W_0010
	push	hl
WR1	inr	b
	dcr	c
	jz	WR2
	call	HILO
	jnc	WR1
WR2	pop	hl
	push	de
	mvi	d,B_00
	mov	a,b
	call	PBYTE
	call	PADR
	xra	a
	call	PBYTE
WR3	mov	a,m
	call	PBYTE
	inx	hl
	dcr	b
	jnz	WR3
	xra	a
	sub	d
	call	PBYTE
	pop	de
	dcx	hl
	call	POC
	DB	00Dh
	call	POC
	DB	00Ah
	call	HILO
	jnc	WR0
	ret

X	lxi	hl,ACTBL
	call	PCHK
	jc	X5
	mvi	c,B_0C
X0	cmp	m
	jz	X1
	inx	hl
	inx	hl
	inx	hl
	dcr	c
	jnz	X0
	jmp	ERROR
X1	call	BLK
X2	call	DREG
	call	COMC
	DB	'-'
	call	PCHK
	rc
	jz	X4
	push	hl
	push	bc
	call	PA0
	mov	a,l
	stax	de
	pop	psw
	ora	a
	jm	X3
	inx	de
	mov	a,h
	stax	de
X3	pop	hl
X4	xra	a
	ora	m
	rm
	mov	a,b
	cpi	B_0D
	rz
	jmp	X2
X5	call	CRLF
X6	call	BLK
	xra	a
	ora	m
	rm
	mov	c,m
	call	COM
	call	COMC
	DB	03Dh
	call	DREG
	jmp	X6
ACTBL	DB	041h,0CFh,000h,042h,0CBh,000h,043h
	DB	0CAh,000h,044h,0C9h,000h,045h,0C8h
	DB	000h,046h,0CEh,000h,048h,0DDh,000h
	DB	049h,0CDh,000h,04Ch,0DCh,000h,04Dh
	DB	0DDh,001h,050h,0E1h,001h,053h,0D1h
	DB	001h,0FFh

Z	call	TI
	cpi	B_24
	jnz	ERROR
	call	TI
	cpi	B_0D
	jnz	ERROR
	mvi	a,B_0C
	out	B_FF
	call	DIAGMN
	ret

; begin BIOS I/O
;

; hardware interface I/O routines for ISIS bios software
;
; check console input status
;
ciflag	equ	0x3c	;this location appears unused by CPM and ISIS
; it is used for the toggle flag for simulating RDY to NRDY transitions..

CSTS
const:
	lda	ciflag	; this simulates RDY to NRDY 
	cma		; needed to make ISIS "paste as input"
	sta	ciflag	; without dropping every other character
	ora	a
	jz	NRDY

	call	selCon
	call	tabJMP
	dw	TTYsi
	dw	CRTsi
	dw	readst	;BATCH in stat
	dw	UC1si	

;
; read a character from console
;
CI
conin:	call	selCon
	call	tabJMP
	dw	TTYi
	dw	CRTi
	dw	reader	;BATCH in
	dw	UC1i	

; output Blank

BLK	mvi	c,B_20	;print a blank
	jmp	COM

; out char folowing the call to COMC

COMC	xthl
	mov	c,m
	inx	hl
	xthl
COM	lda 	IOBYT	;check for Batch mode
	ani	B_03
	cpi	B_02
	cnz	BREAK	;if not batch honor break
;
; write a character to the console device
;
CO
conout:	call	selCon
	call	tabJMP
	dw	TTYo
	dw	CRTo
	dw	list	;BATCH out
	dw	UC1o	

LOM	lda 	IOBYT
	ani	B_03
	cpi	B_02
	cnz	BREAK

; write a character to the list device

LO
list:	call	selList
	call	tabJMP
	dw	TTYo
	dw	CRTo
	dw	LPTo
	dw	UL1o

; status for List only used by CPM 2.2

LSTS
listst	call	selList
	call	tabJMP
	dw	TTYso
	dw	CRTso
	dw	LPTso	
	dw	NRDY	;UL1so

; status for reader only used by batch

readst	call	selRDR
	call	tabJMP
	dw	TTYsi
	dw	RDRsi
	dw	RDY	;UR1si
	dw	RDY	;UR2si

NRDY	xra	a
	ret
RDY	mvi	a,0xff
	ret
REOF	mvi	a,0x1a
	ret
;
; read a character from reader device
;
RI
reader:	call	selRDR
	call	tabJMP
	dw	TTYi
	dw	RDRi
	dw	UR1i
	dw	UR2i

; punch char following the call to POC

POC	xthl
	mov	c,m
	inx	hl
	xthl

;Punch out

PO
punch:	call	selPUN
	call	tabJMP
	dw	TTYo
	dw	PUNo
	dw	UP1o
	dw	UP2o

; physical device drivers used by CI CO CSTS RI PO LO

cstat	equ	0xF7
cdata	equ	0xF6
crdyi	equ	0x02
crdyo	equ	0x01

CRTsi	in	cstat		; read CRT status
	ani	crdyi
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret
CRTi	in	cstat		; read console status
	ani	crdyi		; if not ready
	jz	CRTi		; keep waiting
	in	cdata		; read a character
	ani	7fh		; make most sig bit=0
	ret
; used by list status only
CRTso	in	cstat		; read LPT status
	ani	crdyo
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret
CRTo	in	cstat		; read console status
	ani	crdyo		; if not ready,
	jz	CRTo		; keep waiting
	mov	a,c		; get character
	out	cdata		; print it
	ret
UC1si
	mvi	a,low(CSLOC)
	jmp	@user
UC1i
	mvi	a,low(CILOC)
	jmp	@user
UC1o
	mvi	a,low(COLOC)
	jmp	@user

;c1stat	equ	0x29
;c1data	equ	0x28
;c1rdyi	equ	0x02
;c1rdyo	equ	0x01
;
;UC1si	in	c1stat		; read UC1 status
;	ani	c1rdyi
;	mvi	a,0		; set a=0
;	rz			; return if not ready with a=0
;	cma
;	ret
;UC1i	in	c1stat		; read U console status
;	ani	c1rdyi		; if not ready
;	jz	UC1i		; keep waiting
;	in	c1data		; read a character
;	ani	7fh		; make most sig bit=0
;	ret
;UC1o	in	c1stat		; read U console status
;	ani	c1rdyo		; if not ready,
;	jz	UC1o		; keep waiting
;	mov	a,c		; get character
;	out	c1data		; print it
;	ret

tstat	equ	0xF5
tdata	equ	0xF4
trdyi	equ	0x02
trdyo	equ	0x01

TTYsi	in	tstat		; read TTY status
	ani	trdyi
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret
TTYi	in	tstat		; read console status
	ani	trdyi		; if not ready
	jz	TTYi		; keep waiting
	in	tdata		; read a character
	ani	7fh		; make most sig bit=0
	ret
; used by list status only
TTYso	in	tstat		; read TTY status
	ani	trdyo	
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret
TTYo	in	tstat		; read console status
	ani	trdyo		; if not ready,
	jz	TTYo		; keep waiting
	mov	a,c		; get character
	out	tdata		; print it
	ret

lstat	equ	0x41
ldata	equ	0x40
lrdyo	equ	0x01

; used by list status only
LPTso	in	lstat		; read LPT status
	ani	lrdyo
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret

LPTo	in	lstat		; read list port status
	ani	lrdyo		; if not ready,
	jz	LPTo		; then keep waiting
	mov	a,c		; get character
	out	ldata		; print it
	ret
UL1o
	mvi	a,low(L1LOC)
	jmp	@user
;
rstat	equ	0x59
rdata	equ	0x58
rrdyi	equ	0x02

RDRsi	in	rstat		; read RDR status
	ani	rrdyi
	mvi	a,0		; set a=0
	rz			; return if not ready with a=0
	cma
	ret

RDRi	in	rstat		; read RDR status
	ani	rrdyi		; if not ready
	jz	RDRi		; keep waiting
	in	rdata		; read a character
	ani	7fh		; make most sig bit=0
	ret

UR1i
	mvi	a,low(R1LOC)
	jmp	@user
UR2i
	mvi	a,low(R2LOC)
	jmp	@user

pstat	equ	0x5d
pdata	equ	0x5c
prdyo	equ	0x01

PUNo	in	pstat		; read PUN status
	ani	prdyo		; if not ready,
	jz	PUNo		; keep waiting
	mov	a,c		; get character
	out	pdata		; send it
	ret
UP1o
	mvi	a,low(P1LOC)
	jmp	@user
UP2o
	mvi	a,low(P2LOC)
;	jmp	@user

; A contains lower address of user I/O routine
;  used to access table in RAM Exit area (XTBL)
; 
@USER	push	hl
	lhld 	MEMTOP
	mov	l,a
	xthl
	ret
;
; A= Index
; (sp)=ptr to table
tabJMP	
	xthl		;get ptr to table in HL 
	push	de	;save DE
	mov	e,a	;put index into DE
	xra	a
	mov	d,a
	dad	de	;add to base
	dad	de	;add to base double index
	mov	e,m	;get address from table
	inx	hl
	mov	d,m
	xchg		;address in hl now
	pop	de	;restore DE
	xthl		;restore HL and put ptr on stack
	ret		;jmp to it
;
selCon	lda	IOBYT
;	call	shr0
	ani	3
	ret
selRDR	lda	IOBYT
;	call	shr2
	rrc
	rrc
	ani	3
	ret
selPUN	lda	IOBYT
	call	shr4
	ani	3
	ret
selList	lda	IOBYT
	call	shr6
	ani	3
	ret
;
shr7	rrc
shr6	rrc
shr5	rrc
shr4	rrc
shr3	rrc
shr2	rrc
shr1	rrc
shr0	ret

; End BIOS I/O


BREAK	call	CSTS
	ora	a
	rz
	jmp	TI

IOCHK	lda 	IOBYT
	ret
IOSET	mov	a,c
	sta	IOBYT
	ret
MEMCHK	lda 	MEMTOP+1
	dcr	a
	mov	b,a
	mvi	a,B_C0
	ret
IODEF	push	hl
	push	bc
	lhld 	MEMTOP
	mvi	l,B_E9
	mov	a,c
	cpi	B_08
	jnc	ERROR
	add	c
	add	c
	mov	c,a
	mvi	b,B_00
	dad	bc
	mov	m,e
	inx	hl
	mov	m,d
	pop	bc
	pop	hl
	ret
UI	push	bc
	mvi	b,B_17
	call	PIODR3
	pop	bc
	push	bc
	mov	c,b
	call	PIODR4
	pop	bc
	call	PIODR2
	ret
UO	push	bc
	mvi	b,B_16
	mov	c,e
	call	PIODR3
	mov	c,d
	call	PIODR4
	pop	bc
	call	PIODR4
	ret
UPPS	push	bc
	mvi	b,B_18
	call	PIODR1
	push	psw
	call	PIODR2
	pop	psw
	pop	bc
	ret
BYTE	push	bc
	call	RIX
	call	NIBBLE
	rlc
	rlc
	rlc
	rlc
	mov	c,a
	call	RIX
	call	NIBBLE
	ora	c
	mov	c,a
	add	d
	mov	d,a
	mov	a,c
	pop	bc
	ret
CONV	ani	B_0F
	adi	B_90
	daa
	aci	B_40
	daa
	mov	c,a
	ret
CRLF	call	COMC
	DB	00Dh
	call	COMC
	DB	00Ah
	ret
DADR	mov	a,h
	call	DBYTE
	mov	a,l
DBYTE	push	psw
	rrc
	rrc
	rrc
	rrc
	call	CONV
	call	LOM
	pop	psw
	call	CONV
	jmp	LOM
DELAY	mvi	c,B_70
DLY1	dcr	c
	jnz	DLY1
	ret
DREG	inx	hl
	mov	e,m
	lda 	MEMTOP+1
	mov	d,a
	inx	hl
	mov	b,m
	inx	hl
	ldax	de
	call	LBYTE
	dcr	b
	rm
	dcx	de
	ldax	de
	jmp	LBYTE
EXPR	call	PARAM
	xthl
	push	hl
	dcr	c
	jnc	EX0
	jnz	ERROR
	ret
EX0	jnz	EXPR
	jmp	ERROR
HILO	inx	hl
	mov	a,h
	ora	l
	stc
	rz
	mov	a,e
	sub	l
	mov	a,d
	sbb	h
	ret
LADR	mov	a,h
	call	LBYTE
	mov	a,l
LBYTE	push	psw
	rrc
	rrc
	rrc
	rrc
	call	HXD
	pop	psw
HXD	call	CONV
	jmp	COM
LCRLF	mvi	c,B_0D
	call	LOM
	mvi	c,B_0A
	jmp	LOM
PARAM	call	PCHK
	jz	ERROR
PA0	lxi	hl,W_0000
PA1	mov	b,a
	call	NIBBLE
	jc	PA2
	dad	hl
	dad	hl
	dad	hl
	dad	hl
	ora	l
	mov	l,a
	call	TI
	jmp	PA1
PA2	mov	a,b
	call	P2C
	jnz	ERROR
	ret
NIBBLE	sui	B_30
	rc
	adi	B_E9
	rc
	adi	B_06
	jp	NI0
	adi	B_07
	rc
NI0	adi	B_0A
	ora	a
	ret
PADR	mov	a,h
	call	PBYTE
	mov	a,l
PBYTE	mov	e,a
	rrc
	rrc
	rrc
	rrc
	call	CONV
	call	PO
	mov	a,e
	call	CONV
	call	PO
	mov	a,e
	add	d
	mov	d,a
	ret
PCHK	call	TI
P2C	cpi	B_20
	rz
	cpi	B_2C
	rz
	cpi	B_0D
	stc
	rz
	cmc
	ret
RESTART
	di
	push	hl
	push	de
	push	bc
	push	psw
	pop	de
	push	hl
	lhld 	MEMTOP
	mvi	l,B_CC
	mov	l,m
	in	B_FC
	mov	h,a
	xthl
	push	de
	mvi	a,B_FE
	out	B_FC
	lhld 	MEMTOP
	mvi	l,B_D2
	xchg	
	lxi	hl,W_000C
	dad	sp
	mvi	b,B_05
	xchg	
RST0	dcx	hl
	mov	m,d
	dcx	hl
	mov	m,e
	pop	de
	dcr	b
	jnz	RST0
	pop	bc
	dcx	bc
	sphl
	lhld 	MEMTOP
	mvi	l,B_E2
	mov	a,m
	sub	c
	inx	hl
	jnz	RSTA
	mov	a,m
	sbb	b
	jz	RST1
RSTA	inx	hl
	inx	hl
	mov	a,m
	sub	c
	inx	hl
	jnz	RSTB
	mov	a,m
	sbb	b
	jz	RST1
RSTB	mvi	a,B_20
	out	B_FD
	inx	bc
RST1	lhld 	MEMTOP
	mvi	l,B_DC
	mov	m,e
	inx	hl
	mov	m,d
	mvi	l,B_E0
	mov	m,c
	inx	hl
	mov	m,b
	push	bc
	call	COMC
	DB	023h
	pop	hl
	call	LADR
	lhld 	MEMTOP
	mvi	l,B_E2
	mvi	d,B_02
RST2	mov	c,m
	xra	a
	mov	m,a
	inx	hl
	mov	b,m
	mov	m,a
	inx	hl
	mov	a,c
	ora	b
	jz	RST3
	mov	a,m
	stax	bc
RST3	inx	hl
	dcr	d
	jnz	RST2
	jmp	START
RIX	call	RI
	jc	ERROR
	ani	B_7F
	ret
TI	push	bc
	call	CI
	ani	B_7F
	call	UC
	cpi	B_03
	jz	ERROR
	mov	c,a
	call	CO
	mov	a,c
	pop	bc
	ret
UC	cpi	B_61
	rm
	cpi	B_7B
	rp
	ani	B_DF
	ret
IOCDR1	call	IOCCOM
IOCXXX	in	B_C1
	ani	B_07
	cpi	B_01
	jnz	IOCXXX
	in	B_C0
	push	psw
	mvi	a,B_05
	out	B_FF
	pop	psw
	ret
IOCDR2	call	IOCCOM
IOCYYY	in	B_C1
	ani	B_07
	jnz	IOCYYY
	mov	a,c
	out	B_C0
	mvi	a,B_05
	out	B_FF
	ret
IOCCOM	mvi	a,B_0D
	out	B_FF
IOCZZZ	in	B_C1
	ani	B_07
	jnz	IOCZZZ
	mov	a,b
	out	B_C1
	ret
PIODR1	call	PIOCOM
PIODR2	mvi	a,B_0D
	out	B_FF
	in	B_F9
	ani	B_07
	cpi	B_01
	jnz	PIODR2
	in	B_F8
	push	psw
	mvi	a,B_05
	out	B_FF
	pop	psw
	ret
PIODR3	call	PIOCOM
PIODR4	mvi	a,B_0D
	out	B_FF
	in	B_F9
	ani	B_07
	jnz	PIODR4
	mov	a,c
	out	B_F8
	mvi	a,B_05
	out	B_FF
	ret
PIOCOM	mvi	a,B_0D
	out	B_FF
PIOZZZ	in	B_F9
	ani	B_07
	jnz	PIOZZZ
	mov	a,b
	out	B_F9
	mvi	a,B_05
	out	B_FF
	ret

	org	monitor+0x7fd
MNCKSM
	DB	06Ch,000h,001h
	END	MONITOR
