;  AS-IS this assembles with AS8080, but 
; this must be changed for ISIS Rloc assembler
; also labels may be too big
; not sure where stack gets defined, suspect linker.

; comment out ISIS and STACK

;ISIS:	equ	0	;external
;STACK:	equ	0	;stack

; remove comments from these

	EXTRN	ISIS
	
	CSEG

; Equates for system

open	equ	0
close	equ	1
delete	equ	2
read	equ	3
write	equ	4
seek	equ	5
load	equ	6
rename	equ	7
consol	equ	8
exit	equ	9
attrib	equ	10
rescan	equ	11
error	equ	12
whocon	equ	13
spath	equ	14

faRead	equ	1
faWrit	equ	2
faRW	equ	3

skPos	equ	0
skBwd	equ	1
skLoc	equ	2
skFwd	equ	3
skEof	equ	4

; Equates for DLOAD ports

DLdata	equ	0a0h
DLstat	equ	0a1h
DLcntrl	equ	0a1h

DLrdy	equ	1
DLnrdy	equ	0

DLrew	equ	0ffh

; Console read PB

pbRcon:	dw	1	;:CI:
	dw	rBuf	;pointer to Read Buffer
	dw	32	;Number of bytes to read
	dw	rACT	;return of actual count read
	dw	eStat	;pointer to Status

rACT:	dw	0	;number of bytes read

rBuf:	ds	64

;Open file PB

pbOpen:	dw	fnWrit	;pointer to aftn
	dw	rBuf	;pointer to filename
	dw	faWrit	;access value
	dw	0	;echo file aftn
	dw	eStat	;pointer to Status

; Write PB
; store aftn for write here after open

fnWrit:
pbWrit:	dw	0	;actual aftn
	dw	wBuf	;pointer to write Buffer
wCount:	dw	1	;Number of bytes to write
	dw	eStat	;pointer to Status

wBuf:	ds	8

; Close PB

fnClos:
pbClos:	dw	0	;Aftn to close
	dw	eStat	;error returned by error

; store error at eStat
; pb for error and exit

eStat:
pbErro:	dw	0	;returned error number
pbExit:	dw	eStat	;error returned by error



Start:	lxi	sp,STACK
	
;read file name from command line

	mvi	c,read
	lxi	d,pbRcon
	call	ISIS0

; Open the file for writing

	mvi	c,open
	lxi	d,pbOpen
	call	ISIS0

DoIt:

	mvi	a,DLrew		;rewind file
	out	DLcntrl

while:
	in	DLstat
	cpi	DLrdy
	jnz	EOI

	in	DLdata
	sta	wBuf

	in	DLstat
	cpi	DLrdy
	jnz	EOI
	
; write the buffer

	mvi	c,write
	lxi	d,pbWrit
	call	ISIS0

	jmp	while

EOI:

; Close the file

	lhld	fnWrit
	shld	fnClos
	mvi	c,close
	lxi	d,pbClos
	call	ISIS0
	
	jmp	pExit

; Entry to ISIS  

ISIS0:	call	ISIS
	lda	eStat
	ora	a
	rz
	mvi	c,error
	lxi	d,pbErro
	call	ISIS
pExit:	mvi	c,exit
	lxi	d,pbExit
	call	ISIS
; should not return to here

	end	Start
