
/*
** prntf("format string"[, arg, arg, ...]) -- formatted print 
**        operates as described by Kernighan & Ritchie with
**        the following exceptions:
**
**		- only d, c, and s formats supported
**		- maximum field-width specification of 9
**		- no field seperator specification
**
**	Modified version of J. E. Hendrix's printf distributed
**	with Small-C Version 2.0. This version uses putchar for
**	for output and is renamed to prntf to avoid mutiple 
**	global defines. It is designed to occupy minimum code
**	space and can be used interchangeably with printf(),as
**	long as the exceptions are taken into consideration.
**
**			F. A. Scacchitti  10/7/84
*/ 

#include <stdio.h>

/*
**	Making the following variables static greatly reduces size 
**	while increasing speed. However, if static globals aren't
**	available on your compiler, the prntf.mac file must be
**	edited to remove the additional colon generated by the
**	compiler to ensure no problems occur with multiple global
**	definitions. An alternative to this method would involve
**	renaming all the static variable with some little used
**	prefix. (eg. qqq, xxx, ppp)
*/


static  int i, width, len, *nxtarg, sz;
static  char *ctl, *cx, c, right, str[7], *sptr, pad, sgn;

prntf(argc) int argc; {

  i = CCARGC();   /* fetch arg count from A reg first */
  nxtarg = &argc + i - 1;
  ctl = *nxtarg;

  while(c = *ctl++) {
    if(c != '%') {
      putchar(c);
      continue;
    }
    if(*ctl == '%') {
      putchar(*ctl++);
      continue;
    }
    cx = ctl;
    right = 1;
    pad = ' ';

    if(*cx == '-') {
      right = 0;
      ++cx;
    }
    if(*cx == '0') {
      pad = '0';
      ++cx;
    }

    width = *cx - '0';
    if(width < 1 || width >9)
      width = 0;
    else
      cx++;

    sptr=str; c = *cx++; i = *(--nxtarg);

    switch(c) {

	case 'd': sz = 7;

		  if(i < 0) {
		    i = -i;
		    sgn='-';
		  }
		  else sgn=' ';
  
		  str[--sz] = NULL;

		  while(sz) {
		    str[--sz] = (i % 10 + '0');
		    if((i = i / 10) == 0) break;
		    }
		  if(sz) str[--sz] = sgn;
		  while(sz > 0) str[--sz]=' ';

		  break;
	case 'c': str[0] = i;
		  str[1] = NULL;
		  break;
	case 's': sptr = i;
		  break;
	default : continue;
    }

  ctl = cx; /* accept conversion spec */
    if(c == 'd')
      while(*sptr==' ') ++sptr;

    len = -1;
    while(sptr[++len]); /* get length */

    if(right)
      while(((width--) - len) > 0) putchar(pad);
    while(len) {
      putchar(*sptr++);
      --len;
      --width;
    }
    while(((width--) - len) > 0) putchar(pad);
    }
  }

