program ProxyFailover;

uses
  Forms,
  Unit1 in 'Unit1.pas' {Form1}, Windows;

{$R *.res}

//Declare a var to retrieve current window information
var
  ExtendedStyle : Integer;

begin
  Application.Initialize;
  // Get the Extended Styles of the Application, by passing its
  // handle to GetWindowLong
  ExtendedStyle := GetWindowLong(Application.Handle, GWL_EXSTYLE);

  // Now, set the Extended Style by doing a bit masking operation.
  // OR in the WS_EX_TOOLWINDOW bit, and AND out the WS_EXAPPWINDOW bit
  // This effectively converts the application from an App Windows to a
  // Tool Window.
  SetWindowLong(Application.Handle, GWL_EXSTYLE, ExtendedStyle OR WS_EX_TOOLWINDOW
                                                 AND NOT WS_EX_APPWINDOW);

  Application.CreateForm(TForm1, Form1);
  Application.Run;
end.
