{ Convert letters to upper case }

function upper (ch : char) : char;

begin
if ch in ['a'..'z'] then upper := chr(ord(ch) - casediff)
else upper := ch
end; { upper }

{ Read the next character and classify it }

procedure getchar;

var
ch : char;

begin
currchar := nextchar;
with nextchar do
if eof(infile) then
begin name := filemark; value := blank end
else
if eoln(infile) then
begin name := endofline; value := blank;
inlines := inlines + 1; readln(infile) end
else
begin
read(infile,ch);
value := ch;
if ch in ['a'..'z','A'..'Z','_'] then name := letter
else
if ch in ['0'..'9'] then name := digit
else
if ch = '''' then name := quote
else
if (ch = blank) or (ch = chr(tab)) then name := space
else name := otherchar
end
end; { getchar }

{ Store a character in the current symbol }

procedure storenextchar(var length : byte; var value : token);

begin
getchar;
if length < maxsymbolsize then
begin length := length + 1; value[length] := currchar.value end;
end; { storenextchar }

{ Count the spaces between symbols }

procedure skipblanks (var spacesbefore,crsbefore : byte);

begin
spacesbefore := 0;
crsbefore := 0;
while nextchar.name in [space,endofline] do
begin
getchar;
case currchar.name of
space : spacesbefore := spacesbefore + 1;
endofline : begin
crsbefore := crsbefore + 1;
spacesbefore := 0
end
end
end
end; { skipspaces }

{ Process comments using either brace or parenthesis notation }

procedure getcomment (sym : symbolinfo);

begin
sym^.name := opencomment;
while not (((currchar.value = '*') and (nextchar.value = ')'))
or (currchar.value = '}')
or (nextchar.name = endofline)
or (nextchar.name = filemark)) do
storenextchar(sym^.length,sym^.value);
if (currchar.value = '*') and (nextchar.value = ')') 
then
begin
storenextchar(sym^.length,sym^.value); sym^.name := closecomment
end;
if currchar.value = '}' 
then sym^.name := closecomment
end; { getcommment }
