;MI - C  v-3.18   (C) COPYRIGHT  G. KERSTING / H. ROSE, 1983
; RUNTIME LIBRARY   MI - C   V  3.1   (LONG)
;
; PUBLIC CLPUTM,CLSPUTM,CLGDIR,CLSGDIR
; PUBLIC CLGPIND,CLSGPIND,CLGSIND,CLSGSIND
; PUBLIC CLPIND,CLSPIND
; PUBLIC CUTOL,CUSTOL,CCTOL,CCSTOL
; PUBLIC CLSUB,CLADD,CLDIV,CLMULT,CLMOD,CLSSUB,CLSDIV,CLSMOD
; PUBLIC CLOR,CLAND,CLXOR,CLASR,CLASL,CLCOM,CLNEG,CLLNOT
; PUBLIC CLSNEG,CLSASL,CLSASR,CLSLNOT,CLSCOM
; PUBLIC CLEQ,CLGT,CLLT,CLNE,CLGE,CLLE
; PUBLIC CLSWAP
; PUBLIC CLPUSH,CLSPUSH,CLPOP,CLSPOP
; PUBLIC CLSFLAG,CLSSFLAG,CLSWTEST
; PUBLIC CLINC,CLSINC,CLDEC,CLSDEC
; PUBLIC CLPRIM,CLSEC
; PUBLIC CLREST
; EXT CCMULT,CC0DIV
;
;
; !!! FALLS DIVISION DURCH 0 BEI LONG AUFTRITT
; VOM BENUTZER KANN HIER ABRUCH ODER ANDERES VORGEHEN 
; EINGEFUEGT WERDEN
;
CL0DIV:
	JMP CC0DIV
;
;
; CLPRIM -> (BC)
CLPUTM:
	MOV	A,L
	STAX	B
	INX	B
	MOV	A,H
	STAX	B
	INX	B
	LDA	CLPRIM
	STAX	B
	INX	B
	LDA	CLPRIM+1
	STAX	B
	RET
;
; CLSEC -> (BC)
CLSPUTM:
	MOV	A,E
	STAX	B
	INX	B
	MOV	A,D
	STAX	B
	INX	B
	LDA	CLSEC
	STAX	B
	INX	B
	LDA	CLSEC+1
	STAX	B
	RET
;
; 4 BYTE HINTER AUFRUF NACH CLPRIM SCHAFFEN
CLGDIR:
	POP	B
	LDAX	B
	INX	B
	MOV	L,A
	LDAX	B
	MOV	H,A
	INX	B
	LDAX	B
	STA	CLPRIM
	INX	B
	LDAX	B
	STA	CLPRIM+1
	INX	B
	PUSH	B
	RET
;
; 4 BYTE HINTER AUFRUF NACH CLSEC SCHAFFEN
CLSGDIR:
	POP	B
	LDAX	B
	INX	B
	MOV	E,A
	LDAX	B
	MOV	D,A
	INX	B
	LDAX	B
	STA	CLSEC
	INX	B
	LDAX	B
	STA	CLSEC+1
	INX	B
	PUSH	B
	RET
;
;  (HL) -> CLPRIM
CLGPIND:
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	SHLD	CLPRIM
	MOV	L,C
	MOV	H,B
	RET
;
;  (HL) -> CLSEC
CLSGPIND:
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	A,M
	STA	CLSEC
	INX	H
	MOV	A,M
	STA	CLSEC+1
	RET
;
;  (DE) ->CLPRIM
CLGSIND:
	LDAX	D
	MOV 	L,A
	INX	D
	LDAX	D
	MOV	H,A
	INX	D
	LDAX	D
	STA	CLPRIM
	INX	D
	LDAX	D
	STA	CLPRIM+1
	RET
;
;  (DE) -> CLSEC
CLSGSIND:
	XCHG
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	SHLD	CLSEC
	MOV	L,C
	MOV	H,B
	XCHG
	RET
;
; CLPRIM -> (DE)
CLPIND:
	MOV	A,L
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	INX	D
	LDA	CLPRIM
	STAX	D
	INX	D
	LDA	CLPRIM+1
	STAX	D
	RET
;
;  CLSEC -> (HL)
CLSPIND:
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	LDA	CLSEC
	MOV	M,A
	INX	H
	LDA	CLSEC+1
	MOV	M,A
	RET
;
; UNSIGNED -> LONG
CUTOL:
	XRA	A
	STA	CLPRIM
	STA	CLPRIM+1
	RET
;
; UNSIGNED -> LONG  (SEONDARY)
CUSTOL:
	XRA	A
	STA	CLSEC
	STA	CLSEC+1
	RET
;
; INT -> LONG
CCTOL:
	MOV	A,H
	RLC
	SBB	A
	STA	CLPRIM
	STA	CLPRIM+1
	RET
;
; INT -> LONG  (SECONDARY)
CCSTOL:
	MOV	A,D
	RAL
	SBB	A
	STA	CLSEC
	STA	CLSEC+1
	RET
;
; PUSH CLPRIM
CLPUSH:
	MOV	C,L
	MOV	B,H
	LHLD	CLPRIM
	XTHL
	PUSH	B
	PCHL
;
; PUSH CLSEC
CLSPUSH:
	MOV	C,E
	MOV	B,D
	XCHG
	LHLD	CLSEC
	XTHL
	PUSH	B
	PUSH	H
	XCHG
	RET
;
; POP CLPRIM
CLPOP:
	POP	B
	POP	H
	XTHL
	SHLD	CLPRIM
	POP	H
	PUSH	B
	RET
;
; POP CLSEC
CLSPOP:
	XCHG
	POP	B
	POP	H
	XTHL
	SHLD	CLSEC
	POP	H
	PUSH	B
	XCHG
	RET
;
; SETZE FAHNEN FUER TEST
CLSFLAG:
	MOV	A,L
	ORA	H
	LHLD	CLPRIM
	ORA	L
	ORA	H
	RET
;
CLSSFLAG:
	MOV	A,E
	ORA	D
	XCHG
	LHLD	CLSEC
	XCHG
	ORA	E
	ORA	D
	RET
;
; SWITCH TEST
CLSWTEST:
	MOV	A,E
	CMP	L
	RNZ
	MOV	A,D
	CMP	H
	RNZ
	LHLD	CLPRIM
	LDA	CLSEC
	CMP	L
	RNZ
	LDA	CLSEC+1
	CMP	H
	RET
;
; INC CLPRIM
CLINC:
	INX	H
	MOV	A,L
	ORA	H
	RNZ
	LHLD	CLPRIM
	INX	H
	SHLD	CLPRIM
	LXI	H,0
	RET
;
; INC CLSEC
CLSINC:
	INX	D
	MOV	A,E
	ORA	D
	RNZ
	XCHG
	LHLD	CLSEC
	INX	H
	SHLD	CLSEC
	XCHG
	LXI	D,0
	RET
;
; DEC CLPRIM
CLDEC:
	MOV	A,L
	ORA	H
	DCX	H
	RNZ
	LHLD	CLPRIM
	DCX	H
	SHLD	CLPRIM
	LXI	H,-1
	RET
;
; DEC CLSEC
CLSDEC:
	MOV	A,E
	ORA	D
	DCX	D
	RNZ
	XCHG
	LHLD	CLSEC
	DCX	H
	SHLD	CLSEC
	XCHG
	LXI	D,-1
	RET
;
;-----------------------
; LONG INTEGER ADDITION
;-----------------------
;
CLADD:
	DAD	D
	MOV	B,H
	MOV	C,L
	LHLD	CLSEC
	MOV	D,H
	MOV	E,L
	LHLD	CLPRIM
	JNC	CLA1
	INX	D
CLA1:
	DAD	D
	SHLD	CLPRIM
	MOV	H,B
	MOV	L,C
	RET
;
;--------------------------
; LONG INTEGER SUBTRAKTION
;--------------------------
;
CLSSUB:
	MOV	A,L
	SUB	E
	MOV	E,A
	MOV	A,H
	SBB	D
	MOV	D,A
	LDA	CLPRIM
	LXI	H,CLSEC
	SBB	M
	MOV	B,A
	INX	H
	LDA	CLPRIM+1
	SBB	M
	MOV	H,A
	MOV	L,B
	SHLD	CLPRIM
	XCHG
	RET
;
;-------------------------
; CLSEC - CLPRIM -> CLPRIM
;-------------------------
;
CLSUB:
	MOV	A,E
	SUB	L
	MOV	E,A
	MOV	A,D
	SBB	H
	MOV	D,A
	LDA	CLSEC
	LXI	H,CLPRIM
	SBB	M
	MOV	M,A
	INX	H
	LDA	CLSEC+1
	SBB	M
	MOV	M,A
	XCHG
	RET
;
;  MULTIPIKATION
;
CLMULT:
	PUSH	H
	MOV	C,L
	MOV	B,H
	LXI	H,0
	MVI	A,16
CLMUL1:
	STA	CLMLZAE
	ANA	A
	DAD	H
	MOV	A,C
	RAL
	MOV	C,A
	MOV	A,B
	RAL
	MOV	B,A
	JNC	CLMLSH
	DAD	D
	JNC	CLMLSH
	INX	B
CLMLSH:
	LDA	CLMLZAE
	DCR	A
	JNZ	CLMUL1
	XTHL
	PUSH	B
	PUSH	H
	LHLD	CLPRIM
	CALL	CCMULT
	XTHL
	XCHG
	LHLD	CLSEC
	XCHG
	CALL	CCMULT
	POP	D
	DAD	D
	POP	D
	DAD	D
	SHLD	CLPRIM
	POP	H
	RET
;
; CLPRIM / CLSEC -> CLPRIM
;
CLSDIV:
	CALL	CLSWAP
;
;
CLDIV:
	CALL	CLDODIV
	LHLD	CLSEC
	SHLD	CLPRIM
	LHLD	CLSEC-2
	LDA	CLDIVO
	ANA	A
	RZ
	CALL	CLNEG
	RET 
;
; REST V. CLPRIM / CLSEC -> CLPRIM
;
CLSMOD:
	CALL	CLSWAP
;
CLMOD:
	CALL	CLDODIV
	LHLD	CLREST+2
	SHLD	CLPRIM
	LHLD	CLREST
	LDA	CLDIVO
	ANA	A
	RZ
	CALL	CLNEG
	RET
;
;
CLDODIV:
	SHLD	CLPRIM-2
	XCHG
	SHLD	CLSEC-2
	XCHG
	MOV	A,H
	ORA	L
	LHLD	CLPRIM
	ORA	H
	ORA	L
	JNZ	CLDV00
	CALL	CL0DIV
	MVI	A,0
	STA	CLDIVO
	LHLD	CLSEC
	SHLD	CLREST+2
	LHLD	CLSEC-2
	SHLD	CLREST
	LXI	H,0FFFFH
	SHLD	CLSEC
	SHLD	CLSEC-2	
	RET
;
CLDV00:
	LDA	CLSEC+1
	LXI	H,CLPRIM+1
	XRA	M
	ANI	80H
	STA	CLDIVO
	MOV	A,M
	ANI	80H
	JZ	CLDV01
	LHLD	CLPRIM-2
	CALL	CLNEG
	SHLD	CLPRIM-2
CLDV01:
	LDA	CLSEC+1
	ANI	80H
	JZ	CLDV0
	LHLD	CLSEC-2
	XCHG
	LHLD	CLPRIM-2
	CALL	CLSWAP
	CALL	CLNEG
	CALL	CLSWAP
	SHLD	CLPRIM-2
	XCHG
	SHLD	CLSEC-2
CLDV0:
	LXI	H,0
	SHLD	CLREST
	SHLD	CLREST+2
	MVI	A,32
	STA	CLDIVZAE
CLDV1:
	MVI	B,8
	ANA	A
	LXI	H,CLSEC-2
CLDV2:
	MOV	A,M
	ADC	A
	MOV	M,A
	INX	H
	DCR	B
	JNZ	CLDV2
	SBB	A
	MOV	C,A
	LXI	D,CLREST
	LXI	H,CLPRIM-2
	MVI	B,4
	ANA	A
CLDV3:
	LDAX	D
	SBB	M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	CLDV3
	SBB	A
	SUB	C
	JNZ	CLDVUNGLEICH
CLDVGLEICH:
	LXI	H,CLSEC-2
	INR	M
	LXI	H,CLDIVZAE
	DCR	M
	JNZ	CLDV1
	RET
CLDVUNGLEICH:
	MVI	B,8
	LXI	H,CLDIVZAE
	DCR	M
	JZ	CLDV7
	ANA	A
	LXI	H,CLSEC-2
CLDV5:
	MOV	A,M
	ADC	A
	MOV	M,A
	INX	H
	DCR	B
	JNZ	CLDV5
	SBB	A
	MOV	C,A
	MVI	B,4
	ANA	A
	LXI	D,CLREST
	LXI	H,CLPRIM-2
CLDV6:
	LDAX	D
	ADC	M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	CLDV6
	SBB	A
	SUB	C
	JNZ	CLDVUNGLEICH
	JMP	CLDVGLEICH
CLDV7:
	MVI	B,4
	LXI	D,CLREST
	LXI	H,CLPRIM-2
	ANA	A
CLDV71:
	LDAX	D
	ADC	M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	CLDV71
	RET
;
; TEST IF CLSEC  = CLPRIM
CLEQ:	
	CALL CLCMP
	LXI H,1
	JZ CLEQ1
	DCR L
	RET
CLEQ1:
	ORA L
	RET
;
; TEST IF CLSEC NOT = CLPRIM
CLNE:	
	CALL	CLCMP
	LXI H,1
	RNZ
	DCR L
	RET
;
; TEST IF CLSEC > CLPRIM (SIGNED)
CLGT:
	CALL CLCMP
	LXI	H,0
	RZ
	JC	CLGT1
	INR L
	RET
CLGT1:
	XRA	A
	RET
;
; TEST IF CLSEC <= CLPRIM (SIGNED)
CLLE:	
	CALL CLCMP
	LXI	H,1
	RC
	JZ	CLEQ1
	DCR L
	RET
;
; TEST IF CLSEC >= CLPRIM (SIGNED)
CLGE:
	CALL CLCMP
	LXI	H,0
	INR	L
	RNC
	DCR L
	RET
;
; TEST IF CLSEC < CLPRIM (SIGNED)
CLLT:	
	CALL CLCMP
	LXI	H,1
	RC
	DCR	L
	RET
;
;
CLCMP:
	SHLD	CLPRIM-2
	XCHG
	SHLD	CLSEC-2
	LXI	H,CLPRIM+1
	LXI	D,CLSEC+1
	LDAX	D
	XRA	M
	JP	CLCPGLEI
	ANA	M
	RM
	ORI	1
	STC	
	RET
CLCPGLEI:
	MVI	B,4
CLCP1:
	LDAX	D
	CMP	M
	RC
	RNZ
	DCX	H
	DCX	D
	DCR	B
	JNZ	CLCP1
	RET
;
; LOGISCHE OPERATIONEN: ODER, UND, EXCLUSIEVES ODER
;
CLOR:
	MOV	A,L
	ORA	E
	MOV	E,A
	MOV	A,H
	ORA	D
	MOV	D,A
	LXI	H,CLPRIM
	LDA	CLSEC
	ORA	M
	MOV	M,A
	MOV	C,A
	INX	H
	LDA	CLSEC+1
	ORA	M
	MOV	M,A
	XCHG
	ORA	C
	ORA	H
	ORA	L
	RET
;
CLAND:
	MOV	A,L
	ANA	E
	MOV	E,A
	MOV	A,H
	ANA	D
	MOV	D,A
	LXI	H,CLPRIM
	LDA	CLSEC
	ANA	M
	MOV	M,A
	MOV	C,A
	INX	H
	LDA	CLSEC+1
	ANA	M
	MOV	M,A
	XCHG
	ORA	C
	ORA	H
	ORA	L
	RET
;
CLXOR:
	MOV	A,L
	XRA	E
	MOV	E,A
	MOV	A,H
	XRA	D
	MOV	D,A
	LXI	H,CLPRIM
	LDA	CLSEC
	XRA	M
	MOV	M,A
	MOV	C,A
	INX	H
	LDA	CLSEC+1
	XRA	M
	MOV	M,A
	XCHG
	ORA	C
	ORA	H
	ORA	L
	RET
;
; NEGATION VON CLSEC
;
CLSNEG:
	XCHG
	XRA	A
	MOV	B,A
	SBB	L
	MOV	L,A
	MOV	A,B
	SBB	H
	MOV	H,A
	PUSH	H
	LXI	H,CLSEC
	MOV	A,B
	SBB	M
	MOV	M,A
	INX	H
	MOV	A,B
	SBB	M
	MOV	M,A
	POP	H
	XCHG
	RET
;
; NEGATION VON CLPRIM
;
CLNEG:
	XRA	A
	MOV	B,A
	SBB	L
	MOV	L,A
	MOV	A,B
	SBB	H
	MOV	H,A
	PUSH	H
	LXI	H,CLPRIM
	MOV	A,B
	SBB	M
	MOV	M,A
	INX	H
	MOV	A,B
	SBB	M
	MOV	M,A
	POP	H
	RET
;
; CLPRIM, LOG. NICHT
;
CLLNOT:
	MOV	A,L
	ORA	H
	LHLD	CLPRIM
	ORA	L
	ORA	H
	LXI	H,1
	JZ	CLLN1
	DCR	L
	RET
CLLN1:
	ORA	L
	RET
;
; CLSEC, LOG. NICHT
;
CLSLNOT:
	MOV	A,E
	ORA	D
	XCHG
	LHLD	CLSEC
	XCHG
	ORA	D
	ORA	E
	LXI	D,1
	JZ	CLSLN1
	DCR	E
	RET
CLSLN1:
	ORA	E
	RET
;
; NACH LINKS SHIFTEN
;
CLSASL:
	MOV	A,E
	ANA	A
	RZ
	XCHG
	LHLD	CLPRIM
CLSAL1:
	DAD	H
	XCHG
	DAD	H
	XCHG
	JNC	CLSAL2
	INX	H
CLSAL2:
	DCR	A
	JNZ	CLSAL1
	SHLD	CLPRIM
	XCHG
	RET
;
CLASL:
	MOV	A,L
	ANA	A
	JNZ	CLASL3
	LHLD	CLSEC
	SHLD	CLPRIM
	XCHG
	RET
CLASL3:
	LHLD	CLSEC
CLASL1:
	DAD	H
	XCHG
	DAD	H
	XCHG
	JNC	CLASL2
	INX	H
CLASL2:
	DCR	A
	JNZ	CLASL1
	SHLD	CLPRIM
	XCHG
	RET
;
; NACH RECHTS SHIFTEN
;
CLSASR:
	MOV	A,E
	ANA	A
	RZ
	MOV	B,A
	XCHG
	LHLD	CLPRIM
	JMP	CLRSHI
;
CLASR:
	MOV	A,L
	ANA	A
	JNZ	CLASR1
	LHLD	CLSEC
	SHLD	CLPRIM
	XCHG
	RET
CLASR1:
	MOV	B,L
	LHLD	CLSEC
CLRSHI:
	MOV	A,H
	RAL
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	MOV	A,D
	RAR
	MOV	D,A
	MOV	A,E
	RAR
	MOV	E,A
	DCR	B
	JNZ	CLRSHI
	SHLD	CLPRIM
	XCHG
	RET
;
; KOMPLEMENTIERE CLPRIM
;
CLCOM:
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	MOV	B,H
	MOV	C,L
	LXI	H,CLPRIM
	MOV	A,M
	CMA
	MOV	M,A
	INX	H
	MOV	A,M
	CMA
	MOV	M,A
	MOV	H,B
	MOV	L,C
	RET
;
; KOMPLEMENTIERE CLSEC
;
CLSCOM:
	XCHG
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	MOV	B,H
	MOV	C,L
	LXI	H,CLSEC
	MOV	A,M
	CMA
	MOV	M,A
	INX	H
	MOV	A,M
	CMA
	MOV	M,A
	MOV	H,B
	MOV	L,C
	XCHG
	RET
;
; CLPRIM UND CLSEC VERTAUSCHEN
; 
CLSWAP:
	XCHG
	MOV	B,H
	MOV	C,L
	LHLD	CLPRIM
	LDA	CLSEC
	STA	CLPRIM
	LDA	CLSEC+1
	STA	CLPRIM+1
	SHLD	CLSEC
	MOV	H,B
	MOV	L,C
	RET
;
;----------------------------
;
;	DSEG
	DS	2
CLPRIM:	DS	2
	DS	2
CLSEC:	DS	2
CLREST:	DS	4
;
CFLBZ:	DS	1
CLMLZAE:
	DS	1
CLDIVZAE:
	DS	1
CLDIVO: DS	1
;	CSEG
