/*
CFX.C - Main module of CP/M File eXpress
Copyright 20 Jan 1992 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	..!uunet!ddsw1!carson

BBS:	Antelope Freeway, 1-708-455-0120

Version:        1.3
Date:           08 Jul 2006
Author:         Copr. 1992 by Carson Wilson, parts 2006 Peter Dassow
Changes:	Initial universal version.
		Normal exit now always returns 0.
		Added .GIF, .ZOO to file exclusion list.
		Minor cosmetic tweaks.

                New changes 2006:
                -----------------
                A minor bug fixed displaying the date of lbr
                members (year 2000 or more, displayed was 106
                instead of 06).
                File creation date is now preserved by default,
                means if the file in the lbr was created in 2006,
                the extracted file will have the original file date.
                Filename processing added, means a '/' in a CP/M-
                filename will result a '_' in the MS-DOS-filename.
                Removed a short to long integer bug in the
                filesize calculation (records * 128), which had
                resulted wrong filesizes above 64KB
                Peter Dassow in July '06

Notes:		Compiles under ISC SYSVR3.2 v2.2.1 SDS
		  and with MSDOS Turbo C 2.01.
*/
/* ======================================================= */

#include "cfx.h"
#include <sys/stat.h>
#include <io.h>

/* External variables */

unsigned cksum;			/* Checksum of all bytes written to output */
unsigned outreccount;		/* Number of bytes written to output record */
unsigned long mlength;		/* library member length */

unsigned char repeat_flag;	/* So send can remember if repeat required*/
long unclength;         	/* global for library members */

char *infname;			/* Current input file name */
FILE *infd;			/* Currently open input file */
FILE *outfd;			/* Currently open output file */

/* Command line flags */

int brief = 0;			/* -b brief output only */
int cdline = 0;			/* -c command line argument (0..4) */
int diskout = 0;		/* -d disk output flag */
int uncompress = 1;		/* -n no uncompress flag */
int info = 0;			/* -i info only flag */
int prompt = 0;			/* -p prompt flag */
time_t timelmt = 0;		/* -t time limit command line argument */
int waitflag = 0;		/* -w wait for key at end of files */

/* Internal flags */

int inlbr;			/* library file flag */
int contin = 1;			/* Global abort flag */
int scrline = 1;		/* Current screen line for [more] */
int pause = 1;			/* Pause at each screenful */
int infoflag;			/* Display directory info */

char membername[40] = "";

struct stat fsstruct;		/* file status buffer */
struct tm *ftsptr;

time_t nowtime, starttime;	/* -t time buffers */

int fileyear, filemonth, fileday;

char firstname[40] = "";

/* ============================ MAIN PROGRAM =========================== */

int main(argc, argv)
int argc;
char *argv[];
{
	extern int optind;		/* pointer to remaining arguments */
	extern char *optarg;		/* pointer to current argument */
	extern int opterr;		/* getopt() control */
	int badopt = 0;
	int c;
	int fhandle;

#ifdef UNIX
	char DOSSW = '-';
#else
	char DOSSW;			/* MSDOS command line switch */
	_AX = 0x3700;                   /* Get SW using DOS call 0x37 */
	geninterrupt(0x21);
	DOSSW = _DL;			/* save DOS "switch" character */
#endif

	/* Process global variables */
	opterr = 0;			/* disallow getopt messages */

	while ((c = getopt (argc, argv, "bBc:C:dDiIm:M:nNpPt:T:wW")) != EOF )
		switch (tolower(c))
		{
		case 'b' : brief = 1;
			   break;
#ifndef UNIX
		case 'c' : cdline = atoi(optarg);
			   if (strcmp(optarg, "0") && (!cdline))
				badopt = 1;	/* allow /c0 = console */
			   break;
#endif
		case 'd' : diskout = 1;
			   break;
		case 'i' : info = 1;		/* info only */
			   break;
		case 'm' : strcpy(membername, optarg);
			   break;
		case 'n' : uncompress = 0;
			   break;
		case 'p' : prompt = 1;
			   break;
		case 't' : timelmt = atoi(optarg);
			   if (!timelmt)	/* -t 0 or illegal */
				badopt = 1;
			   else
				timelmt *= 60;	/* in seconds */
			   break;
		case 'w' : waitflag = 1;
			   break;
		case '?' :
		default  : badopt = 1;
			   break;
		}

	if (badopt || (optind == argc))
        {       printf("\n%s - Cp/m File eXpress v%s, (C)1992,2006 by %s\n",
                        PROGNAME, VERS, AUTHOR);
		printf("  Usage:\n");
		printf("        %s [option ...] afn ...\n", PROGNAME);
		printf("  Options:\n");
		printf("        %cb       - brief output only\n", DOSSW);
#ifndef UNIX
		printf("        %cc n     - monitor COMn for carrier\n", DOSSW);
#endif
		printf("        %cd       - disk output\n", DOSSW);
		printf("        %ci       - display file info only\n", DOSSW);
		printf("        %cm \"afn\" - library member specification\n", DOSSW);
		printf("        %cn       - don't uncompress library members\n", DOSSW);
		printf("        %cp       - prompt before processing files\n", DOSSW);
		printf("        %ct n     - maximum minutes allowed\n", DOSSW);
		printf("        %cw       - wait after last file\n", DOSSW);
#ifdef UNIX
		printf("\n");
#endif
		exit(0);
	}
#ifdef UNIX
	ttyraw();			/* select raw tty input */
#endif
	if (timelmt)			/* -t option */
	       time(&starttime);	/* log start time */

	/* Do all the files specified */
	argv += optind;
	argc -= optind;			/* subtract */
	while (argc--)
	{	inlbr = 0;
		infname = *argv++;
		/* Open input file */
		tryopen:
		if ( 0 == (infd = fopen(infname, "rb")) )
		{	if (!strchr(infname, '.'))
			{
				infname = strcat(infname, LBREXT);
				goto tryopen;
			}
			else
			{	outcrlf(1);
				printf("  %s: can't open file \"%s\".", PROGNAME, infname);
				outcrlf(1);
			}
		}
		else
		{	/* preload file datestamp */
			fhandle = fileno(infd);
			fstat(fhandle, &fsstruct);
			ftsptr = localtime(&fsstruct.st_mtime);
			fileyear = ftsptr->tm_year;
			filemonth = ftsptr->tm_mon;
			fileday = ftsptr->tm_mday;
			infoflag = info;
			outcrlf(1);		/* count linefeeds */
                        printf(" File Name    Length  Method    Date");
			outcrlf(1);
			printf("============  ======  ========  ========");
#ifndef UNIX
                        strcpy(firstname,strupr(infname));
#endif
			process(infd, infname, fsstruct.st_size);
			fclose(infd);
		}
		outcrlf(1);
	}
	checkwait();
	quit();			/* done */
	return(0);		/* else compiler warning */
}
/* ---------------------------------------------------------------- */
/*
	Process a single file.
*/
void process(procfd, procfn, procfs)
FILE *procfd;			/* opened file descriptor */
char *procfn;			/* name of opened file    */
long procfs;

{
	int mresult;
	int procch;
        int tmpyear,tmpmonth;
	char *procptr;
#ifndef UNIX
        struct ftime ft;
#endif
	/* Upcase name */
#ifndef UNIX
	stupcase(procfn);
#endif
	/* Strip leading modifiers */
	procptr = strrchr(procfn, DIRSEPCHAR);
	if (procptr++ == NULLCHARPTR)		/* DIRSEPCHAR not found */
	{	procptr = strrchr(procfn, ':');
			if (procptr++ == NULLCHARPTR)	/* ':' not found */
				procptr = procfn;
	}
	procfn = procptr;
	outcrlf(1);
        if (diskout && !infoflag && (strcmp(firstname,procfn)!=0) ) fputs("Writing ",stdout); fflush(stdout);
        printf("%-12s  %6lu  ", procfn, procfs);

        /* added filename processing for special chars in CP/M by P. Dassow */
	procfn = procptr;
        while (*procptr != '\0') {
          if (*procptr == '/') *procptr = '-'; /* replace CP/M '/' into '-' */
          procptr++;
        }
        procptr = procfn; /* reset the ptr if needed later */

	mresult = method(procfd, procfn, procfs);
	switch (mresult)
	{
	case 0 :
        case 1 : printf("%s", "Stored  ");
		 break;
	case 2 :
	case 3 : printf("%s", "Squeezed");
		 break;
	case 4 :
	case 5 : printf("%s", "Crunched");
		 break;
	case 6 :
        case 7 : printf("%s", "Cr-Lzh  ");
		 break;
	case 8 : printf("%s", "Library ");
		 break;
	}
	/* print date */
        tmpmonth = filemonth;
        tmpyear  = fileyear;
/* cosmetic glitch ... from year 2000, it must start again with 00 */
        if (fileyear > 99) tmpyear = tmpyear - 100;
        printf("  %02d-%02d-%02d", filemonth, fileday, tmpyear);

	if (mresult == 8) 			/* library file */
	{	/* don't show initial info on lbrs in lbrs */
		if (infoflag && inlbr && !info)
			goto alldone;
		inlbr = 1;
		outcrlf(2);
                printf("member name   length  method    date");
		outcrlf(1);
		printf("------------  ------  --------  --------");
		lbr(procfd);
		if (infoflag)
			goto alldone;
		else
			goto filedone;
	}

	if (infoflag)
		goto alldone;

	if (!diskout)
	{	if ((mresult == 1) || (mresult == 3) || (mresult == 5) ||
		    (mresult == 7) ||
		    ((mresult) && (!uncompress)))
		{	printf("  Can't display binary file.");
			goto alldone;
		}
		else
			outfd = stdout;		/* default */
	}
	else if (!inlbr)
		if ( (mresult == 0) || (mresult == 1) || !uncompress )
		{	printf("  Input and output files identical.");
			goto alldone;
		}

	if (prompt)
	{	scrline = 1;			/* reset [more] flag */
		printf("  %s (y/N/q)? ", (diskout ? "Extract" : "View"));
		procch = toupper(mgetch(WAIT));
		if (isprint(procch))
			printf("%c ", procch);
		switch (procch)
		{ case 3   :			/* ^C, ^K, ^N */
		  case 11  :
		  case 14  :
		  case 'Q' : cfabort();		/* abort */
			     break;
		  case 'Y' : scrline = 1;
			     break;
		  default  : goto alldone;
		}
	}
	cksum = 0;
	if (!diskout)
	{	if (prompt)
			outcrlf(1);
		printf("  [^c=quit ^x=next file ^z=eof]");
	}

	if (uncompress && ((mresult == 2) || (mresult == 3)))
		/* squeezed */
		unsqueeze(procfd, procfn, procfs);
	else if (uncompress && ((mresult == 4) || (mresult == 5)))
        	/* crunched */
		uncrunch(procfd, procfn, procfs);
	else if (uncompress && ((mresult == 6) || (mresult == 7)))
		/* LZH encoded */
		unlzh(procfd, procfn, procfs);
	else
	{	if (diskout)
		{
#ifdef UNIX
			unixfn(procfn);
#endif
			outfd = fopen(procfn, "wb");
			outreccount = 0;
		}
		else
			outcrlf(2);
		while (((procch = cgetc(procfd)) != EOF) && (contin))
			output(procch, outfd);
	}
	/* All done this file */
	filedone:
	if (diskout)          	/* Don't "close" console! */
	{
#ifndef UNIX
		/* A fixup for MSDOS: Make CP/M files even sector size */
		while(outreccount)
			output(0x1a, outfd); /* pad with EOFs */

/* New code: file date preservation */

        if (strcmp(firstname,procfn)!=0) {
                ft.ft_tsec =0;
                ft.ft_min  =0;
                ft.ft_hour =0;
                if (filemonth == 0) { /* then no date was stored */
                  ft.ft_month=1;
                  ft.ft_day  =1;
                  ft.ft_year =0; /* years since 1980 = 1.1.1980 */
/*                puts("\nSet no filedate (= 1-1-1980)"); */
                }
                else {
                  ft.ft_month=tmpmonth;
                  ft.ft_day  =fileday;
                  ft.ft_year =fileyear-80; /* not sure what happens before 2000 */
/*                printf("\nSet the filedate (m-d-y): %d-%d-%d\n",tmpmonth,fileday,tmpyear); */
                }
                setftime(fileno(outfd), &ft);
        }
/* End of new code */

#endif

		fclose(outfd);
	}
	alldone:
	pause = 1;
}
/* ---------------------------------------------------------------- */
/*
	Determine file storage method.
	0 = normal file
	1 = binary file		 (per file EXTent)
	2 = squeezed normal file
	3 = squeezed binary file ( "    "    "   )
	4 = crunched normal file
	5 = crunched binary file ( "    "    "   )
	6 = LZH normal file
	7 = LZH binary file	 ( "    "    "   )
	8 = library file
*/
int method(mfd, mfn, mfsize)
FILE *mfd;
char *mfn;
long mfsize;
{
	long mmarker;
	char *mptr, *mtptr;
	int byte1, byte2;
	int mresult;		/* result code */
	char mname[100];

	mname[0] = '\0';
	mresult = 0;		/* normal file */

	/* Mark place */
	mmarker = ftell(mfd);

	if (islbr(mfd) && (mfsize > 128))
		return (8);	/* Novosielski .LBR format */

	/* Get crunched/squeezed/LZH signature.  If found, use */
	/*  the embedded filename instead of the command line spec. */
	/*  for binary file detection. */

	mtptr = mname;		/* point to temp. storage */
	byte1 = getc(mfd);
	byte2 = getc(mfd);
	if (feof(mfd) || (mfsize < 5))
	{	fseek(mfd, mmarker, SEEK_SET);	/* restore pointer */
		goto checkext;		/* too short for signature */
	}
	else if ((byte1 == 0x76) && (byte2 == 0xFD))
	{	/* point to un-LZHed filespec */
		mresult = 6;
		for ( (getw(mfd)) ;
			(*mtptr = getc(mfd)) != '\0'; mtptr++);
		mtptr = mname;
	}
	else if ((byte1 == 0x76) && (byte2 == 0xFE))
	{	/* point to uncrunched filespec */
		mresult = 4;
		for ( ; (*mtptr = (getc(mfd)) & 0x7F) != '\0'; mtptr++)
			if (*mtptr == 1)
				*mtptr = '\0';
		mtptr = mname;
	}
	else if ((byte1 == 0x76) && (byte2 == 0xFF))
	{	/* point to unsqueezed filespec */
		mresult = 2;
		for ( (getw(mfd)) ;
			(*mtptr = getc(mfd)) != '\0'; mtptr++);
		mtptr = mname;
	}
	else	/* no signature found */
checkext:
#ifdef UNIX
	{	strcpy(mname, mfn);		/* Convert possibly mixed */
		stupcase(mname);		/*  or lower case for	*/
		mtptr = mname;			/*  testing, and point to it */
	}
#else
		mtptr = mfn;			/* Point to input filespec */
#endif
	mptr = (char *) strchr(mtptr, '.');	/* find extent, if any */
	fseek(mfd, mmarker, SEEK_SET);		/* restore file pointer */

	if (mptr != NULL)
		if (!strncmp(mptr, ".OBJ", 4) ||
#ifdef UNIX
		    !strncmp(mptr, ".Z\0", 3) ||
#endif
		    !strncmp(mptr, ".COM", 4) ||
		    !strncmp(mptr, ".EXE", 4) ||
		    !strncmp(mptr, ".BIN", 4) ||
		    !strncmp(mptr, ".ARC", 4) ||
		    !strncmp(mptr, ".ZIP", 4) ||
		    !strncmp(mptr, ".ARK", 4) ||
		    !strncmp(mptr, ".REL", 4) ||
		    !strncmp(mptr, ".SLR", 4) ||
		    !strncmp(mptr, ".HDR", 4) ||
		    !strncmp(mptr, ".CFG", 4) ||
		    !strncmp(mptr, ".SCN", 4) ||
		    !strncmp(mptr, ".LBR", 4) ||	/* compressed .LBR */
		    !strncmp(mptr, ".ZDK", 4) ||
		    !strncmp(mptr, ".OVR", 4) ||
		    !strncmp(mptr, ".Z3T", 4) ||
		    !strncmp(mptr, ".CHN", 4) ||
		    !strncmp(mptr, ".CIM", 4) ||
		    !strncmp(mptr, ".3OM", 4) ||
		    !strncmp(mptr, ".4OM", 4) ||
		    !strncmp(mptr, ".T4C", 4) ||
		    !strncmp(mptr, ".DAT", 4) ||
		    !strncmp(mptr, ".GIF", 4) ||
		    !strncmp(mptr, ".ZOO", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4) ||
		    !strncmp(mptr, ".ZRL", 4))
			mresult++;			/* binary file */
	return (mresult);
}
/* ---------------------------------------------------------------- */
/*
	Determine whether file is library.  0 = not library.
*/
int islbr(lbrfd)
FILE *lbrfd;
{
	long lbrmarker;
	int lbrresult;
	struct direntry islbrent;

	lbrresult = 0;
	/* Mark place */
	lbrmarker = ftell(lbrfd);

	if ((fread(&islbrent, sizeof(islbrent), 1, lbrfd)) < 1)
		;
	else
		if ((islbrent.status == '\0') &&
		    (strcmp(islbrent.name, "           ") == 0) &&
		    (islbrent.index == 0))
		{       lbrresult = 1;
			xferndate(islbrent.credate, islbrent.moddate);
		}

	fseek(lbrfd, lbrmarker, SEEK_SET);	/* restore pointer */
	return (lbrresult);
}
/* ---------------------------------------------------------------- */
/*
	Transfers given Novosielski datestamps to global fileyear, 
	  filemonth, and fileday variables.  Use modify datestamp by 
	  default; if modify unavailable use create datestamp; if neither 
	  available set date to zero.
	Novosielski dates are in days since 12/31/77, or 0 if undefined.
*/
void xferndate(ncdate, nmdate)
unsigned short int ncdate;
unsigned short int nmdate;
{
	time_t xferval;

	if (!nmdate)			/* no modify datestamp */
		nmdate = ncdate;	/* fallback to create datestamp */
	if (!nmdate)			/* no datestamps */
	{	fileyear = filemonth = fileday = 0;
		return;
	}
        xferval = nmdate * 60L * 60L * 24L; /* seconds since 12/31/77 */
	xferval += 252392400L;		   /* seconds since 01/01/70 */
	ftsptr = localtime(&xferval);
	fileyear = ftsptr->tm_year;
	filemonth = ftsptr->tm_mon;
	fileday = ftsptr->tm_mday;
}
/* ---------------------------------------------------------------- */
/*
	Write a byte to output file.
	Repeat byte (0x90) expanded here.
	Checksumming of output stream done here.
*/
void send(c)
register unsigned char c;
{
	static unsigned char savec;	/* Previous byte put to output */

	/* Repeat flag may have been set by previous call */
	if (repeat_flag)
	{
		/* Repeat flag was set - emit (c-1) copies of savec	*/
		/*  or (if c is zero), emit the repeat byte itself	*/
		repeat_flag = 0;
		if (c)
		{
			cksum += (savec & 0xff) * (c - 1);
			while (--c)
				output(savec, outfd);
		}
		else
		{
			output(REPEAT_CHARACTER, outfd);
			cksum += REPEAT_CHARACTER;
		}
	}
	else
		/*normal case - emit c or set repeat flag*/
		if (c == REPEAT_CHARACTER)
			repeat_flag++;
		else
		{
			output(savec = c, outfd);
			cksum += (c & 0xff);
		}
}
/* ----------------------------------------------------------------- */
/*
	Output to screen or file, checking for abort during screen output.
*/
void output(ch, fd)
int ch;
FILE *fd;
{
	int tchar;

	if (diskout)		/* No checking during disk output */
	{	if (putc(ch, fd) == EOF)
		{	cerror("error writing to file.");
			cfabort();		/* disk output broken */
		}
		else
			outreccount = (outreccount + 1) & 127;
		return;
	}
	else if (!contin)	/* allows seek to next library member */
		return;

	ch &= 0x7F;
	if (ch != '\07')	/* no bells please */
		putc(ch, fd);

	if (ch == '\n')
	{
		tchar = 0;
		if ((scrline++ > ROWS - 3) && (pause))
		{	scrline = 1;
			  printf(" [more] ");
			tchar = mgetch(WAIT);
			printf("\r       \r");
		}
		else
			tchar = mgetch(NOWAIT);

		if (toupper(tchar) == 'Q')
		{	cfabort();
			return;
		}

		switch (tchar & 0x1F)		/* c, C --> ^C, etc. */
		{ case 3  :			/* ^C, ^K */
		  case 11 : cfabort();		/* exit program */
			    break;
		  case 24 : contin = 0;		/* ^X next file */
			    break;
		  case 26 : pause = 0;		/* ^Z zip to EOF */
			    break;
		}
	}
}
/* ---------------------------------------------------------------- */
/*
	Send CRLFs to console, causing output() to count lines.
*/
void outcrlf(times)
int times;
{
	contin = 1;		/* always print */
	while(times--)
	{	output('\r', stdout);
		output('\n', stdout);
	}
}
/* ---------------------------------------------------------------- */
/*
	Get / test for character / monitor for carrier loss (if cdline).
*/
int mgetch(keywait)
int keywait;
{
	int result = 0, comresult;

	do
	{	if (timelmt)	/* see if time expired */
		{	time(&nowtime);
			if ((nowtime - starttime) > timelmt)
			{       printf(
			"\n  %s: %d-minute time limit exceeded.\n",
					PROGNAME, timelmt / 60);
				quit();
			}
		}
#ifdef UNIX
		if (keywait)
		{	result = getchar();
			if (result < 0)
				result = 0;
		}
#else
		if (cdline)	/* check for carrier */
		{	comresult = bioscom(3, 0, cdline-1);
			if ((comresult & 0x80) == 0)
				quit();		/* no carrier; abort */
			else if (comresult & 0x100)	/* COM data ready */
				return(bioscom(2, 0, cdline-1));
		}
		if (bioskey(1))			/* also poll console */
			result = bioskey(0);
#endif
	}
	while (!result && keywait);	/* if !keywait, just poll once */
	return (result);
}
/* ---------------------------------------------------------------- */
/*
	Custom input routine, checks for end of library member
*/
int cgetc(stream)
FILE *stream;
{
	if (inlbr)
		if (mlength-- == 0)	/* library member length */
		{	contin = 0;
			return (EOF);
		}
	return (getc(stream));
}
/* ---------------------------------------------------------------- */
/*
	Print error message.
*/
void cerror(message1, message2, message3, message4)
char *message1, *message2, *message3, *message4;
{
	outcrlf(1);
	fprintf(stderr, "  %s: ", PROGNAME);
	fprintf(stderr, message1, message2, message3, message4);
	return;
}
/* ---------------------------------------------------------------- */
/*
	Program exits.
*/
void quit()
{
#ifdef UNIX
	printf("\n");
	ttyrestore();		/* restore tty */
#endif
	exit (0);		/* no errors */
}
/* ---------------------------------------------------------------- */
/*
	Abort program.
*/
void cfabort()
{
	printf("\n [abort]\n");
	checkwait();
	quit();
}
/* ---------------------------------------------------------------- */
/*
	Wait for keystroke (-w option)
*/
void checkwait()
{
	if (waitflag)
	{	printf(" Strike any key -- ");
		mgetch(WAIT);
		printf("\n");
	}
}
/* ---------------------------------------------------------------- */
/*
	Translate string to uppercase, strip high bits
*/
void stupcase(stptr)
char *stptr;
{
	while (*stptr != '\0')
		*stptr++ = (toupper(*stptr) & 0x7F);
}
/* ---------------------------------------------------------------- */
/*
 cisubstr(string, token) searches for lower case token in string s
 returns pointer to token within string if found, NULL otherwise
*/

char *cisubstr(s, t)
char *s, *t;
{
        char *ss, *tt;
        /* search for first char of token */
        for (ss = s; *s; s++)
                if (*s == *t)
                        /* compare token with substring */
			for (ss = s, tt = t; ; )
			{	if (*tt == 0)
                                        return s;
                                if (*ss++ != *tt++)
                                        break;
                        }
        return NULL;
}
/* End of CFX.C */
