.scrwidth   equ 128
.halfheight equ #40
.fa         equ 256 * 4  ;Fine angles (1/4 of 1/256th)
.famax      equ fa - 1
.famask     equ famax / 256
.fa90       equ fa / 256 / 4
.fa180      equ fa90 * 2
.fa270      equ fa180 + fa90
.focal      equ #57
.step       equ 50
.wallnear   equ #57  ;Max of focal and step
.mwallnear  equ -wallnear
.keyframes  equ 4

nolist
limit #9fff
org #3000
incbin "test.lay"

org #4400
incbin "sprdat.bin"

org #8000

run start,wffb

.flipx equ #01
.negx  equ #02
.flipy equ #04
.negy  equ #08
.degcon
;0 .. 89 degrees
db flipx + negy
;90 .. 179 degrees
db negx + negy + flipy
;180 .. 269 degrees
db negx + flipx
;270 .. 359 degrees
db flipy

.inks
db #54,#44,#55,#56,#52,#5e,#4a,#46,#53,#4e,#47,#54,#5c,#4c,#40,#4b

.intrt
push af
push bc
push hl
ld hl,intno
ld b,#f5
in a,(c)
rra
ld a,(hl)
jr nc,useint
xor a
.useint
inc a
ld (hl),a
dec a
jr z,int0
dec a
dec a
jr z,int2
dec a
jr z,int3
dec a
jr z,int4
dec a
jr z,int5
.endint
pop hl
pop bc
pop af
ei
ret

.int0
ld bc,#bc07
out (c),c
ld bc,#bdff
out (c),c
ld bc,#bc06
out (c),c
ld bc,#bd10
out (c),c
ld bc,#bc0c
out (c),c
.scrhigh equ $ + 1
ld bc,#bd30
out (c),c
ld bc,#bc0d
out (c),c
ld bc,#bd00
out (c),c
ld bc,#7f00
out (c),c
.sky equ $ + 1
ld bc,#7f55
out (c),c
ld hl,keytest
dec (hl)
jr nz,endint
ld (hl),keyframes
push de
call keys
pop de
jr endint

.int2
ld bc,#bc04
out (c),c
ld bc,#bd10
out (c),c
jr endint

.int3
ld bc,#7f00
out (c),c
.ground equ $ + 1
ld bc,#7f56
out (c),c
jr endint

.int5
ld bc,#bc07
out (c),c
ld bc,#bd0a
out (c),c
ld bc,#bc04
out (c),c
ld bc,#bd15
out (c),c
jr endint

.int4
call scan
ld bc,81
.ploop
dec bc
ld a,b
or c
jr nz,ploop
ld bc,#bc0c
out (c),c
ld bc,#bd00
out (c),c
ld bc,#bc0d
out (c),c
ld bc,#bd20
out (c),c
ld bc,#7f00
out (c),c
ld bc,#7f54
out (c),c
ld bc,#bc06
out (c),c
ld bc,#bd02
out (c),c
jp endint

.start
xor a
call #bc0e
ld bc,#0303
call #bc38
call #bd19
ld bc,#bc07
out (c),c
ld bc,#bd1b
out (c),c
.wffb
call #bd19
call #b909
di
ld a,#c3
ld (#38),a
ld hl,intrt
ld (#39),hl
ld hl,inks
ld bc,#7f00
.iloop
out (c),c
ld a,(hl)
inc hl
out (c),a
dec b
inc c
bit 4,c
jr z,iloop
ld bc,#bc01
out (c),c
ld bc,#bd20
out (c),c
ld bc,#bc02
out (c),c
ld bc,#bd2a
out (c),c
ei
xor a
ld hl,#3000
ld de,#c0
ld b,64
.mkmap
push bc
push de
ld bc,64
ldir
pop de
inc d
pop bc
djnz mkmap

exx
push bc
push de
push hl
.dowalls
di
.newangle equ $ + 1
ld a,#11
ld (angle),a
ld hl,(newplayerx)
ld (playerx),hl
ld hl,(newplayery)
ld (playery),hl
ei
call walls
call swapscreen
call render
jr dowalls

.keys
ld hl,newangle
ld a,8
call tkey
jr nz,noleft
inc (hl)
.noleft
ld a,1
call tkey
jr nz,noright
dec (hl)
.noright
xor a
call tkey
jr nz,noup
ld b,30
call move
jr nodown
.noup
ld a,2
call tkey
jr nz,nodown
ld b,-30
call move
.nodown
ld a,#2f
call tkey
jr nz,nospace
ld bc,#0878
.keysp
push bc
ld a,(newangle)
ld hl,#180
call hlcosa
ld de,(playerx)
add hl,de
push hl
ld a,(newangle)
add 128
ld hl,#180
call hlsina
ld de,(playery)
add hl,de
pop de
pop bc
ld l,d
ld a,h
cp 64
ret nc
ld a,l
cp #c0
ret c
ld a,(hl)
add b
and c
jr nz,notz
ld a,h
or a
jr z,bound
cp 63
jr z,bound
ld a,l
cp #c0
jr z,bound
inc a
ld a,0
jr nz,notz
.bound
ld a,(hl)
add b
add b
.notz
or a
jr z,aisz
or 128
.aisz
ld (hl),a
ret

.nospace
ld a,#4f
call tkey
ret nz
ld bc,#0000
jr keysp

.move
push bc
ld a,(newangle)
call bcosa
ld e,a
ld d,0
bit 7,e
jr z,epos
dec d
.epos
.newplayerx equ $ + 1
ld hl,#c880
pop bc
push hl
add hl,de
ld (newplayerx),hl
push hl
ld a,(newangle)
add 128
call bsina
ld e,a
ld d,0
bit 7,e
jr z,epos2
dec d
.epos2
.newplayery equ $ + 1
ld hl,#0880
add hl,de
ex de,hl
pop bc  ;BC = x, DE = y
ld h,d
ld l,b
ld a,(hl)
add a
jr c,nomove
;Check to left (x - 1)
dec l
ld a,(hl)
add a
jr nc,nowl
ld a,c
cp wallnear
jr nc,nowl
ld c,wallnear
.nowl
;Now check right (x + 1)
inc l
inc l
ld a,(hl)
add a
jr nc,nowr
ld a,mwallnear
cp c
jr nc,nowr
ld c,a
.nowr
;Now check forward (y - 1)
dec l
dec h
ld a,(hl)
add a
jr nc,nowf
ld a,e
cp wallnear
jr nc,nowf
ld e,wallnear
.nowf
;Now check backward (y + 1)
inc h
inc h
ld a,(hl)
add a
jr nc,nowb
ld a,mwallnear
cp e
jr nc,nowb
ld e,a
.nowb
ld (newplayery),de
ld (newplayerx),bc
pop hl
ret

.nomove
pop hl
ld (newplayerx),hl
ret

.walls
ld a,(angle)
ld l,a
add hl,hl
add hl,hl
ld (midangle),hl
add 128
ld (anglep180),a
ld b,focal
call bcosa
ld e,a
ld d,0
bit 7,a
jr z,cpos
dec d
.cpos
ld hl,(playerx)
add hl,de
ld a,l
or a
jr nz,xnoto
inc l
.xnoto
ld (viewx),hl
call negHL
ld (nviewx),hl
ld a,(angle)
ld b,focal
call bsina
ld e,a
ld d,0
bit 7,a
jr z,spos
dec d
.spos
ld hl,(playery)
add hl,de
ld a,l
or a
jr nz,ynoto
inc l
inc a
.ynoto
ld (viewy),hl
neg
ld (ypartialup),a
call negHL
ld (nviewy),hl
ld a,(viewx)
neg
ld (xpartialup),a
ld hl,info
ld (pixx),hl
ld hl,pixangle
ld b,scrwidth
.walllp
push bc
ld c,(hl)
inc l
ld b,(hl)
inc hl
push hl
.midangle equ $ + 1
ld hl,0
add hl,bc
ld a,h
and famask
ld h,a          ;HL now holds correct angle for vertical line
ld b,l

ld l,a
ld h,degcon / 256
ld c,(hl)       ;C has degree mask

db #fd:ld l,c   ;YL = bit mask

.xpartialup equ $ + 1
ld a,0
ld h,#1c        ;INC E
bit 1,c         ;Neg X?
jr z,xisup
neg
inc h           ;DEC E
.xisup
ld (xpartial),a
ld a,h
ld (focxstep),a
ld (xtilestep),a
.ypartialup equ $ + 1
ld a,0
ld h,#14        ;INC D
bit 3,c
jr z,yisup
neg
inc h           ;DEC D
.yisup
ld (ypartial),a
ld a,h
ld (focystep),a
ld (ytilestep),a

call dosteps
ld (xstep),hl
ld (xcond),a

call dosteps
ld (ystep),hl
ld (ycond),a  

.xpartial equ $ + 1
ld b,0
call smulHLbyB
.viewy equ $ + 1
.focalty equ viewy + 1
ld bc,#0001
add hl,bc
.ystep equ $ + 1
ld bc,0
;BC = Y intercept Low is used in Vert loop

;H is now Y Intercept High, used in loop, also used for Y in xspot
;X in xspot is focaltx + xtilestep (inc/dec), Used in vert loop
ld d,h
ld a,(focaltx)
ld e,a
.focxstep
;INC/DEC E
inc e           ;E is xtile
exx

.ypartial equ $ + 1
ld b,0
ld hl,(xstep)
call smulHLbyB
.viewx equ $ + 1
.focaltx equ viewx + 1
ld bc,#a900
add hl,bc
.xstep equ $ + 1
ld bc,0

;H is now X Intercept High, used in loop, Also used for X in yspot
;Y in Y spot is focalty + ytilestep (inc/dec), Used in horiz loop
ld e,h
ld a,(focalty)
ld d,a
.focystep
;INC/DEC D
inc d           ;D is ytile
exx

;Compare yintercepth (D') with ytile (D)
.vertcheck
ld a,d
cp 64
exx
jr nc,horizentry
cp d
jr z,horizentry
.ycond
jr nc,horizentry
exx
.vertentry
;Test map + yspot
ld a,(de)
add a
jr c,verthit
.xtilestep
inc e           ;xtile = xtile + xtilestep (INC/DEC E)
add hl,bc       ;yintercept + ystep
ld d,h
jr vertcheck

.horizcheck
ld a,e
cp #c0
exx
jr c,vertentry
cp e
jr z,vertentry
.xcond
jr nc,vertentry
exx
.horizentry
ld a,(de)
add a
jr c,horizhit
.ytilestep
inc d           ;ytile = ytile + ytilestep (INC/DEC D)
add hl,bc       ;xintercept + xstep
ld e,h
jr horizcheck

.verthit
db #fd:ld c,l
bit 1,c         ;Neg X?
jr z,nongx
inc e           ;Increment xintercepthigh (xtile) if xtilestep = -1
.nongx
ld b,l          ;B is texture offset shl n
ex de,hl        ;DE is now yintercept
ld h,l          ;xtile
ld l,0          ;HL is now xtile shl 8
jr dohit

.horizhit
db #fd:ld c,l
bit 3,c         ;Neg Y?
jr z,nongy
inc d           ;Increment yintercepthigh (ytile) if ytilestep = -1
.nongy          ;HL already xintercept
ld b,l
ld e,0          ;DE is now ytile shl 8

.dohit
ex af,af'
ld a,b
rra:rra:rra:rra
and #0f
push af
;ld a,b
;ld (texture),a
push de
.nviewx equ $ + 1
ld de,0
add hl,de
.angle equ $ + 1
ld a,#11
call hlcosa
ex (sp),hl
.nviewy equ $ + 1
ld de,0
add hl,de
.anglep180 equ $ + 1 ;Actually need -HL*sin(A) to add, so use angle + 180
ld a,0
call hlsina
pop de
add hl,de       ;HL is now distance to wall, need to divide height numerator by it
;Height Numerator is #5800
;push hl
srl h
rr l
call calcheight ;Gets the height in B
pop de
ex af,af'
or d
.pixx equ $ + 1
ld hl,0         ;X pixel
ld (hl),a       ;Wall type
inc l
ld (hl),b       ;Height
;inc h
;ld (hl),d       ;Texture Offset
;dec l
;ld (hl),e
;dec h
;inc l
inc l
ld (pixx),hl
pop hl
pop bc
dec b
jp nz,walllp
ret

.dosteps        ;B = angle, C=mask. Returns Carry if Negative
ld a,b
rr c
jr nc,noflip    ;Flip?
cpl
.noflip
rr c            ;Carry remains from here
ld h,tantab / 256
jr nc,noneg
ld h,tantab / 256 + 2
.noneg
ld l,a
ld a,(hl)
inc h
ld h,(hl)
ld l,a
ld a,#30
ret nc
ld a,#38
ret

.divtable ;HL=0 ..#3ff, A=H

.calcheight  ;#2c00 / HL returned in B
ld de,-#002d
add hl,de
ld b,d       ;#ff
ret nc

;#0000 to #ffff
ld a,h
cp #06
jr nc,ge6

;#0000 to #05ff
cp #04
jr nc,ge4

;#0000 to #03ff
add divtab / 256
ld h,a
ld b,(hl)
ret

.ge4
ld a,l
ld b,#09
;#0400 to #05ff
jr nz,ge5
;#0400 to #04ff
cp #75
ret nc
;#0400 to #0474
inc b
cp #04
ret nc
;#0400 to #0403
inc b
ret

.ge5
;#0500 to #05ff
ld a,l
or a
ret z
;#0501 to #05ff (-1)
dec b
cp #b1 
ret c
;#05b1 to #05ff
dec b
ret

.ge6
;#0600 to #ffff
jr nz,ge7
;#0600 to #06ff
ld b,h
ld a,l
cp #98
ret nc
;#0698 to #06ff
inc b
ret

.ge7
;#0700 to #ffff
cp #0c
jr nc,gec
;#0700 to #0bff
sub #09
jr nc,ge9
;#0700 to #08ff
ld b,#05
inc a
ret z
;#0700 to #07ff
ld a,l
cp #d4
ret nc
;#0700 to #07d3
inc b
ret

.ge9
ld b,#04
;#0900 to #0bff
ret nz
;#0900 to #09ff
ld a,l
cp #9b
ret nc
;#0900 to #099a
inc b
ret

.gec
ld b,#03
;#0c00 to #ffff
jr nz,ged
;#0c00 to #0cff
ld a,l
cp #66
ret nc
inc b
ret

.ged
;#0d00 to #ffff
cp #11
ret c
;#1100 to #ffff
jr nz,ge12
;#1100 to #11ff
ld a,l
cp #6d
ret c
dec b
ret

.ge12
;#1200 to #ffff
dec b
cp #1d
ret c
;#1d00 to #ffff
ld a,l
cp #29
ret c
;#1d29 to #ffff
dec b
ret

.bcosa
add 64

.bsina
add a
jr z,bsinzero
jr nc,bpossin
call bpossin
neg
ret

.bsinzero
xor a
ret

.bis90
ld a,b
ret

.bpossin        ;sin for angles 1..127 (1 to 179 degrees)
cp #80          ;90 degrees
jr c,blt90
jr z,bis90      ;If it is 90 degrees, A is B sin(90) = 1
neg             ;Converts back to 0..63
.blt90
ld l,a
ld h,sintab / 256
inc l
ld l,(hl)
ld a,b
or a
jp p,mulLbyA
neg
call mulLbyA
neg
ret

.mulLbyA
ld e,l
ld d,0
add a
ld h,a
jr c,ncad0
ld l,d
.ncad0
add hl,hl
jr nc,ncad1
add hl,de
.ncad1
add hl,hl
jr nc,ncad2
add hl,de
.ncad2
add hl,hl
jr nc,ncad3
add hl,de
.ncad3
add hl,hl
jr nc,ncad4
add hl,de
.ncad4
add hl,hl
jr nc,ncad5
add hl,de
.ncad5
add hl,hl
jr nc,ncad6
add hl,de
.ncad6
add hl,hl
ld a,h
ret nc
add hl,de
ld a,h
ret

.smulHLbyB
bit 7,h
jr z,mulHLbyB
call negHL
call mulHLbyB

.neghl
xor a
sub l
ld l,a
sbc a
sub h
ld h,a
ret

.mulHLbyB
ld e,l
ld d,h
ld c,0
ld a,b
add a
jr c,noadh0
ld l,c
ld h,c
.noadh0
add hl,hl
rla
jr nc,noadh1
add hl,de
adc c
.noadh1
add hl,hl
rla
jr nc,noadh2
add hl,de
adc c
.noadh2
add hl,hl
rla
jr nc,noadh3
add hl,de
adc c
.noadh3
add hl,hl
rla
jr nc,noadh4
add hl,de
adc c
.noadh4
add hl,hl
rla
jr nc,noadh5
add hl,de
adc c
.noadh5
add hl,hl
rla
jr nc,noadh6
add hl,de
adc c
.noadh6
add hl,hl
rla
jr nc,noadh7
add hl,de
adc c
.noadh7
bit 7,l
ld l,h
ld h,a
ret z
inc hl
ret

.hlcosa         ;Returns HL*cos(A) in HL
add 64

.hlsina         ;Returns HL*sin(A) in HL
add a           ;Gets offset into table in A, and tests for 180..359 degrees
jr z,sinzero
jr nc,possin
call possin
jr negHL

.sinzero
ld hl,0
ret

.possin         ;sin for angles 1..127 (1 to 179 degrees)
cp #80          ;90 degrees
jr c,lt90
ret z           ;If it is 90 degrees, HL is unchanged since sin(90) = 1
neg             ;Converts back to 0..63
.lt90
ex de,hl
ld l,a
ld h,sintab / 256
ld a,(hl)
inc l
ld h,(hl)
ld l,a
bit 7,d
jr z,mulHLbyDE

ld c,l
ld b,h
ld hl,0
sbc hl,de
ex de,hl
ld l,c
ld h,b
call mulHLbyDE
jr negHL

.mulHLbyDE      ;Multiply HL by DE - Result in HLDE
ld a,h       ;1
ld c,l       ;2
ld hl,0      ;5
ld b,h       ;6

add a        ;7
jr nc,noad0  ;9
add hl,de    ;12
adc b        ;13
.noad0
add hl,hl    ;16
rla          ;17
jr nc,noad1  ;19
add hl,de    ;22
adc b        ;23
.noad1
add hl,hl    ;26
rla          ;27
jr nc,noad2  ;29
add hl,de    ;32
adc b        ;33
.noad2
add hl,hl    ;36
rla          ;37
jr nc,noad3  ;39
add hl,de    ;42
adc b        ;43
.noad3
add hl,hl    ;46
rla          ;47
jr nc,noad4  ;49
add hl,de    ;52
adc b        ;53
.noad4
add hl,hl    ;56
rla          ;57
jr nc,noad5  ;59
add hl,de    ;62
adc b        ;63
.noad5
add hl,hl    ;66
rla          ;67
jr nc,noad6  ;69
add hl,de    ;72
adc b        ;73
.noad6
add hl,hl    ;76
rla          ;77
jr nc,noad7  ;79
add hl,de    ;82
adc b        ;83
.noad7

ld b,a       ;84
ld a,c       ;85
ld c,b       ;86
push hl      ;90
ld b,0       ;92
ld h,b       ;93
ld l,b       ;94

add hl,hl    ;97
rla          ;98
jr nc,noad8  ;100
add hl,de    ;103
adc b        ;104
.noad8
add hl,hl    ;107
rla          ;108
jr nc,noad9  ;110
add hl,de    ;113
adc b        ;114
.noad9
add hl,hl    ;117
rla          ;118
jr nc,noad10 ;120
add hl,de    ;123
adc b        ;124
.noad10
add hl,hl    ;127
rla          ;128
jr nc,noad11 ;130
add hl,de    ;133
adc b        ;134
.noad11
add hl,hl    ;137
rla          ;138
jr nc,noad12 ;140
add hl,de    ;143
adc b        ;144
.noad12
add hl,hl    ;147
rla          ;148
jr nc,noad13 ;150
add hl,de    ;153
adc b        ;154
.noad13
add hl,hl    ;157
rla          ;158
jr nc,noad14 ;160
add hl,de    ;163
adc b        ;164
.noad14
add hl,hl    ;167
rla          ;168
jr nc,noad15 ;170
add hl,de    ;173
adc b        ;174
.noad15
pop de       ;177
;First result in CDE
;Current in AHL - Answer is CDE0 + AHL
ld b,d       ;178
ld d,e       ;179
ld e,0       ;181
add hl,de    ;184
adc b        ;185
ld e,a       ;186
ld a,c       ;187
adc 0        ;189
ld d,a       ;190
ex de,hl     ;191
ret          ;194

.swapscreen
ld hl,scrbase1
ld a,(hl)
xor #24
ld (hl),a
ld hl,scrbase2
ld a,(hl)
xor #04
ld (hl),a
ld hl,scrbase3
ld a,(hl)
xor #02
ld (hl),a
ret

.scraddr  ;L = y, H = x
ld d,h          ;1
ld h,#18        ;3
add hl,hl       ;6
.scrbase1
nop             ;7  - Swapped for inc h
add hl,hl       ;10
add hl,hl       ;13
ld a,l          ;14
ld e,a          ;15
and #c0         ;17
add d           ;18
ld l,a          ;19
ld a,e          ;20
and #38         ;22
add h           ;23
ld h,a          ;24
ret             ;27

.render
ld hl,info
.scrbase2 equ $ + 2
ld de,#c000
;push de
ld b,scrwidth / 2
.rendlp
push bc
ld c,(hl)   ;Wall hit
inc l
ld b,(hl)   ;Height
inc l
push hl
push de
push bc
ld l,halfheight
ld a,b
cp l
jr c,lt40
.il40
ld b,l
.lt40
ld a,b
ex af,af'
ld a,l
sub b
ex de,hl
call adown1
ld de,#c840
exx
pop bc          ;B is height, C is texture and wall
ld l,b          ;Need routine address (B and 7)
ld a,b
cp halfheight
jr c,lt64
ld a,halfheight
ld b,a
.lt64
and 7
db #fd:ld l,a
cp 4
jr nc,age4
sub 2
jr nc,age2
inc a
ld a,text0
jr nz,usetext
ld a,text7
jr usetext

.age2
ld a,text6
jr z,usetext
ld a,text5
jr usetext

.age4
sub 6
jr nc,age6
inc a
ld a,text4
jr nz,usetext
ld a,text3
jr usetext

.age6
ld a,text2
jr z,usetext
ld a,text1
.usetext
ld (textcall),a
ld a,b
exx
ld c,1
ld b,a
and #07
ld a,b
jr nz,not8
dec c
.not8
rra:rra
and #1e
add c
ld b,a
ld c,#08
exx
ld a,c
ld e,0
scf
rra
rr e
rra
rr e
ld d,a         ;DE is wall sprite and offset
ld h,scaletab / 256
ld c,(hl)      ;Adder low
inc h
ld b,(hl)      ;Adder high
inc h
inc h          ;This could be avoided if table modified
ld a,(hl)      ;Init High
dec h
ld l,(hl)      ;Init Low
add e
ld h,a

.textcall equ $ + 1
call text0

ex af,af'
call adown2
pop de
pop hl
ld c,(hl)   ;Wall hit
inc l
ld b,(hl)
inc l
push hl
push de
push bc
ld l,halfheight
ld a,b
cp l
jr c,lt40b
ld b,l
.lt40b
ld a,l
sub b
ld l,a
ld a,e
and #3f
ld h,a
call scraddr
ld de,#c840
exx
pop bc          ;B is height, C is texture and wall
ld l,b          ;Need routine address (B and 7)
ld a,b
cp halfheight
jr c,lt64b
ld a,halfheight
ld b,a
.lt64b
and 7
db #fd:ld l,a
cp 4
jr nc,age4b
sub 2
jr nc,age2b
inc a
ld a,text0b
jr nz,usetextb
ld a,text7b
jr usetextb

.age2b
ld a,text6b
jr z,usetextb
ld a,text5b
jr usetextb

.age4b
sub 6
jr nc,age6b
inc a
ld a,text4b
jr nz,usetextb
ld a,text3b
jr usetextb

.age6b
ld a,text2b
jr z,usetextb
ld a,text1b
.usetextb
ld (textcallb),a
ld a,b
exx
ld c,1
ld b,a
and #07
ld a,b
jr nz,not8b
dec c
.not8b
rra:rra
and #1e
add c
ld b,a
ld c,#08
exx
ld a,c
ld e,#80
scf
rra
rr e
rra
rr e
ld d,a         ;DE is wall sprite and offset
ld h,scaletab / 256
ld c,(hl)      ;Adder low
inc h
ld b,(hl)      ;Adder high
inc h
inc h          ;This could be avoided if table modified
ld a,(hl)      ;Init High
dec h
ld l,(hl)      ;Init Low
add e
ld h,a

.textcallb equ $ + 1
call text0b

pop de
inc de
pop hl
pop bc
dec b
jp nz,rendlp
;pop hl
;ld a,(angle)
;rra
;rra
;and 63
;jr z,nodots
;ld b,a
;.pixlp
;ld (hl),#aa
;inc hl
;djnz pixlp
;.nodots
.scrbase3 equ $ + 1
ld a,#30
ld (scrhigh),a
ret

.scan       ;Scans the keyboard to ktab, called on interrupt
            ;HL, BC, Flags corrupt
ld l,0
ld bc,#f40e
out (c),c
ld bc,#f6c0
out (c),c
out (c),l
ld bc,#f792
out (c),c
ld c,#49
ld hl,ktab+9
.sclp
ld b,#f6
out (c),c
ld b,#f4
ind
dec c
bit 6,c
jp nz,sclp
ld bc,#f782
out (c),c
ret

.tkey       ;Tests key A, returns Z if pressed
push hl
rrca
rrca
rrca
ld h,a
and #1f
ld l,a
ld a,h
ld h,0
ld bc,ktab
add hl,bc
rra
rra
and #38
or #46
ld (gmsk+1),a
.gmsk
bit 0,(hl)
pop hl
ret

.inkxlat
db #00,#c0,#30,#f0,#0c,#cc,#3c,#fc,#03,#c3,#33,#f3,#0f,#cf,#3f,#ff

.adown1
ld b,a
add a
ret z
add b
ld e,a
ld d,fastclr / 256
.skycol equ $ + 1
ld bc,#1000
push de
cp #c0
jr z,fastclr2
ld a,#c9
ld (de),a
ld a,h
ld de,#c840
call fastclr
pop de
ld a,#71   ;ld (hl),c
ld (de),a
ret

.fastclr2
ld a,h
ld de,#c840
jp fastclr

.adown2
ld b,a
add a
ret z
add b
ld e,a
ld d,fastclr / 256
push de
ld a,h
and #f7
ld de,#c840
.groundcol equ $ + 1
ld bc,#1000
ret

defs 256 - $ and 255
.fastclr
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add b
ld h,a
ld (hl),c
set 3,h
ld (hl),c
add hl,de
ld a,h
ret

list
.textlp
nolist
exx
add hl,bc

.text0
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
exx
add hl,bc

.text1
ld e,h
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text2
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
exx
add hl,bc
ld e,h

.text3
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text4
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
exx
add hl,bc

.text5
ld e,h
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text6
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
exx
add hl,bc

.text7
ld e,h
ld a,(de)
exx
ld (hl),a
add hl,de
djnz textlp
db #fd:ld a,l
or a
ret z
ld b,a
exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
ld (hl),a
set 3,h
ret

.textlpb
nolist
exx
add hl,bc

.text0b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
exx
add hl,bc

.text1b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text2b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
exx
add hl,bc
ld e,h

.text3b
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text4b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
exx
add hl,bc

.text5b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
exx
add hl,bc

.text6b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
exx
add hl,bc

.text7b
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
add hl,de
djnz textlpb
db #fd:ld a,l
or a
ret z
ld b,a
exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
ld a,h
add c
ld h,a
dec b
ret z

exx
add hl,bc
ld e,h
ld a,(de)
exx
or (hl)
ld (hl),a
set 3,h
ret

.convmap
ld hl,#c0
ld de,#3000
ld b,64
.convlp
push bc
push hl
ld bc,64
ldir
pop hl
inc h
pop bc
djnz convlp
ret

.ktab         ds 10,#ff

.playerx      dw #c800
.playery      dw #0800

.intno        db 128
.keytest      db keyframes

.space
ds 256 - $ and 255

list
.endprog

nolist
.divtab
incbin "div.dat"
list
.tantab
nolist
incbin "fasttan.dat"
list
.sintab   equ $ - #80
.scaletab equ sintab - #400
.pixangle equ scaletab - #100
nolist
defs 256 - $ and 255

.info
ds 128 * 4

list
.end