.upper		equ #caa6

.dalloc		equ #a900
.sorted		equ #aa00
.sortedx	equ #ab00
.dalloch	equ #a9
.sortedh	equ #aa
.sortedxh	equ #ab
.winbuff	equ #a360
.formbuff	equ #a300
.vbuff		equ #aeb0

nocode
org #be80

list
.ramlist 	ds 34
.keystate	db 0
.stack		dw 0
.formdesc	dw 0
.sect1		db 0
.sect2		db 0
.sect3		db 0
.fspec		ds 14
.fspec2		ds 13
.unumb		ds 4
.tuser		ds 4
.userl		db 0
.issort		db 0
.rwcal		ds 3
.fordo		ds 3
.dire		db 0
.dirsc		db 0
.dsm		dw 0
.exmsk		db 0
.blmsk		db 0
.entries	dw 0
.files		dw 0
.lastf		dw 0
.lastf2		dw 0
.firstf		db 0
.totalk		dw 0
.kused		dw 0
.curpos		dw 0
.maxcp		dw 0
.curadr		dw 0
.ktagged	dw 0
.ftagged	dw 0
.xypos		dw 0
.doit		db 0
.numadr
.attset		dw 0
.obaff
.destuser	db 0
.verror
.alloww		db 0
.numfr		db 0
.scrls		db 0
.basea		dw 0
.basef		db 0
.currf		db 0
.resert		db 0
.verform	db 0
.formdrv	db 0
.oldwin		ds 4
.oldpen		db 0
.oldcurs	dw 0
.wintop		dw 0
.winwid		db 0

nolist

org #40

list
.tempf2		ds 13
.tempf		ds 13
.savedpb	ds #3a
.recaddr	dw 0
.blkoff		dw 0
.sectoff	db 0
.trksec		dw 0
.rfname		dw 0
.buftot		ds 3
.buffree	ds 3
.bufstrt	dw 0
.bufstbk	db 0
.bufend		dw 0
.bufendbk	db 0
.ddir		dw 0
.crsect		dw 0
.rfptr		dw 0
.dlogged	db 0
.endddir	dw 0
.ffile		db 0	;Leave this
.wfptr		dw 0	;group of 5 bytes
.wblks		dw 0	;intact.
.wrecad		dw 0
.wblkof		dw 0
.wsectof	db 0
.writeyn	db 0
.wextent	db 0
.wfloc		dw 0
.writeent	dw 0
.wtrksec	dw 0
.wclose		db 0
.werror		db 0
.wrtany		db 0
.needent	db 0
.cursdisp	dw $+endcurs-showcurs
nolist

code

.RAM_DDB equ #baff
.RAM_DPBC equ #bafe
.RAM_LOCK equ #bafa

org #1000
limit #3fff
write "rom.cmd"
ld c,6
call #b90f
push bc
ld a,(#c002)
ld hl,fb
cp 7
jp nz,start
ld hl,fb2
jp start
.fname
db "A40B80.ROM"
db 2,3			;Format enables, DDB
.start
push hl
ld a,#a			;Increase step rate for faster drive access
ld (#45da),a
ld a,#75
ld (#4004),a
ld a,#f3
ld (#4078),a
call #b903
pop hl
.nxthl
ld e,(hl)
inc hl
ld a,(hl)
inc hl
sub #80
ld d,a
or e
jr z,finished
ld bc,3
ldir
jr nxthl
.finished
ld a,#f0
ld (#4593),a
ld (hlval+1),hl
ld hl,fname
.lngh
ld b,10
ld de,#8000
call #bc8c
ret nc
.hlval
ld hl,0
ld bc,len1
ld de,here2
ld a,(start-1)
ld (hl),a
inc hl
inc hl
inc hl
ld a,(start-2)
ld (hl),a
dec hl
dec hl
dec hl
ldir
ld hl,here2
ld de,#5c00
ld bc,#2400
ldir
ld hl,endall-#8000
ld de,endall-#7fff
list
ld bc,2-endall
nolist
ld (hl),0
ldir
ld a,2
ld hl,#4000
ld de,#4000
ld bc,0
call #bc98
ret nc		;jp nc,diser
call #bc8f
ret nc		;jp nc,diser
pop bc
jp #b918

.fb
dw #c1be
call dob912
dw #c1c4
jp setdrv
dw #c5f2
call setdrv2
dw #c588
call selhl
dw #c59f
call selde
dw #c687
call drvhd
dw #c566
call drvhd
dw #c6a6
call rttr2
dw #c76f
call rttr
dw #c6aa
call rthd
dw #cde7
call setup
dw #ca7b
call dmess
dw #c57a
call abstrk
dw #c072
jp plus
dw #c075
db "PDo"

dw #8000

.here1
org #dc00
limit #ffff
.ROM_DDB
defb #03
defw RAM_DDB
.DPB_Cont
defb #02
.endd

.len1 equ endd-#dc00

org here1+len1
.fb2
dw #c1b5		;?????
call dob912
dw #c61c
call setdrv
dw #c588
call selhl
dw #c59f
call selde
dw #c687
call drvhd
dw #c566
call drvhd
dw #c6a6
call rttr2
dw #c7d3
call rttr
dw #c6aa
call rthd
dw #cede
call setup
dw #8000

.here2
org #dc00
.pROM_DDB
defb #03
defw RAM_DDB
.pDPB_Cont
defb #02

org here2+len1

.routines

org #dc00+len1

.setdrv2

push hl
ld hl,16
add hl,sp
ld a,(hl)
cp #2e
jr z,ok464
cp #2b
jr nz,nosign
.ok464
inc hl
ld a,(hl)
cp 3
call z,signon

.nosign
ld hl,(RAM_LOCK)
ld a,h
cp #44
jr nz,resetddb
ld a,l
cp #50
jr z,movein
.resetddb
ld a,(ROM_DDB)
ld (RAM_DDB-2),a	;#bafd
ld a,(DPB_Cont)
ld (RAM_DPBC-2),a	;#bafc
ld hl,#4450
ld (RAM_LOCK),hl	;#bafa
.movein
ld hl,(RAM_DPBC-2)
ld (RAM_DPBC),hl
pop hl
.dob912
jp #b912

.setdrv
call #b912
or a			;If this is ROM 0, do CPM
jr z,c1c7
cp 7			;If this is ROM 7, log on as normal
jr z,c1c7
pop bc			;Return address in lower ROM
ret nc
push bc
push de
push hl
ld hl,3
add hl,bc
ld b,a
ld a,(hl)
inc hl
cp #21
jr z,is464
inc hl
inc hl
.is464
ld e,(hl)
inc hl
ld d,(hl)		;Address of ROM workspace table

ld hl,14		;Offset of ROM 7
add hl,de
ld a,(hl)
inc hl
or (hl)			;Not logged on if zero
ld a,b
jr nz,overwr
pop hl
pop de

.c1c7
push iy
push de
jp #c1c7

.overwr
ld bc,-14
add hl,bc
ld c,a
inc b
add hl,bc
add hl,bc		;HL=address of workspace table for
			;this ROM

push iy
ld de,(#be7d)		;Address of Disc ROM workspace
ld (hl),d
dec hl
ld (hl),e

push de
pop iy
ld (iy-2),a
ld hl,#c9d6
ld (#be71),hl
ld (#be73),a
ld hl,#18b
call #ca9f		;Change for plus version?
ld (hl),#30
inc hl
ld (hl),#cd
inc hl
ld (hl),a
ld hl,#c5d4
call #c60d
push hl
call setdrv2
pop hl
pop iy
pop hl
pop de
or a
ret

.signon
call cprint
db " PARADOS V1.1. ",&a4,"1997 QUANTUM Solutions.",13,10,10,#ff
ret

.plus
call #b906
ld hl,0
jp #77

.nomen
call cprint
db 26,0,79,24,24,14,1,15,0,12," ",#ff
.cprint
pop hl
call cprint2
jp (hl)

.cprint2
push ix
ld ix,#bb5a
call fprint3
pop ix
ret

.fprint2
push ix
ld ix,fastchr
.fprint4
call #b906
call fprint3
call #b909
pop ix
ret

.fprint3
ld a,(hl)
inc hl
cp #a5
jr c,lessa5
cp #ff
ret z
cp #fe
jr nz,multf
push bc
ld a,c
cpl
ld c,a
ld a,(hl)
inc hl
call doix
pop bc
jr fprint3
.multf
cp -23
jr nc,gt23
push hl
ld hl,messtab
sub #a5
jr z,gotmess
ld b,a
ld a,#ff
.getmess
cp (hl)
inc hl
jr nz,getmess
djnz getmess
.gotmess
call fprint3
pop hl
jr fprint3
.gt23
jr nz,not23
ld a,-55
.not23
neg
.multf2
ld b,a
ld a,(hl)
inc hl
or a
jr nz,pllop2
.pllop3
inc de
djnz pllop3
jr fprint3
.pllop2
push bc
push af
call doix
pop af
pop bc
djnz pllop2
jr fprint3
.lessa5
call doix
jr fprint3

.fastch
push af
call #b906
pop af
call fastchr
jp #b909

.fastchr	;B=mask
push hl
ld h,7
ld l,a
add hl,hl
add hl,hl
add hl,hl
ld b,8
.chloop
ld a,(hl)
inc l
xor c
ld (de),a
ld a,d
add b
ld d,a
jp nc,chloop
add #c0
ld d,a
pop hl
inc de
ret

.chkdrv3
push bc
push de
and 1
ld e,a
ld a,#f
push hl
call #ca63
ld a,(#be51)
and #f0
ld (hl),a
pop hl
jr chkdrv4

.chkdrv2
push bc
push de
and 1
ld e,a
.chkdrv4
ld a,(RAM_DPBC)
ld d,#f
and d
add a:add a
add a:add a
ld c,a
bit 4,c
jr nz,nodpbuse2
ld a,d
call #ca5c
and #f0

cp #90		;PARADOS 80
jr z,ispdos
cp #70		;S-DOS (ROMDOS D80)
jr nz,nsdos
.ispdos
dec d
set 1,c		;80 tracks per side

.nsdos
cp #80			;PARADOS 41?
jr z,setdtoc		;Must be single sided, 40 track

or a			;IBM/D1
jr nz,notd1a
bit 6,c			;IBM formats disabled?
jr z,ds80		;Must be D1 (DS80)
.notd1a
cp #10			;Ultraform/D10
jr nz,notd10a
bit 7,c			;Ultraform disabled?
jr z,ds80		;Must be D10 (DS80)
jr setdtoc		;If Ultraform (SS40)

.notd10a
bit 5,c			;Electro formats enabled?
jr nz,nodpbuse		;IF not, DATA, SYSTEM and IBM (SS40)

cp #40			;SYSTEM
jr z,setdtoc
cp #c0			;DATA
jr z,setdtoc
or a			;IBM
jr nz,nodpbuse

.setdtoc
ld d,#c

.nodpbuse
cp #20		;D2
jr z,ds80
cp #50		;D40
jr z,ds40
cp #a0		;PARADOS 40D
jr z,ds40
cp #30		;D20
jr nz,nodpbuse2

.ds80
set 1,c		;80 tracks per side
.ds40
set 0,c		;Double sided
.nodpbuse2
ld a,e
call chkdrv0
and d
or c
pop de
pop bc
ret

.chkdrv0
or a
ld a,(RAM_DDB)
jr nz,driveb
rra:rra
rra:rra
.driveb
bit 1,a		;If drive is 80 track, then
ret z
and #7		;Disable double-stepping
ret

.selhl
ld a,l
ld (#be4e),a
call stdalv
push af
push bc
ld hl,#ca43		;SYSTEM SS40
ld a,(RAM_DPBC)
ld c,a
bit 1,c
jr nz,allowbigds	;Allow big data and system formats
ld a,(#be51)
and #f0
cp #40
jr z,issys
cp #c0
jr z,issys
bit 3,c
jr z,notultraf
cp #10
jr z,issys
.notultraf
bit 2,c
jr z,allowbigds		;Not IBM formats
or a
jr nz,allowbigds
.issys
pop bc
pop af
ret

.allowbigds
pop bc
pop af
call chkdrv3
and 3
ret z
ld hl,sys160
cp 3
ret z
ld hl,sys80
ret

.selde
push af
ld a,(#be4e)
call chkdrv3
and 3
ld b,a
ld a,(RAM_DPBC)
ld c,a
pop af
bit 2,c
jr z,noibmform
or a
jr nz,noibmform
ld a,b
ld de,#c5c0
or a
ret z
ld de,ibm160
cp 3
ret z
ld de,ibm80
ret

.noibmform
inc b
djnz nottyp0

bit 3,c
jr z,nottyp0

ld de,ultra
cp #10
jr z,bigalv

.nottyp0
ld de,d1
or a
jr z,setromdos
ld de,d10
cp #10
jr z,setromdos
ld de,d2
cp #20
jr z,setromdos
ld de,d20
cp #30
jr z,setromdos
ld de,d40
cp #50
jr z,setromdos
cp #70
ld de,d80
jr z,setromdos
cp #80
ld de,pdos41
jr z,bigalv
cp #90
ld de,pdos80
jr z,setromdos2
cp #a0
ld de,pdos40d
jr z,setromdos2
ld de,unknf
ret

.setromdos2
ld a,1
db 6

.setromdos
xor a
push hl
inc hl
inc hl
ld (hl),4
inc hl
ld (hl),#f
inc hl
ld (hl),a
inc hl
inc hl
inc hl
ld a,(de)
inc de
ld (hl),a
inc hl
inc hl
add a
ld a,#c0
jr nc,is7f
ld a,#f0
.is7f
ld (hl),a
inc hl
inc hl
ld (hl),#20
pop hl

.bigalv
ld a,(#be4e)
push de
push hl
ld de,#be00
or a
jr z,setalv
ld de,#4b0
call #ca98
jr setalv

.stdalv
push de
push hl
ld de,#1b9
or a
jr z,isalva
ld de,#1f9
.isalva
call #ca98
.setalv
ld hl,#21e
or a
jr z,isalva2
ld hl,#22e
.isalva2
call #ca9f
ld (hl),e
inc hl
ld (hl),d
pop hl
pop de
ret

.drvhd
call chkdrv2
push bc
ld b,a
bit 0,b
ld a,e
jr z,single
bit 0,d
jr z,output
set 2,a
.output
pop bc
jp #c95c
.single
ld a,b
and 4
or e
jr output

.rttr
call #ca63
ld a,e
call chkdrv2
push bc
ld b,a
bit 0,b		;Sidedness
jr z,output2
srl d		;Divide by 2 if double sided
.output2
bit 3,b
pop bc
ret z
sla d		;Multiply by 2 if double-stepped
ret

.rttr2
ld a,e
call chkdrv2
push bc
ld b,a
bit 0,b
ld a,d
jr z,output3
srl a
.output3
pop bc
call #c95c
ld a,d
ret

.rthd
ld a,e
call chkdrv2
push bc
ld b,a
bit 0,b
ld a,0
jr z,output
ld a,d
and 1
jr output

.abstrk
ld hl,(#bafe)
push hl
set 0,l
res 0,h
ld (#bafe),hl
ld hl,#c55d
call #c6ff
pop hl
ld (#bafe),hl
ret

.sys160
defb #24,#00
defb #05
defb #1f
defb #03
defb #b0,#00
defb #7f,#00
defb #80,#00
defb #10,#00
defb #02,#00
defb #41
defb #09
defb #2a
defb #52
defb #e5
defb #02
defb #04

.sys80
defb #24,#00
defb #04
defb #0f
defb #01
defb #ae,#00
defb #7f,#00
defb #c0,#00
defb #10,#00
defb #02,#00
defb #41
defb #09
defb #2a
defb #52
defb #e5
defb #02
defb #04

.ibm160
defb #20,#00
defb #9e,#00
defb #01,#00
defb #01
defb #08
defb #2a
defb #50

.ibm80
defb #20,#00
defb #9d,#00
defb #01,#00
defb #01
defb #08
defb #2a
defb #50

.pdos41
db #28,#00	;SPT, records per track
db #cc,#00	;DSM, number of blocks - 1
db #00,#00	;OFF, reserved tracks
db #81		;first sector number
db #0a		;sectors per track
db #09		;gap length (read/write)
db #10		;gap length (format)

.ultra
db #28,#00
db #cc,#00
db #00,#00
db #10
db #0a
db #09
db #10

.unknf
db #18,0
db #02,0
db 0,0
db #2a
db 6
db 0
db 0

.d1
db #7f
db #24,#00
db #67,#01
db #00,#00
db #01
db #09
db #2a
db #52

.d2
db #ff
db #24,#00
db #67,#01
db #00,#00
db #21
db #09
db #2a
db #52

.d10
db #7f
db #28,#00
db #8f,#01
db #00,#00
db #11
db #0a
db #09
db #10

.d20
db #ff
db #28,#00
db #8f,#01
db #00,#00
db #31
db #0a
db #09
db #10

.d40
db #7f		;DRM, number of directory entries - 1
db #28,#00
db #c7,#00
db #00,#00
db #51
db #0a
db #09
db #10

.d80		;Old SDOS format
db #7f		;DRM, number of directory entries - 1
db #28,#00
db #c7,#00
db #00,#00
db #71
db #0a
db #09
db #10

.pdos80
db #7f		;DRM, number of directory entries - 1
db #28,#00
db #c7,#00
db #00,#00
db #91
db #0a
db #09
db #10

.pdos40d
db #7f		;DRM, number of directory entries - 1
db #28,#00
db #c7,#00
db #00,#00
db #a1
db #0a
db #09
db #10

.dmess
ld a,(iy+0)
inc a
ld a,(#be78)
ret nz
pop af
pop af
push bc
push hl
push de
push af
call #bb69
ld (oldwin),hl
ld (oldwin+2),de
call #bb78
ld (oldcurs),hl
call #bb93
ld (oldpen),a
pop af
push af
cp #12
ld hl,#c32c
ld bc,#1cff
jr nz,smallwin
ld l,#29
ld b,#22
.smallwin
ld (wintop),hl
push bc
push hl
inc b
inc b
ld a,b
ld (winwid),a
ld de,winbuff
ld c,40
.keeplp
push bc
push hl
.keeplp2
rst #20
inc hl
ld (de),a
inc de
djnz keeplp2
pop hl
call nwline
pop bc
dec c
jr nz,keeplp
pop de
pop bc
call tline
call hline2
call hline2
call hline2
call bline
ld a,27
rrc b
dec b
sub b
ld h,a
ld a,27
add b
ld d,a
ld l,11
ld e,#d
call #bb66
xor a
call #bb90
ld a,1
call #bb96
pop af
pop de
pop hl
pop bc
ld c,e
call #cab8
push af
push hl
push de
push bc
ld hl,(wintop)
ld a,(winwid)
ld c,a
ld b,40
ld de,winbuff
.restloop
push bc
push hl
ld b,0
ex de,hl
ldir
ex de,hl
pop hl
call nwline
pop bc
djnz restloop
ld hl,(oldwin)
ld de,(oldwin+2)
call #bb66
ld a,(oldpen)
ld b,a
call #bb90
ld a,b
xor 1
call #bb96
ld hl,(oldcurs)
call #bb75
pop bc
pop de
pop hl
pop af
ret

.nwline
ld a,h
add 8
ld h,a
ret nc
ld bc,#c050
add hl,bc
ret

.bline
ld hl,#9a99
ld a,#93
jr hline

.mhline
push af
call hline2
pop af
dec a
jr nz,mhline
ret

.tline
ld hl,#9a9c
ld a,#96
jr hline

.mline
ld hl,#9a9d
ld a,#97
jr hline

.hline2
ld hl,#2095
ld a,l

.hline		;B=width, A=left character, H=mid character, L=right character
push de
push bc
call fastch
call #b906
pop bc
push bc
res 7,b
.mloop
push bc
ld a,h
call fastchr
pop bc
djnz mloop
ld a,l
call fastchr
pop bc
pop de
ld hl,80
bit 7,b
jr z,downl
ld hl,-80
.downl
add hl,de
ex de,hl
jp #b909

.ctagged
ld hl,(ftagged)
ld a,h
or l
ret nz
pop hl
ret

.clastf
ld hl,(lastf)
ld a,h
or l
ret nz
pop hl
ret

.cursor
call clastf
ld a,(curpos)
call times80
ld a,(curpos+1)
ld c,a
add a		;*2
add a		;*4
add a		;*8
add c		;*9
add a		;*18
ld c,a
add hl,bc
ld bc,#c0f1
add hl,bc
ld (curadr),hl
ld bc,#1201
jp cursdisp
.pad
ld a,e
cp h
ret z
ld a,32
call fastch
jr pad

.deck
srl h:rr l
srl h:rr l
jr dec3

.dec3a
ld l,a
ld h,0
.dec3
ld ix,#20ff
jr dec3b

.dec5		;Display HL as a 5 digit decimal
db #dd:ld h,32
ld bc,10000
call decbit
ld bc,1000
call decbit

.dec3b
ld bc,100
call decbit
ld bc,10
call decbit
ld a,l
add 48
jr decdig

.decbit
ld a,"0"
or a
sbc hl,bc
jr c,fnddig
inc a
db #dd:ld h,"0"
jr decbit+2
.fnddig
add hl,bc
cp "0"
jr nz,decdig
db #dd:ld a,h
.decdig
db #dd:ld c,l
jp fastch

.times80
add a	;*2
add a	;*4
add a	;*8
ld l,a
ld c,a
ld h,0
ld b,h
add hl,hl	;*16
add hl,hl	;*32
add hl,bc	;*40
add hl,hl	;*80
ret

.getblk		;HL=block number, drive in A, returns H=track, L=sector
ld e,a
ld a,2
call #ca5c	;Get block shift in A
sub 2
.adjhl
add hl,hl	;HL=HL*sectors per block
dec a
jr nz,adjhl
ld a,#10
call #ca5c	;Get sectors per track in A
push de
ld c,a
ld de,0
ld b,d
ld a,16
.loopd
push af
add hl,hl
rl e
rl d
ex de,hl
call cphlbc
jr c,nodiv
sbc hl,bc
set 0,e
.nodiv
ex de,hl
pop af
dec a
jr nz,loopd
ld h,e
pop de
ld a,(resert)
add l
ld l,a
ld a,(sect2)
add h
ld h,a
ret

.checkused
ld a,(bufstbk)
ld l,a
ld a,(bufendbk)
cp l
ret nz
ld hl,(bufstrt)
ld bc,(bufend)
jr cphlbc

.getfree
ld a,(buffree+2)
ld hl,(buffree)
or a
ret

.checkfree
call getfree
ret nz

.cphlbc
ld a,h
sub b
ret nz
ld a,l
sub c
ret

.rbuff
push hl
push bc
call movout
ld (bufstrt),de
ld (bufstbk),a
call getfree
pop bc
push bc
add hl,bc
adc 0
call setfree
pop bc
pop hl
ld de,winbuff
.outbuff
ex de,hl
ldir
ex de,hl
ret

.inbuff
ldir
ret

.wbuff
push bc
push bc
ld de,winbuff
ldir
pop hl
call movin
ld (bufend),de
ld (bufendbk),a
pop bc
call getfree
sbc hl,bc
sbc a,0
.setfree
ld (buffree),hl
ld (buffree+2),a
jp showfree

.movout
ld h,b:ld l,c
push hl
ld de,(bufstrt)
add hl,de
ld a,(bufstbk)
ld ix,outbuff
jr movemem

.movin
push hl
ld de,(bufend)
add hl,de
ld a,(bufendbk)
ld ix,inbuff

.movemem
ld bc,#8000
cp b
jr nz,usea3
ld b,#a3
.usea3
or a
sbc hl,bc
jr nc,nofit
pop bc		;Total length

.fits
ld hl,winbuff

push hl
push bc
ld h,#be
ld l,a
ld b,#7f
ld c,(hl)
out (c),c
pop bc
ld a,b
or c
ld a,l
pop hl
call nz,doix
ld bc,#7fc0
out (c),c
ret

.doix
jp (ix)

.nofit
ex (sp),hl		;Second section length
ld h,b
ld l,c
sbc hl,de
ld b,h
ld c,l
call fits
ld d,#40
inc a
pop bc
jr fits+3

.messtab
db #fe,"Attributes",-3," ",#fe,"Copy",-3," "	;#A5
db #fe,"E",#bf,-3," ",#ff
db "  ",#fe,"Tag",-3," ",#fe,"Un-tag",#ff	;#A6
db "ser number",#c0,#ff				;#A7
db "Total ",#ff					;#A8
db "entries ",#ff				;#A9
db "space  ",#ff				;#AA
db "agged ",#ff					;#AB
db "buffer  ",#ff				;#AC
db "rive ",#ff					;#AD
db "ormat",#ff					;#AE
db "erify",#ff					;#AF
db #ae,"ting",#ff				;#B0
db "ead only",#ff				;#B1
db "Used ",#ff					;#B2
db "Free ",#ff					;#B3
db "iles",#ff					;#B4
db "isc ",#ff					;#B5
db "d",#b5,#ff					;#B6
db #b6,#cb,#ff					;#B7
db " ",#cb,#ff					;#B8
db "rror",#ff					;#B9
db "ress any key",#ff				;#BA
db "ing track",#c0,#ff				;#BB
db ":  0K",#ff					;#BC
db "ename ",#ff					;#BD
db "irectory ",#ff				;#BE
db "rase",#ff					;#BF
db " : ",#ff					;#C0
db "- Ok",-3," ",#ff				;#C1

db "ROMDOS D",#ff				;#C2
db "SYSTEM ",#ff				;#C3
db "DATA ",#ff					;#C4
db "IBM ",#ff					;#C5
db "PARADOS ",#ff				;#C6
db "(S",#cc,#ff					;#C7
db "(D",#cc,#ff					;#C8
db "(S",#cd,#ff					;#C9
db "(D",#cd,#ff					;#CA

db "to ",#ff					;#CB
db "S 40)",#ff					;#CC
db "S 80)",#ff					;#CD

db "setup ",#ff					;#CE
db "onfigure ",#ff				;#CF

db "ULTRAFORM",#ff				;#D0

db "orted)",#ff					;#D1
db "(Y/N)",#c0,#ff				;#D2
db " another ",#b6,#ff				;#D3

.setup
or a
jp nz,#cdc2
ld hl,showcurs
ld de,cursdisp
ld bc,endcurs-showcurs
ldir
call #b912
ld hl,cursdisp+3
ld (hl),a
dec hl
ld c,0
jp #bd16
.begun
ld iy,#ac00
ld (iy+0),#ff
ld hl,ramlist2
ld de,ramlist
ld bc,#7fc0
ld ix,#62
push hl
.ramcheck
ld a,(hl)
inc hl
or a
jr z,exit1
out (c),a
xor a
ld (#4000),a
jr ramcheck
.exit1
pop hl
ld a,(hl)
inc hl
or a
jr z,exit2
out (c),a
ld a,(#4000)
or a
jr nz,exit1+1
cpl
ld (#4000),a
dec hl
ld a,(hl)
ld (de),a
inc hl
inc de
push bc
ld bc,#40
add ix,bc
pop bc
jr exit1+1
.exit2
xor a
ld (de),a
out (c),c
ld e,a
db #dd:ld a,h
db #dd:ld d,l
ld (buftot),de
ld (buftot+2),a
ld hl,initfs
ld de,fspec
ld bc,14+13+4+4+1+3+2
ldir
call cprint
db 4,2,29,13,13,28,-3,32,28,1,13,13,14,1,15,0
db 26,0,79,0,1,12
db 26,0,79,24,24,12,#ff

ld de,#c002
call dprint
db "PARADOS - Version 1.1   ",#a4
db "1997 QUANTUM Solutions.  Program by Richard Wilson.",0

.UnLogDsk
ld sp,#c000
call clmain
ld hl,0
ld (lastf),hl
ld (ftagged),hl
ld de,#c0a0
ld a,#ff
ld (fspec),a
ld c,a
call fprint
db #96,-23,#9a,#9e,-22,#9a,#9c,#ff
ld b,20
.pllop
push bc
call fprint
db #95,-23,0,#95,-22," ",#95,#ff
pop bc
djnz pllop
call fprint
db #93,-23,#9a,#9b,-22,#9a,#99,#ff
inc c
ld de,#c129
call fprint
db -5," Information",-6," ",#ff
dec c
ld e,#c9
call fprint
db "D",#ad,#c0,#ff
ld de,#c219
call fprint
db "F",#ae,#c0,#ff
ld e,#69
call fprint
db "User",-3," :",#ff
ld e,#b9
call fprint
db "F",#b4," ",#c0,#ff
ld de,#c359
call fprint
db "No. of f",#b4," ",#c0,#ff
ld e,#a9
call fprint
db #b2,#a9,#c0,#ff
ld e,#f9
call fprint
db #a8,#a9,":",#ff
ld de,#c499
call fprint
db #b3,#aa,"  ",#bc,#ff
ld e,#e9
call fprint
db #b2,#aa,"  ",#bc,#ff
ld de,#c539
call fprint
db #a8,#aa," ",#bc,#ff
ld e,#d9
call fprint
db "T",#ab,"f",#b4," ",#c0,#ff
ld de,#c629
call fprint
db "T",#ab,#aa,#bc,#ff
ld e,#c9
call fprint
db #b3,#ac," ",#bc,#ff
ld de,#c719
call fprint
db #a8,#ac,#bc,#ff
ld h,1
call setbuff

.keyloop2
ld a,#ff
ld (keystate),a
call status
.keyloop3
call cursor
.keyloop
call #bb1b
push af
ld a,23
call #bb1e
ld hl,klist2
ld a,2
jr nz,pressed
ld a,21
call #bb1e
ld hl,klist1
ld a,1
jr nz,pressed
ld hl,klist0
xor a
.pressed
push hl
call showmenu
pop hl
pop af
jr nc,keyloop
call upper
ld b,a
.ktloop
ld a,(hl)
inc hl
or a
jr z,testud
cp b
jr z,pressed2
inc hl
inc hl
jr ktloop
.pressed2
call cursor2
ld e,(hl)
inc hl
ld d,(hl)
ex de,hl
ld (stack),sp
call #1e
.cont
ld sp,(stack)
jr keyloop2

.testud
xor a
call #bb1e
jr nz,goup
ld a,2
call #bb1e
jr z,keyloop
call cursor3
.godown
ld bc,#213
call cpbchl
jr nz,notscru
call first
ld bc,60
add hl,bc
call checkhl
jr c,setcurs+3
call mainw
db 31,1,21,10,24,#ff
ld hl,firstf
inc (hl)
call first
ld de,#c6e1
add 19
.showem
ld l,a
call showf
inc de
call showf
inc de
call showf
jr setcurs+3
.notscru
ld a,d
cp h
jr nz,notr1
ld a,l
cp e
jr z,setcurs+3
.notr1
ld a,l
inc a
ld l,a
cp 20
jr nz,setcurs
ld l,0
inc h
.setcurs
ld (curpos),hl
jp keyloop3

.goup
call cursor3
ld a,h
or l
jr nz,notscrd
ld hl,firstf
ld a,(hl)
or a
jr z,setcurs+3
dec (hl)
call mainw
db 11,10,24,#ff
call first
ld de,#c0f1
jr showem

.notscrd
ld a,l
dec l
or a
jr nz,setcurs
ld l,19
dec h
jr setcurs

.mainw
call cprint
db 26,1,55,3,22,24,#ff
jp cprint

.cursor3
call cursor
ld hl,(curpos)
ld de,(maxcp)
ret

.cursor2
push hl
call cursor
.ret0
pop hl
xor a
ret

.status
ld c,#ff
ld de,#c269+8
ld a,(fspec+1)
or a
jr z,showdecu
call fprint
db "All",#ff
jr notdecu
.showdecu
ld a,(fspec+2)
call dec3a
.notdecu
ld de,#c2b9+8
ld hl,fspec2
call fprint2
ld de,#c1c9+8
ld a,(fspec)
inc a
ret z
add 64
call fastch
call fprint
db ": (",#ff
ld a,(issort)
or a
jr z,itssort
call fprint
db "Un-s",#d1,#ff
jr notsort
.itssort
call fprint
db "S",#d1,#fd," ",#ff
.notsort
ld de,#c219+8
ld hl,(formdesc)
call fprint2
.nochar
ld h,#2f
call pad
ld de,#c359+15
ld hl,(files)
call dec3
ld de,#c3a9+15
ld hl,(entries)
call dec3
ld de,#c3f9+15
ld a,(dire)
ld l,a
ld h,0
inc hl
call dec3
ld hl,(totalk)
push hl
ld de,(kused)
or a
sbc hl,de
ld de,#c499+15
call dec3
pop hl
ld de,#c539+15
call dec3
ld hl,(kused)
ld de,#c4e9+15
call dec3
call showt
push iy
ld iy,#ff
ld de,#c0f1
call first
.lpshowf
call checkhl
jr c,nofs
push hl
call showf2
db #fd:inc l
db #fd:ld a,l
cp 20
jr nz,norow
db #fd:inc h
db #fd:ld l,0
.norow
call nxfline
jr c,enddisp
.trynext
pop hl
inc hl
jr lpshowf
.enddisp
pop hl
jr anymore

.nofs
push de
ld c,0
call fprint
db -17," ",#ff
pop de
call nxfline
jr nc,nofs
.anymore
ld (maxcp),iy
pop iy
ret

.showf
push hl
call showf2
ld hl,17
add hl,de
ex de,hl
pop hl
ld a,l
add 20
ld l,a
ret

.cshow
call coffset
pop bc
push hl
push bc

.showf3		;HL points to file number
ld l,(hl)
db #dd:ld l,#ff
xor a
jr showf4

.showf2
db #dd:ld l,#00
ld l,(hl)
ld h,dalloch
ld a,(hl)
.showf4
push de
push af
call faddr
call pfile
pop af
and #40
ld a,32
jr z,usespc
ld a,"*"
.usespc
call fastch
pop de
ret

.showt
ld de,#c5d9+15
ld hl,(ftagged)
call dec3
ld de,#c629+15
ld hl,(ktagged)
jp dec3

.first
ld a,(firstf)
ld l,a
ld h,sortedh
ret

.showcurs
jr showcrs2
ld c,7
push bc
ld h,b
call #bcce
pop bc
call #b90f
jp begun

.showcrs2
call #b903
.xorlp2
push bc
push hl
.xorlp
ld a,(hl)
cpl
ld (hl),a
inc hl
djnz xorlp
pop hl
ld a,h
add 8
ld h,a
pop bc
jr nc,xorlp2
ld a,l:add #50:ld l,a
ld a,h:adc #c0:ld h,a
dec c
jr nz,xorlp2
jp #b900
.endcurs

.nxfline	;Carry set if at last pos
ld hl,#50
add hl,de
ld bc,#c730
call cpbchl
jr nc,nline
ld bc,#f9d2
add hl,bc
ld bc,#c120
call cpbchl
.nline
ex de,hl
ret

.pfile		;Displays filename of file at HL
push hl
ld l,(hl)
ld h,0
db #dd:ld h,#20
call dec3b
ld a,":"
call fastch
pop hl
inc hl
ld b,8
call pmask
ld a,"."
call fastch
ld b,3

.pmask
ld a,(hl)
inc hl
push bc
bit 7,a
jr z,b7i0
ld c,#ff
.b7i0
and #7f
call fastch
pop bc
djnz pmask
ret

.checkhl2
ld bc,(lastf2)
jp cpbchl
.checkhl
ld bc,(lastf)
.cpbchl
ld a,b
sub h
ret nz
ld a,c
sub l
ret

.showmenu
ld b,a
ld a,(keystate)
cp b
ret z
ld a,b
ld (keystate),a
or a
jr nz,notmain
call setcff
db "MAIN",#ff
call showmen
db #a5,#fe,"F",#b4,"pec",-3," ",#fe,"Move",-3," ",#fe,"R",#bd,#a6,"  ",#ff
ret

.klist0
db "A":dw SAttrib
db "C":dw SCopy
db "E":dw SErase
db "F":dw Filespec
db "M":dw SMove
db "R":dw Rename
db "T":dw STag
db "U":dw SUntag
db 0

.notmain
dec a
jr nz,notshft
call setcff
db "SHIFT",#ff
call showmen
db #fe,"Backup",-3," ",#fe,"C",#cf,"  ",#fe,"F",#ae,-3," ",#fe,"Log "
db #b6,"  ",#fe,"Sort",-3," ",#fe,"Un-log ",#b6,"  ",#fe,"V",#af,#ff
ret

.klist1
db "B":dw Backup
db "C":dw Configure
db "F":dw Format
db "L":dw Logdisc
db "S":dw SortFiles
db "U":dw UnLogDsk
db "V":dw DVerify
db 0

.notshft
call setcff
db "CONTROL",#ff
call showmen
db #a5,#fe,"Move ",#a6,-19," ",#ff
ret

.klist2
db "A"-64:dw MAttrib
db "C"-64:dw MCopy
db "E"-64:dw MErase
db "M"-64:dw MMove
db "T"-64:dw MTag
db "U"-64:dw MUntag
db 0

.dprint
call #b906
pop hl
ld a,(hl)
inc hl
push hl
or a
jp z,#b909
call dheight
jr dprint+3

.dheight
ld h,7
ld l,a
add hl,hl
add hl,hl
add hl,hl
ld c,8
push de
.chrloop
ld a,(hl)
cpl
ld (de),a
ld a,d
add c
ld d,a
ld a,(hl)
cpl
ld (de),a
inc hl
ld a,d
add c
jr nc,noadd
ld a,e
cp #50
jr nc,last
add #50
ld e,a
ld a,d
adc #c8
.noadd
ld d,a
jr chrloop
.last
pop de
inc de
ret

.showmen
call fprint
db #c0,#ff

.fprint
ex (sp),hl
call fprint2
ex (sp),hl
ret

.getkey
call #bb8a
call #bb18
push af
call #bb8a
pop af
ret

.getukey
call getkey
jp upper

.getdrive
call getukey
cp #fc
jp z,cont
cp "A"
jr c,getdrive
cp "C"
jr nc,getdrive
call #bb5a
sub "A"
ret

.coffset
ld hl,(curpos)
ld a,h
add a
add a
add h		;*5
add a
add a		;*20
add l
ld l,a
ld a,(firstf)
add l
ld l,a
ld h,sortedh	;HL=sorted+cursor offset
ret

.findsame	;Finds entry A from sortedx
ld bc,#100
ld hl,sortedx
cpir
dec hl
ret		;Returns with Z set if found

.attmes
call mestop
db "Set ",#ff
ret

.SAttrib
call clastf
call attmes
call cshow
ld e,#95
call getatt
ld (attset),hl
pop hl
ret c
call forone
jp writedir

.MAttrib
call ctagged
call attmes
call alltag
call getatt
ret c
ld (attset),hl
call fortagged
jp writedir

.attf
push hl
ld l,e
call faddr
ld bc,(attset)
ld a,l
add c
ld l,a
ld a,(hl)
and #7f
or b
ld (hl),a
pop hl
ret

.copyf
ld (rfptr),hl
push hl
ld l,e
call faddr
ld (rfname),hl
push hl
ld a,(doit)
or a
jr nz,notbeg
call showrf
ld hl,16
ld (blkoff),hl
xor a
.notbeg
ld hl,(crsect)
ld (hl),a
ld a,#ff
ld (doit),a
inc h:inc h
ld (recaddr),hl
xor a
ld (sectoff),a
ld bc,5
call testfree
pop ix
ld a,(exmsk)
and (ix+12)	;Number of 16K blocks
ld d,a
xor a
srl d
rra
add (ix+15)	;Number of 128 byte blocks
ld e,a
jr nc,noih
inc d		;Actual number of 128 byte blocks
.noih
push de
ld hl,(crsect)
ld l,4
ld (hl),d
dec hl
ld (hl),e
dec hl
ld de,(rfptr)
ld (hl),d
dec hl
ld (hl),e
dec hl
ld bc,5
call wbuff
pop bc
.rdloop
push bc
ld bc,#80
push bc
call testfree
ld hl,(recaddr)
ld a,(crsect+1)
add 2
sub h
jr nz,notfbu
or l
jr nz,notfbu
ld a,(sectoff)
or a
jr nz,notfstsc
ld hl,(rfname)		;First sector in block
ld bc,(blkoff)
add hl,bc
ld e,(hl)
inc hl
inc c
ld d,b
ld a,(dsm+1)
or a
jr z,gotdev
ld d,(hl)
inc c
.gotdev
ld a,c
and #df
or #10
ld (blkoff),a
ex de,hl		;Now HL=block number
ld a,(fspec)
call getblk
ld (trksec),hl
.notfstsc
ld hl,(trksec)
push hl
ld c,h
ld d,l
ld hl,(crsect)
ld (recaddr),hl
ld a,(fspec)
ld e,a
call #c666		;Read one sector
pop bc
ld hl,sectoff
call nextsec
ld (trksec),bc
.notfbu
pop bc
push bc
ld hl,(recaddr)
push hl
call wbuff
pop hl
pop bc
add hl,bc
ld (recaddr),hl
pop bc
dec bc
ld a,b
or c
jp nz,rdloop
pop hl
ret

.nextsec
inc b
ld a,(sect3)
cp b
jr nz,samet
ld a,(sect2)
ld b,a
inc c
.samet
ld a,(blmsk)
rra:rra:and 15
inc (hl)
and (hl)
ld (hl),a
ret

.tsame
ld a,(formdrv)
ld e,a
ld a,(fspec)
cp e
ret

.inmesd
push de
call insert
db "destination ",#b6,#ff
dec de
ld a,(formdrv)
call indrive2
pop de
ret

.inmess
call tsame
ret nz
call insert
db "source ",#b6,#ff
dec de
ld a,(fspec)
.indrive2
call indrive
.nomen2
push af
call nomen
db #ff
pop af
ret

.testfree
call checkfree
ret nc
call emptycb

.showrf
call setcff
db "Reading ",#ff
ld hl,(rfptr)
jp showf3

.showwf
call setcff
db "Writing ",#ff
ld hl,(wfptr)
jp showf3

.exitcp
ld a,1
ld (wclose),a

.emptycb
call unlog
ld a,(formdrv)
ld e,a

ld a,(dlogged)
or a
jr nz,allog
inc a
ld (dlogged),a
call inmesd		;Insert destination disc
ld a,e
call loga
call dirinf2
ld hl,(ddir)
call rsects
ld (endddir),hl
call unlogd
jr nodmes

.allog
call tsame
call z,inmesd
call relogd

.nodmes
ld hl,(wblks)
ld a,h
or l
jr z,getnewe
call showwf
jp notnewe

.getnewe		;New file entry
call checkused
jp z,exitwr
ld bc,5
ld hl,ffile
call rbuff
call showwf
ld a,(ffile)
or a
jr z,makenew
ld a,(needent)
or a
jr z,setnewe
jr notnewe
.makenew
ld hl,16
ld (wblkof),hl
ld l,h
ld (wsectof),hl
ld (wextent),hl
ld hl,(wfptr)
ld l,(hl)
call faddr
ld (wfloc),hl
ex de,hl	;DE points to filename
ld hl,(ddir)
call find2
jr nz,setnewe
push bc
push de
push hl
call exists
call cprint
db " - Overwrite ",#d2,#ff
call getyn2
call nomen2
pop hl
pop de
pop bc
sub "Y"
ld (writeyn),a
jr nz,isnewe
.erasede
ld (hl),#e5
call contfind
jr z,erasede

call showwf

.setnewe
call getfentry
ld a,h
or l
jp z,dirfull
ld (wrtany),a
ld (needent),a
ld (writeent),hl
ex de,hl
ld hl,(wfloc)
ld bc,12
ldir
ld a,(wextent)
ld (de),a
inc e
ld bc,3+16
call #caaf

.isnewe
ld hl,vbuff
ld (wrecad),hl

.notnewe
ld hl,(wblks)
ld a,h
or l
jp z,getnewe

call checkused
jp z,exitwr

ld hl,(wrecad)
ld bc,#80
call rbuff
ex de,hl
ld hl,(wblks)
dec hl
ld (wblks),hl
ld a,(writeyn)
or a
jr nz,notnewe

ld (wrecad),de
ld a,h
or l
ld hl,vbuff+#200
jr z,writesect

call cphlde
jr nz,noteos

.writesect
ld hl,(wtrksec)
ld a,(wsectof)
or a
jr nz,notnewb

call getfreeb
jp c,diskfull
ld hl,(writeent)
ld bc,(wblkof)
add hl,bc

ld (hl),e
inc hl
inc c
ld a,(dsm+1)
or a
jr z,noputd
ld (hl),d
inc hl
inc c
.noputd
ld a,c
and #df
or #10
ld (wblkof),a
push de
call usedblk
pop hl
ld a,(formdrv)
call getblk

.notnewb
push hl
ld a,(formdrv)
ld e,a
ld d,l
ld c,h
ld hl,vbuff
ld (wrecad),hl
call #c64e
pop bc
ld hl,wsectof
call nextsec
ld (wtrksec),bc

.noteos
ld ix,(writeent)
inc (ix+15)
jp p,notnewe
ld hl,wextent
inc (hl)
ld a,(exmsk)
and (hl)
jr nz,incext
ld hl,(wblks)
ld a,h
or l
jp nz,setnewe
ld (needent),a
jp getnewe
.incext
ld (ix+15),0
inc (ix+12)
jp notnewe

.dirfull
call didrv
db #be,#ff

.diskfull
call didrv
db #b5,#ff

.didrv
ld de,(wfloc)
ld hl,(ddir)
call find2
jr nz,noeyet
.erahalf
ld (hl),#e5
call contfind
jr z,erahalf
.noeyet
call mestop
db "D",#ad,#ff
ld a,(formdrv)
add "A"
call fastch
call fprint
db ": d",#ff
pop hl
call fprint2
call fprint
db "full",#ff
push de

ld a,1
ld (wclose),a
ld (werror),a

.exitwr
ld hl,(endddir)
call setbuff2
ld a,(wclose)
or a
jp z,relogs

ld a,(wrtany)
or a
jr z,nowrtaa

call relogd
ld hl,(ddir)
call wsects

.nowrtaa
ld a,(werror)
or a
jr z,nowerr

pop de
ld c,#ff
call fprint
db " - P",#ba,#ff
call #bb18

.nowerr
ld hl,cont
push hl

ld hl,(crsect)
call setbuff2

.relogs
call inmess		;Insert source disc
call relog
jp dirinf

.getfreeb		;No carry if free block
ld hl,formbuff
ld b,#60
ld a,#ff
.findfre
cp (hl)
jr nz,fndfre
inc hl
djnz findfre
.fndfre
ld a,(hl)
ld h,0
add hl,hl
add hl,hl
add hl,hl
dec l
.getfrel
inc l
rla
jr c,getfrel
ex de,hl
ld hl,(dsm)

.cphlde
ld a,h
sub d
ret nz
ld a,l
sub e
ret

.getfentry
ld de,formbuff+1	;Create block allocation map, and find free entry
ld bc,#5f
call #caaf
ld a,(formdrv)
ld e,a
ld a,#9
call #ca5c
ld (formbuff),a		;Allocate directory blocks

ld ix,(endddir)		;For each directory entry
ld hl,0
ld a,(dire)
inc a
ld b,a

.allclp
ld de,-32
add ix,de
ld a,(ix)
cp #e5
jr z,skipit
push bc
push ix
ex (sp),hl
ld bc,16
add hl,bc
.nextalb
ld e,(hl)
inc hl
ld a,(dsm+1)
or a
jr z,setdvl
ld a,(hl)
inc hl
.setdvl
ld d,a
call usedblk
bit 4,l
jr nz,nextalb
pop hl
pop bc
jr conallc
.skipit
push ix
pop hl
.conallc
djnz allclp
ret

.usedblk
push hl
ld hl,(dsm)
call cphlde
pop hl
ret c
ld a,e
and 7
inc a
ld b,a
srl d:rr e
srl e:srl e
ld d,formbuff/256
ld a,1
.rcalp
rrca
djnz rcalp
ex de,hl
or (hl)
ld (hl),a
ex de,hl
ret

.getcdrive
call fprint
db #b8,"d",#ad,": ",#ff
call getcdrive2
call nomen2
call initcb
xor a
ld (dlogged),a
ld (wclose),a
ld (werror),a
ld (wrtany),a
ld h,a
ld l,a
ld (wblks),hl
ld de,copyf
ret

.getcdrive2
call getdrive
ld (formdrv),a
ret

.SCopy
call clastf
call copmess
call cshow
ld e,#96
call getcdrive
pop hl
call forone
jp exitcp

.MCopy
call ctagged
call copmess
call alltag
call getcdrive
call fortagged
jp exitcp

.mestop
call nomen2
.setcff
ld c,#ff
ld de,#c781
jp fprint

.copmess
call nomen
db 31,35,1,#ff
call setcff
db "Copy ",#ff
ret
