(* written Q&D 920308 by Tilmann Reh *)
(* some modifications during 1992 & 1993 *)
(* translated and adapted to GIDE 950403 Tilmann Reh *)
(* variable base address added 951015 Tilmann Reh *)
(* added support for both ECB-IDE and GIDE by condition, 960204 TR *)
(* adding device select plus first ATAPI features 26 Mar 2000 Shawn Sijnstra *)
(* Preliminaries for extra ATAPI featurs 000327 SS *)
(* Implementing ATAPI features plus extra bits 000328-000331 SS bugs still exist *)
(* April 3 - more specific ATAPI stuff, April 4 expanded error messages *)
(* and added further functions - start/stop/eject, switchable delays *)



(* initialise the harddisk drive and set the desired geometry *)

procedure hd_init(cyls,hds,secs:integer);
begin
  writeln('Initialising the drive...');
  port[alt_status]:=6;
  delay(10);            (* Drive Software Reset *)
  port[alt_status]:=2;
  wait_ready;
  writeln(port[ide_error]:4,port[ide_seccnt]:4,port[ide_secnum]:4,
          port[ide_cyllow]:4,port[ide_cylhigh]:4,port[ide_sdh]:4);
  port[ide_seccnt]:=secs;
  port[ide_cyllow]:=lo(cyls);
  port[ide_cylhigh]:=hi(cyls);
  port[ide_sdh]:=pred(hds)+select;
  ide_command(cmd_initialize);
  writeln('Mode : ',cyls,'x',hds,'x',secs);
  end;

(* read and show drive ID data *)

procedure hd_identify;
var buffer : IDRecord absolute secbuf;
    Words  : array[0..255] of integer absolute secbuf;
    i,j    : integer;
    secs   : real;
begin
  writeln('Reading ID information...');
  ide_command(cmd_identify);
  if not read_secbuf(secbuf) then Error('Read Identify',false);
  with buffer do begin
    writeln('ID constant            : ',config,' (',hexword(config),')');
    writeln('cylinders fixed        : ',NumCyls);
    writeln('cylinders removable    : ',NumCyls2);
    writeln('number of heads        : ',NumHeads);
    writeln('bytes per track phys.  : ',BytesPerTrk);
    writeln('bytes per sector phys. : ',BytesPerSec);
    writeln('sectors per track      : ',SecsPerTrack);
    writeln('serial number          : ',st(SerNo));
    writeln('controller revision    : ',st(CtrlRev));
    writeln('buffer size (sectors)  : ',BfrSize);
    writeln('number of ECC bytes    : ',ECCBytes);
    writeln('controller model       : ',st(CtrlModl));
    secs := int(NumCyls) * NumHeads * SecsPerTrack;
    writeln('total sector count     : ',secs:1:0);
    writeln('capacity (MByte)       : ',int(secs / 2048):1:1);
    writeln('capability word        : ',wrprotect,' (',hexword(wrprotect),')');
    writeln('current C/H/S setting  : ',CurCyls,'/',CurHeads,'/',CurSPT);
    end;
  write(^m^j'press ENTER ');
  readln;
end;

(* execute drive diagnostics (self test) *)

procedure hd_diagnostics;
var  i : byte;
begin
  writeln(^m^j'Drive Self-Test...');
  ide_command(cmd_diagnostics);
  i := port[ide_error];
  writeln('Result Code: ',hexbyte(i));
   write('  Device 0 : ');
   if (i and $7F) = $01 then write('Ok') else write('defective');
   write('; Device 1 : ');
   if (i and $80) = $00 then write('Ok or not connected') else write('defective');
   writeln('.',^m^j);
  end;

(* Random Seek Test *)

procedure hd_seekrandom;
begin
  writeln('Seek Test. Press any key to abort.');
  repeat
    i:=random(cylinders);
    write(^m,i:4);
    if not hd_seek(i) then error('Seek',false);
  until keypressed;
  read(kbd,c);
  writeln(' ** Aborted **');
  end;

(* Read the complete drive, linear access *)

procedure hd_readlinear;
begin
  writeln('Disk is being read. Press any key to abort.');
  for i:=0 to pred(cylinders) do
  for j:=0 to pred(heads) do
  for k:=1 to sectors do begin
    write(^m,i:4,j:3,k:3);
    hd_readsector(i,j,k,secbuf);
    if keypressed then begin
      read(kbd,c);
      writeln(' ** Aborted **');
      exit; end;
    end;
  end;

(* randomly read the harddisk drive *)

procedure hd_readrandom;
begin
  writeln('Disk is being read. Press any key to abort.');
  repeat
    i:=random(cylinders); j:=random(heads); k:=succ(random(sectors));
    write(^m,i:4,j:3,k:3);
    hd_readsector(i,j,k,secbuf);
  until keypressed;
  read(kbd,c);
  writeln(' ** Aborted **');
  end;

(* read and write-back the entire drive, linear *)

procedure hd_rw_linear;
begin
  writeln('Test running. Press any key to abort.');
  for i:=0 to pred(cylinders) do
  for j:=0 to pred(heads) do
  for k:=1 to sectors do begin
    write(^m,i:4,j:3,k:3);
    hd_readsector(i,j,k,secbuf);
    hd_writesector(i,j,k,secbuf);
    if keypressed then begin
      read(kbd,c);
      writeln(' ** Aborted **');
      exit; end;
    end;
  end;

(* randomly read and write-back drive data *)

procedure hd_rw_random;
begin
  writeln('Test running. Press any key to abort.');
  repeat
    i:=random(cylinders); j:=random(heads); k:=succ(random(sectors));
    write(^m,i:4,j:3,k:3);
    hd_readsector(i,j,k,secbuf);
    hd_writesector(i,j,k,secbuf);
  until keypressed;
  read(kbd,c);
  writeln(' ** Aborted **');
  end;

(* Write random data to a sector, then read back and compare. *)
(* Repeat this linearly for the complete drive. All data is   *)
(* destroyed by this test, so be careful!                     *)

procedure hd_test_linear;
begin
  write('All data will be destroyed! Continue? (Y/N) ');
  repeat read(kbd,c); c:=upcase(c) until (c='Y') or (c='N');
  writeln(c); if c='N' then exit;
  writeln('Test running. Press any key to abort.');
  for i:=0 to pred(cylinders) do
  for j:=0 to pred(heads) do
  for k:=1 to sectors do begin
    write(^m,i:4,j:3,k:3);
    for l:=0 to 511 do bakbuf[l]:=random(256);
    hd_writesector(i,j,k,bakbuf);
    hd_readsector(i,j,k,secbuf);
    err:=false;
    for l:=0 to 511 do if secbuf[l]<>bakbuf[l] then err:=true;
    if err then Error('Sector R/W Verify',false);
    if keypressed then begin
      read(kbd,c);
      writeln(' ** Aborted **');
      exit; end;
    end;
  end;

(* Write random data to a sector, then read back and compare. *)
(* Repeat this randomly for the complete drive. All data is   *)
(* destroyed by this test, so be careful!                     *)

procedure hd_test_random;
begin
  write('All data will be destroyed! Continue? (Y/N) ');
  repeat read(kbd,c); c:=upcase(c) until (c='Y') or (c='N');
  writeln(c); if c='N' then exit;
  writeln('Test running. Press any key to abort.');
  repeat
    i:=random(cylinders); j:=random(heads); k:=succ(random(sectors));
    write(^m,i:4,j:3,k:3);
    for l:=0 to 511 do bakbuf[l]:=random(256);
    hd_writesector(i,j,k,bakbuf);
    hd_readsector(i,j,k,secbuf);
    err:=false;
    for l:=0 to 511 do if secbuf[l]<>bakbuf[l] then err:=true;
    if err then Error('Sector R/W Verify',false);
  until keypressed;
  read(kbd,c);
  writeln(' ** Aborted **');
  end;

(* Toggle master/slave device *)

procedure toggle_device;
begin
  wait_ready;
  select := (select xor 16);
  port[ide_sdh] := select;
  SetPorts(GIDEbase);
  end;

(* read and show CD-ROM/ATAPI drive ID data *)

procedure cd_identify;
var buffer : IDRecord absolute secbuf;
    Words  : array[0..255] of integer absolute secbuf;
begin
  writeln('Reading ID information...');
  ide_command(atapi_identify);
  if not read_secbuf(secbuf) then Error('Read Identify',false);
  with buffer do begin
    writeln('Configuration word     : ',config,' (',hexword(config),')'); (* 00 = 12 byte commands, 01 = 16 *)
    writeln('serial number          : ',st(SerNo));
    writeln('firmware revision      : ',st(CtrlRev));
    writeln('controller model       : ',st(CtrlModl));
    writeln('capability word        : ',wrprotect,' (',hexword(wrprotect),')');
    end;
  write(^m^j'press ENTER ');
  readln;
end;

(* Send ATAPI inquire *)

procedure cd_inquiry;
var cmd : ATAPI_cmd_type;
    buffer : InquiryRecord absolute secbuf;
    i   : integer;
begin
    for i:=0 to 11 do cmd[i]:=0;
    cmd[0] := scsi_inquiry;
    cmd[4] := $FF;  (* Length of reply *)
    write_ATAPI_command(cmd);
    if not read_halfbuf(secbuf) then Error('Data receive',false);
    with buffer do begin
      writeln('Manufacturer          : ',manufacturer);
      writeln('Product               : ',product);
      writeln('Revision              : ',revision);
    end;
end;

(* read and show CD-ROM headers *)

procedure cd_headers;
var buffer : CDRecord absolute secbuf;
    Words  : array[0..511] of integer absolute secbuf;
    i,j    : integer;
    cmd    : ATAPI_cmd_type;
begin
  writeln('Reading ID information...');
    for i:=0 to 11 do cmd[i]:=0;
    cmd[0] := SCSI_read;
    cmd[5] := 16; (* sector 16 *)
    cmd[8] := 1; (* 1 sector to read *)
    write_ATAPI_command(cmd);
    if not read_bigsecbuf(secbuf) then Error('Read Identify',false);
   with buffer do begin
    writeln('Type                   : ',cdtype,' (',hexword(cdtype),')');
    writeln('Version                : ',version,' (',hexword(version),')');
    writeln('System Id              : ',System_id);
    writeln('Volume Id              : ',Volume_id);
    end;
  write(^m^j'press ENTER ');
  readln;
end;

(* Read the complete ATAPI device, linear access *)

procedure atapi_readlinear;
var i      : integer;
    cmd    : ATAPI_cmd_type;
begin
    writeln('Device is being read. Press any key to abort. Current block number:');
    for i:=0 to 11 do cmd[i]:=0;
    cmd[0] := SCSI_read;
    cmd[8] := 1; (* 2048 bytes. [8]=0 already. setting doesn't seem to work *)
    for i:=0 to 320 do begin (* 320 sectors *)
     cmd[4]:=hi(i);cmd[5]:=lo(i);
     write(^m,i);
     write_ATAPI_command(cmd);
      if not read_bigsecbuf(secbuf) then Error('Read error',false);
      if keypressed then begin
        read(kbd,c);
        writeln(' ** Aborted **');
        exit; end;
    end;
end;

(* Eject CD *)

procedure cd_eject;
var cmd  : ATAPI_cmd_type;
    i    : byte;
    j,k  : integer;
    func : char;
begin
    for i:=0 to 11 do cmd[i]:=0;
    cmd[0] := SCSI_startstop;
    writeln('press 0 to stop, 1 to start, 2 to eject (if possible) or');
    writeln('3 to close tray (if possible) :');
    repeat read(kbd,func); func:=upcase(func)
    until func in ['0'..'3'];
    writeln(func);
    val('$'+func,j,k);
    cmd[4] := j;
    write_ATAPI_command(cmd);
end;


