;File:	DOSDISK.ASM
;Edit date:	86/12/13..
;Serial number 4
;
;	DOSDISK - Install RSX to define DOS processed disks.
;
;	PC RP/M2 call:
;
;		DOSDISK a
;
;	where	a =  string of drive names
;
;	For example,
;
;		DOSDISK CDE
;
;	will install RSX and assign drives C, D, and E to DOS.
;
;
;	Copyright (c) 1986 by microMethods.
;                             P.O. Box G
;                             Warrenton, Oregon  97146
;
;	Reserved locations.
;
RWBT	EQU	0000H	;warmboot vector
RIOB	EQU	0003H	;Intel iobyte
RDSK	EQU	0004H	;4/user number, 4/current disk
RDOS	EQU	0005H	;RDOS vector
RFCB	EQU	005CH	;Resident file control block
RBUF	EQU	0080H	;Resident record buffer
RTPA	EQU	0100H	;FWA for all user programs
;
;	RDOS functions.
;
FCCI	EQU	 1	;console character in
FCCO	EQU	 2	;console character out
FRIN	EQU	 3	;reader char in
FSEL	EQU	14	;select disk
FCNF	EQU	22	;create new file
FRCD	EQU	25	;return current disk
;
;	Assembly constants.
;
VERN	EQU	4 mod 10	;CBIOS revision level
RECSIZ	EQU	80H	;record size
MEMSIZ	EQU	64	;memory size in k bytes
MEMPAG	EQU	MEMSIZ*4	;memory size in pages
BIOSIZ	EQU	3+11+1		;CBIOS size in pages
RDOSIZ	EQU	14		;RDOS size in pages
RCPSIZ	EQU	8		;RCP size in pages
XCPSIZ	EQU	3		;XCP size in pages
;
;	NEC uPD70108 (V20) instructions.
;
INT88	EQU	081H	;software interrupt @ 204H
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;	Ascii character codes.
;
cr	EQU	0DH	;carriage return
lf	EQU	0AH	;line feed
;
;	Assembly options.
;
;
;	Assembler calculated memory map.
;
BIOFWA	EQU	(MEMPAG-BIOSIZ)*100H	;CBIOS fwa
RDOFWA	EQU	BIOFWA-(RDOSIZ*100H)	;RDOS fwa
RCPFWA	EQU	RDOFWA-(RCPSIZ*100H)	;RCP fwa
XCPFWA	EQU	0FB00H	;put PCDOSDSK above CBIOS80
;
;	Locations in RDOS.
;
RDOSEP	EQU	RDOFWA+06H	;RDOS entry point
RDOSDO	EQU	RDOFWA+17H	;directory ordinal
RDOSCF	EQU	RDOSDO+2	;current function
;
;	Locations in CBIOS80.
;
BIOWBT	EQU	BIOFWA+03H	;warmboot
;
;	Locations in PCDOSDSK, the RSX.
;
XWBT	EQU	XCPFWA+0CH	;vector to real warmboot
;
;	Offsets in C88 COMMON data area.
;
RPMSEG	EQU	001AH	;PC RP/M2 data segment
COMRSY	EQU	00DBH	;03=DOSDISK present
;
;	Assembly controls.
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
	ORG	RTPA
;
	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STACK
	JMP	LSD	;go to program
;
;	Data space.
;
DATSEG:	DW	0	;save PC RP/M2 data segment
LINEN:	DB	1	;display line number
TABLN:	DW	1	;selected table number n
BI:	DW	RFCB+1	;buffer index
DVAL:	DW	0	;decimal value
COMADR:	DW	0	;.common data area
OLDSP:	DW	0	;save RCP stack pointer
	DB	cr,lf,'Copyright (c) 1985 by microMethods, Inc.',0
	DB	VERN
;
	DS	2*24
STACK	EQU	$
;
;	MMC - Move memory.
;	Entry	HL = source fwa
;		DE = destination fwa
;		 C = byte count
;
MMC:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MMC	;loop for C bytes
	RET
;
;	CHD - Compare HL:DE.
;
CHD:	MOV	A,H
	SUB	D
	RNZ		;If mismatch
;
	MOV	A,L
	SUB	E
	RET
;
;	SCD - Set current disk.
;
SCD:	MVI	C,FRCD	;get current disk
	CALL	RDOS
	LHLD	IMAGE+6+9+(3*2)	;.CDISK
	MOV	M,A
	RET
;
;	SXD - Set assigned drive numbers.
;
SXD:	LHLD	IMAGE+6+9+(2*2)	;.XDISK
	XCHG
	LXI	H,RFCB+1	;argument string
	MVI	C,8
SXD1:	MOV	A,M
	CPI	' '
	CZ	SXD2	;If space
;
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	SXD1	;loop for 8 char
;
	RET
;
;	Replace blank with end-of-table.
;
SXD2:	MVI	A,0FFH
	RET
;
;	GCA - Get address of COMMON data area.
;
GCA:	MVI	C,FRIN	;DE=.common
	CALL	RDOS
	XCHG
	SHLD	COMADR
	RET
;
;	GDW - Get data word from COMMON.
;	Entry	DE = offset
;	Exit	DE = data word
;		HL = .data word
;
GDW:	LHLD	COMADR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	H
	RET
;
;	CSP - Check DOSDISK present.
;	Exit	 Z = true, if DOSDISK present
;		HL = .RSX identification byte
;
CSP:	LXI	D,COMRSY	;get DOSDISK flag
	CALL	GDW
	MOV	A,E
	CPI	03H
	RET
;
;	RDP - Remove DOSDISK RSX.
;
RDP:	CALL	CSP
	JNZ	RDP1	;If DOSDISK not present
;
;	Mark DOSDISK removed.
;
	MVI	M,0
;
;	Restore RDOS entry point.
;
	LHLD	XCPFWA+6+3+1
	SHLD	RDOSEP+1
;
;	Restore the CBIOS warmboot entry point.
;
	LHLD	XWBT+1	;actual warmboot processor
	SHLD	BIOFWA+3+1
	JMP	0000	;real warmboot
;
;	DOSDISK is not present.
;
RDP1:	LXI	H,RDPA	;"not here"
	CALL	MSG
;
;	Return to RCP.
;
RDP2:	LHLD	OLDSP
	SPHL
	RET
;
RDPA:	DB	'The DOSDISK RSX is not active.',0
;
;
;	MSG - Console message ending in 00.
;	Entry	HL = .message
;
MSG:	MOV	A,M
	ORA	A
	RZ		;If end of message
;
	MOV	E,A
	CALL	CCO	;console char out
	INX	H
	JMP	MSG	;loop to end of message
;
;	EOL - Issue carriage return, line feed.
;
EOL:	MVI	E,cr
	CALL	CCO
	MVI	E,lf
;
;	CCO - Console character out.
;	Entry	 E = char
;
CCO:	PUSH	H
	MVI	C,FCCO
	CALL	RDOS
	POP	H
	RET
;
;	CCI - Console character in.
;	Exit	 A = char
;
CCI:	MVI	C,FCCI
	CALL	RDOS
	RET
;
;	Move PCSETDSK to high memory.
;
LSD:	CALL	GCA	;set COMMON data fwa
	LXI	D,RPMSEG	;save PC RP/M2 data segment
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	DATSEG
	LXI	D,0060H	;check MS-DOS present
	CALL	CHD
	JZ	LSD4	;If MS-DOS not present
;
	LDA	RFCB+1
	CPI	' '
	JZ	RDP	;If remove DOSDISK
;
	CALL	CSP
	JZ	LSD3	;If DOSDISK already present
;
	ORA	A
	JNZ	LSD2	;If another RSX present
;
	LXI	H,IMAGE	;source
	LXI	D,XCPFWA	;destination
	MVI	B,XCPSIZ	;page count
	MVI	C,0	;move full pagees
LSD1:	CALL	MMC	;move one page
	DCR	B
	JNZ	LSD1	;loop over page count
;
;	Set assigned drive numbers.
;
	CALL	SXD	;set XDISK
;
;	Preset the current disk in RSX.
;
	CALL	SCD	;set current disk
;
;	Set PC RP/M2 data segment in register array.
;
	LHLD	DATSEG
	XCHG
	LHLD	XCPFWA+6+9	;.DSEG
	MOV	M,E
	INX	H
	MOV	M,D
;
;	Set RDOS and warmboot vectors.
;
	LXI	D,XCPFWA+6
	LXI	H,RDOSEP+1
	MOV	C,M
	MOV	M,E
	INX	H
	MOV	B,M
	MOV	M,D
;
	MOV	L,C
	MOV	H,B
	SHLD	XCPFWA+6+3+1
;
	LHLD	IMAGE+6+9+(1*2)	;.PWB in PCSETDSK
	XCHG
	LHLD	RWBT+1
	INX	H
	MOV	C,M
	MOV	M,E
	INX	H
	MOV	B,M
	MOV	M,D
	MOV	L,C
	MOV	H,B
	SHLD	XCPFWA+6+6+1
;
	NOP ! NOP ! NOP
;
	LXI	D,COMRSY	;mark DOSDISK present
	CALL	GDW
	MVI	M,03h
	MVI	C,FSEL	;select disk A
	MVI	E,0
	CALL	RDOS
	JMP	0000	;warmboot
;
;	An RSX other than DOSDISK is already present.
;
LSD2:	LXI	H,LSDA	;"an RSX is present"
	CALL	MSG
	JMP	0000
;
;	The DOSDISK RSX is present, change disk assignments.
;
LSD3:	CALL	SXD
	JMP	RDP2	;return to RCP
;
;	Process MS-DOS not present.
;
LSD4:	LXI	H,LSDB	;"MS-DOS not present"
	CALL	MSG
	JMP	RDP2	;return to RCP
;
LSDA:	DB	'An RSX is already present.',0
LSDB:	DB	'MS-DOS is not present.',0
;
;	Image of PCSETDSK.
;
	ORG	($ AND 0FF00H) + 100H
IMAGE	EQU	$
;
;	Disk parameter tables.
;
