;File: KAYPRO.ASM v.04
;Date: December 17, 1986
;
;      KAYPRO - PC RP/M2 TERMINAL EMULATION TABLE INSTALLATION EXAMPLE
;                  (c) 1986 by MicroMethods, Inc.
;
;      (Modify this file and assemble it to install your own terminal table.)
;
;      Direct Calling Procedure:
;
;      KAYPRO[enter] = installation of Kaypro I, II, 4, 10, 84 emulation table.
;      KAYPRO 0     = shuts off terminal emulation.
;      KAYPRO x     = any argument, shuts off terminal emulation.
;
;      Assembly constants.
;
RDOS   EQU     0005H
BDOS   EQU     RDOS
SFCB   EQU     005CH
SBUFF  EQU     0080H
cr     EQU     0DH
lf     EQU     0AH
eof    EQU     1AH     ;control-z = end of file.
;
;      RDOS functions.
;
WBOOT  EQU     0       ;Warm Boot
FCCI   EQU     1       ;Console character in.
FCCO   EQU     2       ;Console character out.
FRIN   EQU     3       ;Reader in.
FDIO   EQU     6       ;Direct console I/O.
MSGF   EQU     9       ;Write console message.
RDCF   EQU     10      ;Read console line.
RDCS   EQU     11      ;Get Console Status.
;
;
;      CBIOS88 locations.
;
COMMON EQU     0FA00H  ;Start of CBIOS88 common data area.
TERMID EQU     0FA1CH  ;Identifier of Terminal Currently Emulated (0 = none).
TRMTBL EQU     0FA68H  ;Terminal Emulation Control Table Pointer location.
TETSEG EQU     0FA80H  ;Offset to Terminal Emulation Table Segment in common.
TETOFS EQU     0FA82H  ;Offset to Terminal Emulation Table Offset in common.
TBLSIZ EQU     0200H   ;Size of table in CBIOS88 (byte count).
TBLADR EQU     04300H  ;Start of Terminal Emulation Table
STRTBL EQU     TBLADR  ;Start of Terminal Emulation Table
RPMSEG EQU     0FA1AH  ;RP/M segment address in common data area.
SCRLIN EQU     0FA8BH  ;Scroll line (bottom line) in common data area.
;
;      TERMINAL FUNCTIONS THAT MAY BE EMULATED VIA RP/M CBIOS:
;
TERMTBL        EQU     04200H  ;Table of Emulation Processor Addresses
;
HM     EQU     TERMTBL+3       ;Home Cursor
BR     EQU     HM+3            ;Bright Intensity
NI     EQU     BR+3            ;Normal Intensity
RV     EQU     NI+3            ;Reverse (toggle) video background/foreground.
NV     EQU     RV+3            ;Normal video background/foreground.
BW     EQU     NV+3            ;Black background/White foreground video.
BN     EQU     BW+3            ;Blinking foreground (text).
NB     EQU     BN+3            ;Normal (non-blinking) foreground.
UN     EQU     NB+3            ;Underline character (monochrome board only).
NU     EQU     UN+3            ;Underline off (monochrome board only).
SV     EQU     NU+3            ;Remember (save) cursor position.
RS     EQU     SV+3            ;Restore remembered cursor position.
BC     EQU     RS+3            ;Block Cursor type.
LC     EQU     BC+3            ;Line Cursor type.
NL     EQU     LC+3            ;New Line (carriage-return, line-feed).
EL     EQU     NL+3            ;Erase to End of Line.
ES     EQU     EL+3            ;Erase to End of Screen.
AC     EQU     ES+3            ;Advance Cursor Right one column.
DC     EQU     AC+3            ;Cursor Down one line.
UC     EQU     DC+3            ;Cursor Up one line.
SC     EQU     UC+3            ;Set cursor position.
CH     EQU     SC+3            ;Clear screen and Home cursor.
NS     EQU     CH+3            ;Dump (null) string (non-emulated string).
LI     EQU     NS+3            ;Line Insert at cursor position.
LD     EQU     LI+3            ;Line Delete at cursor position.
;
SETCUR EQU     SC              ;Address of Set Cursor Processor
CLEAR  EQU     CH              ;Address of Clear/Home Processor
LININS EQU     LI              ;Address of Line Insert Processor
LINDEL EQU     LD              ;Address of Line Delete Processor
NULSTR EQU     NS              ;Address of Null String Processor
;
CBIO88  EQU     0F133H          ;CBIOS80 entry pt 11H to CALL CBIOS88
;CALLN  EQU     0EDEDH          ;CALLN op code.
;INT81  EQU     081H            ;CALLN interrupt number.
;
       ORG     0100H
;
       JMP     KTERM
;
;
       DB      'KAYPRO - Terminal Emulation Table Installation '
       DB      '(C) 1986 by MicroMethods, Inc. '
       DB      '118 S.W. First Street '
       DB      'Warrenton, Oregon  97146 '
       DB      'v.04 12-17-86'
;
;
       DS      2*32
STACK: DS      0
;
       ORG     16*($/16)+16
;
;
KTERM: EQU     $
       LXI     H,0000
       DAD     SP
       SHLD    OLDSP
       LXI     SP,STACK
;
       LHLD    RPMSEG         ;RP/M segment address.   
       SHLD    SEGFROM         ;store in move array
       LHLD    TETSEG          ;Terminal Emulation Table segment.
       SHLD    SEGTO           ;store in move array
       LHLD    TETOFS          ;Terminal Emulation Table offset.
       SHLD    OFSTO           ;store in move array
;
       LXI     H,005DH         ;address of command in FCB
       MOV     A,M             ;get argument
       STA     DIRCOM  
       CPI     ' '             ;check for blank
       JZ      KAYPRO          ;no argument, install Kaypro table.
;                               anything else,
       MVI     A,'0'           ;remove terminal emulation
       STA     DIRCOM
       JMP     NOTERM
;
;
KAYPRO         EQU     $       ;Kaypro table.
       MVI     A,'K'
       STA     TRMREQ          ;Terminal Ident byte.
       LXI     H,KAYTBL
       PUSH    H
       LXI     D,KAY
       LDA     KAYBLN          ;bottom line = 24 (scroll line)
;
INSTALL:       EQU     $       ;Install table and set emulation mode on.
       PUSH    D
       CALL    SETBLN          ;set bottom (scroll) line
       CALL    CHM             ;clear/home cursor
       POP     D
       CALL    SENDMS          ;display terminal being installed
       LDA     DIRCOM          ;check if query              
       CPI     '?'
       POP     H               ;retrieve terminal table address
       JNZ     INS1            ;if not query, go install table
       JMP     EXIT            ;exit if query       
INS1:  EQU     $
       CALL    MOVTBL          ;install table / set emulation mode on.
;
;      EXIT to warm boot.
;
EXIT:  EQU     $
       LXI     SP,0000
OLDSP  EQU     $-2
       JMP     WBOOT           ;warm boot
;
;      NOTERM - Shut off or display emulation mode turned off.
;
NOTERM:        EQU     $
       CALL    CHM             ;clear/home cursor
       LXI     D,OFFMSG        ;EMULATION OFF message
       CALL    SENDMS
       MVI     A,00H           ;shut terminal emulation off
       STA     TERMID
       MVI     A,018H          ;reset to 25 lines (scroll line)
       CALL    SETBLN
       JMP     EXIT 
;
;
;      MOVTBL - Move Terminal Emulation Control Table to CBIOS88 location.
;              Entry, H & L addresses terminal table to be moved.
;              Exit, table is moved, and emulation mode turned on.
;
MOVTBL:        EQU     $
       SHLD    OFSFROM         ;Store table address in move array.
       LXI     H,MOVARY        ;Set H&L to MOVARY address.
       MVI     D,01DH          ;CBIOS88 memory move function.
       CALL    CB88            ;request to CBIOS88
       LDA     TRMREQ          ;get terminal I.D. matching table
       STA     TERMID          ;store it in CBIOS88 / turns emulation on.
       RET
;
;      SETBLN - set bottom (scroll line).
;              Entry, A = bottom line-1
;
SETBLN:        EQU     $
       STA     SCRLIN          ;store in common data area for CBIOS88
       RET
;
;      CHM - clear screen/home cursor.
;
CHM:   MVI     D,01CH          ;clear/home function
       CALL    CB88            ;to CBIOS88
       RET
;
;      CB88 - call CBIOS88
;
CB88:  EQU     $
       CALL    CBIO88    ;Call CBIOS80 entry pt 11H to CALL CBIOS88
       RET
;
;      SENDMS  - send message to display.
;
SENDMS:  EQU   $
       MVI     C,MSGF  ;RDOS send message function.
       CALL    RDOS
       RET
;
;
OFFMSG DB      cr,lf,'EMULATION OFF',cr,lf,'$'
;
DIRCOM DB      0       ;Direct Command (ASCII), zero if none.
TRMREQ DB      0       ;Terminal Emulation requested (I.D. character).
;
;      MOVARY - Memory Moving Array
;
MOVARY:        EQU     $       ;Array for Moving Table to CBIOS88
;
OFSFROM:       DW      KAYTBL  ;Table offset
SEGFROM:       DW      0       ;RP/M Segment address
OFSTO:         DW      TBLADR  ;Terminal Control Table address in CBIOS88
SEGTO:         DW      0       ;CBIOS88 Segment address
MOVSIZ:        DW      TBLSIZ  ;Number of bytes to move.
;
;
;      TERMINAL EMULATION CONTROL STRING DEFINITION TABLE
;
       DB      'EMULATION TABLE - TERMINAL ID AT END OF TABLE',cr,lf,'$'
;
;==========================================================================
;
;      Method of defining cursor positioning in the table:
;
;      When one byte = line or column position:
;
;              0FEH = line position byte
;               nnH = line position bias value (usually 00H or 20H)
;
;              0FFH = column position byte
;               nnH = column position bias value
;
;      When two bytes = line or column position:
;
;              0FAH = first line byte
;              0FBH = second line byte
;              0F8H = means next byte is line separator character
;               nnH = line separator character
;               nnH = line bias value (usually 00H or 20H)
;
;              0FCH = first column byte
;              0FDH = second column byte
;              0F9H = means next byte is column separator character
;               nnH = column separator character
;               nnH = column bias value
;
;      Note:  There may only be ONE two-byte type of cursor positioning
;              definition in the table.
;
;===========================================================================
;
       ORG     256*($/256)+256
;
;
KAYTBL:        EQU     $       ;KAYPRO I, II, IV, 10, 84 TABLE
       DW      KAYUC1-KAYTBL+STRTBL    ; Kaypro cursor up
       DW      KAYAC1-KAYTBL+STRTBL    ; Kaypro cursor right
       DW      KAYDC1-KAYTBL+STRTBL    ; Kaypro cursor down
       DW      KAYES1-KAYTBL+STRTBL    ; Kaypro erase to end of screen
       DW      KAYES2-KAYTBL+STRTBL    ; Kaypro erase to end of screen
       DW      KAYES3-KAYTBL+STRTBL    ; Kaypro erase to end of screen
       DW      KAYEL1-KAYTBL+STRTBL    ; Kaypro erase to end of line
       DW      KAYEL2-KAYTBL+STRTBL    ; Kaypro erase to end of line
       DW      KAYCH1-KAYTBL+STRTBL    ; Kaypro clear/home cursor
       DW      KAYCH2-KAYTBL+STRTBL    ; Kaypro clear/home cursor
       DW      KAYHM1-KAYTBL+STRTBL    ; Kaypro home cursor
       DW      KAYNL1-KAYTBL+STRTBL    ; Kaypro new line (cr/lf)
       DW      KAYCP1-KAYTBL+STRTBL    ; Kaypro cursor positioning
       DW      KAYLI1-KAYTBL+STRTBL    ; Kaypro insert line
       DW      KAYLD1-KAYTBL+STRTBL    ; Kaypro delete line
       DW      KAYRV1-KAYTBL+STRTBL    ; Kaypro reverse video
       DW      KAYRV2-KAYTBL+STRTBL    ; Kaypro reverse video
       DW      KAYNV1-KAYTBL+STRTBL    ; Kaypro normal video
       DW      KAYNV2-KAYTBL+STRTBL    ; Kaypro normal video
       DW      KAYNV3-KAYTBL+STRTBL    ; Kaypro normal video
       DW      KAYBR1-KAYTBL+STRTBL    ; Kaypro bright intensity
       DW      KAYNI1-KAYTBL+STRTBL    ; Kaypro normal intensity
       DW      KAYBN1-KAYTBL+STRTBL    ; Kaypro blinking text on
       DW      KAYNB1-KAYTBL+STRTBL    ; Kaypro end blinking text (off)
       DW      KAYUN1-KAYTBL+STRTBL    ; Kaypro underline on (mono card only)
       DW      KAYNU1-KAYTBL+STRTBL    ; Kaypro underline off(mono card only)
       DW      KAYSV1-KAYTBL+STRTBL    ; Kaypro remember cursor position.
       DW      KAYRS1-KAYTBL+STRTBL    ; Kaypro restore remembered position.
       DW      0                       ; end of Kaypro strings
KAYUC1 DW      UC                      ;cursor up one line
       DB      01H,00BH,00H
;                  ^K(VT)
KAYAC1 DW      AC                      ;advance cursor right one column
       DB      01H,00CH,00H
;                  ^L(FF)
KAYDC1 DW      DC                      ;cursor down one line
       DB      01H,016H,00H
;                  ^V(SYNC)
KAYES1 DW      ES                      ;erase to end of screen
       DB      01H,017H,00H
;                  ^W(ETB)
KAYES2 DW      ES                      ;erase to end of screen
       DB      01H,01BH,059H,00H
;                  Esc   Y
KAYES3 DW      ES                      ;erase to end of screen
       DB      01H,01BH,03AH,00H
;                  Esc   :
KAYEL1 DW      EL                      ;erase to end of line
       DB      01H,01BH,018H,00H
;                  Esc  ^X(CAN)
KAYEL2 DW      EL                      ;erase to end of line
       DB      01H,01BH,054H,00H
;                  Esc   T
KAYCH1 DW      CH                      ;clear screen/home cursor
       DB      01H,01AH,00H
;                  ^Z(SUB)
KAYCH2 DW      CH                      ;clear screen/home cursor
       DB      01H,01BH,01AH,00H
;                  Esc  ^Z(SUB)
KAYHM1 DW      HM                      ;home cursor
       DB      01H,01EH,00H
;                  ^6(RS)
KAYNL1 DW      NL                      ;new line (cr/lf)
       DB      01H,01FH,00H
;                  ^-(US)
KAYCP1 DW      SC                      ;set cursor position
       DB      01H,01BH,03DH,0FEH,020H,0FFH,020H,00H
;                  Esc   =   line bias col  bias
KAYLI1 DW      LI                      ;line insert
       DB      01H,01BH,045H,00H
;                  Esc   E
KAYLD1 DW      LD                      ;line delete
       DB      01H,01BH,052H,00H
;                  Esc   R
KAYRV1 DW      RV                      ;reverse video
       DB      01H,01BH,042H,030H,00H
;                  Esc   B    0
KAYRV2 DW      RV                      ;reverse video
       DB      01H,01BH,028H,00H
;                  Esc   (
KAYNV1 DW      NV                      ;normal video
       DB      01H,01BH,043H,030H,00H
;                  Esc   C    0
KAYNV2 DW      NV                      ;normal video
       DB      01H,01BH,029H,00H
;                  Esc   )
KAYNV3 DW      NV                      ;normal video
       DB      01H,01BH,01DH,00H
;                  Esc  ^](GS)
KAYBR1 DW      BR                      ;bright intensity
       DB      01H,01BH,043H,031H,00H
;                  Esc   C    1 
KAYNI1 DW      NI                      ;normal intensity
       DB      01H,01BH,042H,031H,00H
;                  Esc   B    1
KAYBN1 DW      BN                      ;set blinking text on
       DB      01H,01BH,042H,032H,00H
;                  Esc   B    2
KAYNB1 DW      NB                      ;no blinking (set off)
       DB      01H,01BH,043H,032H,00H
;                  Esc   C    2
KAYUN1 DW      UN                      ;underline on (mono board only)
       DB      01H,01BH,042H,033H,00H
;                  Esc   B    3
KAYNU1 DW      NU                      ;no underline (off) mono bd only
       DB      01H,01BH,043H,033H,00H
;                  Esc   C    3
KAYSV1 DW      SV                      ;save (remember) cursor position.
       DB      01H,01BH,042H,036H,00H
;                  Esc   B    6
KAYRS1 DW      RS                      ;restore remembered cursor position.
       DB      01H,01BH,043H,036H,00H
;                  Esc   C    6
KAYSIZ DB      $-KAYTBL        ;size of Kaypro table
;
KAYBLN DB      017H            ;bottom (scroll) line = line 24
;
KAY:   DB      cr,lf,'KAYPRO I, II, IV, 10, 84',cr,lf,'$'
;
;===========================================================================
;
       END
;
