/* search.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include "search.h"

/* BinarySearch() searches a sorted array. */
void *
	BinarySearch(const void *key,
	             const void *elements,
	             unsigned maxElement,
	             unsigned elementSize,
	             SearchCompareFunction compare)
{
	void *elementPtr;
	int i;
	int j;
	int k;
	int n;

	i = 0;
	k = maxElement - 1;

	while (i <= k) {

		j = (i + k) / 2;

		elementPtr = &((char *)elements)[elementSize * j];

		n = compare(key, elementPtr);

		if (n == 0)
			goto found;

		if (n > 0)
			i = j + 1;
		else
			k = j - 1;

	}

	/* Return zero if not found. */
	return 0;

	/* Return a pointer to the Element if found. */
found:
	return elementPtr;

}
