/* file.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include "stdio.h"
#include "string.h"
#include "file.h"

/* FileName() removes the file extension. */
const char *FileName(const char *file)
{
	static char fileName[kMaxFileName];
	int i;

	strcasecpy(fileName, file);
	for (i = strlen(fileName) - 1; i >= 0; i--) {
		if (fileName[i] == '.') {
			fileName[i] = 0;
			break;
		}
	}

	/* Return the file name without the extension. */
	return fileName;

}

/* FileExtension() extracts the file extension. */
const char *FileExtension(const char *file)
{
	static char fileExtension[kMaxFileName];
	int i;

	fileExtension[0] = 0;
	for (i = strlen(file) - 1; i >= 0; i--) {
		if (file[i] == '.') {
			strcasecpy(fileExtension, &file[i + 1]);
			break;
		}
	}

	/* Return the extension from the file name. */
	return fileExtension;

}
