/* dir.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#define kSizeofFileName 64
#define kSizeofFilePath 256

typedef struct DirEntry DirEntry;
typedef DirEntry *DirEntryPtr;
struct DirEntry {
	char name[kSizeofFileName];
	char pathPrefix[kSizeofFilePath];
	int isFile;
	unsigned long size;
};

typedef struct Dir Dir;
typedef Dir *DirPtr;

extern DirPtr DirOpenPath(const char *dir);

extern DirPtr DirOpen(const char *path);

extern int DirClose(DirPtr dirPtr);

extern DirEntryPtr DirRead(DirPtr dirPtr);
