; PUTSYS.ASM - Write the CP/M system to a disk from memory at 0900H.
; Copyright (C) 2000  Tsurishaddai Williamson, tsuri@earthlink.net
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; CP/M LOCATIONS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

	ORG	USRTPA

	; PREPARE THE STACK
	LXI	H,0
	DAD	SP
	SHLD	CCPSTK
	LXI	SP,STACK

	; DISPLAY THE BANNER
	LXI	D,BANNER
	CALL	PRINT

	; SET THE DISK NUMBER
	LXI	D,MSG2
	LDA	USRFCB+0
	ORA	A
	JZ	DONE
	DCR	A
	MOV	C,A
	CALL	SELDSK

	; WRITE TO TRACK 0
	LXI	B,0
	CALL	SETTRK
	LXI	H,0900H+0*80H	; 0900H + 0 * 80H
	LXI	B,0D01H		; 13 SECTORS STARTING WITH 1
	CALL	WRTRK		; 01 03 05 07 09 11 13 15 17 19 21 23 25
	JNZ	ERROR
	LXI	H,0900H+1*80H	; 0900H + 1 * 80H
	LXI 	B,0D02H		; 13 SECTORS STARTING WITH 2
	CALL	WRTRK		; 02 04 06 08 10 12 14 16 18 20 22 24 26
	JNZ	ERROR

	; WRITE TO TRACK 1
	LXI	B,1
	CALL	SETTRK
	LXI	H,0900H+26*80H	; 0900H + 26 * 80H
	LXI	B,0D01H		; 13 SECTORS STARTING WITH 1
	CALL	WRTRK		; 01 03 05 07 09 11 13 15 17 19 21 23 25
	JNZ	ERROR
	LXI	H,0900H+27*80H	; 0900H + 27 * 80H
	LXI 	B,0D02H		; 13 SECTORS STARTING WITH 2
	CALL	WRTRK		; 02 04 06 08 10 12 14 16 18 20 22 24 26
	JNZ	ERROR

	LXI	D,MSG1

	; ALL DONE, RESTORE THE STACK AND RETURN TO CCP
DONE:	CALL	PRINT
	LHLD	CCPSTK
	SPHL
	RET

ERROR:	LXI	D,ERRMSG
	JMP	DONE
ERRMSG:	DB	'?DISK ERROR',10,13,'$'

BANNER:	DB	'PUTSYS 1.0',13,10,'$'

MSG1:	DB	'OK.',13,10,'$'

MSG2:	DB	'?DRIVE NOT SPECIFIED',10,13,'$'

; CP/M PRINT FUNCTION
PRINT:	MVI	C,9
	JMP	SYSTEM

; WRTRK -- WRITE EVERY OTHER SECTOR ON A TRACK
; IN: HL = DESTINATION ADDRESS
; IN: B = SECTORCOUNT
; IN: C = SECTORNUMBER
; OUT: NZ IF ERROR
WRTRK:	PUSH	H
	PUSH	B
	PUSH	H
	MVI	B,0
	CALL	SETSEC
	POP	B
	CALL	SETDMA
	CALL	WRSEC
	RNZ
	POP	B
	POP	H
	INR	H
	INR	C
	INR	C
	DCR	B
	JNZ	WRTRK
	RET

; BIOS SELECT DISK FUNCTION
SELDSK:	LHLD	REBOOT+1
	LXI	D,(9-1)*3
	DAD	D
	PCHL

; BIOS SET DMA POINTER FUNCTION
SETDMA:	LHLD	REBOOT+1
	LXI	D,(12-1)*3
	DAD	D
	PCHL

; BIOS SET DISK TRACK FUNCTION
SETTRK:	LHLD	REBOOT+1
	LXI	D,(10-1)*3
	DAD	D
	PCHL

; BIOS SET DISK SECTOR FUNCTION
SETSEC:	LHLD	REBOOT+1
	LXI	D,(11-1)*3
	DAD	D
	PCHL

; BIOS WRITE DISK SECTOR FUNCTION
WRSEC:	LHLD	REBOOT+1
	LXI	D,(14-1)*3
	DAD	D
	PCHL

; BIOS READ DISK SECTOR FUNCTION
RDSEC:	LHLD	REBOOT+1
	LXI	D,(13-1)*3
	DAD	D
	PCHL

; THE STACK.
CCPSTK:	DS	2
	DS	32
STACK	EQU	$

	END
