; CBOOT.ASM - uSim 64K CP/M COLD START LOADER
; Copyright (C) 2000  Tsurishaddai Williamson, tsuri@earthlink.net
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; 63.5K CP/M LOCATIONS
MEMSIZ	EQU	64			; MEMORY SIZE, KILOBYTES
CPMVER	EQU	22			; CP/M VERSION
CCP	EQU	3200H+(MEMSIZ-20)*1024	; CCP BASE ADDRESS
BDOS	EQU	CCP+0800H		; BDOS BASE ADDRESS
BIOS	EQU	CCP+1600H		; BIOS BASE ADDRESS
DATA	EQU	BIOS+(2300H-1F80H)	; BIOS UNINITIALIZED DATA ADDRESS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

; THE FOLLOWING TAKEN FROM uSim SYSTEM.EQU 
DMAHI	EQU	9	; DMA HIGH BYTE PORT
DMALO	EQU	10	; DMA LOW BYTE PORT
TRKHI	EQU	17	; TRACK HIGH BYTE PORT
TRKLO	EQU	18	; TRACK LOW BYTE PORT
SECHI	EQU	15	; SECTOR HIGH BYTE PORT
SECLO	EQU	16	; SECTOR LOW BYTE PORT
DSKRD	EQU	1	; DISK READ STATUS/COMMAND
DSKCTL	EQU	14	; DISK CONTROL/STATUS PORT
DSKERR	EQU	128	; DISK ERROR STATUS

	ORG	USRBUF

	; SET UP THE STACK UNDER THE CCP
	LXI	SP,CCP

	; READ FROM TRACK 0
	LXI	B,0
	CALL	SETTRK
	LXI	H,CCP+0*80H	; CCP + 0 * 80H
	LXI	B,0D02H		; 13 SECTORS STARTING WITH 2
	CALL	RDTRK		; 02 04 06 08 10 12 14 16 18 20 22 24 26
	JNZ	ERROR
	LXI	H,CCP+1*80H	; CCP + 1 * 80H
	LXI	B,0C03H		; 12 SECTORS STARTING WITH 3
	CALL	RDTRK		; 03 05 07 09 11 13 15 17 19 21 23 25
	JNZ	ERROR

	; READ FROM TRACK 1
	LXI	B,1
	CALL	SETTRK
	LXI	H,CCP+25*80H	; CCP + 25 * 80H
	LXI	B,0D01H		; 13 SECTORS STARTING WITH 1
	CALL	RDTRK		; 01 03 05 07 09 11 13 15 17 19 21 23 25
	JNZ	ERROR
	LXI	H,CCP+26*80H	; CCP + 26 * 80H
	LXI 	B,0D02H		; 13 SECTORS STARTING WITH 2
	CALL	RDTRK		; 02 04 06 08 10 12 14 16 18 20 22 24 26
	JNZ	ERROR
 
	; ENTER BIOS COLD START
	JMP BIOS

; ERROR -- HALT IF THERE WAS ANY ERROR
ERROR:	HLT

; RDTRK -- READ EVERY OTHER SECTOR ON A TRACK
; IN: HL = DESTINATION ADDRESS
; IN: B = SECTORCOUNT
; IN: C = SECTORNUMBER
; OUT: NZ IF ERROR
RDTRK:	PUSH	H
	PUSH	B
	MVI	B,0
	CALL	SETSEC
	PUSH	H
	POP	B
	CALL	SETDMA
	CALL	RDSEC
	RNZ
	POP	B
	POP	H
	INR	H
	INR	C
	INR	C
	DCR	B
	JNZ	RDTRK
	RET

; SETDMA -- SET THE DMA POINTER
; IN: BC = DESTINATION ADDRESS
SETDMA:	MOV	A,B
	OUT	DMAHI
	MOV	A,C
	OUT	DMALO
	RET

; SETTRK -- SET THE TRACK NUMBER
; IN: BC = TRACK NUMBER
SETTRK:	MOV	A,B
	OUT	TRKHI
	MOV	A,C
	OUT	TRKLO
	RET

; SETSEC -- SET THE SECTOR NUMBER
; IN: BC = SECTOR NUMBER
SETSEC:	DCX	B
	MOV	A,B
	OUT	SECHI
	MOV	A,C
	OUT	SECLO
	RET

; RDSEC -- READ A SECTOR
; OUT: NZ IF ERROR
RDSEC:	MVI	A,DSKRD
	OUT	DSKCTL
	IN	DSKCTL
	ANI	DSKERR
	MVI	A,1
	RNZ
	XRA	A
	RET

	END
