/* primary floppy controller port addresses */
#define flop_base 0x3f0 	/* base address of floppy controller */
#define drv_control 0x3f2	/* drive control register */
#define fstatus 0x3f4		/* main status register */
#define fdata 0x3f5		/* data register */
#define frate 0x3f7		/* data rate register */

/* data rate register definitions */
#define khz500 0x0		/* 500 KHZ */
#define khz300 0x1		/* 300 KHZ */
#define khz250 0x2		/* 250 KHZ */
#define mhz1   0x3		/* 1000 KHZ */

/* misc. floppy equates */
#define dsk_chg 0x80		/* disk change line */

/* Flopppy Main status register definitions */
#define rfm 0x80			/* request for master */
#define ddir 0x40			/* data direction */
#define non_dma 0x20		/* non-dma exection */
#define cip 0x10			/* command in progerss */
#define d3s 0x8			/* drive 3 seeking */
#define d2s 0x4			/* drive 2 seeking */
#define d1s 0x2			/* drive 1 seeking */
#define d0s 0x1			/* drive 0 seeking */

/* values for drive select register */
#define dsel0  0x10		/* select drive 0 */
#define dsel1  0x21		/* select drive 1 */
#define dsel2  0x42		/* select drive 2 */
#define dsel3  0x83		/* select drive 3 */

/* first dma controller register equates */
#define dma_status 0x8		/* dma status register r/o */
#define dma_command 0x8	/* dma command register w/o */
#define dma_request 0x9	/* dma rewuest register w/0 */
#define dma_mask 0xa		/* dma single mask register w/o */
#define dma_mode 0xb		/* dma mode register */
#define dma_clear_ff 0xc	/* clear byte pointer flip-flop w/o */
#define dma_read_temp 0xd	/* read temp register r/o */
#define dma_mc 0xd			/* master clear */
#define dma_clear_mask 0xe /* clear mask register */
#define dma_write_all 0xf	/* write all mask bits */
#define dma0_address 0x0	/* dma channel 0 base address register  */
#define dma0_count 0x1		/* dma channel 0 word count register */
#define dma1_address 0x2	/* dma channel 1 address register */
#define dma1_count 0x3		/* dma channel 1 count register */
#define dma2_address 0x4	/* dma channel 2 address register */
#define dma2_count 0x5     /* dma channel 2 count register */
#define dma3_address 0x6	/* dma channel 3 address register */
#define dma3_count 0x7		/* dma channel 3 count register */
#define dma_page 0x81		/* dma page register : high 4 buts */
#define mask 2					/* dam mask value */

/* dma controller commands */
#define memory_read 0x4a	/* DMA from memory ==> floppy */
#define memory_write 0x46	/* DMA from floppy ==> memory */

/* interrupt equates */
#define fdc_int 0x20 	/* floppy interrupt (8259) */
#define eoi 0x20			/* end of interrupt command */
#define fdc_vec 0x0e		/* fdc interrupt vector # */
#define timer_vec 0x8	/* timer 18.2/sec int */
#define alt_timer 0x1c 	/* alternate timer vector */

/* DP8473 controller commands */
#define readid 0xa		/* read id command */
#define mfm_mode 0x40	/* MFM bit for read/write commands */
#define fm_mode 0       /* FM bit for read/write command */
#define recalibrate 0x7 /* recalibrate command */
#define seek_cmd 0xf		/* seek command */
#define sense_stat 0x4	/* sense status */
#define sense_int 0x8	/* sense interupt */
#define specify 0x3     /* specify command */
#define set_track 0x1	/* set track command */
#define format_trk 0xd	/* track format */
#define format_mfm 04e	/* mfm track format */
#define read_mfm_id 0x4a /* mfm read id */
#define scan_equal 0x11/* scan equal */

  /* DP8473 error codes */

/* Status Register 0 */
#define normal    0     /* normal command completion */
#define abnormal  0x40  /* abnormal command completion */
#define invalid   0x80  /* invalid command */
#define rchange   0xc0  /* ready changed state during polling mode */
#define seek_end  0x20  /* seek or recal complete */
#define equipment 0x10  /* after recal, track0 not found. This could mean that
                           another recal should be issued as the chip only
                           issues 77 step pulses, even on 8o trk drives */
#define head_addr 0x4   /* had address at end of execution */
#define drive3    0x3   /* drive 3 selected */
#define drive2    0x2   /* drive 2 selected */
#define drive1    0x1   /* drive 1 selected */
#define drive0    0x0   /* drive 0 selected */

/* Status Register 1 */
#define end_trk   0x80  /* chip xfer'd last sector on track w/o TC */
#define crc_addr  0x40  /* crc error */
#define over_run  0x20  /* over run error */
#define no_data   0x4   /* no data error */
#define protect   0x2   /* media is write protected */
#define mam_addr  0x1   /* missing address mark */

/* Status Register 2 */
#define clt_mark  0x40  /* control mark */
#define crc_data  0x20  /* crc error in data field */
#define wrong_trk 0x10  /* wrong track error */
#define scan_eq   0x8   /* scan equal - not an error */
#define no_scan   0x4   /* scan not satisfied */
#define bad_track 0x2   /* track not found, or wrong one */
#define mam_data  0x1   /* missing address mark in data field */

/* Status register 3 */
#define wp_status 0x40  /* write protect status */
#define trk00_stat 0x10 /* track 00 status */
#define hd_status 0x4   /* head select status */
#define d3_sel    0x3   /* drive 3 selected */
#define d2_sel    0x2   /* drive 2 seeceted */
#define d1_sel    0x1   /* drive 1 selected */
#define d0_sel    0x0   /* drive 0 selected */
