/*
LBR.C - CP/M library file module of CP/M File eXpress
Copyright 20 Jan 1992 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	..!uunet!ddsw1!carson

BBS:	Antelope Freeway, 1-708-455-0120

Notes:
	Novosielski format library utility module
	Notes: Doesn't do any datestamp processing.
		Assumes short int is 2 bytes long.
*/

#include "cfx.h"

/* -------------------------------------------------------- */

void blankout(textstring, arraysize)
char *textstring;
int arraysize;
{
	int slength;
	slength = strlen(textstring);

	while (slength < arraysize)
	{
		*(textstring + slength) = ' ';
		slength++;
	}
	*(textstring + arraysize - 1) = '\0';
}
/* -------------------------------------------------------- */

int getentry(gefile, lbrentry)
FILE *gefile;
struct direntry *lbrentry;
{
	int rresult;
	rresult = fread(lbrentry, sizeof(*lbrentry), 1, gefile);
	return (rresult && (lbrentry->status == 0));
}
/* -------------------------------------------------------- */

int wildfnmatch(wildname, name, wildext, ext)
char *wildname, *name, *wildext, *ext;
{
	int position;

	/* test names */
	for (position = 1;
	     ((*wildname != '*') && (position < 9));
	     position++, wildname++, name++)
		if ((*wildname != '?') && (*wildname != *name))
			return 0;	/* nonmatch */

	/* test extents */
	for (position = 1;
	     ((*wildext != '*') && (position < 4));
	     position++, wildext++, ext++)
		if ((*wildext != '?') && (*wildext != *ext))
			return 0;	/* nonmatch */

	return (1);
}
/* -------------------------------------------------------- */

void lbr(lufd)
FILE *lufd;
{
	char procname[13];
	int lbrents, tlbrents;
	long lbrmarker, lbrmarker1;
	FILE *randfd;
	char matchwork[40];	/* for destructive strtok() */

	char matchname[9], matchext[4];
	char *matchptr;
	char tempname[9], tempext[4];
	struct direntry DCEntry, workentry;

	lbrmarker = ftell(lufd);
	if ((fread(&DCEntry, sizeof(DCEntry), 1, lufd)) < 1)
	{	cerror("zero length library file; abort!");
		return;
	}
	lbrmarker1 = ftell(lufd);
	lbrents = DCEntry.length * 4;	/* 4 entries per sector */

	randfd = fopen(infname, "rb");		/* open a spare */
	if (strlen(membername))		/* member specified */
	{	strcpy(matchwork, membername);
		matchptr = matchwork;
		strcpy(matchname, strtok(matchptr, ". "));
		matchptr = NULLCHARPTR;		/* initialize */
		strcpy(matchext, strtok(matchptr, ". "));
		blankout(&matchname[0], 9);
		blankout(&matchext[0], 4);
		stupcase(matchname);
		stupcase(matchext);
	}

	if (!brief)
		infoflag = 1;		/* just show info first */
	rescan:
	tlbrents = lbrents;
	while (--tlbrents)
		if (getentry(lufd, &workentry))
		{	memcpy(tempname, workentry.name, 8);
			memcpy(tempext, workentry.ext, 3);
			tempname[8] = tempext[3] = '\0';
			strcpy(procname, tempname);
			strcat(procname, ".");
			strcat(procname, tempext);
			if (!strlen(membername) ||
			    wildfnmatch(matchname, tempname, matchext, tempext))
			{	/* seek to member location */
				xferndate(workentry.credate, workentry.moddate);
				fseek (randfd, (workentry.index * 128L) + lbrmarker, SEEK_SET);
                                mlength = workentry.length * 128L;
                                /* here was a small, but important bug before: 128 instead of now 128L as a multiplier */
				/* use recursion to process member */
				process(randfd, procname, mlength);
			}
		}
	if (infoflag && !info)	/* info shown; now do members */
	{	infoflag = 0;
		fseek (lufd, lbrmarker1, SEEK_SET);
		outcrlf(1);
		goto rescan;
	}
	fclose(randfd);
}
/* End of LBR.C */
