/* pstring.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include "pstring.h"

/*
 * A C string is a series of char's ending with a zero char.
 * A Pascal string is an unsigned char length followed by
 * that many unsigned char's.
 */

/* PStrToCStr() converts a P-string to a C-string. */
char *PStrToCStr(char *c, const unsigned char *p)
{
	unsigned n;
	char *x;

	x = c;
	n = *p++;
	while (n-- > 0)
		*x++ = *p++;
	*x = 0;

	return c;

}

/* CStrToPStr() converts a C-string to a P-string. */
unsigned char *CStrToPStr(unsigned char *p, const char *c)
{
	unsigned n;
	char *x;

	x = (char *)&p[1];
	n = 0;
	while ((*x++ = *c++) != 0)
		n++;
	p[0] = n;

	return p;

}
