/* uSim bdev.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#define kMaxBDev 16
#define kMaxSIZ 5242880
#define kMaxTPD 640
#define kMaxSPT 64
#define kMaxBLS 2048
#define kMaxDRM 1023
#define kMaxALV 320
#define kMaxCKS 256
#define kMaxPB  15

#define kBDevSectorSize   128

#define kBDevStatusError     0
#define kBDevStatusReadWrite 1
#define kBDevStatusReadOnly  2
#define kBDevStatusClosed    3

typedef struct BDevParameterBlock BDevParameterBlock;
typedef BDevParameterBlock *BDevParameterBlockPtr;

typedef struct BDev BDev;
typedef BDev *BDevPtr;

extern BDevPtr BDevIndexToPtr(unsigned n);

extern int BDevStatus(BDevPtr bDevPtr, char *name);

extern int BDevInstallParameters(BDevPtr bDevPtr, Word dpAddress);

extern int
	BDevRead(BDevPtr bDevPtr,
	         Word trackNumber,
	         Word sectorNumber,
	         Byte *sector);

extern int
	BDevWrite(BDevPtr bDevPtr,
	          Word trackNumber,
	          Word sectorNumber,
	          Byte *sector);

extern void BDevClose(BDevPtr bDevPtr);

extern int BDevOpen(BDevPtr bDevPtr, const char *name, int readOnly);

extern BDevPtr
	BDevMount(const char *bDevPtr, const char *file, int readOnly);

extern void BDevUnmount(const char *bDevPtr);

extern void
	ShowBDevParameterBlock(BDevParameterBlockPtr pb, int showXLT);

extern int EraseSystemTracks(BDevPtr bDevPtr);

extern int AsciiDiskCopy(BDevPtr bDevPtr, const char *fileName);

extern int FileDiskCopy(BDevPtr bDevPtr, const char *fileName);

extern int
	FileDiskFormat(char *fileName,
	               long siz,
	               long spt,
	               long bls,
	               long drm,
	               long off,
	               long skf);

extern int ShowBDevALV(const char *bDevPtr, unsigned n, char *name);

extern int ShowBDevFCB(const char *bDevPtr, unsigned n, char *name);

extern int ShowBDevDIR(const char *bDevPtr, unsigned n, char *name);

extern void ShowBDevMount(char *bDevPtr, int verbose);
