/* Hist
	3/09/84	SR	index 0 is pen 0 instead of pen 1
*/

#include "ratdef.h";
#define MAXxSTRxBUFFER  100
#define MOVE  1
#define DRAW  2
#define YES  1
#define NO  0
#define UNSUCCESSFUL  0
				/* Unsuccessful GIN operation    */
#define SUCCESSFUL  1
				/* Unsuccessful GIN operation    */
#define DEFAULT  1
				/* Default GIN device number     */
#define PLOTTER  6
				/* Plotter device number for GIN */
int max0(), min0();
unsigned int wxmin, wymin, wxmax, wymax;
int x_fetch(), y_fetch();

DDSTRX (paraseg,paraoff)
int paraoff,paraseg;
 
{
/************************************************************************
*                                                                      *
*     Function: Device Driver for Strobe 2x0 pen plotters              *
*                                                                      *
*     Input Parameters:                                                *
*            paraseg - parameter segment                               *
*            paraoff - parameter offset                                *
*                                                                      *
*     Output Parameters:                                               *
*            none                                                      *
*								       *
*     Routines Called:                                                 *
*             Dbufstr- buffered output for the plotter                 *
*             Gznfpl - prompt the user for a new sheet of paper        *
*             Dr2x0  - move/draw for the plotter                       *
*             Dp2x0  - Change pens on the plotter                      *
*             Dt2x0  - Set text size on plotter                        *
*             Gitoch  - convert integer to characters                  *
*             Gchtoi  - convert character string to integer            *
*             Gimnmx - Function to place integer value in a range      *
*                                                                      *
************************************************************************/
 
#include "ddcom.h"
int     i, j, gimnmx(), ierror, ival, istop,
	opcode, maxclr,
	ginok, icnvt[6], ibuf[40];
unsigned int xy[2], savexy[2];
int     temp, gitoch(), length;
unsigned int x1, y1, x2, y2;
unsigned int hlfsiz, fulsiz;
 
extern int     pens[9], clrred[9], clrgrn[9], clrblu[9];
 
/*  Initialization message - Move the pens to lower left-hand corner, press 
       START/ENTER, and then carriage return */
static initmess[] = {BIGM, BIGO, BIGV, BIGE, SP, BIGT, BIGH, BIGE, SP, BIGP, BIGE, BIGN, BIGS,
                         SP, BIGT, BIGO, SP, BIGL, BIGO, BIGW, BIGE, BIGR, SP,
                         BIGL, BIGE, BIGF, BIGT, MINUS, BIGH, BIGA, BIGN, BIGD,
                         SP, BIGC, BIGO, BIGR, BIGN, BIGE, BIGR, COMMA, SP, 
                         BIGP, BIGR, BIGE, BIGS, BIGS, SP, BIGS, BIGT, BIGA,
                         BIGR, BIGT, SLASH, BIGE, BIGN, BIGT, BIGE, BIGR, COMMA,
                         CR, LF, SP, BIGA, BIGN, BIGD, SP, BIGT, BIGH, BIGE,
                         BIGN, SP, BIGC, BIGA, BIGR, BIGR, BIGI, BIGA, BIGG,
                         BIGE, SP, BIGR, BIGE, BIGT, BIGU, BIGR, BIGN, PERIOD,
                         CR, LF, -1 };

/*           Set label(text) font  /CS<font>;/  */
static int setfnt[4] = {BIGC, BIGS, DIG0, SEMICOL};
 
/*           Set rotation /DI/    */
static int rotate[2] ={BIGD, BIGI};

/*           Text output set up /LB/  */
static int txtout[2] = {BIGL, BIGB};
 
/*           Output Marker /SM<0>;/  */
static int mrkout[4] = {BIGS, BIGM, DIG0, SEMICOL};
 
/*           Output Marker (+) for stars /SM2;/  */
static int mrkplus[4] = {BIGS, BIGM, DIG2, SEMICOL};

/*           Set up -
 		Set S/W flagging            <ESC>.H2:
                Reset parameters            DF;
                Home pen                    HO;
                Define Origin               DO;
								*/
static int setup[14] = {ESC,PERIOD,BIGH,DIG2,COLON,BIGD,BIGF,SEMICOL,
                       BIGH,BIGO,SEMICOL,BIGD,BIGO,SEMICOL };

/*              Set transmit delays         <ESC>.M100;
                Set character rotation      DI2;
                                                                */ 
static int setup2[10] = {ESC,PERIOD,BIGM,DIG1,DIG0,DIG0,
                         BIGD,BIGI,DIG2,SEMICOL};

/*           Stop graphics - /<ESC>.)/   */
static int stopgr[3] = {ESC, PERIOD, RPAREN};
 
static int mrktbl[5] = {DIG0, DIG2, DIG1, DIG3, DIG1};

static int ch_up_tbl[4] = {2, 0, 1, 3};
 
static int gogin[3] = {BIGD, BIGP, SEMICOL};
 
static int inqsta[3] = {BIGO, BIGS, SEMICOL};
 
static int getgin[3] = {BIGO, BIGD, SEMICOL};
 
static int comma = COMMA;
 
static int endtxt = ETX;
 
static int semcol = SEMICOL;

static int home[2] = {0, 0};
 
static int iniino[45] = {	/* initial intout array for open workstation*/
   0,0,
   METERS,         /* Device coordinates are meters     */
   50,             /* Step size in micrometers on x axis       */
   50,             /* Step size in micrometers on y axis       */
   0,              /* Number of character heights (continuous) */
   5,              /* Number of line types                     */
   1,              /* Number of line widths                    */
   5,              /* Number of marker types                   */
   0,              /* Number of marker sizes (continuous)      */
   4,              /* Number of text fonts                     */
   0,              /* Number of patterns                       */
   6,              /* Number of hatch styles                   */
   6,              /* Number of predefined colors              */
   1,              /* Number of GDPs                           */
   1,-1,-1,-1,-1,  /* GDPs, except BARS,  do not exist         */
   -1,-1,-1,-1,-1,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   1,              /* Device is capable of color               */
   1,              /* Device is capable of text rotation       */
   1,              /* Device is capable of filled area         */
   0,              /* Device is not capable of pixel operations*/
   0,              /* Number of colors available (continuous   */
			       /* pen colors)                  */
   1,              /* Number of locator devices available      */
   0,              /* Number of valuator devices available     */
   0,              /* Number of choice devices available       */
   0,              /* Number of string devices available       */
   2};             /* Workstation type (input/output)          */

static int inipto[12] = {	   /* initial ptsout array for open workstation */
   0,
   48,             /* Minimum character height in DC space      */
   0,
   0,
   1,              /* Minimum line width in DC space            */
   0,
   1,              /* Maximum line width in DC space            */
   0,
   0,
   48,             /* Minimum marker height in DC space         */
   0,
   0};

static int getid[] = {BIGO,BIGI,SEMICOL };

extern int conoff, iinoff, pinoff, ioutoff, poutoff, LFETCH();
extern int conseg, iinseg, pinseg, ioutseg, poutseg;

conoff=LFETCH(paraseg,paraoff,0); conseg=LFETCH(paraseg,paraoff,1);
iinoff=LFETCH(paraseg,paraoff,2); iinseg=LFETCH(paraseg,paraoff,3);
pinoff=LFETCH(paraseg,paraoff,4); pinseg=LFETCH(paraseg,paraoff,5);
ioutoff=LFETCH(paraseg,paraoff,6); ioutseg=LFETCH(paraseg,paraoff,7);
poutoff=LFETCH(paraseg,paraoff,8); poutseg=LFETCH(paraseg,paraoff,9);
 
opcode=LFETCH(conseg,conoff,OPCODE);
LSTORE(conseg,conoff,2,0);                 /*Assume no vertices are being passed back*/

/* opcode open workstation */

switch (opcode) {

 case OPENxWORKSTATION:
   LSTORE(conseg,conoff,2,6);             /* Set to number of output vertices */
   LSTORE(conseg,conoff,4,45);            /* Length of array intout           */

   /* set up output capability array */
   for (i=0;i<45;++i) LSTORE(ioutseg,ioutoff,i,iniino[i]);

   for (i=0;i<12;++i) LSTORE(poutseg,poutoff,i,inipto[i]);

   /*initialize plotter */

   i=0; do TTYOUT(initmess[i]); while (initmess[i++]>=0); TTYIN(&i);

   ndotkt = 0;               /*Initialize the plotter ouput counter. This  */
                             /*   counter is used by the routine 'dbufstr'  */
   outstr (14, setup);        /*Must use outstr because block mode is set   */
                             /*in initialization sequence.                 */
   dbufstr (10, setup2);

   dbufstr (3, getid);
   instr (20,ibuf,&i); for (i=0; (i<20 && (ibuf[i]<DIG0 || ibuf[i]>DIG9)); ++i);
   gchtoi (ibuf,i,&temp,&j);
   nmbrpens = (temp==260) ? 8 : 1;
   maxclr = (nmbrpens==8) ? nmbrpens : 32767;

   ndlntp = max0 (LFETCH(iinseg,iinoff,1),1);                     /*Set current line style*/
   if (ndlntp>5) ndlntp = 1;
   ndclrl = gimnmx (LFETCH(iinseg,iinoff,2), 0, maxclr);          /*Set current polyline color index*/
   ndmktp = LFETCH(iinseg,iinoff,3);                    /*Set current marker type*/
   if (ndmktp < 1 | ndmktp > 5) ndmktp=3;
   ndclrm = gimnmx (LFETCH(iinseg,iinoff,4), 0, maxclr);          /*Set current polymarker color index*/
   ndclrt = gimnmx (LFETCH(iinseg,iinoff,6), 0, maxclr);          /*Set current text color index*/
   ndclrf = gimnmx (LFETCH(iinseg,iinoff,9),0, maxclr);           /*Set current fill area color index*/
   ndstyf = max0 (LFETCH(iinseg,iinoff,8),1);           /*Set current fill style index*/
   if (ndstyf > 6)ndstyf = 1;
   ndistyf = max0 (LFETCH(iinseg,iinoff,7),0);          /*Set current fill interior style*/
   if (ndistyf > 3)ndistyf = 0;
   ndmkht = 6;                          /*Set default marker height */
   ndtysz = 6;                           /*Set default character height */
   ndtxrt = 0;                           /*Set default rotation to 0 degrees*/

   ndclrp = -1;                          /*Set current device color */
 

   dt2x0 (ndtysz);  /*Set initial text size */

   wxmin = wymin = 0;
   wxmax = 5250; wymax = 3650;
   LSTORE (ioutseg,ioutoff,1,wxmax-wxmin);
   LSTORE (ioutseg,ioutoff,0,wymax-wymin);
   inipto[3] = inipto[11] = 2000;
   LSTORE (poutseg,poutoff,3,inipto[3]);
   LSTORE (poutseg,poutoff,11,inipto[3]);
   
   nmbrfonts = 4;
   i = gimnmx (LFETCH(iinseg,iinoff,5), 1, nmbrfonts) - 1;
   setfnt[2] = (i%10) + DIG0;
   dbufstr (4, setfnt);           /*Output command        */

   LSTORE (ioutseg,ioutoff,13,(nmbrpens==8) ? 8 : 2);
   LSTORE (ioutseg,ioutoff,39,(nmbrpens==8) ? 8 : 0);
   LSTORE (ioutseg,ioutoff,10,nmbrfonts);

   for (i=0; i<=nmbrpens; ++i) pens[i] = i; /*Station 1 holds index 1 */
 
   clrred[0] = 0;                        /*Define color index 0 to black */
   clrgrn[0] = 0;
   clrblu[0] = 0;
   for (i=1;i<nmbrpens;++i) {
      clrred[i] = 1001;                        /*Define color index 1 to white */
      clrgrn[i] = 1001;
      clrblu[i] = 1001;
      }

   break;


/* opcode close workstation  */

  case CLOSExWORKSTATION:
   dr2x0 (MOVE, home);
   break;


/* opcode clear workstation  */

  case CLEARxWORKSTATION:
   dr2x0 (MOVE, home);  /*Home the plotter  */
   dbufstr (-1, semcol);  /*Dump buffer       */
   gznfpl();             /*prompt user for new paper (new frame on plotter) */
   ndclrp = -1;          /*Force plotter to pick up pen again */
   break;
 

/* opcode update workstation  */

  case UPDATExWORKSTATION:
   dbufstr (-1, semcol);
   break;


/* opcode escape  */

  case ESCAPE:
   if (LFETCH(conseg,conoff,5) == INQxADDRESSABLExCELLS) {
     LSTORE(ioutseg,ioutoff,0,-1);
     LSTORE(ioutseg,ioutoff,1,-1);
     }
   break;


/* opcode polyline  */

  case POLYLINE:
   if (LFETCH(conseg,conoff,1)<1) break;
   dp2x0 (ndclrl);                         /*Change color to line color  */
   if (ndlntp>1) dashline (LFETCH(conseg,conoff,1), ndlntp);
   else {
      xy[0]=x_fetch(0);
      xy[1]=y_fetch(0);
      dr2x0 (MOVE, xy);                 /*Move to first point         */
      j = 2;
      for (i=2; i<=LFETCH(conseg,conoff,1); ++i) {/*Draw between subsequent pts */
         xy[0]=x_fetch(j);
         xy[1]=y_fetch(j);
         dr2x0 (DRAW, xy);
         j += 2;
         }
      j -= 2;
      xy[0]=x_fetch(j);
      xy[1]=y_fetch(j);
      dr2x0 (MOVE, xy);   /*Move to pick up the pen */
   }
   break;
 

/* opcode polymarker  */

  case POLYMARKER:
   if (LFETCH(conseg,conoff,1)<1) break;
   dp2x0 (ndclrm);                /*Change color if necessary    */
   xy[0]=x_fetch(0);
   xy[1]=y_fetch(0);
   dr2x0 (MOVE, xy);        /*Move to center point         */
 
   dt2x0 (ndmkht);        /*set marker size              */
   mrkout[2] = mrktbl[ndmktp-1];   /*Get proper marker from table */

   /* Set sizes used for marker clipping */
   fulsiz = ndmkht * 8;          /*char height is 8 times code */
   hlfsiz = ndmkht * 4;

   j = 0;
   for (i=1; i<=LFETCH(conseg,conoff,1); ++i) {/*Output marker at each point  */

      xy[0] = x_fetch(j);
      xy[1] = y_fetch(j);

      /*Clip marker to device limits                                          */

      x1 = xy[0] - hlfsiz;
      x2 = x1 + fulsiz;
      y1 = xy[1] - hlfsiz;
      y2 = y1 + fulsiz;
      if ((min0(x1,y1) >= 0) && (x2 <= wxmax) && /* watch out for portrait mode changes*/
	 (y2 <= wymax)) {            /*Marker fits on device */
            dr2x0 (MOVE, xy); /*Move to center point and display */
            dbufstr (4, mrkout);             /*Output marker     */
            if(ndmktp==3) dbufstr(4,mrkplus); /* A star is a plus and an x */
            }
      j += 2;                              /*Increment ptr to coords  */
      }
 
   /*restore the user's text size */
   dt2x0 (ndtysz);
   break;
 

/* opcode text  */

  case TEXT:
   dp2x0 (ndclrt);           /*Change color to text color  */
   xy[0]=x_fetch(0);
   xy[1]=y_fetch(0);
   dr2x0 (MOVE, xy);   /*Move to start point   */

   j = LFETCH(conseg,conoff,INTEGERxINxLENGTH);/*Get the string length  */
   dbufstr (-1, &endtxt);       /*Force the buffer to be cleared */
   dbufstr (2, txtout);         /*Text command  */
   for (i = 0; i < j; ++i) {   /*Loop to keep buffer from overflowing*/
       xy[0]=LFETCH(iinseg,iinoff,i);
       dbufstr (1, xy);
       }
   dbufstr (1, &endtxt);        /*terminate string  */
   break;
 

/* opcode fill area */

  case FILLxAREA:
   dp2x0 (ndclrf);                      /*Change color to fill color  */
   i=LFETCH(conseg,conoff,1);
   if (i>1) gsxfill (ndistyf, ndstyf, ndlntp, i);
   break;


/* opcode cell array */

  case CELLxARRAY:
   savexy[0] = x_fetch(0);                          /*Save boundary points  */
   savexy[1] = y_fetch(0);
   x2 = x_fetch(2);
   y2 = y_fetch(2);

   dp2x0 (ndclrl);                      /*Change color to line color */
   dr2x0 (MOVE, savexy);                /*Move to first point   */

   xy[0] = x2;                          /*Draw boundary around area */
   xy[1] = savexy[1];
   dr2x0 (DRAW, xy);
   xy[1] = y2;
   dr2x0 (DRAW, xy);
   xy[0] = savexy[0];
   dr2x0 (DRAW, xy);
   dr2x0 (DRAW, savexy);

   break;


/* opcode GDP's */

  case GENERALIZEDxDRAWINGxPRIMITIVE:
   i=LFETCH(conseg,conoff,5);

   if(i==1) {         /* BARS - supported by both plotters */
      dp2x0 (ndclrf);                      /*Change color to fill color  */
      for (j=2; j<8; ++j) ibuf[j-2] = LFETCH(pinseg,pinoff,j);
      x1 = LFETCH(pinseg,pinoff,0); y1 = LFETCH(pinseg,pinoff,1);
      x2 = LFETCH(pinseg,pinoff,2); y2 = LFETCH(pinseg,pinoff,3);

      LSTORE(pinseg,pinoff,2,x2);  LSTORE(pinseg,pinoff,3,y1);
      LSTORE(pinseg,pinoff,4,x2);  LSTORE(pinseg,pinoff,5,y2);
      LSTORE(pinseg,pinoff,6,x1);  LSTORE(pinseg,pinoff,7,y2);

      gsxfill(ndistyf,ndstyf,ndlntp,4);

      for (j=2; j<8; ++j) LSTORE(pinseg,pinoff,j,ibuf[j-2]);
   }
        
   break;


/* opcode set character height */

  case SxCHxHEIGHT:

 
   ndtysz = gimnmx (LFETCH(pinseg,pinoff,1), 48, inipto[3])/8;
   
   dt2x0 (ndtysz);             /*Set the text size */

   LSTORE(conseg,conoff,2,2);                       /*One output coordinate pair*/
   LSTORE(poutseg,poutoff,0,savexy[0] = ndtysz * 4);
   LSTORE(poutseg,poutoff,1,savexy[1] = ndtysz * 8);

   /*cell width = 1.5 * char width  */
   /*cell height = 14/8 * char heght   */
   LSTORE(poutseg,poutoff,2,MULDIV(savexy[0],3,2));
   LSTORE(poutseg,poutoff,3,MULDIV(savexy[1],14,8));

   break;


/* opcode set character up vector */

  case SxCHxUPxVECTOR:
   ndtxrt = ((((LFETCH(iinseg,iinoff,0)/10) % 360) + 45) / 90) % 4;
   dbufstr (2,rotate);
   xy[0] = ch_up_tbl[ndtxrt]+DIG0;
   dbufstr (1, xy);
   dbufstr (1,&semcol);          /*End that command*/
   LSTORE(ioutseg,ioutoff,0,ndtxrt*90);         /*Inform upper level of angle */
   break;


/* opcode set color  */

  case SxCOLORxREPRESENTATION:
   /*Save 1 or 8 color indices, 1 for each pen station.  The requested  */
   /*value is the same as the realized value                       */
   i = gimnmx (LFETCH(iinseg,iinoff,0)-1, 0, nmbrpens);           /*Get color index in range  */
   clrred[i] = LFETCH(iinseg,iinoff,1);
   clrgrn[i] = LFETCH(iinseg,iinoff,2);
   clrblu[i] = LFETCH(iinseg,iinoff,3);
   break;


/* opcode set line type */

  case SxPLxLINETYPE:
   ndlntp = max0 (LFETCH(iinseg,iinoff,0),1);
   if (ndlntp>5) ndlntp = 1;
   LSTORE(ioutseg,ioutoff,0,ndlntp);
   break;
 

/* opcode polyline color index  */

  case SxPLxCOLORxINDEX:
   ndclrl = gimnmx (LFETCH(iinseg,iinoff,0), 0, maxclr);
   LSTORE(ioutseg,ioutoff,ndclrl);              /*Return color index selected */
   break;
 

/* opcode set marker type   */

  case SxPMxTYPE:
   ndmktp = LFETCH(iinseg,iinoff,0);
   if (ndmktp < 1 | ndmktp > 5) ndmktp = 3; /*Marker type 3 is default */
   LSTORE(ioutseg,ioutoff,ndmktp);                      /*Return type selected     */
   break;


/* opcode polymarker scale  */

  case SxPMxSCALE:
   ndmkht = gimnmx (LFETCH(pinseg,pinoff,1), 48, inipto[11])/8; /*Make sure size not too        */
						   /*small or too large       */
   LSTORE(conseg,conoff,2,1);                      /*Return 1 coordinate pair */
   LSTORE(poutseg,poutoff,0,0);
   LSTORE(poutseg,poutoff,1,ndmkht*8);             /*Return size selected     */

   break;


/* opcode polymarker color index  */

  case SxPMxCOLORxINDEX:
   LSTORE(ioutseg,ioutoff,0,ndclrm = gimnmx (LFETCH(iinseg,iinoff,0),0,maxclr));
   break;
 

/* opcode set text font  */

  case SxTXxFONT:
   i = j = gimnmx (LFETCH(iinseg,iinoff,0), 1, nmbrfonts) - 1;
   setfnt[2] = (i%10) + DIG0;
   dbufstr (4, setfnt);           /*Output command        */
 
   LSTORE(ioutseg,ioutoff,0,j);                /*Return actual font selected  */
   break;
 

/* opcode text color index   */

  case SxTXxCOLORxINDEX:
   LSTORE(ioutseg,ioutoff,0,ndclrt = gimnmx (LFETCH(iinseg,iinoff,0),0,maxclr));
   break;
 

/* opcode set fill color index  */

  case SxFxCOLORxINDEX:
   LSTORE(ioutseg,ioutoff,0,ndclrf = gimnmx (LFETCH(iinseg,iinoff,0),0,maxclr));
   break;
 

/* opcode set fill interior sytle index  */

  case SxFxINTERIORxSTYLE:
   ndistyf = max0(LFETCH(iinseg,iinoff,0),0);
   if (ndistyf > 3) ndistyf = 0;
   LSTORE(ioutseg,ioutoff,0,ndistyf);
   break;

/* opcode set fill style index  */

  case SxFxSTYLExINDEX:
   ndstyf = max0(LFETCH(iinseg,iinoff,0),1);
   if (ndstyf > 6) ndstyf = 1;
   LSTORE(ioutseg,ioutoff,0,ndstyf);
   break;

/* opcode inquire color representation  */

  case INQxCOLORxREPRESENTATION:
   i = gimnmx (LFETCH(iinseg,iinoff,0)-1, 0, nmbrpens);     /*Map index 0-7 to 1-6 */
   LSTORE(ioutseg,ioutoff,0,i);               /*Color index selected             */
   LSTORE(ioutseg,ioutoff,1,clrred[i]);           /*Set values are same as realized  */
   LSTORE(ioutseg,ioutoff,2,clrgrn[i]);
   LSTORE(ioutseg,ioutoff,3,clrblu[i]);
   break;


/* opcode input locator  */

  case INPxLOCATOR:
   LSTORE(poutseg,poutoff,0,0);
   LSTORE(poutseg,poutoff,1,0);
   LSTORE(conseg,conoff,4,UNSUCCESSFUL);
   i = LFETCH(iinseg,iinoff,0);                       /*check input device number  */
   if (i != DEFAULT && i != PLOTTER) return;
   xy[0]=x_fetch(0);
   xy[1]=y_fetch(0);
   dr2x0 (MOVE, xy);       /*move to initial point*/

   dbufstr (-1, gogin);  /*First flush the buffer  */
   outstr (3, gogin);                /*Arm to do a point input      */
   for (;;) {                          /*Go until the key was pressed */
      outstr (3, inqsta);            /*Ask for a status byte        */
      instr (4, ibuf,  &temp);       /*Get the answer               */
      gchtoi (ibuf, j, &ival, &istop);
      j = (ival>>2) % 2;
      if (j == 1) break;             /*the third bit was on         */
      }
   outstr (3, getgin);       /*Ask for the gin report       */
   instr (18, ibuf,  &temp); /*Get the gin report           */
 
   LSTORE(conseg,conoff,4,SUCCESSFUL);                      /*Request was successful   */
   LSTORE(conseg,conoff,2,1);                               /*Output 1 coordinate pair */
   gchtoi (ibuf, 0, &i, &istop);
   LSTORE(poutseg,poutoff,1,i-wxmin);
   gchtoi (ibuf, istop+1, &i, &istop);
   LSTORE(poutseg,poutoff,0,wymax-i);
   LSTORE(ioutseg,ioutoff,0,ibuf[istop+1] - DIG0 + SP);     /*Return SP or ! (pen up/down)*/
   break;
 

/* opcode set input mode */

  case SxINPUTxMODE:
   LSTORE(ioutseg,ioutoff,0,1);    /*Default mode is request */
   break;
  }

}


dr2x0 (opcode, xy)
int opcode, xy[];
{
/***********************************************************************
*                                                                      *
*     Function: Device Driver move/draw for the Strobe plotter         *
*                                                                      *
*     Input Parameters:                                                *
*           opcode - driver function, either move/draw                 *
*           xy     - coordinates to move or draw to                    *
*                    xy [0] = x-coordinate                             *
*                    xy [1] = y-coordinate                             *
*                                                                      *
*     Output Parameters: none                                          *
*                                                                      *
*     Routines Called:                                                 *
*            dbufstr - output a string to the plotter                  *
*            gitoch - convert integer to character string              *
*                                                                      *
************************************************************************/
 
int length, iconvt[10], ierror, gitoch();
 
static int movdrw[5] = {BIGP, BIGU, SEMICOL, BIGP, BIGA};
static int semcol[1] = {SEMICOL};
static int comma[1] = {COMMA};
 
   movdrw[1] = BIGU;                       /*Always prepare to do a move */
   if (opcode == DRAW) movdrw[1] = BIGD;   /*Change it for a draw        */
   dbufstr (5, movdrw);
   length = gitoch (xy[0],iconvt,5,&ierror);
   dbufstr (length,iconvt);
   dbufstr (1,comma);
   length = gitoch (xy[1],iconvt,5,&ierror);
   dbufstr (length,iconvt);
   dbufstr (1,semcol);
}

dt2x0 (hgt)
unsigned int hgt;
{
/***********************************************************************
*                                                                      *
*     Function: Set text size on Strobe plotter                        *
*                                                                      *
*     Input Parameters:                                                *
*            hgt   - height of character                               *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            gitoch  - convert integer to character string             *
*            dbufstr - output a command to a strobe plotter            *
***********************************************************************/

int leng, ierr, ibuf[6];
/*           Set label(text) size  /SI/  */
static int txtsiz[2] = {BIGS, BIGI};
 
   dbufstr (2, txtsiz);
   leng=gitoch(hgt,ibuf,5,&ierr);
   ibuf[leng] = SEMICOL;             /* Add a semicolon to terminate command */
   dbufstr (leng+1,ibuf);
 
}

dp2x0 (color)
int color;
{
/***********************************************************************
*                                                                      *
*     Function: Change the color on the Strobe 2x0 plotter             *                                                                      *
*     Input Parameters:                                                *
*            color - color to change to                                *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            gznppl - prompt for new pen on plotter                    *
*            dbufstr - output a command to the plotter                 *
***********************************************************************/
 
int newsta;
extern int pens[], clrred[], clrgrn[], clrblu[];
 
#include "ddcom.h";
 
/*   Change pens   */
static int penclr[4] = { BIGS, BIGP, DIG0, SEMICOL };  /*  SP0; */
 
if (ndclrp != color) {
   /*prompt for new pen on plotter if necessary  */
   gznppl (color, nmbrpens, pens, &newsta);
 
   ndclrp = color;   /*Set the current color  */
   if (nmbrpens>1) {
      penclr[2] = newsta + DIG0;
      dbufstr (4,penclr); /* load the pen */
      }  
   }
}

dbufstr (icount, iarray)
int icount, iarray[];
{
/***********************************************************************
*                                                                      *
*     Function: Strobe buffered output handler                         *
*                                                                      *
*     Input Parameters:                                                *
*           icount - number of characters in iarray to be output       *
*                    -1 flushes the buffer                             *
*                                                                      *
*           iarray - Array of characters to be output                  *
*                                                                      *
*     Output Parameters: none                                          *
*                                                                      *
*     Routines Called:                                                 *
*            RDRIN - get a character from the plotter                  *
*            PCHOUT - output a character to the plotter                *
*            outstr - output a string to the plotter                   *
*                                                                      *
***********************************************************************/
 
int adechar, k;
int tries;
 
#include "ddcom.h";
 
   k = icount;
   if (k < 0) k = 0;
   if (((ndotkt+k) > MAXxSTRxBUFFER) || (icount < 0)) {
      PCHOUT (ENQ);               /*Output buffer terminating character  */
      ndotkt = 0;               /*Reset the plotter buffer counter     */
      /*Wait for prompt response from device. The prompt in most cases is */
      /*   the ack (6) character.                                      */
      tries = adechar = 0;
      do RDRIN (&adechar);
        while ((adechar != ACK) && (++tries<100));
      }
   outstr (k, iarray);
   ndotkt = ndotkt + k;         /*Update the plotter buffer counter    */
}

gznfpl()
{
/***********************************************************************
*                                                                      *
*     Function: Issue prompt to change paper and wait for input        *
*                                                                      *
*     Input Parameters:                                                *
*            none                                                      *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            TTYIN - get keyboard input                                *
*            TTYOUT - output text to console                           *
***********************************************************************/

   int i;
   static int string[] = {
     BIGC,BIGH,BIGA,BIGN,BIGG,BIGE,SP,BIGP,BIGA,BIGP,BIGE,BIGR,COMMA,
     SP,BIGT,BIGH,BIGE,BIGN,SP,BIGP,BIGR,BIGE,BIGS,BIGS,SP,BIGR,BIGE,
     BIGT,BIGU,BIGR,BIGN,CR,LF };

   i=0; do TTYOUT(string[i]); while (string[i++]!=LF);
   TTYIN(&i);
}

gznppl(color, npens, pens, newstat)
int color, npens, pens[], *newstat;
{
/***********************************************************************
*                                                                      *
*     Function: Issue prompt to change pens and wait for input         *
*                                                                      *
*     Input Parameters:                                                *
*            color - new color                                         *
*            npens - number of pens on plotter                         *
*            pens - pen station array                                  *
*                                                                      *
*     Output Parameters:                                               *
*            newstat - new station                                     *
*                                                                      *
*     Routines Called:                                                 *
*            TTYIN - get keyboard input                                *
*            TTYOUT - output text to console                           *
***********************************************************************/

   int i,j;
   static string[] = {
    BIGL,BIGO,BIGA,BIGD,SP,BIGP,BIGE,BIGN,SP,SP,SP,SP,SP,SP,SP,BIGA,BIGN,BIGD,
    SP,BIGP,BIGR,BIGE,BIGS,BIGS,SP,BIGR,BIGE,BIGT,BIGU,BIGR,BIGN,-1 };
   
   *newstat=-1;
   for (i=0; i<=npens; ++i) if (pens[i]==color) *newstat=i;
   if (*newstat==-1) {
      for (i=9;i<13;++i) string[i]=SP; gitoch(color,&string[9],5,&i);
      i=0; do TTYOUT(string[i]); while (string[++i]>=0);
      TTYIN(&i); TTYOUT(i); 
      TTYOUT(CR); TTYOUT(LF);
      *newstat = gimnmx(i-'0',0,npens);
      pens[*newstat]=color;
      }
   }


instr (lenin,string,lenout)
int lenin, string[], *lenout;
{
/***********************************************************************
*                                                                      *
*     Function: Input a string from the plotter                        *
*                                                                      *
*     Input Parameters:                                                *
*            lenin - maximum length of string                          *
*                                                                      *
*     Output Parameters:                                               *
*            string - array of ADE values received from plotter        *
*            lenout - actual length of string                          *
*                                                                      *
*     Routines Called:                                                 *
*            RDRIN - get plotter input                                 *
***********************************************************************/

   int i, tmplen, temp;

   /* check for valid length */

   *lenout = 1; 
   if (lenin>0) {
      tmplen = min0(lenin,81);
      i=-1;
      do {
         do RDRIN(&temp); while (temp==0);
         string[++i]=temp;
         *lenout = i+1;
         } while (*lenout<tmplen && string[i]!=LF);
      }
   /* put the 'new line' character at the end of the string */
   string[*lenout] = LF;
   }

outstr (len, string)
int len, string[];
{
/***********************************************************************
*                                                                      *
*     Function: Output a string to the plotter                         *
*                                                                      *
*     Input Parameters:                                                *
*            len - length of string                                    *
*            string - array of ADE values                              *
*                                                                      *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            RDROUT - send character to plotter                        *
***********************************************************************/

   int i;

   for (i=0; i<len; ++i) PCHOUT (string[i]); 
   }

int gitoch (value, string, max, ierror)
int string[], max, value, *ierror;
{
/*********************************************************************
* 			  				             *
* 	FUNCTION: CONVERT AN INTEGER TO AN ADE STRING                *
* 							             *
* 	INPUT PARAMETERS:				             *
* 		VALUE - INTEGER TO BE CONVERTED                      *
*		MAX - MAXIMUM LENGTH OF STRING                       *
* 			  				             *
* 	OUTPUT PARAMETERS:				             *
* 		STRING - ARRARY TO HOLD THE ADE VALUES               *
*    		IERROR - ERROR FLAG                                  *
* 							             *
* 	ROUTINES CALLED:				             *
*               NONE                                                 *
*********************************************************************/

    int l;

    *ierror=-1;
    nb2ade(value,string,&l);
    if ((l<=0) || (l>max)) return(0);
    else {*ierror=0; return(l);}
   }

int gimnmx (value, min, max)
int value, min, max;
{
/*********************************************************************
* 			  				             *
* 	FUNCTION: CHECK THAT AN INTEGER IS WITHIN A GIVEN RANGE      *
* 							             *
* 	INPUT PARAMETERS:				             *
* 		VALUE - INTEGER TO CHECK                             *
*		MIN - MINIMUM LEGAL VALUE                            *
*		MAX - MAXIMUM LEGAL VALUE                            *
* 			  				             *
* 	OUTPUT PARAMETERS:				             *
*               GIMNMX - VALUE RETURNED                              *
* 							             *
* 	ROUTINES CALLED:				             *
*               NONE                                                 *
*********************************************************************/

    return (min0(max0(min,value),max));
    }

nb2ade(number,chars,number_char)
int number,*number_char;
int *chars;

/***********************************************************************
*                                                                      *
*     Function: Convert a number to an ade-string                      *
*                                                                      *
*     Input Parameters:                                                *
*            number - value to convert                                 *
*                                                                      *
*     Output Parameters:                                               *
*            chars - array of ade values                               *
*            number_char - length of chars                             *
*                                                                      *
*     Routines Called:                                                 *
*            none                                                      *
***********************************************************************/

{
	int digit,i,first,tens[5];
	tens[0]=10000; tens[1]=1000; tens[2]=100; tens[3]=10;
	tens[4]=1;
	if (number==0) {
		*number_char=1;
		*(chars++)='0';
	}
	else {
		*number_char=0;
		first=0;
		if (number<0) {
			*number_char=1;
			*(chars++)='-';
			number*=-1;
		}
		for (i=0;i<=4;++i) {
			digit=number/tens[i];
			if (digit>0 || first!=0)  {
				*(chars++)=digit + '0';
				++*number_char;
				number-=digit*tens[i];
				first=1;
			}
		}
	}
}

gchtoi (string, start, value, stop)
int string[], start, *value, *stop;
{
/*********************************************************************
* 			  				             *
* 	FUNCTION: CONVERT AN ADE STRING TO AN INTEGER                *
* 							             *
* 	INPUT PARAMETERS:				             *
* 		STRING - ARRAY CONTAINING THE STRING                 *
*		START - POSITION IN STRING TO START CONVERSION       *
* 			  				             *
* 	OUTPUT PARAMETERS:				             *
* 		VALUE - THE INTEGER VALUE                            *
*    		STOP - THE LAST POSITION OF THE STRING IN THE ARRAY  *
* 							             *
* 	ROUTINES CALLED:				             *
*               NONE                                                 *
*********************************************************************/

    int sign;


    sign = 1;
    for (*stop=start; string[*stop]==' '; *stop++);
    if (string[*stop] == '+' || string[*stop] == '-' )     /* sign */
       sign = (string[(*stop)++]=='+') ? 1 : -1;
    for (*value = 0; string[*stop] >= '0' && string[*stop] <= '9'; (*stop)++)
       *value = 10 * *value + string[*stop] - '0';
    *value = sign * *value;
    }

int min0 (a,b)
int a,b;
{
/*********************************************************************
* 			  				             *
* 	FUNCTION: RETURN THE MINIMUM OF A AND B                      *
* 							             *
* 	INPUT PARAMETERS:				             *
* 		A, B - VALUES TO FIND THE MINIMUM OF                 *
* 			  				             *
* 	OUTPUT PARAMETERS:				             *
* 		MIN0 - FUNCTION VALUE RETURNED                       *
* 							             *
* 	ROUTINES CALLED:				             *
*               NONE                                                 *
*********************************************************************/

    return((a<b) ? a : b);
    }

int max0 (a,b)
int a,b;
{
/*********************************************************************
* 			  				             *
* 	FUNCTION: RETURN THE MAXIMUM OF A AND B                      *
* 							             *
* 	INPUT PARAMETERS:				             *
* 		A, B - VALUES TO FIND THE MAXIMUM OF                 *
* 			  				             *
* 	OUTPUT PARAMETERS:				             *
* 		MIN0 - FUNCTION VALUE RETURNED                       *
* 							             *
* 	ROUTINES CALLED:				             *
*               NONE                                                 *
*********************************************************************/

    return((a>b) ? a : b);
    }

gsxfill (int_style, style_index, line_style, length)
int int_style, style_index, length;
/***********************************************************************
*                                                                      *
*     Function: Prepare data for polygon-fill routine                  *
*                                                                      *
*     Input Parameters:                                                *
*            int_style - interior style                                *
*            style_index - interior style index                        *
*            line_style - current line style                           *
*            length - number of points in polygon                      *
*                                                                      *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            LSTORE - long store                                       *
*            LFETCH - long fetch                                       *
*            plyfill - polygon fill                                    *
*            dr2x0 - move/draw on plotter                             *
*            dbufstr - send string to plotter                           *
***********************************************************************/

{
   int savexy[2], xy[2], ival, i, j, distance;

   if (ndistyf==1 || ndistyf==3) {
      savexy[0]=LFETCH(pinseg,pinoff,2*length);
      savexy[1]=LFETCH(pinseg,pinoff,2*length+1);
      LSTORE(pinseg,pinoff,2*length,LFETCH(pinseg,pinoff,0));
      LSTORE(pinseg,pinoff,2*length+1,LFETCH(pinseg,pinoff,1));

      distance = (ndistyf==1) ? 6 : 60;
      if (ndistyf==1) ival = 2;
      else {
         ival = ndstyf;
         if (ndstyf > 4) ival -= 3;
      }   
      plyfill (ival, distance, length+1);
      if (ndistyf==3 && ndstyf>4) {   
         ival = (ndstyf==5) ? 1 : 4;
         plyfill (ival, distance, length+1);
      }
      LSTORE(pinseg,pinoff,2*length,savexy[0]);
      LSTORE(pinseg,pinoff,2*length+1,savexy[1]);
   }
   xy[0]=x_fetch(0);
   xy[1]=y_fetch(0);
   dr2x0 (MOVE, xy);              /*Move to first point         */

   dr2x0 (MOVE, xy);              /*Move to repostion pen       */

   j = 2;
   for (i=2; i<=length; ++i) {  /*draw between subsequent points    */
      xy[0]=x_fetch(j);
      xy[1]=y_fetch(j);
      dr2x0 (DRAW, xy);
      j += 2;
      }
   xy[0]=x_fetch(0);
   xy[1]=y_fetch(0);
   dr2x0 (DRAW, xy);     /*draw to first point to make sure     */
				     /*polygon closed                  */
   dr2x0 (MOVE, xy);     /*Move to the point to pick the pen up */
}

plyfill(pattern,distance,length)
int pattern, distance, length;
/***********************************************************************
*                                                                      *
*     Function: Fill a polygon                                         *
*                                                                      *
*     Input Parameters:                                                *
*            pattern - fill pattern                                    *
*            distance - distance between fill lines                    *
*            length - number of points in polygon                      *
*                                                                      *
*     Output Parameters:                                               *
*            none                                                      *
*                                                                      *
*     Routines Called:                                                 *
*            LSTORE - long store                                       *
*            LFETCH - long fetch                                       *
*            MULDIV - muliply and divide using 32-bits                 *
*            INTERCPT - calculate intercept formula in 32 bits         *
*            dr2x0 - move/draw on plotter                             *
***********************************************************************/

{
   int incr, i, j, raster, intx[50], LFETCH(), MULDIV(), INTERCPT(), wmin, wmax;
   int x1, x2, y1, y2, j2, xy[2], temp, oldx, oldy;
   int oxmin, oxmax, oymin, oymax, intercept, sign, evenodd;
   int x_fetch(),y_fetch();

   incr = distance;
   if (pattern > 2) incr = (distance*7)/5;
   sign = (pattern == 4) ? -1 : 1;
   oxmax = oymax = -1; oxmin = oymin = 32767;
   x1 = x_fetch(0);  y1 = y_fetch(0);
   for (i=2*length-4; i>0; i-=2) {
      oldx = x_fetch(i);
      oldy = y_fetch(i);
      if (pattern==1 && oldy!=y1) break;
      if (pattern==2 && oldx!=x1) break;
      if (pattern>2 && (oldx-oldy)!=(-1*sign*(x1-y1))) break;
      }
   for (i=0; i<2*length; i+=2) {
      x1 = x_fetch(i);
      y1 = y_fetch(i);
      if (oxmax < x1) oxmax = x1;
      if (oxmin > x1) oxmin = x1;
      if (oymax < y1) oymax = y1;
      if (oymin > y1) oymin = y1;
   }
   switch (pattern) {
      case 2: wmin = oxmin; wmax = oxmax; break;
      case 1: wmin = oymin; wmax = oymax; break;
      case 4: wmin = oymin - oxmax; wmax = oymax - oxmin; break;
      case 3: wmax = oxmax + oymax; wmin = oxmin + oymin; break;
   }
   evenodd=0;
   for (raster=wmax; raster>=wmin; raster-=incr) {
      j = 0;
      evenodd = (++evenodd)%2;
      for (i=0; i<(2*length-2); i+=2) {
         x1 = x_fetch(i);
         y1 = y_fetch(i);
         x2 = x_fetch(i+2);
         y2 = y_fetch(i+2);
         intercept = -1;
         switch (pattern) {
            case 2:
              if ((x1<=raster && x2>=raster) || (x1>=raster && x2<=raster))
                 if (x1!=x2) {
                    intercept = y1 + MULDIV(raster-x1,y1-y2,x1-x2);
                    if ((x1==raster) && ((x2<raster && oldx>raster) ||
                                     (x2>raster && oldx<raster))) 
                       intercept=-1;
                 }
              if (x1!=x2) {oldx=x1; oldy=y1;}
              break;
            case 1:
              if ((y1<=raster && y2>=raster) || (y1>=raster && y2<=raster))
                 if (y1!=y2) {
                    intercept = x1 + MULDIV(raster-y1,x1-x2,y1-y2);
                    if ((y1==raster) && ((y2<raster && oldy>raster) ||
                                     (y2>raster && oldy<raster))) 
                       intercept=-1;
                 }
              if (y1!=y2) {oldx=x1; oldy=y1;}
              break;
            case 3: 
            case 4:
              if (((sign*x1+y1)<=raster && (sign*x2+y2)>=raster) ||
                  ((sign*x1+y1)>=raster && (sign*x2+y2)<=raster))
                 if (((x1!=x2) || (y1!=y2)) && (((y1-y2)+sign*(x1-x2))!=0)) {
                    intercept = INTERCPT(raster,sign,x1,y1,x2,y2);
                    if (((sign*x1+y1)==raster) && (((sign*x2+y2)<raster && (sign*oldx+oldy)>raster) ||
                                     ((sign*x2+y2)>raster && (sign*oldx+oldy)<raster))) 
                       intercept=-1;
                 }
              if ((x1-x2)!=(-1*sign*(y1-y2))) {oldx=x1; oldy=y1;}
              break;
            }
            if (intercept>=0) {
               intx[j++]=intercept;
               l_insert(intx,j-1,intx[j-1],evenodd);
            }
      }
      i = 0;
      for (j2=0; j2<j; ++j2) {
         switch (pattern) {
            case 2:
              xy[0] = raster; xy[1] = intx[j2]; break;
            case 1:
              xy[0] = intx[j2]; xy[1] = raster; break;
            case 3:
            case 4:
              xy[0] = intx[j2];  xy[1] = raster - sign*intx[j2]; break;
         }
         dr2x0 ((i++ % 2) + 1, xy);
      }
   }
}

l_insert(array,length,value,evenodd)
int array[], length, value, evenodd;
{
   int j, j2;

   for (j=0; j<length; ++j) 
      if ((array[j] > value && evenodd==0) || (array[j] < value && evenodd!=0)) {
         for (j2=length-1; j2>=j; --j2) array[j2+1]=array[j2];
         array[j]=value;
         break;
      }
}

int x_fetch(position) {return(LFETCH(pinseg,pinoff,position+1)+wxmin);}

int y_fetch(position) {return(wymax-LFETCH(pinseg,pinoff,position));}

dashline (number,dashtype)
int number, dashtype;
{
   int i,j,oldx,oldy,x,y,dx,dy,dist,diag,ppos,dash_dist,opcode,l_dash,xy[2];
   int LFETCH(), MULDIV(), DISTAN(), x_fetch(), y_fetch();
   static int dash_tbl[4][5] = {
      {2, 80,-80,  0,  0},
      {4,  8,-72,  8,-72},
      {4, 80,-36,  8,-36},
      {2,120,-40,  0,  0}
   };

   dashtype-=2;
   l_dash = dash_tbl[dashtype][0]; 
   xy[0]=oldx = x_fetch(0); xy[1]=oldy = y_fetch(0);
   dash_dist = dash_tbl[dashtype][1]; if (dash_dist<0) dash_dist=-1*dash_dist;
   j=0;  ppos=2;
   dr2x0 (MOVE,xy);
   for (i=1; i<number; ++i) {
      x=x_fetch(ppos); y=y_fetch(ppos); ppos+=2;
      dx = x-oldx;  dy = y-oldy;
      diag=dist=DISTAN((dx>=0) ? dx : -1*dx,(dy>=0) ? dy : -1*dy);
      if (diag<0) {
         x=oldx/2 + x/2;  y=oldy/2 + y/2;
         dx = x-oldx;  dy = y-oldy;
         diag=dist=DISTAN((dx>=0) ? dx : -1*dx,(dy>=0) ? dy : -1*dy);
         ppos -= 2;  i -= 1;
      }
      opcode=MOVE;
      if (dist!=0)
         for (;;) {
            if (dash_dist==0) {
               dash_dist=dash_tbl[dashtype][j+1];
               if (dash_dist<0) dash_dist=-1*dash_dist;
            }
            xy[0]=oldx=oldx+MULDIV(dx,dash_dist,diag);
            xy[1]=oldy=oldy+MULDIV(dy,dash_dist,diag);
            opcode = (dash_tbl[dashtype][j+1]<0) ? MOVE : DRAW;
            if (dash_dist>=dist) break;
            dr2x0 (opcode,xy);
            dist=DISTAN((oldx>x) ? oldx-x : x-oldx,(oldy>y) ? oldy-y : y-oldy);
            dash_dist=0;
            j=(++j)%l_dash;
         }
      xy[0]=x; xy[1]=y;
      dr2x0 (opcode,xy);
      dash_dist=dash_dist-dist;
      oldx=x; oldy=y;
   }
}
