/* -*-c,save-*- */

/*

 * pokev.c - poker evaluation functions

 * Robert Heller. Created: Sun Mar 9, 1986 17:59:57.14

 * Last Mod: 

 * 

 * (c) Copyright 1986 by Robert Heller

 *     All Rights Reserved

 * 

 * 

 */

#include <stdio.h>



#define LOCAL static



/* #define DEBUG /* debugging */



#ifdef DEBUG

#define LOCAL /* static */

#endif



LOCAL float POKEV_A[10];



#define A(INDX) POKEV_A[(INDX)+1]



pok_ini()

{

#ifdef DEBUG

    register int i;

#endif



    A(-1) = 0.0;

    A(0) = 0.501;

    A(1) = 0.924;

    A(2) = 0.971;

    A(3) = 0.9924;

    A(4) = 0.9963;

    A(5) = 0.9983;

    A(6) = 0.99974;

    A(7) = 0.999985;

    A(8) = 1.0;



#ifdef DEBUG

    for (i=(-1);i<9;i++) {

	printf("POKEV[%d] = %f\n",i,A(i));

	}

#endif

    }

LOCAL char VALS[6];

LOCAL float pr(l,prefix)

register int l;

register char *prefix;

{

    register int combs;

    float pow13();

    register float fraction,result;



#ifdef DEBUG

    printf("***In pr(): l=%d,prefix=%s,VALS=%s\n",l,prefix,VALS);

#endif

    combs = comb(13,strlen(VALS));

    fraction = ((float) (base10(prefix,13) * combs + decomb(VALS))) / 

	       (pow13(strlen(prefix)) * ((float) combs));

#ifdef DEBUG

    printf("***         fraction=%f\n",fraction);

#endif

    result = A(l-1) + ((A(l)-A(l-1)) * fraction);

#ifdef DEBUG

    printf("***pr() returns %f\n",result);

#endif

    return(result);

    }

LOCAL float pow13(ipow)

register int ipow;

{

    register float result;

    register int iresult;



    iresult = 1;

#ifdef DEBUG

    printf("***13^%d=",ipow);

#endif

    while (ipow-- > 0) iresult *= 13;

    result = (float) iresult;

#ifdef DEBUG

    printf("%f\n",result);

#endif

    return(result);

    }

LOCAL comb(n,m)

register int n,m;

{

    register int k,result,diff;



#ifdef DEBUG

    printf("***comb(%d,%d)\n",n,m);

#endif

    if (m == 0) result = 1;

    else result = comb(n-1,m-1) * n / m;  

#ifdef DEBUG

    printf("***comb returns %d\n",result);

#endif

    return(result);

    }

LOCAL decomb(s)

register char *s;

{

    register int k,t,result;



#ifdef DEBUG

    printf("***decomb(%s)\n",s);

#endif

    result = 0;

    while (*s != '\0') {

	k = *s-'A';

	s++;

	result += comb(k,strlen(s)+1);

	}

#ifdef DEBUG

    printf("***decomb returns %d\n",result);

#endif

    return(result);

    }

LOCAL base10(n,b)

register char *n;

register int b;

{

    register int t,result;



#ifdef DEBUG

    printf("***base10(%s,%d) = ",n,b);

#endif

    result = 0;

    while (*n != '\0') {

	t = *n - 'A'; n++;

	result = (result * b) + t;

	}

#ifdef DEBUG

    printf("%d\n",result);

#endif

    return(result);

    }

LOCAL char *STRAIGHT_SEQ = "MLKJIHGFEDCBAM";

float pokev(h)

register char *h;

{

    char SUITS[6],temp[3];

#ifdef DEBUG

    char scratch[20];

#endif

    int rchar();

    float pr();

    register char v,w,*p;

    register int i;

    char *index(),*ispair(),*istrips(),*isfours(),*isflush();



#ifdef DEBUG

    display(h,scratch);

    printf("***In pokev(): h = %s\n",scratch);

#endif

    vals(h,VALS);

    qsort(VALS,strlen(VALS),sizeof(char),rchar);

    suits(h,SUITS);

    if (isstraight(VALS)) {

	if (isflush(SUITS) != NULL) return(pr(8,""));

	else return(pr(4,""));

	}

    if (isflush(SUITS) != NULL) return(pr(5,""));

    else if (ispair(VALS) == NULL) return(pr(0,""));

    else {

	p = isfours(VALS);

	if (p != NULL) {

	    temp[0] = v = *p; temp[1] = '\0';

	    for (i=0;i<4;i++) {

		p = index(VALS,v);

		strcpy(p,p+1);

		}

	    return(pr(7,temp));

	    }

	p = istrips(VALS);

	if (p != NULL) {

	    w = v = *p; temp[0] = w; temp[1] = '\0'; temp[2] = '\0';

	    for (i=0;i<3;i++) {

		p = index(VALS,v);

		strcpy(p,p+1);

		}

	    p = ispair(VALS);

	    if (p == NULL) return(pr(3,temp));

	    else {

		temp[1] = v = *p;

		for (i=0;i<2;i++) {

		    p = index(VALS,v);

		    strcpy(p,p+1);

		    }

		return(pr(6,temp));

		}

	    

	    }

	else {

	    p = ispair(VALS);

	    temp[1] = temp[2] = '\0';

	    if (p != NULL) {

		temp[0] = w = *p;

		for (i=0;i<2;i++) {

		    p = index(VALS,w);

		    strcpy(p,p+1);

		    }

		}

	    p = ispair(VALS);

	    if (p == NULL) return(pr(1,temp));

	    else {

		v = *p;

		for (i=0;i<2;i++) {

		    p = index(VALS,v);

		    strcpy(p,p+1);

		    }

		temp[1] = v;

		return(pr(2,temp));

		}

	    }

	}

    }

LOCAL rchar(a,b)

register char *a,*b;

{

    return(*b-*a);

    }

LOCAL isstraight(str)

register char *str;

{

    char *index(),temp[8];

    register char *p1,*p2;



    for (p1 = str;p1 != '\0'; p1++) {

	p2 = index(STRAIGHT_SEQ,*p1);

	if (p2 != NULL) break;

	}

    if (p2 != NULL && strncmp(p2,p1,strlen(p1)) == 0) return(TRUE);

    strcpy(temp,str+1);

    p1 = temp+strlen(temp);

    *p1++ = *str;

    *p1 = '\0';

    for (p1 = temp;p1 != '\0'; p1++) {

	p2 = index(STRAIGHT_SEQ,*p1);

	if (p2 != NULL) break;

	}

    if (p2 != NULL && strncmp(p2,p1,strlen(p1)) == 0) return(TRUE);

    return(FALSE);

    }

LOCAL char *ispair(str)

register char *str;

{

    char *index();

    register char *p1,*p2;



    for (p1 = str; *p1 != '\0'; p1++) {

	p2 = index(p1+1,*p1);

	if (p2 != NULL) break;

	}

    return(p2);

    }

LOCAL char *istrips(str)

register char *str;

{

    char *ispair(),*index();

    register char *p1,*p2;



    for (p1 = str;*p1 != '\0'; p1++) {

	p2 = ispair(p1);

	if (p2 != NULL && ((p2 = index(p2+1,*p2)) != NULL)) break;

	}

    return(p2);

    }

LOCAL char *isfours(str)

register char *str;

{

    char *istrips(),*index();

    register char *p1,*p2;



    for (p1 = str;*p1 != '\0'; p1++) {

	p2 = istrips(p1);

	if (p2 != NULL && ((p2 = index(p2+1,*p2)) != NULL)) break;

	}

    return(p2);

    }

LOCAL char *isflush(str)

register char *str;

{

    char *isfours(),*index();

    register char *p1,*p2;



    for (p1 = str;*p1 != '\0'; p1++) {

	p2 = isfours(p1);

	if (p2 != NULL && ((p2 = index(p2+1,*p2)) != NULL)) break;

	}

    return(p2);

    }

                                                                                                         