/* cm_lib_i686_evcnt.h */
/* machine depending defines for evcnt device library */


#ifndef CM_LIB_I686_EVCNT_H_
#define CM_LIB_I686_EVCNT_H_ 

#ifdef LINUX
#include "../driver/linux/ix86/evcnt_ix86.h"
#endif
#ifdef SOLARIS
#include "../driver/solaris/ix86/evcnt_ix86.h"
#endif

/* general parameters */
#define CM_TYPE CM_T_I686	/* defined in cm_lib.h */
#define CM_VERSION 0		/* version of CPU monitor library */
#define CM_P_CNT_NUM EVCNT_CNUM	/* number of physical counters */
#define CM_EVENT_NUM 0x64	/* number of events */
#define CM_P_CNT_BITS 40 	/* physical counter bits */
#define CM_USER_MODE_F 3	/* special user mode measurement */

#define CM_NEED_SETCNTS0	/* need to use 0 to init with EV_SETCNTS */
/* #define CM_SETEV_RESET */	/* SET_EVENT resets the counters with 0 */

/* user mode parameters */
#define USER_RANGE 0x01	/* CPL1..CPL3 */
#define OS_RANGE 0x02	/* CPL0 */
/* #define ALL_RANGE (USER_RANGE | OS_RANGE) */


#define CM_GET_RANGE(mask) \
  ((mask & 0x02) ? USER_RANGE : 0) | \
  ((mask & 0x01) ? OS_RANGE : 0)


/* get counter, for which event is possible; return cnt, if all possible */
/*
 * On i686, 6 events are only countable by a single counter:
 *
 * event_pos event_num   event_name
 *    5       16 (0x10)  fp_ops_exe       : Counter 0 only
 *    9       20 (0x14)  cyc_div_busy     : Counter 0 only
 *   84      193 (0xC1)  float            : Counter 0 only
 *
 *    6       17 (0x11)  fp_assist        : Counter 1 only
 *    7       18 (0x12)  mul              : Counter 1 only
 *    8       19 (0x13)  div              : Counter 1 only
 *
 *   99        - -       cycles           : Counter 2 only
 */
/* get counter, for which event is possible; return cnt, if all possible */
#define CM_GET_CNT(event, cnt) \
  (((event == 5) || (event == 9) || (event == 84)) ? 0 : \
  ((event == 6) || (event == 7) || (event == 8)) ? 1 : (event == 99) ? 2 : \
  (cnt & 1))

/* get mode (counter group) the event belongs to; return 0, if no modes. */
#define CM_GET_MODE(event) 0


/* event texts, CM_EVENT_NUM different */
#define CM_EVENT_TXT \
    "", \
    "ld_blocks", "sb_drains", "data_misa", "seg_ld", \
    "fp_ops_exe", "fp_assist", "mul", "div", "cyc_div_busy", \
    "L2_ads", "L2_dbus_busy", "L2_dbus_busy_rd", \
    "sdcm", "L2_m_lines_inm", "L2_lines_out", "L2_m_lines_outm", \
    "sicm", "sicm_M", "sicm_E", "sicm_S", "sicm_I", \
    "L2_ld", "L2_ld_M", "L2_ld_E", "L2_ld_S", "L2_ld_I", \
    "L2_st", "L2_st_M", "L2_st_E", "L2_st_S", "L2_st_I", \
    "L2 rqsts", "L2 rqsts_M", "L2 rqsts_E", "L2 rqsts_S", "L2 rqsts_I", \
    "ldst", \
    "pdcm", "DCU_m_lines_in", "DCU_m_lines_out", \
    "DCU_miss_outst", \
    "bus_req_outst", "bus_BNR_drv", "bus_DRDY_clk", "bus_DRDY_clk_a", \
    "bus_lock_clk", "bus_lock_clk_a", \
    "bus_data_rcv", "bus_tr_brd", "bus_tr_brd_a", \
    "bus_tr_rfo", "bus_tr_rfo_a", "bus_tr_wb", "bus_tr_wb_a", \
    "bus_tr_ifetch", "bus_tr_ifetch_a", "bus_tr_inval", "bus_tr_inval_a", \
    "bus_tr_pwr", "bus_tr_pwr_a", "bus_tr_p", "bus_tr_p_a", \
    "bus_tr_io", "bus_tr_io_a", "bus_tr_def", "bus_tr_def_a", \
    "bus_tr_burst", "bus_tr_burst_a", "bus_tr_mem", "bus_tr_mem_a", \
    "bus_tr", "bus_tr_a", \
    "cpu_non_HLT", "bus_hit_drv", "bus_hitm_drv", \
    "bus_snoop_s", \
    "IFU_ifetch", "picm", \
    "cTLBmiss", "IFU_mem_s", "ILD_s", \
    "resource_s", \
    "inst_ret", "float", "uops_ret", \
    "br_inst_ret", "br_ret_misp", \
    "int_msk", "int_msk_pnd", "hw_int_rx", \
    "br_tkn_ret", "br_tkn_ret_misp", \
    "inst_deco", \
    "partial_rad_s", \
    "br_inst_deco", \
    "BTB_miss", \
    "br_bogus", \
    "barclears", \
    "cycles"  \


/* event descriptions */
#define CM_EVENT_DESCR \
    "", \
    "ld blocks (Store buffer blocks)", \
    "sb drains (Store buffer drain cycles)", \
    "misalign mem ref (Misaligned data memory references; approximation)", \
    "segment reg loads (Segment register loads)", \
    "fp comp ops exe (Computational floating-point operations executed)", \
    "fp assist (Floating-point exception cases handled by microcode)", \
    "mul (Multiplies; integer and FP)", \
    "div (Divides; integer and FP)", \
    "cycles div busy (Cycles divider is busy; integer and FP)", \
    "L2 ads (L2 address strobes)", \
    "L2 dbus busy (Cycles during which the L2 cache data bus was busy)", \
    "L2 dbus busy rd (Cycles during which the L2 cache data bus was busy with read)", \
    "secondary data cache misses (L2 lines in; lines allocated in the L2)", \
    "L2 m lines inm (Modified state lines allocated in the L2)", \
    "L2 lines out (Lines removed from the L2)", \
    "L2 m lines outm (Modified state lines removed from the L2)", \
    "secondary instruction cache miss (L2 ifetch; L2 Instruction fetches)", \
    "sicm M (L2 ifetch M; L2 Instruction fetches; modified)", \
    "sicm E (L2 ifetch E; L2 Instruction fetches; exclusive)", \
    "sicm S (L2 ifetch S; L2 Instruction fetches; shared)", \
    "sicm I (L2 ifetch I; L2 Instruction fetches; invalid)", \
    "L2 load (L2 data loads)", \
    "L2 load M (L2 data loads; modified)", \
    "L2 load E (L2 data loads; exclusive)", \
    "L2 load S (L2 data loads; shared)", \
    "L2 load I (L2 data loads; invalid)", \
    "L2 store (L2 data stores)", \
    "L2 store M (L2 data stores; modified)", \
    "L2 store E (L2 data stores; exclusive)", \
    "L2 store S (L2 data stores; shared)", \
    "L2 store I (L2 data stores; invalid)", \
    "L2 rqsts (L2 requests)", \
    "L2 rqsts M (L2 requests; modified)", \
    "L2 rqsts E (L2 requests; exclusive)", \
    "L2 rqsts S (L2 requests; shared)", \
    "L2 rqsts I (L2 requests; invalid)", \
    "load store (data memory references; all loads from/stores to any memory)", \
    "primary data cache misses (DCU lines in; Lines allocated in the DCU)", \
    "DCU m lines in (Modified state lines allocated in the DCU)", \
    "DCU m lines out (Modified state lines evicted from the DCU)", \
    "DCU miss outstanding (Cycles while a DCU miss is outstanding; weighted)", \
    "bus req outstandig (Bus requests outstanding)", \
    "bus BNR drv (Bus clock cycles processor is driving BNR pin)", \
    "bus DRDY clocks (Clocks during which DRDY is asserted)", \
    "bus DRDY clocks any (Clocks during which DRDY is asserted; any agent)", \
    "bus lock clocks (Clocks during which LOCK is asserted)", \
    "bus lock clocks any (Clocks during which LOCK is asserted; any agent)", \
    "bus data rcv (Bus clock cycles processor is receiving data)", \
    "bus trans brd (Bus burst read transactions)", \
    "bus trans brd any (Bus burst read transactions; any agent)", \
    "bus trans rfo (Completed bus read for ownership transactions)", \
    "bus trans rfo any (Completed bus read for ownership transactions; any agent)", \
    "bus trans wb (Completed bus write back transactions)", \
    "bus trans wb any (Completed bus write back transactions; any agent)", \
    "bus trans ifetch (Completed bus instruction fetch transactions)", \
    "bus trans ifetch any (Completed bus instruction fetch transactions; any agent)", \
    "bus trans inval (Completed bus invalidate transactions)", \
    "bus trans inval any (Completed bus invalidate transactions; any agent)", \
    "bus trans pwr (Completed bus partial write transactions)", \
    "bus trans pwr any (Completed bus partial write transactions; any agent)", \
    "bus trans p (Completed bus partial transactions)", \
    "bus trans p any (Completed bus partial transactions; any agent)", \
    "bus trans io (Completed bus I/O transactions)", \
    "bus trans io any (Completed bus I/O transactions; any agent)", \
    "bus trans def (Completed bus deferred transactions)", \
    "bus trans def any (Completed bus deferred transactions; any agent)", \
    "bus trans burst (Completed bus burst transactions)", \
    "bus trans burst any (Completed bus burst transactions; any agent)", \
    "bus trans mem (Completed bus memory transactions)", \
    "bus trans mem any (Completed bus memory transactions; any agent)", \
    "bus trans (All completed bus transactions)", \
    "bus trans any (All completed bus transactions; any agent)", \
    "cpu clk unhalted (Cycles the processor is not halted)", \
    "bus hit drv (Bus clock cycles processor is driving HIT pin)", \
    "bus hitm drv (Bus clock cycles processor is driving HITM pin)", \
    "bus snoop stall (Bus clock cycles bus is snoop stalled)", \
    "IFU ifetch (Instruction fetches; 1 for each cacheable line)", \
    "primary instruction cache miss (IFU Instruction fetch misses)", \
    "cTLBmiss (Code (Instruction) TLB miss)", \
    "IFU mem stall (Cycles instruction fetch is stalled)", \
    "ILD stall (Cycles that the instruction length decoder is stalled)", \
    "resource stalls (Resource related stalls; register renaming,...)", \
    "inst retired (Instructions retired)", \
    "flops (Computational floating-point operations retired)", \
    "uops retired (Micro-ops retired)", \
    "br inst retired (Branch instructions retired)", \
    "br miss pred retired (Branch mispredictions that get retired)", \
    "int masked (Processor cycles interrupts are masked)", \
    "int masked pend (Processor cycles interrupts are pending and disabled)", \
    "hw int rx (Hardware interrupts received)", \
    "br taken retired (Taken branches retired)", \
    "br miss pred taken ret (Taken but mispredicted branches that get retired)", \
    "inst decoder (Instructions decoded)", \
    "partial rad stalls (Cycles or events for partial stalls)", \
    "br inst decoded (Branch instructions decoded)", \
    "BTB misses (Branches that the BTB did not predict)", \
    "br bogus (Branch predictions generated for non-branches)", \
    "barclears (Time BACLEAR is asserted; static branch prediction is made)", \
    "cycles" \


/* event registers/numbers, CM_EVENT_NUM different */
#define CM_EVENT_REG \
    0, \
    3, 4, 5, 6, \
    16, 17, 18, 19, 20, \
    33, 34, 35, 36, 37, 38, 39, \
    40 | 0x0f00, 40 | 0x0800, 40 | 0x0400, 40 | 0x0200, 40 | 0x0100, \
    41 | 0x0f00, 41 | 0x0800, 41 | 0x0400, 41 | 0x0200, 41 | 0x0100, \
    42 | 0x0f00, 42 | 0x0800, 42 | 0x0400, 42 | 0x0200, 42 | 0x0100, \
    46 | 0x0f00, 46 | 0x0800, 46 | 0x0400, 46 | 0x0200, 46 | 0x0100, \
    67, \
    69, 70, 71, 72, \
    96, 97, 98, 98 | 0x2000, 99, 99 | 0x2000, 100, 101, 101 | 0x2000, \
    102, 102 | 0x2000, 103, 103 | 0x2000, 104, 104 | 0x2000, \
    105, 105 | 0x2000, 106, 106 | 0x2000, 107, 107 | 0x2000, \
    108, 108 | 0x2000, 109, 109 | 0x2000, 110, 110 | 0x2000, \
    111, 111 | 0x2000, 112, 112 | 0x2000, \
    121, 122, 123, \
    126, \
    128, 129, \
    133, 134, 135, \
    162, \
    192, 193, 194, \
    196, 197, \
    198, 199, 200, \
    201, 202, \
    208, \
    210, \
    224, \
    226, \
    228, \
    230, \
    0 \


/*
 * If CM_EVENT_REG is defined, event register mapping will be created as
 * cm_event_reg in cm_lib.c
 */


#define CM_I686_TYPE_TICKS 1

/* Convert sample (event numbers) to coded mode value for the device driver */
/* In: ev0 = event number 0, ev1 = event number 1, range_flg = ALL_RANGE,... */
/* Out: ev0 = mode value 0, ev1 = mode value 1 */
#define CM_SAMPLE2MODE \
  ev0 = cm_event_reg[ev0] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16; \
  ev1 = cm_event_reg[ev1] | ((CM_I686_TYPE_TICKS << 2) | range_flg) << 16;


#endif /* CM_LIB_I686_EVCNT_H_ */
/* end */
