//: K_MATRIX.H -- simplified matrix class for kohonen's algorithm
//. 31.12.1994
//

#ifndef K_MATRIX_H_
#define K_MATRIX_H_



#define VAL_INLINE

//typedef double scalar;	// could also be int or float
typedef double scalar;	// could also be int (but not for LU!) or float


class matrix {
  struct matrep {
    scalar **m;		// pointer to the matrix
    int r, c;		// number of rows, columns
    int n;		// reference count
  } *p;
  void error(char *msg1, char *msg2 = "");
  void *create(int mrows, int columns);	// create the matrix
  void dispose(void);	// dispose the matrix, if no references

public:
  matrix(int mrows = 1, int columns = 1, scalar initval = 0);
  matrix(char *flag, int mrows, int columns, scalar *initvalue);
  matrix(char *flag, int dimension);	// create an ident matrix
  matrix(matrix& x);	// copy-constructor
  ~matrix();
  int rows() const { return p->r; }
  int cols() const { return p->c; }
#ifdef VAL_INLINE
  inline scalar& val(int row, int col) { return(mval(row, col)); }
#else
  inline scalar& val(int row, int col);	// element selection (r/w)
#endif
  void resize_matrix(int mrows, int mcols, scalar initval);
   // dispose the old and create a new matrix
  void print(char *msg = "");		// print matrix with a message

  private:
  scalar& mval(int row, int col) { 	// without checking boundaries
    return p->m[row][col];
    //return val(row, col);    //p->m[row][col];
  }
};

#endif // K_MATRIX_H_
