//
// Situations 1
// based on situ1.c (MV, 1995)
// (c) Marco Vieth, 2003
// http://www.benchmarko.de/
//
// 0.01  09.12.2000  first tests
//       04.06.2001  inserted some comments, interval delay changed to seconds
// 0.02  23.09.2001  all global variables start with this.situ_*, functions with situ_*;
// 0.03  19.01.2002  new object-oriented design
//       20.01.2002  do not use unnamed functions, prototypes -> useful for old browsers with Javascript 1.1
// 0.04  18.06.2003  use class Timer for timer handling
// 0.05  23.06.2003  StarOffice 5.2 can only initialize up to 128 elements in an Array, so split adjectives...
// 0.06  23.11.2003  data put into separate file situ_data1.js
// 0.061 30.11.2003  avoid switch() because it is JS 1.2...
// 0.062 08.12.2003  avoid substr() because it is not supported by Netscape 2 and 3, Explorer 3, Hotjava 3, Opera 3 and WebTV
//

// Minimum requirement: JS 1.1 (Netscape 3.0, IE 4.0) (something missing?)
// - Needed for Situ_auto_change_text: timer1.js
// - Needed for debugging: debug1.js

var g_debug = null; // maybe changed later...

var myint = Math.floor; // cast to integer for NGS, floor for others


// Constructor for class Situ
function Situ(surroundings, events, meetings, adjectives, separator) {
  // attributes
  this.situ_txtval = 0; // ??
  this.situ_itimer = 0; // interval timer
  this.separator = (separator) ? separator : "\n\n";

  if (surroundings) {
    this.situ_surroundings = surroundings;
  }

  if (events) {
    this.situ_events = events;
  }

  if (meetings) {
    this.situ_meetings = meetings;
  }

  if (adjectives) {
    this.situ_adjectives = adjectives;
  }

  // methods
  if (!Situ.prototype) { // old browsers get the methods directly into the object...
    this.get_rnd_index1 = Situ_get_rnd_index1;
    this.select_rnd_adjnoun = Situ_select_rnd_adjnoun;
    this.change_text = Situ_change_text;
    this.auto_change_text = Situ_auto_change_text;
    // simulate class attributes
  }
}


//
// normally we would create unnamed functions here but for old browsers...
// Situ.prototype.get_rnd_index1 = function(list) { ... }
//

// For new browsers (JS 1.2) set the prototypes...
new Situ(); // force old browsers to create prototype
if (Situ.prototype) {
  Situ.prototype.get_rnd_index1 = Situ_get_rnd_index1;
  Situ.prototype.select_rnd_adjnoun = Situ_select_rnd_adjnoun;
  Situ.prototype.change_text = Situ_change_text;
  Situ.prototype.auto_change_text = Situ_auto_change_text;
  // class attributes
}



//
// situ_get_rnd_index1 - get random index
// IN:  <list>
// OUT: random index to a list element
//
function Situ_get_rnd_index1(list) {
  return myint(Math.random() * list.length); // for NVG we neec integer index!
}

//
// situ_select_rnd_adjnoun - select random adjective, noun
// IN:  <list of adjectives>, <list of nouns>
// OUT: random adjective+noun, with proper declension
//
function Situ_select_rnd_adjnoun(adj_l, noun_l) {
  if (g_debug) { g_debug.writeln("Situ_select_rnd_adjnoun: adj_l="+ adj_l.length +", noun_l="+ noun_l.length); }
  var a0 = this.get_rnd_index1(adj_l);
  var a = this.get_rnd_index1(adj_l[a0]);
  var n = this.get_rnd_index1(noun_l);
  var parts = noun_l[n].split("."); // split into noun "sex" and noun
  var adj = adj_l[a0][a];
  var ending = (adj.substring(adj.length - 1, adj.length) == "e") ? "" : "e";
    // append "e" if adj not ending with it
    // (IE does not know -1=last character, old browsers do not know substr, so use substring)
  // Normally we would use a switch() here, but this is JS 1.2...
  // (for 'f'='feminine noun' and 'p'='plural' we don't need another ending)
  if (parts[0] == "m") { // masculine noun
    ending += "r";
  } else if (parts[0] == "s") {
    ending += "s";
  } else if ((parts[0] != "f") && (parts[0] != "p")) {
    alert("Error: Unknown noun code: "+ parts[0]);
  }

  //alert(parts[0] +": "+ adj_l[a0][a] + ending +" "+ parts[1]);
  return(adj_l[a0][a] + ending +" "+ parts[1]);
}


//
// situ_change_text - change text (of e.g. input field)
// IN:  [<txtval> = text field]
// OUT: txt = new random situation, also set as txtval.value, if specified (before)
//
function Situ_change_text(txtval) {
  if (g_debug) { g_debug.writeln("Situ_change_text: txtval="+ txtval); }
  if (txtval) { // if text value specified, save it
    this.situ_txtval = txtval;
  }
  var txt = this.select_rnd_adjnoun(this.situ_adjectives, this.situ_surroundings) + this.separator +
            this.select_rnd_adjnoun(this.situ_adjectives, this.situ_events) + this.separator +
            this.select_rnd_adjnoun(this.situ_adjectives, this.situ_meetings);

  if (this.situ_txtval) {
    this.situ_txtval.value = txt;
    //e.g. document.Situation.description.value = txt;
  }
  return txt;
}


//
// situ_auto_change_text - automatically change text
// IN:  <delay>
// OUT: -
// Stop a running interval timer and restart it with <delay> seconds to change text automatically.
// Use delay=0 to switch the timer off.
// Note: Before using this function call change_text() with a parameter.
//
function Situ_auto_change_text(delay_sec) {
  if (g_debug) { g_debug.writeln("Situ_auto_change_text: delay_sec="+ delay_sec); }
  if (this.situ_itimer) { // timer active?
    this.situ_itimer.clearInterval(); // stop
  } else if (typeof Timer != "undefined") {
    this.situ_itimer = new Timer(this, 'change_text');
  }

  if ((this.situ_itimer) && (delay_sec > 0)) {
    this.situ_itimer.setInterval(delay_sec * 1000);
  }
}

// end
