// printer.h
// Revision 20-mar-2004

#include <string>

class Printer {
public:
	virtual ~Printer () { }
	virtual void put (char c)= 0;
	virtual void flush () { }
};

class SpoolPrinter : public Printer {
public:
	SpoolPrinter ();
	~SpoolPrinter ();
	void put (char c);
	void flush ();
private:
	class Internal;
	Internal * pin;
};

class FilePrinter : public Printer {
public:
	FilePrinter (const std::string & filename);
	~FilePrinter ();
	void put (char c);
	void flush ();
private:
	class Internal;
	Internal * pin;
};

// End of printer.h
