// cpm.h
// Revision 16-may-2005

#include "console.h"
#include "printer.h"

#include <string>


class CpmOptions;


class CPM {
public:
	CPM (Console & console_n, Printer & printer_n,
		const CpmOptions & options);
	~CPM ();

	void setdisk (char disk, const std::string & path);
	char newdisk (const std::string & path);

	void interactive ();
	void runprogram
		(const std::string & filename, const std::string & args);
	void runcommandline (const std::string & commandline);

	class Internal; // Public because other implementation class uses it.
private:
	Internal * p;
};


class CpmOptions {
public:
	CpmOptions ();
	void setdebugz80 (bool deb);
	void setdebugsystem (bool deb);
	void setprefix (char newprefix);
	void settpaend (unsigned short newtpaend);
	void setdefaultdisk (char diskletter);
private:
	friend class CPM::Internal;

	bool debugz80;
	bool debugsystem;
	char prefix;
	unsigned short tpaend;
	char default_disk;
};


// End of cpm.h
