// aliados.cpp
// Revision 13-mar-2004

#include "cpm.h"

#include "realconsole.h"

#include <iostream>
#include <fstream>
using std::cin;
using std::cout;
using std::cerr;
using std::endl;
using std::flush;
#include <stdexcept>
#include <memory>

namespace {

int doit (int argc, char * * argv)
{
	bool debugsystem= false;
	bool debugz80= false;
	bool rawin= false;
	bool rawout= false;
	bool wskeys= false;
	unsigned short tpaend= 0;
	std::string printerfile;
	int argpos;
	for (argpos= 1; argpos < argc; ++argpos)
	{
		std::string arg (argv [argpos] );
		if (arg == "-d") // Debug all.
		{
			debugsystem= true;
			debugz80= true;
		}
		else if (arg == "-s") // Debug operating system.
		{
			debugsystem= true;
		}
		else if (arg == "-z") // Debug z80 code.
		{
			debugz80= true;
		}
		else if (arg == "--raw") // Console in raw mode.
		{
			rawin= true;
			rawout= true;
		}
		else if (arg == "--rawin") // Console in raw mode.
		{
			rawin= true;
		}
		else if (arg == "--rawout") // Console out raw mode.
		{
			rawout= true;
		}
		else if (arg == "--ws") // WordStar keys.
		{
			wskeys= true;
		}
		else if (arg == "--tpaend") // Set TPA end.
		{
			++argpos;
			if (argpos >= argc)
				throw std::runtime_error
					("--tpaend needs a parameter");
			char * aux;
			unsigned long ultpaend=
				strtoul (argv [argpos], & aux, 0);
			if (* aux != '\0')
				throw std::runtime_error
					("Inavlid parameter in --tpaend");
			tpaend= static_cast <unsigned short> (ultpaend);
		}
		else if (arg == "--printer") // Set printer to file
		{
			++argpos;
			if (argpos >= argc)
				throw std::runtime_error
					("--print needs a parameter");
			printerfile= argv [argpos];
		}
		else
			break;
	}

	RealConsole console;
	std::auto_ptr <Printer> pprinter;
	if (printerfile.empty () )
		pprinter.reset (new SpoolPrinter);
	else
		pprinter.reset (new FilePrinter (printerfile) );
	CPM cpm (console, * pprinter);

	if (tpaend != 0)
		cpm.settpaend (tpaend);

	if (rawin)
		console.rawin ();
	if (rawout)
		console.rawout ();

	if (wskeys)
		console.wskeys ();

	if (argpos >= argc)
	{
		cpm.interactive (debugsystem, debugz80);
	}
	else
	{
		// Load program file.

		if (! cpm.loadcommand (argv [argpos] ) )
		{
			cerr << "Error loading command" << endl;
			return 1;
		}

		// Build arguments.

		std::string args;
		++argpos;
		for ( ; argpos < argc; ++argpos)
		{
			std::string aux= argv [argpos];
			if (! aux.empty () )
			{
				args+= ' ';
				args+= aux;
			}
		}
		cerr << "Arguments: " << args << endl;
		cpm.setarguments (args);

		cpm.tpastart (debugsystem, debugz80);
	}
	return 0;
}

} // namespace

int main (int argc, char * * argv)
{
	try
	{
		return doit (argc, argv);
	}
	catch (std::exception & e)
	{
		cerr << "ERROR: " << e.what () << endl;
	}
	catch (const std::string & str)
	{
		cerr << "ERROR: " << str << endl;
	}
	catch (const char * str)
	{
		cerr << "ERROR: " << str << endl;
	}
	return 1;
}

// End of aliados.cpp
