/* xc
% cc -i -O restor.c -o restor
% ls -lx restor /sys/bin/restor
% size restor /sys/bin/restor
%c cc -i -O restor.c -o restor
%c cp restor /sys/bin/restor
%c rm restor
*/

/* Heavy-duty commenting done.  This code was unbearable to read through
 * the first time.  Also, removed some unused variables and constants
 * and moved some ridiculously small functions to be inline
 * (like checkvol());  I also felt these changes made the code
 * more readable.  Changed usage: to be a function, usage().
 * I think that is about it.
 *					awe 8/3/86
 */

/* for big file systems move the inode table array to a temp file */
#define	BIGFS

#define	MAXINO	3500	/* 3725 too big
			 * with BIGFS defined, if the number of inodes is
			 * bigger than this it tells you to run restor -b
			 * N.B. MAXINO needed whether or not BIGFS is defined
			 */
#define NCACHE	3	/* size of the disk cache (# blocks of size BSIZE) */

#define	TRUE	1
#define FALSE	0

#include <stdio.h>
#include <signal.h>
#include <sys/sto.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/inode.h>
#include <sys/ino.h>
#include <sys/fblk.h>
#include <sys/filsys.h>
#include <sys/dir.h>
#include <dumprestor.h>		/* struct spcl defined here as */
				/* struct spcl	spcl; */

/* Bitmap manipulation macros */
	/* MLEN is the number of bits in a word in the bitmap */
	/* (MLEN=16 defined in <dumprestor.h>) */

/* finds the word in which the bit corresponding to i in bitmap m is found */

#define	MWORD(m,i) (m[(unsigned)(i-1) / MLEN])

/* mask to get you the bit within the word in the bitmap w for i */

#define	MBIT(i)	(1 << ((unsigned)(i-1)%MLEN))

/* these are unused, but may be useful sometime */
/* #define BIS(i,w) (MWORD(w,i) |=  MBIT(i))	/* set bit / */
/* #define BIC(i,w) (MWORD(w,i) &= ~MBIT(i))	/* clear bit corresponding to */
						/* number w in bitmap i */

#define	BIT(i,w)	(MWORD(w,i) & MBIT(i))	/* test bit corresponding to */
						/* number w in bitmap i */

struct	filsys	sblock;		/* superblock for filestem -- first read
				 * off of disk file system, then modified
				 * by restor according to files extracted,
				 * then updated at end of restor
				 * used for 'restor -r' and '-R' only
				 */

int	fi;	/* used to hold file descriptor for opened disk device
		 * used for 'restor -r' and '-R' only
		 */
ino_t	ino;
ino_t	maxi;	/* maximum number of inodes for a file system (read from
		 * superblock on disk)
		 * used for 'restor -r' and '-R' only
		 */

ino_t	curino; /* current inode */

int	mt;	/* file descriptor for opened magtape device */

char	tapename[] = "/dev/rmt0";	/* default name for tape device */

char	*magtape = tapename;

int	ofile;
char	dirfile[] = "rstXXXXXX";	/* holds directory entries */
FILE	*dfp;				/* file pointer to opened dirfile */

char 	tmpfile[] = "tmpXXXXXX";	/* holds list of found file names to
					 * be restored.  per line format is:
					 * inode# path type
					 * type is either 'f' or 'd' for
					 * regular file or directory, resp.
					 */
FILE	*tfp;				/* file pointer to opened tmpfile */

int 	flg;

#ifdef	BIGFS
int bflag = 0;
char	inofile[] = "inoXXXXXX";	/* holds inode table with -b */
FILE	*ifp;				/* file pointer for opened inofile */
struct bob {				/* format of entries in inofile */
	ino_t	ft_ino;
	daddr_t	ft_seekpt;
} dirptr;
#endif	BIGFS

struct {				/* Directory inodes */
	ino_t	t_ino;			/* inode number */
	daddr_t	t_seekpt;		/* position of actual directory */
					/* in dirfile */
} inotab[MAXINO];
int	ipos;

char	name[BSIZE];

char	dirbuf[BSIZE];				/* dirfile buffer */
int	drpt;

int	eflag;


struct dinode tino;		/* tape inode info */
struct dinode dino;		/* disk inode info */
daddr_t	taddr[NADDR];

daddr_t	curbno;

short	dumpmap[MSIZ];				/* bit map of dumped inodes */
short	clrimap[MSIZ];				/* bit map of clear inodes  */
						/*  at dump time            */

int	volno = 1;		/* tape volume number */
int bct = NTREC+1;		/* tape block count, readtape() and flsht() */
				/* when above NTREC, readtape fills tapebuf */
char tapebuf[NTREC*BSIZE];	/* tape buffer */

int xnum = 0;			/* number of files to extract/extracted */
struct  extract {
	ino_t	x_ino;
	char	x_name[BSIZE];
	char	x_flag[2];
} ext;
int 	dflag = 0;		/* debug */
int	vflag = 0;		/* verbose */

struct	cache {
	daddr_t	c_bno;
	int	c_time;
	char	c_block[BSIZE];
} cache[NCACHE];		/* disk cache buffer */
int	curcache;		/* current position in the cache */

/*
 *
 */

main(argc, argv)
char *argv[];
{
	register char *cp;
	char command;
	int done();

	if (argc < 2)
		usage();
	argv++;
	argc -= 2;

	for (cp = *argv++; *cp; cp++) {
		switch (*cp) {
		case '-':
			break;
		case 'f':	/* alternate tape device follows */
			magtape = *argv++;
			argc--;
			break;
		case 'd':	/* debug */
			dflag++;
			break;
		case 'v':	/* verbose */
			vflag++;
			break;
		case 'r':	/* full file system, single volume */
		case 'R':	/* full file system, multiple volume */
		case 't':	/* times -- tell time of dump, previous dump */
		case 'x':	/* extract files */
			command = *cp;
			break;
#ifdef	BIGFS
		case 'b':	/* big -- used when > 2500 inodes on tape */
			bflag++;
			mktemp(inofile);
			break;
#endif
		default:
			printf("Bad key character %c\n", *cp);
			usage();
		}
	}
	mktemp(dirfile);
	if (command == 'x') {
		if (signal(SIGINT, done) == SIG_IGN)
			signal(SIGINT, SIG_IGN);
		if (signal(SIGTERM, done) == SIG_IGN)
			signal(SIGTERM, SIG_IGN);

		if ((dfp = fopen(dirfile, "w")) == NULL) {
			fprintf(stderr, "Can't open %s\n", dirfile);
			fprintf(stderr, "(directory temporary file)\n");
			exit(1);
		}
#ifdef	BIGFS
		if (bflag)
			if ((ifp = fopen(inofile, "w")) == NULL) {
				fprintf(stderr, "Can't open %s\n", inofile);
				fprintf(stderr, "(inode temporary file)\n");
				exit(1);
			}
#endif	BIGFS
		mktemp(tmpfile);

	}
	doit(command, argc, argv);
	if (command == 'x') {
		if (!dflag) {	/* keep these files around if debugging */
			unlink(dirfile);
			unlink(tmpfile);
#ifdef	BIGFS
			if (bflag)
				unlink(inofile);
#endif	BIGFS
		}
	}
	exit(0);
}


usage()
{
	printf("Usage: restor x file ..., restor r filesys, or restor t\n");
	exit(1);
}

/*
 *
 */
doit(command, argc, argv)
char	command;
int	argc;
char	*argv[];
{
	extern char *ctime();
	register i;
	int c, c1, ln;
	FILE *tmpdes;
	int status;
	char cmdlin[100];
	int count = 0;

	ino_t	d;
	int	xtrfile(), skip();
	int	rstrfile(), rstrskip();
	struct dinode *ip, *ip1;


	umask(0);

	if ((mt = open(magtape, 0)) < 0) {
		printf("%s: cannot open tape\n", magtape);
		exit(1);
	}
	switch(command) {
	case 't':
		if (readhdr(&spcl) == 0) {
			printf("Tape is not a dump tape\n");
			exit(1);
		}
		printf("Dump   date: %s", ctime(&spcl.c_date));
		printf("Dumped from: %s", ctime(&spcl.c_ddate));
		return;
	case 'x':
		if (readhdr(&spcl) == 0) {
			printf("Tape is not a dump tape\n");
			exit(1);
		}
		if (spcl.c_volume != 1) {
			printf("Tape is not volume 1 of the dump\n");
			exit(1);
		}
		pass1();  /* This sets the various maps on the way by */
		fclose(dfp);
#ifdef	BIGFS
		if (bflag)
			fclose(ifp);
#endif
		if ((tfp = fopen(tmpfile, "w")) == NULL) {
			fprintf("%s: cannot create temporary file\n", tmpfile);
			exit(1);
		}
		if ((dfp = fopen(dirfile, "r")) < 0) {
			fprintf(stderr, "%s: cannot open directory ", dirfile);
			fprintf(stderr, "temporary for reading\n");
			exit(1);
		}
#ifdef	BIGFS
		if (bflag)
			if ((ifp = fopen(inofile, "r")) < 0) {
				fprintf(stderr, "%s: cannot open ", inofile);
				fprintf(stderr, "inode temporary for reading\n");
				exit(1);
			}
#endif
		/*
		 * go down the arglist creating a directory hierarchy
		 * for each path on the command line
		 */
		while(argc--) {
			if ((d = psearch(*argv)) == 0 || BIT(d, dumpmap) == 0) {
				printf("%s: not on the tape\n", *argv++);
				continue;
			}
			count++;
			if (vflag) 
				printf("%s: extract file\n", *argv);
			argv++;
		}
		fclose(tfp);
		fclose(dfp);

		if (!count) { /* Nothing to do? Go home */
			printf("No files to restor, bye!\n");
			return;
		}
		/*
		 * sort the file
		 *
		 * the command says to sort using the second "word" in the
		 * input as the main sort key, followed by the first word
		 */
#ifndef	PATH
		sprintf(cmdlin, "/usr/bin/sort +2.0 -3.0 +0.0n -1.0 %s -o %s",
			tmpfile, tmpfile);
#else
		sprintf(cmdlin, "/bin/sort +2.0 -3.0 +0.0n -1.0 %s -o %s",
			tmpfile, tmpfile);
#endif
		/* this should be changed to fork()/exec()/wait() */
		status = system(cmdlin);
		if (status) {
			fprintf(stderr, "sort failed\n");
			exit(1);
		}
		if ((tmpdes = fopen(tmpfile, "r")) == NULL) {
			printf("%s: cannot open tmpfile\n", tmpfile);
			exit(1);
		}
		flg = TRUE;
newvol:
		flsht();	/* tell readtape() to read another tape block */
				/* next time it's called */
		close(mt);
getvol:
		printf("Mount desired tape volume: Specify volume #: ");
		if (gets(tapebuf) == NULL)
			return;
		volno = atoi(tapebuf);
		if (volno <= 0) {
			printf("Volume numbers are positive numerics\n");
			goto getvol;
		}
		mt = open(magtape, 0);
		if (readhdr(&spcl) == 0) {
			printf("tape is not dump tape\n");
			goto newvol;
		}
		if (spcl.c_volume != volno) {
			printf("Wrong volume (%d)\n", spcl.c_volume);
			goto newvol;
		}
rbits:
		while (gethead(&spcl) == 0)
			;
		if (spcl.c_type == TS_INODE) {
			printf("Can't find inode mask!\n");
			goto newvol;
		}
		if (spcl.c_type != TS_BITS)
			goto rbits;
		readbits(dumpmap);
		while(xnum) {

again:
			if (ishead(&spcl) == 0)
				while(gethead(&spcl) == 0)
					;
			if (spcl.c_type == TS_END) {
				printf("end of tape\n");
checkdone:
				if(xnum != 0)
					goto newvol;
				return;
			}
			if (spcl.c_type != TS_INODE) {
				gethead(&spcl);
				goto again;
			}
			d = spcl.c_inumber;
			if(flg) {
				fscanf(tmpdes, "%d%s%s", &ext.x_ino,
					ext.x_name, ext.x_flag);
			}
				if(d == ext.x_ino) {
					sprintf(name, "%s", ext.x_name);
					if(trunc(name)) {
						if(chkdir(name, &spcl) == 0)
							fprintf(stderr, "%s: cannot create directory\n", name);
						if(*ext.x_flag == 'd') {
							xnum--;
							flg = TRUE;
							gethead(&spcl);
							goto done;
						}
					}
					if ((ofile = creat(ext.x_name,
						spcl.c_dinode.di_mode)) < 0) {
						printf("%s: ", ext.x_name);
						printf("cannot create file\n");
						xnum--;
						flg = TRUE;
						gethead(&spcl);
						goto done;
					}
					if(vflag) 
						fprintf(stderr, "%s: extracted\n", ext.x_name);
					chown(ext.x_name, spcl.c_dinode.di_uid,
						spcl.c_dinode.di_gid);
					getfile(ino, xtrfile, skip,
						spcl.c_dinode.di_size);
					xnum--;
					flg = TRUE;
					close(ofile);
					goto done;
				}
				else
					flg = FALSE;
			gethead(&spcl);
done:
			;
		}
		goto checkdone;
	case 'r':
	case 'R':
		if ((fi = open(*argv, 2)) < 0) {
			printf("%s: cannot open\n", *argv);
			exit(1);
		}
		if (command == 'R') {
			printf("Enter starting volume number: ");
			if (gets(tapebuf) == EOF) {
				volno = 1;
				printf("\n");
			}
			else
				volno = atoi(tapebuf);
		}
		else
			volno = 1;
		printf("Last chance before scribbling on %s. ", *argv);
		while (getchar() != '\n');
		/* read existing superblock off of disk */
		dread((daddr_t)1, (char *)&sblock, sizeof(sblock));
		maxi = (sblock.s_isize-2)*INOPB;
		if (readhdr(&spcl) == 0) {
			printf("Missing volume record\n");
			exit(1);
		}
		if (spcl.c_volume != volno) {
			printf("Tape is not volume %d\n", volno);
			exit(1);
		}
		gethead(&spcl);
		for (;;) {
ragain:
			if (ishead(&spcl) == 0) {
				printf("Missing header block\n");
				while (gethead(&spcl) == 0)
					;
				eflag++;
			}
			if (spcl.c_type == TS_END) {
				printf("End of tape\n");
				close(mt);
				/* write out new superblock to file system */
				dwrite((daddr_t) 1, (char *) &sblock);
				return;
			}
			if (spcl.c_type == TS_CLRI) {
				readbits(clrimap);
				for (ino = 1; ino <= maxi; ino++)
					if (BIT(ino, clrimap) == 0) {
						getdino(ino, &tino);
						if (tino.di_mode == 0)
							continue;
						itrunc(&tino);
						clri(&tino);
						putdino(ino, &tino);
					}
				/* write out new superblock to file system */
				dwrite((daddr_t) 1, (char *) &sblock);
				goto ragain;
			}
			if (spcl.c_type == TS_BITS) {
				readbits(dumpmap);
				goto ragain;
			}
			if (spcl.c_type != TS_INODE) {
				printf("Unknown header type\n");
				eflag++;
				gethead(&spcl);
				goto ragain;
			}
			ino = spcl.c_inumber;
			if (eflag)
				printf("Resynced at inode %u\n", ino);
			eflag = 0;
			if (ino > maxi) {
				printf("%u: ilist too small\n", ino);
				gethead(&spcl);
				goto ragain;
			}
			dino = spcl.c_dinode;
			getdino(ino, &tino);
			curbno = 0;
			/* free all blocks associated w/this inode */
			itrunc(&tino);
			/* clear the inode */
			clri(&tino);
			for (i = 0; i < NADDR; i++)
				taddr[i] = 0;
			l3tol(taddr, dino.di_addr, 1);
			getfile(ino, rstrfile, rstrskip, dino.di_size);
			ip = &tino;
			ltol3(ip->di_addr, taddr, NADDR);
			ip1 = &dino;
			ip->di_mode = ip1->di_mode;
			ip->di_nlink = ip1->di_nlink;
			ip->di_uid = ip1->di_uid;
			ip->di_gid = ip1->di_gid;
			ip->di_size = ip1->di_size;
			ip->di_atime = ip1->di_atime;
			ip->di_mtime = ip1->di_mtime;
			ip->di_ctime = ip1->di_ctime;
			putdino(ino, &tino);
		}
	}
}

/*
 * Read the tape, building up a directory structure for extraction
 * by name
 * Creates the internal table of all directories and inodes
 * And the file with ALL files and inodes
 * And the bit maps for free blocks and used blocks
 * 
 * A dump tape contains:
 *	a header record
 *	a bitmap describing blocks used
 *	a bitmap describing free blocks at the time of the dump
 *	a group of records describing directories
 *	a group of records describing files
 *
 * The header record is of the form struct spcl, described in <dumprestor.h>
 * and consumes one BSIZE block of a tape block
 * The first record of each of the descriptions is also a header record
 * and also consumes one BSIZE block
 */
pass1()
{
	register i;
	struct dinode *ip;
	int	putdir(), null();

	/* get header record */
	while (gethead(&spcl) == 0) {
		printf("Can't find directory header!\n");
	}
	for (;;) {
		/* record is bit map of dumped inodes */
		if (spcl.c_type == TS_BITS) {
			readbits(dumpmap);
			continue;
		}
		/* record is bit map of clear inodes at dump time */
		if (spcl.c_type == TS_CLRI) {
			readbits(clrimap);
			continue;
		}
		/* record is not a file or directory */
		if (spcl.c_type != TS_INODE) {
			return;
		}
		/* make an entry for directories only */
		ip = &spcl.c_dinode;
		i = ip->di_mode & IFMT;
		if (i != IFDIR) { /* no more directory records */
			return;
		}
#ifdef	BIGFS
		if (bflag) {
			dirptr.ft_ino = spcl.c_inumber;
			dirptr.ft_seekpt = (daddr_t) ftell(dfp);
			fwrite(&dirptr, sizeof(dirptr), 1, ifp);
		} else {
			inotab[ipos].t_ino = spcl.c_inumber;
			inotab[ipos++].t_seekpt = (daddr_t) ftell(dfp);
			if (ipos >= MAXINO) {
				fprintf(stderr, "Too many inodes (%d).  ");
				fprintf(stderr, "Run 'restor b'\n");
				abort();
			}
		}	
#else	!BIGFS
		inotab[ipos].t_ino = spcl.c_inumber;
		inotab[ipos++].t_seekpt = (daddr_t) ftell(dfp);
#endif	!BIGFS
		/* write from tapebuf to dirfile */
		getfile(spcl.c_inumber, putdir, null, spcl.c_dinode.di_size);
		/* marks end of directory in dirfile: */
		putent("\000\000/", dfp);
	}
}

/*
 * Do the file extraction, calling the supplied functions
 * with the blocks
 */
getfile(n, f1, f2, size)
ino_t	n;		/* current inode number */
int	(*f2)();	/* what to do for an block address that exists */
int	(*f1)();	/* what to do for a NULL block address */
long	size;
{
	register i;
	struct spcl addrblock;
	char buf[BSIZE];

	addrblock = spcl;
	curino = n;
	goto start;
	for (;;) {
		if (gethead(&addrblock) == 0) {
			printf("Missing address (header) block\n");
			goto eloop;
		}
		if (addrblock.c_type != TS_ADDR) {
			spcl = addrblock;
			curino = 0;
			return;
		}
start:
		for (i = 0; i < addrblock.c_count; i++) {
			if (addrblock.c_addr[i]) {
				readtape(buf);
				(*f1)(buf, size > BSIZE ? (long) BSIZE : size);
			} else {
				clearbuf(buf);
				(*f2)(buf, size > BSIZE ? (long) BSIZE : size);
			}
			/* I don't get it.  If we have read more BSIZE blocks
			   than size, we loop, looking for a header block.
			   If the header block says that it is a
			   TS-type tape, we still loop

			   Answer (maybe).  If (size -= BSIZE) <- 0, we're
			   done with this file (period), and we now read the
			   tape until a non-TS_ADDR-type header block is seen
			   (exactly why, I'm not sure -- is dump likely to be
			   that dumb?).  Note the for (;;) loop above; this
			   is how groups of TS_ADDR-headed tape sections are
			   handled.
			*/

			if ((size -= BSIZE) <= 0) {
eloop:
				while (gethead(&spcl) == 0)
					;
				if (spcl.c_type == TS_ADDR)
					goto eloop;
				curino = 0;
				return;
			}
		}
	}
}

/*
 * Do the tape i/o, dealling with volume changes
 * 
 * (this works like a getc where each call results in getting
 *  one block of BSIZE from the tape into b. This function
 *  buffers reads by NTREC*BSIZE = one tape block)
 */
readtape(b)
char *b;
{
	register i;
	struct spcl tmpbuf;

	/* if bct > NTREC we have to read another tape block into tapebuf */
	if (bct >= NTREC) {
		/* clear out c_magic in each block of the tape buffer */
		for (i = 0; i < NTREC; i++)
			((struct spcl *)&tapebuf[i*BSIZE])->c_magic = 0;
		bct = 0;

		/* read one tape block */
		if ((i = read(mt, tapebuf, NTREC*BSIZE)) < 0) {
			printf("Tape read error: inode %u\n", curino);
			eflag++;
			for (i = 0; i < NTREC; i++)
				clearbuf(&tapebuf[i*BSIZE]);
		}
		if (i == 0) { /* end of tape */
			bct = NTREC + 1;
			volno++;
loop:
			flsht(); /* tell readtape() to get another tape */
				 /* block next time around */
			close(mt);
			printf("Mount volume %d\n", volno);
			while (getchar() != '\n')
				;
			if ((mt = open(magtape, 0)) == -1) {
				printf("Cannot open tape!\n");
				goto loop;
			}
			if (readhdr(&tmpbuf) == 0) {
				printf("Not a dump tape.  Try again\n");
				goto loop;
			}
			if (tmpbuf.c_volume != volno) {
				printf("Wrong volume (%d).", tmpbuf.c_volume);
				printf("  Try again.\n");
				goto loop;
			}
			readtape(b);
			return;
		}
	}
	/* copy one block to b, increment tape block count */
	copy(&tapebuf[(bct++*BSIZE)], b, BSIZE);
}

/*
 * Forces readtape to get another tape block on next call to readtape
 */
flsht()
{
	bct = NTREC+1;
}

/*
 * from f to t, do s 
 */
copy(f, t, s)
register char *f, *t;
{
	register i;

	i = s;
	do
		*t++ = *f++;
	while (--i);
}

/*
 * null out BSIZE chars starting at cp
 */
clearbuf(cp)
register char *cp;
{
	register i;

	i = BSIZE;
	do
		*cp++ = 0;
	while (--i);
}

/*
 * Dirfile format
 * inode-number file-name zero
 *
 * Put an entry into the dirfile
 */
putent(cp, dirfp)
char	*cp;
FILE *dirfp;
{
	register i;

	for (i = 0; i < sizeof(ino_t); i++)
		putc(*cp++, dirfp);
	for (i = 0; i < DIRSIZ; i++) {
		putc(*cp, dirfp);
		if (*cp++ == 0)
			return;
	}
	return;
}

/*
 * Get an entry from the dirfile
 */
getent(bf, dirfp)
register char *bf;
FILE *dirfp;
{
	register i;

	for (i = 0; i < sizeof(ino_t); i++)
		*bf++ = getc(dirfp);
	for (i = 0; i < DIRSIZ; i++)
		if ((*bf++ = getc(dirfp)) == 0)
			return;
	return;
}


/*
 * search for file cp in the directory whose
 * inode number is inum
 */
ino_t
search(inum, cp)
ino_t	inum;
char	*cp;
{
	register i;
	struct direct dir;

	/* rip through looking for inum */
#ifdef	BIGFS
	if (bflag) {
		fseek(ifp, 0, 0);
		while (fread(&dirptr, sizeof(dirptr), 1, ifp))
			if (dirptr.ft_ino == inum)
				goto found;
	} else {
		for (i = 0; i < MAXINO; i++)
			if (inotab[i].t_ino == inum) {
				goto found;
			}
	}
#else	!BIGFS
	for (i = 0; i < MAXINO; i++)
		if (inotab[i].t_ino == inum) {
			goto found;
		}
#endif	!BIGFS
	return(0); /* not a directory */
found:
	/* seek into the dirfile and look for the entry */
#ifdef	BIGFS
	if (bflag)
		fseek(dfp, (long) dirptr.ft_seekpt, 0);
	else
		fseek (dfp, (long) inotab[i].t_seekpt, 0);
#else	!BIGFS
	fseek(dfp, (long) inotab[i].t_seekpt, 0);
#endif	!BIGFS
	do {
		getent((char *)&dir, dfp);
		if (direq(dir.d_name, "/"))
			return(0); /* not in directory */
	} while (direq(dir.d_name, cp) == 0);
	return(dir.d_ino);
}

/*
 * Search the directory tree rooted at inode 2 for the path pointed at by n
 * The idea is to find the inode of the file the path specifies.
 * returns the inode number if file is found, 0 if not
 */
psearch(n)
char	*n;
{
	register char *cp, *cp1;
	char c;

	ino = 2;
	if (*(cp = n) == '/')
		cp++;
next:
	cp1 = cp + 1;	/* cp1 will point to the character following the */
			/* current element of the path (eg in /user/stu/... */
			/* cp will point to the u in user, cp1 will point */
			/* to the / between user and stu)  cp1 may point to */
			/* NULL if it is the last component of the path */
	while (*cp1 != '/' && *cp1)
		cp1++;
	c = *cp1;	/* save the char for later */
	*cp1 = 0; /* NULL terminate for the benefit of search() */
	ino = search(ino, cp);	/* search for this path element */
	if (ino == 0) {
		*cp1 = c;
		return(0); /* file not on tape */
	}
	*cp1 = c;	/* replace the NULL with what it was before */
	if (c == '/') {
		cp = cp1+1;	/* do it again for the next path element */
		goto next;
	}
	/* at this point, have found all elements of the path -- file is */
	/* on the tape. cp1 points to the NULL at the end of the name */
	cp = n; /* point to the entire path */
	if (*cp == '/')
		cp++;
	sprintf(name, "%s", cp);
	collect(name, ino, dfp);	/* write info about files into tmp* */
	return(ino);
}

/*
 *	Write inode-numbers file-names and 'f' or 'd' to tmp*
 *	path   - path name of file
 *	inum   - inode number of this file
 *	dirfp  - open a new one for each recursion
 *	Calls itself recursively and returns when it hits the
 *	end of the directory in dirfile or after writing out
 * 	an entry to the tmp* file.
 */
collect(path, inum, dirfp)
char *path;
ino_t inum;
FILE *dirfp;
{
	register int i;
	daddr_t sk;
	struct direct dir;

#ifdef	BIGFS
	if (bflag) {
		fseek(ifp, (long)0, 0);
		while (fread(&dirptr, sizeof(dirptr), 1, ifp))
			if (dirptr.ft_ino == inum) {
				sk = dirptr.ft_seekpt;
				goto offramp;
			}
		goto notdirect;	/* not a directory */
	} else {
		for(i=0; i< MAXINO; i++)
			if (inotab[i].t_ino == inum) {
				sk = inotab[i].ft_seekpt;
				goto offramp;
			}
		goto notdirect;	/* not a directory */
	}
#else	!BIGFS
	for(i=0; i< MAXINO; i++)
		if (inotab[i].t_ino == inum) {
			sk = inotab[i].ft_seekpt;
			goto offramp;
		}
	goto notdirect;	/* not a directory */
#endif	!BIGFS
offramp:
	/* seek to the compressed directory */
	if (fseek(dirfp, sk, 0) == -1)
		/* This should error out and exit I think */
		printf("seek error\n");

	/* while not at end-of-directory marker */
	/* actually, while the directory name gotten with getent does */
	/* not have the name "/" */
	while((getent((char *)&dir, dirfp), direq(dir.d_name, "/")) == 0) {
		/* if a directory but not "." or ".." */
		if (direq(dir.d_name, ".") == 0 &&	/* not . */
		    direq(dir.d_name, "..") == 0 &&	/* not .. */
		    bsearch(dir.d_ino) != 0) {		/* and found */
			int len;
			FILE *tdfp;

			len = strlen(path);
			strcat(path, "/");
			strncat(path, dir.d_name, sizeof(dir.d_name));
			tdfp = fopen(dirfile, "r");
			collect(path, dir.d_ino, tdfp);
			fclose(tdfp);
			path[len]='\0';
		} else
		/* if a directory on tape and not ".." */
		if (BIT(dir.d_ino, dumpmap)&&(direq(dir.d_name, "..") == 0)) {
			if (direq(dir.d_name, "."))
				/* path/. */
				fprintf(tfp, "%d %s/. d\n", dir.d_ino, path);
			else
				/* path/dirname */
				fprintf(tfp, "%d %s/%-.14s f\n",
				   dir.d_ino, path, dir.d_name);
			xnum++;
			if (dflag)
				fprintf(stderr, "%s/%-.14s: restor directory\n",
				   path, dir.d_name);
		}
	}
	return;
notdirect:
	/* not a directory */
	fprintf(tfp, "%d %s f\n", inum, path);
	if (dflag)
		fprintf(stderr, "%s: restore file\n", path);
	xnum++;
	return;
}

/*
 * returns
 *  1	identical to 14 or less
 *  0	not identical
 */

direq(s1, s2)
register char *s1, *s2;
{
	register i;

	for (i = 0; i < DIRSIZ; i++)
		if (*s1++ == *s2) {
			if (*s2++ == 0)
				return(1);
		} else
			return(0);
	return(1);
}

/*
 * read/write a disk block, be sure to update the buffer
 * cache if needed.
 */
dwrite(bno, b)
daddr_t	bno;
char	*b;
{
	register i;

	for (i = 0; i < NCACHE; i++) {
		if (cache[i].c_bno == bno) {
			copy(b, cache[i].c_block, BSIZE);
			cache[i].c_time = 0;
			break;
		}
		else
			cache[i].c_time++;
	}
	lseek(fi, bno*BSIZE, 0);
	if (write(fi, b, BSIZE) != BSIZE) {
		fprintf(stderr, "disk write error %ld\n", bno);
		exit(1);
	}
}

/* read cnt bytes from the disk (or the cache).  The disk is called 'fi' */
/* and is assumed to already be opened for reading */

dread(bno, buf, cnt)
daddr_t bno;
char *buf;
{
	register i, j;

	j = 0;
	for (i = 0; i < NCACHE; i++) {
		if (++curcache >= NCACHE)
			curcache = 0;
		if (cache[curcache].c_bno == bno) {
			copy(cache[curcache].c_block, buf, cnt);
			cache[curcache].c_time = 0;
			return;
		}
		else {
			cache[curcache].c_time++;
			if (cache[j].c_time < cache[curcache].c_time)
				j = curcache;
		}
	}

	lseek(fi, bno*BSIZE, 0);
	if (read(fi, cache[j].c_block, BSIZE) != BSIZE) {
		printf("read error %ld\n", bno);
		exit(1);
	}
	copy(cache[j].c_block, buf, cnt);
	cache[j].c_time = 0;
	cache[j].c_bno = bno;
}

/*
 * the inode manpulation routines. Like the system.
 *
 * clri zeros the inode
 */
clri(ip)
struct dinode *ip;
{
	int i, *p;
	i = sizeof(struct dinode)/sizeof(int);
	p = (int *)ip;
	do
		*p++ = 0;
	while(--i);
}

/*
 * itrunc/tloop/bfree free all of the blocks pointed at by the inode
 */
itrunc(ip)
register struct dinode *ip;
{
	register i;
	daddr_t bn, iaddr[NADDR];

	if (ip->di_mode == 0)
		return;
	i = ip->di_mode & IFMT;
	if (i != IFDIR && i != IFREG)
		return;
	l3tol(iaddr, ip->di_addr, NADDR);
	for(i=NADDR-1;i>=0;i--) {
		bn = iaddr[i];
		if (bn == 0)
			continue;
		switch(i) {
		default:
			bfree(bn);
			break;

		case NADDR-3:
			tloop(bn, 0, 0);
			break;

		case NADDR-2:
			tloop(bn, 1, 0);
			break;

		case NADDR-1:
			tloop(bn, 1, 1);
		}
	}
	ip->di_size = 0;
}

/*	free indirect blocks.
		tloop(bn, 0, 0) frees single indirect blocks
		tloop(bn, 1, 0) frees double indirect blocks
		tloop(bn, 1, 1) frees triple indirect blocks
	ridiculous code -awe
 */
tloop(bn, f1, f2)
daddr_t	bn;
int	f1, f2;
{
	register i;
	daddr_t nb;
	union {
		char	data[BSIZE];
		daddr_t	indir[NINDIR];
	} ibuf;

	dread(bn, ibuf.data, BSIZE);
	for(i=NINDIR-1;i>=0;i--) {
		nb = ibuf.indir[i];
		if (nb) {
			if (f1)
				tloop(nb, f2, 0);
			else
				bfree(nb);
		}
	}
	bfree(bn);
}

bfree(bn)
daddr_t	bn;
{
	register i;
	union {
		char	data[BSIZE];
		struct	fblk frees;
	} fbuf;

	/* sblock.s_nfree should never be > NICFREE */
	/* should we panic?  How about just an error msg */
	/* seems to be working ok without it */

	if (sblock.s_nfree > NICFREE)
		fprintf(stderr, "Warning! Free list is too big!  (ignored)\n");
	if (sblock.s_nfree >= NICFREE) {
		fbuf.df_nfree = sblock.s_nfree;
		for(i=0;i<NICFREE;i++)
			fbuf.df_free[i] = sblock.s_free[i];
		sblock.s_nfree = 0;
		dwrite(bn, fbuf.data);
	}
	sblock.s_free[sblock.s_nfree++] = bn;
}

/*
 * allocate a block off the free list.
 */
daddr_t
balloc()
{
	daddr_t	bno;
	register i;
	static char zeroes[BSIZE];
	union {
		char	data[BSIZE];
		struct	fblk frees;
	} fbuf;

/* if (sblock.s_nfree == 0 || (bno=sblock.s_free[--sblock.s_nfree]) == 0) { */
/*
 * this doesn't work.  If sblock.s_nfree == 0, it just means we've run
 * out of free blocks in the current block of free pointers in the super block.
 * Then what we have to do is just read in the next block of free pointers
 * (pointed to by sblock.s_free[0]) in the chain.  This condition is
 * tested for in the following 'if'.  First condition in first if deleted.
 * Without this change we ran into "Out of space" messages on big
 * file systems  	-awe 8/3/86
 */
	if ((bno = sblock.s_free[--sblock.s_nfree]) == 0) {
		/* we've reached the absolute end of the free list */
		fprintf(stderr, "Out of space.\n");
		exit(1);
	}

	/*
	 * if s_nfree == 0, then bno is simply the next block of free
	 * pointers in the free list, so we read it in to s_nfree and s_free
	 * in the super block
	 */
	if (sblock.s_nfree == 0) { /* this would never have happened!!! */
		dread(bno, fbuf.data, BSIZE);
		sblock.s_nfree = fbuf.df_nfree;
		for(i=0;i<NICFREE;i++)
			sblock.s_free[i] = fbuf.df_free[i];
	}
	dwrite(bno, zeroes);
	return(bno);
}

/*
 * map a block number into a block address, ensuring
 * all of the correct indirect blocks are around. Allocate
 * the block requested.
 */
daddr_t
bmap(iaddr, bn)
daddr_t	iaddr[NADDR];
daddr_t	bn;
{
	register i;
	int j, sh;
	daddr_t nb, nnb;
	daddr_t indir[NINDIR];

	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (bn < NADDR-3) {
		iaddr[bn] = nb = balloc();
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for(j=3; j>0; j--) {
		sh += NSHIFT;
		nb <<= NSHIFT;
		if (bn < nb)
			break;
		bn -= nb;
	}
	if (j == 0) {
		return((daddr_t)0);
	}

	/*
	 * fetch the address from the inode
	 */
	if ((nb = iaddr[NADDR-j]) == 0) {
		iaddr[NADDR-j] = nb = balloc();
	}

	/*
	 * fetch through the indirect blocks
	 */
	for(; j<=3; j++) {
		dread(nb, (char *)indir, BSIZE);
		sh -= NSHIFT;
		i = (bn>>sh) & NMASK;
		nnb = indir[i];
		if (nnb == 0) {
			nnb = balloc();
			indir[i] = nnb;
			dwrite(nb, (char *)indir);
		}
		nb = nnb;
	}
	return(nb);
}

/*
 * read the tape into buf, then return whether or
 * or not it is a header block.
 */
gethead(buf)
struct spcl *buf;
{
	readtape((char *)buf);
	if (buf->c_magic != MAGIC || checksum((int *) buf) == 0)
		return(0);
	return(1);
}

/*
 * return whether or not the buffer contains a header block
 */
ishead(buf)
struct spcl *buf;
{
	if (buf->c_magic != MAGIC || checksum((int *) buf) == 0)
		return(0);
	return(1);
}

checksum(b)
int *b;
{
	register i, j;

	j = BSIZE/sizeof(int);
	i = 0;
	do
		i += *b++;
	while (--j);
	if (i != CHECKSUM) {
		printf("Checksum error %o\n", i);
		return(0);
	}
	return(1);
}

readhdr(b)
struct	spcl *b;
{
	if (gethead(b) == 0)
		return(0);
	if (b->c_type != TS_TAPE)
		return(0);
	return(1);
}

/*
 * The next routines are called during file extraction to
 * put the data into the right form and place.
 */
xtrfile(b, size)
char	*b;
long	size;
{
	write(ofile, b, (int) size);
}

null() {;}

skip()
{
	lseek(ofile, (long) BSIZE, 1);
}


rstrfile(b, s)
char *b;
long s;
{
	daddr_t d;

	d = bmap(taddr, curbno);
	dwrite(d, b);
	curbno += 1;
}

rstrskip(b, s)
char *b;
long s;
{
	curbno += 1;
}

putdir(b)
char *b;
{
	register struct direct *dp;
	register i;

	for(dp = (struct direct *)b, i = 0; i < BSIZE; dp++, i += sizeof(*dp)) {
		if (dp->d_ino == 0)
			continue;
		putent((char *) dp, dfp);
	}
}

/*
 * read/write an inode from the disk
 */
getdino(inum, b)
ino_t	inum;
struct	dinode *b;
{
	daddr_t	bno;
	char buf[BSIZE];

	bno = (ino - 1)/INOPB;
	bno += 2;
	dread(bno, buf, BSIZE);
	copy(&buf[((inum-1)%INOPB)*sizeof(struct dinode)], (char *) b, sizeof(struct dinode));
}

putdino(inum, b)
ino_t	inum;
struct	dinode *b;
{
	daddr_t bno;
	char buf[BSIZE];

	bno = ((ino - 1)/INOPB) + 2;
	dread(bno, buf, BSIZE);
	copy((char *) b, &buf[((inum-1)%INOPB)*sizeof(struct dinode)], sizeof(struct dinode));
	dwrite(bno, buf);
}

/*
 * read a bit mask from the tape into bitmap m.
 *
 * bit mask has the form
 *	header record	(already read in at this point, into spcl)
 *	bitmap block #1
 *	   ...
 *	bitmap block #spcl.c_count
 */
readbits(m)
short	*m;
{
	register i;

	i = spcl.c_count;

	while (i--) {
		readtape((char *) m);

/*
 *	The following used to be
 *		m += (BSIZE/(MLEN/BITS));
 *	with MLEN = 16 (from <dumprestor.h>), BITS = 8 (from this file)
 *	but that is less clear than the following; bitmaps are arrays of short
 */

		m += (BSIZE / (sizeof (*m)));
	}
	while (gethead(&spcl) == 0)
		;
}

done()
{
	if (!dflag) {
		unlink(dirfile);
		unlink(tmpfile);
	}
	exit(0);
}


/*
 *	Binary search the inotab for inum
 *	Return 0 if not found
 */
bsearch(inum)
ino_t	inum;
{
	register low, high, probe;
#ifdef	BIGFS
	if (bflag) {
		/* (yeah, sure, binary search a file ... ??) */
		fseek(ifp, (long)0, 0);
		while (fread(&dirptr, sizeof(dirptr), 1, ifp))
			if (inum == dirptr.ft_ino)
				return(1);
		return(0);
	}
#endif	!BIGFS

	low = 0;
	high = ipos-1;

	while (low != high) {
		probe = (high - low + 1)/2 + low;
		if (inum >= inotab[probe].t_ino)
			low = probe;
		else
			high = probe - 1;
	}
	return(inum == inotab[low].t_ino);
}

/*
 	Check to see that all directories in a given
	path exist.  If they don't create them.
*/
chkdir(dir, b)
char *dir;
struct spcl *b;
{

	extern int errno;
	int a, len;
	char parent[512];
	char nm[512];


	if ((a = access(dir, 0)) == 0)
		return(1);


	if (trunc(dir)) {
		len = strlen(dir);
		if (chkdir(dir, b) == 0) {
			dir[len] = '/';
			return(0);
		}
		strcpy(parent, dir);
		dir[len] = '/';
		if (mknod(dir, (040000 | spcl.c_dinode.di_mode), 0) == 0) {
			link(dir, strcat(nm, "/."));
			link(parent, strcat(nm, "."));
			chown(dir, b->c_dinode.di_uid, b->c_dinode.di_gid);
			strcpy(nm, dir);
			if (vflag)
				fprintf(stderr, "%s: directory created\n", dir);
		}
		return(1);
	}
	else {
		return(0);
	}
}


/*
 	Truncate the given name back to 
	the last slash.
*/
trunc(dname)
char *dname;
{

	register char *c, *cp;

	for(c = dname; *c; c++)
		;
	c--;

	while(*c != '/' && c != dname) {
		c--;
	}

	if (c == dname)
		return(0);
	*c = '\0';
	return(1);
}
