/*
 *  File system/special file tables .....
 *  An entry says that filenames beginning with
 *  `pfx' are to be found on device `spcl'.
 *  NULL pfx is a catchall at end;
 *  put default (ie the root device) here.
 *
 *  For VMS version, `mindev' is the UNIX minor device
 *  number for the appropriate special file.  This is
 *  used to determine the drive number and the index
 *  into the `cyloff' table.
 */

struct fstab {
	char	*fs_pfx;
#if VMS
	int	fs_mindev;
#else
	char	*fs_spcl;
#endif VMS
};

#if VMS

#define	UNIXDEV		"$UNIX0:"

/*  The following line is clearly device-dependent  */

#define	BLKSPERCYL	(608L)

/*
 *  These are the cylinder offset values from the UNIX system's io.h
 *
 *  Note:  Our driver has 16 filesystems per physical drive.  Systems
 *  which use eight (or anything other than 16) will have to make some
 *  minor (and rather obvious) changes wherever you see fs_mindev used
 *  with the `%' or `>>' operator.
 */

int	cyloff[16] = {
	  0,	/* a */
	 25,	/* b */
	 30,	/* c */
	 35,	/* d */
	135,	/* e */
	235,	/* f */
	  0,	/* g */
	  0,	/* h */
	  0,	/* i */
	335,	/* j */
	385,	/* k */
	335,	/* l */
	334,	/* m */
	  0,	/* n */
	  0,	/* o */
	 50,	/* p */
};

struct fstab	V6fs[] = {
	NULL,		-1,
};

struct fstab	V7fs[] = {
	NULL,		-1,
};

struct fstab	V32fs[] = {
	NULL,		-1,
};

struct fstab	S5Pfs[] = {
	NULL, 		-1,
};

struct fstab	S5Vfs[] = {
	NULL, 		-1,
};

#else

#if vax

struct fstab	V6fs[] = {
	NULL,		"/dev/rl0",
};

struct fstab	V7fs[] = {
	NULL,		"/dev/rl0",
};

struct fstab	V32fs[] = {
	NULL,		NULL,
};

struct fstab	S5Pfs[] = {
	NULL,		"/dev/rl0",
};

struct fstab	S5Vfs[] = {
	"/usr/",	"/dev/usr",
	"/u/",		"/dev/u",
	"/db/",		"/dev/db",
	NULL,		"/dev/root",
};

#else

struct fstab	V6fs[] = {
	NULL,		NULL,
};

struct fstab	V7fs[] = {
	"/usr/",	"/dev/rl11",
	NULL,		"/dev/rl10",
};

struct fstab	V32fs[] = {
	NULL,		NULL,
};

struct fstab	S5Pfs[] = {
	"/usr/",	"/dev/rl01",
	NULL,		"/dev/rl00",
};

struct fstab	S5Vfs[] = {
	NULL,		NULL,
};

#endif vax

#endif VMS
