/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: readline.c,v 1.3 1997/12/01 10:04:40 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>

# include "begemot.h"

# define CHUNK		512
# define REQ		80

int readlinecnt;

char *
readline(FILE *fp)
{
	char *buf;
	size_t len, alloc;

	buf = 0;
	len = alloc = 0;
	readlinecnt = 0;
	for(;;) {
		if(alloc - len < REQ) {
			alloc += CHUNK;
			buf = xrealloc(buf, alloc);
		}
		if(fgets(&buf[len], alloc - len, fp) == NULL) {
			if(len == 0) {
				free(buf);
				return NULL;
			}
			return buf;
		}
		len = strlen(buf);
		if(buf[len - 1] == '\n') {
			readlinecnt++;
			if(len > 1 && buf[len - 2] == '\\') {
				len -= 2;
				buf[len] = '\0';
			} else
				break;
		}
	}

	return buf;
}

# ifdef TEST

int
main(int argc, char *argv[])
{
	char *line;

	while(putchar('>'), (line = readline(stdin)) != NULL) {
		printf("%d, %d: '%s'\n", readlinecnt, strlen(line), line);
		free(line);
	}
	if(ferror(stdin))
		printf("ERROR\n");
	if(feof(stdin))
		printf("EOF\n");
	return 0;
}

# endif
