'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: readline.man,v 1.3 1997/12/01 10:04:40 hbb Exp $
'\"
.TH readline l "30 Aug 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
readline - read line of arbitrary size from file
.SH SYNOPSIS
.nf
.LP
.B "# include <stdio.h>"
.B "# include <begemot.h>"
.LP
.BR "char * readline(FILE * " "fp" ");"
.LP
.B int readlinecnt;
.fi
.SH DESCRIPTION
This function allows you to read lines of arbitrary length from an input file. It
thus overcomes the problem of ``how large should I allocate the input buffer?'' in many
programs. It handles the convention of signaling line continuation with a backslash
in the last position, i.e. it silently removes sequences of ``\e\e\en'' from input.
.LP
The variable
.B readlinecnt
contains the number of input lines which where folded together for the last line
returned by
.BR readline .
.SH "RETURN VALUE"
The function returnes a pointer to a
.BR malloc (3C)ed
area on success. If end of file or an error is encountered before any character is
transfered to the buffer, NULL is returned.
.BR readline (l)
uses
.BR xrealloc (l)
to allocate the buffer and thus exists with
.BR panic (l)
in the case of insufficient memory.
.SH "SEE ALSO"
.BR xrealloc (l),
.BR panic (l)
