'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: getfields.man,v 1.2 1997/12/01 10:04:40 hbb Exp $
'\"
.TH getfields l "12 Sep 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
getfields, getmfields, setfields \- split string into fields
.SH SYNOPSIS
.LP
.B "# include <begemot.h>"
.LP
.BI "int getfields(char *" "str" ", char **" "fields" ", int"
.IB "nfields" ");"
.LP
.BI "int getmfields(char *" "str" ", char **" "fields" ", int"
.IB "nfields" ");"
.LP
.BI "char *setfields(char *" "delim" ");"
.LP
.SH DESCRIPTION
.B getfields
and
.B getmfields
split the input string in substrings as defined by a set of delimiting characters.
The pointer array
.I fields
is filled with pointers to the starts of the substrings. Each substring is
terminated with a NUL character (the original string is modified). The number
of entries in the array is given with
.IR nfields .
If the string contains more substrings than
.I nfields
specifies, the last pointer in
.I fields
will point to the rest of the string.
If there are lesser substrings than entries in
.IR fields ,
the substring pointer array will be NULL terminated.
Both functions return the number of substrings found.
.LP
.B getfields
and
.B getmfields
differ in the interpretation of multiple delimiting characters.
.B getfields
interprets two consecutive delimiters as an empty field, whereas
.B getmfields
collapses multiple delimiters.
.LP
.B setfields
sets a new set of delimiters. A string containing
the old delimiting characters is returned. The default set is
"\\t\ ". The NUL character is always interpreted as a delimiter and
end of string.
.SH "RETURN VALUE"
.B getfields
and
.B getmfields
return the number of substrings.
.B setfields
returns a pointer to static memory containing the old delimiting characters.
This is valid only until the next call to
.B setfields
and can directly be feed into the next
.B setfields
call.
.SH "SEE ALSO"
.BR strtok (3),
.SH BUGS
Could, perhaps, be more performant.
