/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include <stdio.h>
# include <stdlib.h>

struct cnt {
	unsigned	cnt;
	unsigned	op;
};

struct cnt	a[0x10000];

unsigned	cnt[0x10000];

int	comp(const void *, const void *);

long long ccc;

main()
{
	int i;

	if(fread(cnt, sizeof(cnt), 1, stdin) != 1) {
		perror("fread");
		exit(1);
	}

	for(i = 0; i < 0x10000; i++) {
		a[i].op = i;
		ccc += cnt[i];
		if((i & 070000) == 0 && !(i & 04000) && i >= 0400)
			a[i & ~0377].cnt += cnt[i]; 	/* BRANCH */
		else if((i & 0177000) == 077000)
			a[i & ~077].cnt += cnt[i];	/* SOB */
		else if((i & 0177000) == 0104000)
			a[i & ~0377].cnt += cnt[i];	/* TRAP/EMT */
		else if((i & 0177700) == 06400)
			a[i & ~077].cnt += cnt[i];	/* MARK */
/*
		else if((i & 070000) != 0 && (i & 070000) != 070000)
			a[i & 0170000].cnt += cnt[i];
		else if((i & 070000) == 0 && (i & 07777) > 05000)
			a[i & ~077].cnt += cnt[i];
*/
		else
			a[i].cnt = cnt[i];
	}

	qsort(a, 0x10000, sizeof(struct cnt), comp);

	for(i = 0; i < 0x10000; i++) {
		if(a[i].cnt == 0)
			break;
		printf("%06o %11d %f\n", a[i].op, a[i].cnt, 100.0 * a[i].cnt / ccc);
	}
	return 0;
}

int	
comp(const void *p1, const void *p2)
{
	const struct cnt *a1 = p1;
	const struct cnt *a2 = p2;

	return a2->cnt - a1->cnt;
}
