.hpf hyphen.local
.P1
.de PT
.tl 'RP01 - RP-11/RP03 MOVING HEAD DISK INTERFACE'\*[CH]'PD-1C303-01'
.tl 'File: rp.c''Section 10'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B rpintr
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpintr()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the RP03.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The block device driver interrupt handling routines receive control when an
interrupt from their respective devices occurs. All of these routines
perform the same basic functions.
.IP 1. 4
Mark the device as inactive (d_active in the device's devtab).
.IP 2. 4
Check to see if an error occurred on the transfer. If so, certain actions
unique to that particular device may need to be taken (e.g., reset the
controller). The transfer is usually then reinitiated and is reggrded as
incomplete. An I/O request may be retried up to ten times before being
abandoned as hopeless (B_ERROR in the buffer header's b_flags).
.IP 3. 4
Mark completed requests as such. This is done both to requests that have
completed successfully and to those that have been deemed hopeless because
of I/O errors.
.IP 4. 4
Remove the completed requests from the device's I/O queue and initiate I/O
for the next request in the queue.
.sp 1m
.ne 10
.
.LP
.LG
.B rpphys
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpphys(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Zero if a "raw" I/O request will exceed the logical device's upper bound;
one if it remains in bounds.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Verifies that a raw mode I/O request to an RP03 logical device will remain
within the upper bound of that device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Because I/O requests to RP03s are made to a logical (i.e., minor) device
and there are many logical devices on a single physical device, it is
necessary to impose software checks to ensure that a raw mode I/O request
can be fulfilled within the confines of the logical device. Whereas
rp.c/rpstrategy ensures that the starting block address is valid, rpphys
verifies that the number of bytes to be transferred will not cause the
transfer to overrun the end of the logical device. A one is returned for a
valid 110 request, otherwise, zero.
.sp 1m
.ne 10
.
.LP
.LG
.B rpread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpread(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RP03 driver for "raw" mode read requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The read routines for disk and ,tape drivers are the functions that handle
"raw" mode read requests for their respective devices. That is, they are
the interface between users making such requests and the I/O subsystem, and
are called whenever a read is done to the raw device. They usually do
little more than invoke bio.c/physio to do the real work involved with
"raw" I/O, but are vitally necessary, as they inform physio of such things
as the device strategy routine to invoke to make the I/O request.
.
.LP
Rpread merely veriies (see rp.c/rpphys) that the "raw" read request will
remain entirely within the bounds of the RP03 logical device in question
before calling physio.
.sp 1m
.ne 10
.
.LP
.LG
.B rpstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Initiates the actual I/O to an RP03 device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If there are any I/O requests on the RP03 queue (chained from d_actf in
rptab), restart marks the RP03 as active (rptab.d_active) and initiates I/O
for the first request in the queue. The real work of activation is done by
bio.c/devstart, but rpstart must fill in an RP03 controller register that
is not filled in by devstart. Although the physical block address has
already been computed by rp.c/rpstrategy, rpstart must complete the logical
to physical device mapping by selecting the actual physical drive.
.sp 1m
.ne 10
.
.LP
.LG
.B rpstrategy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpstrategy(bp)
.br
struct buf *bp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places an I/O buffer on the RP03's queue of I/O buffers to read/write.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The strategy routines for disk and tape drivers provide two major services:
to place I/O requests on the device's queue of pending requests in an order
that is most efficient for that particular device, and, to verify that the
request's logical block address conforms to the logical (i.e., minor)
device policy of the device driver. In particular, disk and tape strategy
routines do the following specific things for each 110 request, which the
driver sees in terms of a pointer "bp" to a buffer header (struct buf):
.IP 1. 4
Verify that the block address given in the I/O request is a plausible
address for the logical device being read/written. That is, ensure
conformity to the logical device policy of the driver.
.IP 2. 4
For devices that have several logical devices on a single physical device,
translate the block address on the logical (i.e., minor) device to a true
block address on a physical device. The remainder of the translation
(selecting the physical drive) is peforuied elsewhere, usually in the
driver's start routine. Note that for drivers that map a logical device to
one or more physical devices this step is omitted and the address
translation is done elsewhere, usually in the driver's start routine.
.IP 3. 4
Place the I/O request in the device's queue of pending 110 requests (work
to do queue). The location within the queue where the request is placed
depends on the queuing strategy being employed for the device. The queue
itself is chained from d_actf in the device's devtab (e.g., rptab, rftab,
etc.) Immediately prior to rechaining the queue to insert the request, the
processor's hardware priority must be raised to that of the device to
disable interrupts from the device.
.IP 4. 4
Cause physical I/O to be initiated if there are no previous requests
currently being serviced.
.
.LP
The strategy routine for dig RP03 disk, rpstrategy, performs all of the
above functions. The logical to physical deVice mapping is accomplished by
dividing the logical (i.e., the minor) device number by eight. The quotient
of this division is interpreted as the controller drive number and the
remainder is the logical file system on that drive. For example, a minor
device number of 13 is construed to be logical file system five on physical
drive one. Each physical drive is divided into eight logical file systems
as follows:
.
.LP
	File #	Cylinders	# of blocks
.br
	0	0 - 202	40600
.br
	1	203 - 405	40600
.br
	2	0 - 45		9200
.br
	3	360 - 405	9200
.br
	4	0 - 327	65535
.br
	5	78 - 405	65535
.br
	6	unused
.br
	7	unused
.
.LP
The queuing strategy used is the "elevator" technique. That is, when a
request is made, if there are none or one other request on the queue, the
new request is placed at the end of the queue (First In First Out (FIFO)
strategy). If there are already two or more pending requests, the new
request is inserted so that all requests on the queue are in cylinder
number order. Whether this order is increasing or decreasing by cylinder
number is established when there are two re, quests on the queue. All
requests for the same cylinder are handled in a FIFO manner.
.sp 1m
.ne 10
.
.LP
.LG
.B rpwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
rpwrite(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interface to RP03 driver for "raw" mode write requests.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The write routines for disk and tape drivers are the functions that handle
"raw" mode write requests for their respective devices. That is, they are
the interface between users making such requests and the I/O subsystem, and
are called whenever a write is done to the raw device. They usually do
little more than invoke bio.c/physio to do the real work involved with
"raw" I/O, but are vitally necessary, as they inform physio of such things
as the device strategy routine to invoke to make the I/O request.
.
.LP
Rpwrite merely verifies (see rp.c/rpphys) that the "raw" write request will
remain entirely within the bounds of the RP03 logical device in question
before calling physio.
