.hpf hyphen.local
.P1
.de PT
.tl 'PC01 - PC-11 PAPER TAPE READ/PUNCH INTERFACE'\*[CH]'PD-1C303-01'
.tl 'File: pc.c''Section 5'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B pcclose
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcclose(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically closes the PC11 paper tape reader/punch.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the PC11 was open for writing ("flag" nonzero), pcclose logically closes
it by punching a leader in the tape (see pc.c/pcleader). However, if the
PC11 was being used for reading ("flag" = 0), then all characters that were
received from the device but not yet read by the user are flushed from the
input queue (pcin), the reader is disabled, and the device's state
(pcstate) is changed to indicate that the reader may now be used by other
users.
.sp 1m
.ne 10
.
.LP
.LG
.B pcleader
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcleader()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Punches a leader on paper tape.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Whenever paper tape is used for output, pcleader is invoked at the time the
PC11 paper tape reader/punch is logically opened (see pc.c/pcopen) or
closed (see pc.c/pcclose). This routine merely punches a leader of a
hundred zero characters.
.sp 1m
.ne 10
.
.LP
.LG
.B pcopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcopen(dev, flag)
.br
int dev, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens the PC11 paper tape reader/punch for input or output.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The pcopen routine logically opens the PC11 paper tape reader/punch. The
specific actions that are taken depend on whether the device is being
opened for reading ("flag" = 0) or writing ("flag" nonzero).
.
.LP
If the PC11 is being opened for reading, pcopen verifies that the device is
not already open for reading by some other user (pcstate). If it is, pcopen
returns with an error (u error), since allowing multiple users to read
the_same tape will usually prove unacceptable to all of them. Otherwise,
the device's state (pcstate) is set to WAITING and pcopen waits for the
state to change. A change of state signifies that a character has been
actually been received (see pc.c/pcrint); this ploy ensures that there is
tape in the reader and that it is online.
.
.LP
If the PC11 is opened for writing, pcopen merely punches a leader in the
tape (see pc.c/pcleader).
.sp 1m
.ne 10
.
.LP
.LG
.B pcoutput
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcoutput(c)
.br
int c;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places a character on the PC11's output queue and activates punching.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Before placing the character "c" on the PC11's output queue (pcout),
pcoutput must verify that no device errors have occurred punching any
previous characters. If an error did occur, pcoutput indicates that fact
(u_error) and returns, as any further attempts to punch would be futile. In
the absence of errors, this routine places the character "c" on the output
queue and activates the punch (sec pc.c/pcstart). Note that if the queue is
too long, pcoutput may have to wait until it shrinks to an acceptable
length (see pc.c/pcpint) before placing the character on it.
.sp 1m
.ne 10
.
.LP
.LG
.B pcpint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcpint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interrupt handler for the PC11 paper tape punch.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for the PC11 paper tape punch, pcpint must
reactiviate the punch for the next character in the output queue (pcout),
if any. It is also responsible for awakening pc.c/pcoutput if the output
queue length has shrunk to a reasonable length, so that more characters may
be placed on the queue.
.sp 1m
.ne 10
.
.LP
.LG
.B pcread
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcread()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The read routine for the PC paper tape reader/punch.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The pcread routine is the interface between the user reading from the PC11
device and the device driver itself. As such, it is called whenever the
user issues a read request to this device. Pcread attempts to pass to the
user's buffer as many characters from the input queue (pcin) as are
necessary to satisfy the read request's byte count. If there are not enough
characters available on this queue, pcread activates the PC reader, waits
for more characters to be received and placed on the input queue (see
pc.c/pcrint), and then continues to pass characters to the user. Pcread
will return once the user's request is satisfied; however, it will return
prematurely if an end-of-file is sensed on the PC11 reader (EOF in pcstate,
see pc.c/pcrint) or an error occurs while passing characters to the user's
buffer.
.sp 1m
.ne 10
.
.LP
.LG
.B pcrint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcrint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Interrupt handler for the PC11 paper tape reader.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The pcrint routine receives control when interrupts are received from the
PC11 reader. If the state of the reader (pcstate) is WAITING and a
character was successfully received from the PC11, the state is changed to
READING (see pc.c/pcopen for an explanation of the significance of this).
This character is then handled as is any other chSracter that is read when
the PC is in the READING state (see below).
.
.LP
When an interrupt is received (i.e., a character is received) with the PC11
in the READING state, perint checks to see if an error occurred. Any error
is interpreted as end-of-file and the device's state is changed to reflect
this fact. Correctly received characters are placed on the input queue
(pcin) and the reader is reactiviated if there are not already too many
characters on the input queue. Whether the interrupt was from a properly
received character or an end-of-file (i.e., an error), pc.c/pcread is
awakened in case it was waiting for more characters to be received and
placed on the input queue.
.sp 1m
.ne 10
.
.LP
.LG
.B pcstart
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcstart()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Activates the PC11 paper tape punch for a character.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
If the PC11 punch is ready to punch a character and there are any
characters in the output queue (pcout), then the punch is passed the first
character in the queue.
.sp 1m
.ne 10
.
.LP
.LG
.B pcwrite
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
pcwrite()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
The write routine for the PC11 paper tape reader/punch.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The pcwrite routine is the interface between the user writing to the PC11
device and the device driver itself. As such, it is called whenever the
user issues a write request to this device. Pcwrite collects as many
characters from the user's output buffer as necessary to satisfy the write
request's byte count and causes them to be placed on the PC11's output
queue (pcout; see also pc.c/pcoutput).
