.hpf hyphen.local
.P1
.de PT
.tl 'MALLOC01 - MEMORY ALLOCATOR'\*[CH]'PD-1C303-01'
.tl 'File: malloc.c''Section 2'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B malloc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
malloc(mp, size)
.br
int size, *mp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Address of a memory/disk area of the desired size. Zero if requested amount
of memory/disk space is not available.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Malloc is used to obtain (allocate) space from either main memory or the
swap device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The malloc and malioc.c/mfree functions are used to allocate and
deallocate, respectively, space either in main memory or on the swap device
using a first fit, low address first algorithm. Two tables of free space
are maintained by the system, one for free core (the array coremapfl) and
the other for free swap space (the array swapmapn). Each table entry
contains the free area size, in 64 byte granularity for memory and 512 byte
granularity for swap space, and the free area's starting address, expressed
as either a memory segment number or disk block number. The entries within
each table are ordered by ascending starting address.
.
.LP
When called, malloc does a linear search of the table pointed to by the
first function argument ("mp") for the first entry whose siie is equal to
or greater than the second argument ("size"). Because no conversion of
"size" to the next 64 or 512 byte value is performed and because of the
table updating requirement, the granularity of "size" must already be in
the proper units. When a free area of sufficient size is found, the size
and starting address of the table entry are adjusted to reflect the
allocation of the requested space by decreasing the size and increasing the
starting address. In the case where the requested "size" was equal to the
size of the free area available (i.e. the updated size value is zero), that
entry in the table is eliminated and all of the following entries are moved
up. The starting address of the allocated space (either a memory segment
number or a disk block address) is returned. A zero is returned in the case
that all free areas were smaller than the requested size.
.sp 1m
.ne 10
.
.LP
.LG
.B mfree
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
mfree(mp, size, addr)
.br
int size, addr, *mp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Mfree is used to free (deallocate) space from either main memory or the
swap device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Mfree is the complementary function of malloc.c/malloc, in that it frees
(deallocates) the memory/swap area of "size" that begins at "addr". In
deallocating memory, both "size" and "addr" are expressed in memory
management units (64 byte), whereas for deallocation of swap space, "size"
is in 512 byte units and "addr" is a disk block number. See the description
of malloc for an explanation of the tables used to maintain a mapping of
free space in memory and on the swap device.
.
.LP
A linear search of the free space table pointed to by the first argument
("mp") is made to find the first entry Ei whose starting address is greater
than that of the area being freed ("addr"). If there is no such entry, then
Ei is the first unused slot in the table. The space being freed (the new
free area) is then entered in the table (deallocated) in one of four ways.
.IP 1. 4
If the free areas described by entries Ei-1 and Ei do not abut the area
being freed, then entry Ei and all following entries are moved down in the
table and the entry for the new free area is inserted in the ith slot.
.IP 2. 4
If the preceding entry Ei-1 abuts the new free area, then "size" is added
to the size of entry Ei-1.
.IP 3. 4
If the entry Ei abuts the new free area, then its size is increased and its
starting address decreased by "size".
.IP 4. 4
If the new free area abuts both Ei-1 and Ei (i.e. the area being freed is
the hole between these two free areas), the size of Ei and "size" are both
added to the size of Ei-1. Entry Ei is then removed and all following
entries are moved up in the table.
