.hpf hyphen.local
.P1
.de PT
.tl 'DHDM01 - DHDM MODEM CTL INTERFACE'\*[CH]'PD-1C302-01'
.tl 'File: dhdm.c''Section 5'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dmint
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dmint()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Handles interrupts from the DM11 modem control.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
As the interrupt handler for the DM11 modem control, dmint must determine
which line caused the interrupt and what the carrier transition was (i.e.,
was carrier attained or lost). The action to be taken depends on the line's
new carrier state.
.
.LP
If carrier is not present, the control structure for the line is changed to
reflect absence of carrier (tstate). Additionally, if the device was not
waiting-to-open (i.e., was open, see dh.c/dhopen), the loss of carrier
indicates a hangup situation. In this case, a hangup is sig naled to the
process(es) associated with the line and the device's I/O queues are
flushed (see tty.c/flushtty).
.
.LP
The only other possibility is that a carrier signal is present. The
device's software state (t_state) is changed to reflect this fact and
dhdm.c/dmopen, which is awaiting a carrier signal before continuing open
processing for the device, is awakened.
.sp 1m
.ne 10
.
.LP
.LG
.B dmopen
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dmopen(dev)
.br
int dev;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Logically opens a DM11 modem control.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This version of the dmopen routine is used in conjunction with the DH11
driver (dh.c) whenever the DM11 modem control is used on the DH11. A fake
routine, dhfdm.c/dmopen, is used in lieu of this routine for those DH11s
that do not have a DM11.
.
.LP
Dmopen is invoked by dh.c/dhopen each time a line attached to the DH11 is
opened. It must check to see if a carrier signal is already present on the
line corresponding to device "dev". If this is not the case, dmopen is
obligated to wait until carrier has been received (see dhdm.c/dmint) before
continuing. In any event, once the line has a carrier signal, dmopen may
return to dhopen for the conclusion of open processing.
