.hpf hyphen.local
.P1
.de PT
.tl 'INTRODUCTION'\*[CH]'PD-1C302-01'
.tl '''Section 1'
.tl '''Issue 1, January 1976'
..
.2C
.
.NH
GENERAL
.
.LP
This document describes functions contained in
pidents from PR-1C302-01 as follows:
.
.IP "" 1.5em
.RS
.IP BIO01 11.5em
BLOCK I/O
.
.IP DC01 11.5em
DC-11 COMMUNICATIONS INTERFACE
.
.IP DH01 11.5em
DH-11 COMMUNICATIONS MULTIPLEXER
.
.IP DHDM01 11.5em
DHDM MODEM CTL INTERFACE
.
.IP DHFDM01 11.5em
DHFDM NULL MODEM CTL INTERFACE
.
.IP DN01 11.5em
DN-11 ACU INTERFACE
.
.IP DP01 11.5em
DP-11 201 SYNCHRONOUS INTERFACE
.
.IP HP01 11.5em
RP04 MOVING HEAD DISK INTERFACE
.
.IP HS01 11.5em
RS03/04 INTERFACE
.
.IP HT01 11.5em
TU16 MAGNETIC TAPE INTERFACE
.
.IP KL01 11.5em
KL-11 OR DL-11 ASYNCHRONOUS INTERFACE
.
.IP LP01 11.5em
LINE PRINTER INTERFACE
.RE
.
.NH
PROGRAM CONVENTIONS
.
.IP A. 3
System calls are made with the first argument in register R0. When the
system call is made, the contents of register R0 are moved to the per user
control block (user.h) in the variable called u.u_R0. The remaining
arguments of a system call are moved into the per user control block array
u.u_arg (this means u.u_arg[0] is the second argument).
.
.IP B. 3
Arguments or results of executing some functions are often left behind in
the per user control block. For example, nami.c/namei decodes a pathname
into an inode pointer. In the process, a pointer to the inode of the
parent directory is left in u.u_pdir. This means it is eady to make a
directory entry for a file since the inode for the directory is available.
(See the documented header user.h in PR-1C301.)
.
.IP C. 3
Inodes are always locked during manipulations to prevent simultaneous
update by two processv:. The procedure is to always lock and increment the
usage count of an inode even if it turns out that a user does not have
access to that file. At the end of processing of the inode, the usage
count is reduced by 1 if there was an error, and in either success or
failure, the inode is unlocked.
.
.IP D. 3
Error processing that reflects errors back to the user are set in the per
user control block error flag (u.u_error). These error conditions can be
referenced by the user program through the external variable "errno". (See
Section 2 of Programer's Manual for list of error conditions.)
.
.IP E. 3
If I/O processing is to be done on a device, the particular driver for
that device must be called. Devices are known by major and minor numbers
stored in an inode.  The system calls the particular device driver
indirectly through the major device number. A block switch table and
character switch table are defined at system generation time. The major
device number is used as a displacement into this table and the
appropriate routine is called. For example, the code:
.
.sp .5em
.RS
(*bdevsw[maj].d_close)
.RE
.sp .5em
.
will call the close entry point for the driver associated mith major device "maj".
