.hpf hyphen.local
.P1
.de PT
.tl 'SYSENT01 - TABLE OF SYSTEM ENTRY POINTS'\*[CH]'PD-1C301-01'
.tl 'File: sysent.c''Section 21'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B sysent
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
.sp 1n
.
.LP
.I RETURNS
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
System Entry Point Table.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
This table is used by the trap handler (trap.c/trap) to call the
appropriate system function when a system call is made. The table consists
of two word entries. The first word of each entry is the number of
arguments that are to be fetched from the user's program as arguments to
the system function. This number does not correspond to the number of
arguments to a system call as specified in the UNIX Programmers Manual
since some arguments are passed in registers (see trap.c/trap). Individual
descriptions of system functions should be consulted for the manner in
which arguments are passed. The second word of each entry is the address of
the function in the system that implements the system call. Currently,
there are 64 entries in the table.
.
.LP
The TRAP instruction is executed when a system call is made (SYS pseudo-op
in assembly language). This instruction contains an 8 bit field reserved
for a trap number. UNIX uses the lower six bits of this number as an
identifier for the type of system call and hence an index into the
"sysent[]" table.
.
.LP
Unused system call entries have the function trap.c/nosys entered in the
table. This function posts an error if a system call is made using that as
the index. The first entry in the table (index 0) is filled in with the
trap.c/nullsys function. A zero index in the trap instruction is recognized
as an indirect system call. The trap.c/nullsys entry in the table insures
that multiple levels of indirect system call cannot be made.
