.hpf hyphen.local
.P1
.de PT
.tl 'SYS301 - SYSTEM CALL INTERFACE 3'\*[CH]'PD-1C301-01'
.tl 'File: sys3.c''Section 18'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B dup
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
dup()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Duplicates an open file descriptor.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Dup is the system primitive used to duplicate a user's open file
descriptor. This is easily accomplished by placing another pointer to the
system file table entry (file[]) for the open file in the user's open file
table (u_ofile) and increasing the file's use count (f_count).
.sp 1m
.ne 10
.
.LP
.LG
.B fstat
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
fstat()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allows the caller to obtain the vital statistics of an open file by using
the file descriptor.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Fstat is a system primitive that enables a user to obtain certain
information about an open file by using the file descriptor. Therefore, the
file's name (which could be that of a special file or a pipe) need not be
known. The real work of obtaining this data is done by sys3.c/stat1, and
fstat's principle duty is to translate the user's fstat arguments (file
descriptor and buffer address) into a correct stat1 function call. A
secondary responsibility of fstat before returning is to compute the
correct file length if the file is a pipe, and replace stat1's view of file
length with a more meaningful value. In particular, from the read end of a
pipe, the file length returned by fstat is the number of unread bytes in
the pipe; from the write end, the length is the number of bytes currently
in the pipe, whether read or not.
.sp 1m
.ne 10
.
.LP
.LG
.B getmdev
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
getmdev()
.sp 1n
.
.LP
.I RETURNS
.
.LP
The device number of a block device.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Used while mounting and unmounting file systems to determine the device
number of a block special file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
The routine getmdev is used internally by the system when mounting and
dismounting file systems (sys3.c/smount and sys3.c/sumount, respectively)
to translate the special file's pathname into a device number. It is
expected that this name resides in user space. Certain checks are performed
to ensure that the special file is that of a valid block device that is
configured into the system. The device number is returned unless the device
fails to pass the validation tests, in which case the appropriate error
bits are set (u_error).
.sp 1m
.ne 10
.
.LP
.LG
.B smount
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
smount()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Mounts a file system on a specified directory or regular file.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Smount is the syitem primitive that effects the mounting of a file system
on an existing file or directory (which is called the mountpoint). The
restrictions regarding this procedure are: the mount point may not be
currently in use by the requester or another user, the mount point may not
be a special file, and the file system (device) being mounted may not
already be mounted. Failure to fulfill any one of these requirements
results in the file system not being mounted. If these restrictions have
been satisified, the mount is accomplished by placing the file system's
superblock (struct filsys) in memory in a block I/O buffer, building an
entry in the mount table (mount[]) and marking the mount point i-node as a
mount point.
.sp 1m
.ne 10
.
.LP
.LG
.B stat
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
stat()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Allows the caller to obtain the vital statistics of a file by using the
file's name.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Stat is a system primitive that enables a user to obtain information about
a file whose name is known. Since sys3.c/stat1 does the real work in
obtaining this data, stat's principle function is to translate the file's
pathname into a meaningful stat1 function call.
.sp 1m
.ne 10
.
.LP
.LG
.B stat1
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
stat1(ip, addr)
.br
struct inode *ip;
.br
int *addr;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Returns a file's vital statistics to a user in response to a fstat or stat
system call.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Stat1 does most of the work involved in fulfilling fstat and stat system
calls. To ensure that the most current information regarding the file
(especially the access and update times) is available, the file's inode
table entry, pointed to "ip", is first written to the file system. The
file's inode is then read directly from the file system. The information
requested by the fstat or stat call is transferred directly to the user
supplied area starting at "addr".
.sp 1m
.ne 10
.
.LP
.LG
.B sumount
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
sumount()
.sp 1n
.
.LP
.I RETURNS
.
.LP
System primitive.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Dismounts a mounted file system.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Sumount is the system primitive that unmounts a file system previously
mounted by sys3.c/smount. This can be done only if no files in the file
system are being used (i.e., have no system inode table entries). A sync is
performed to ensure that all incore data regarding the file system is
actually written to the device. The dismount is then completed by clearing
the mount table entry (mount[]), freeing the buffer used for the
superbiock, and removing the mount point stigma from the mount point file.
