.hpf hyphen.local
.P1
.de PT
.tl 'SUBR01 - SYSTEM SUBROUTINES'\*[CH]'PD-1C301-01'
.tl 'File: subr.c''Section 15'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B bcopy
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
bcopy(from, to, count)
.br
int *from, *to, count;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Copies a specified number of words from one location to another.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Bcopy copies "count" words from memory location "from" to memory location
"to". Both "from" and to must be on word boundaries.
.sp 1m
.ne 10
.
.LP
.LG
.B bmap
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
bmap(ip, blk)
.br
struct node *ip;
.br
int blk;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Block number on a device. Zero on an error.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Converts a logical block number of an ordinary file or directory into the
block number on a device.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Brnap is used to convert, for other than special files, a file's logical
block number "blk" into a block number on the logical device containing the
file. This function is not performed for special files, since the logical
block number is always construed to be the physical block number. The file
is identified to bmap by a pointer "ip" to its system inode table entry
(inode[]). The manner in which the file logical block number to device
logical block number mapping is done depends on whether the file is small
(eight blocks or less) or large (between nine and 2048 blocks).
.
.LP
For small files, the logical block number is used as an offset within the
)node table entry (from i_addr) to find the device block number.
.
.LP
However, for large files, the logical block number must be divided by 256,
which is the number of block pointers in each indirect block of a large
file. The quotient of this division is used as an offset within the )node
table entry (from i_addr) to find the device block number of an indirect
block, which is read. The remainder from the division is then used as an
offset within that indirect block to obtain the device block number.
.
.LP
Regardless of whether the file is small or large, if there is no device
block allocated for the logical block number in question, a disk block is
automatically allocated and added to the file as that logical block number.
In the case of small files, this may also entail conversion of the file to
a large file.
.
.LP
A return of zero indicates an error, the appropriate error bits are set in
u_error. Otherwise, the device block number is returned.
.sp 1m
.ne 10
.
.LP
.LG
.B cpass
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
cpass()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A single character from an I/O buffer; -1 on error or the completion of a
write request.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
During processing of a write system call, obtains a single character from
the requester's I/O buffer.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
During processing of a write system call, cpass is used to obtain a single
character from the requester's I/O buffer (which is pointed to by u_base).
The method used to extract this character depends on whether the buffer is
in system or user space (as determined by u_segflag). After getting the
character, the file offset (u_offset) and address of the I/O buffer (u
base) are increased by one, and the byte count for the write system call (u
count) is decreased by one. The character obtained is then returned to the
caller. A -1 return value indicates that the write request byte count has
been satisfied (on the previous invocation of cpass) or that an error
occurred. In the latter case, an error bit is set in u_error.
.sp 1m
.ne 10
.
.LP
.LG
.B nodev
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nodev()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
A dummy routine.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Nodev does nothing but return after setting an error bit in u_error. It is
most commonly used in the configuration table conf.c as a placeholder for a
device driver routine that it is erroneous to call (e.g. the read routine
for the line printer).
.sp 1m
.ne 10
.
.LP
.LG
.B nulldev
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
nulldev()
.sp 1n
.
.LP
.I RETURNS
.
.LP
Always zero.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
A dummy routine.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Nulldev does nothing but return. It is most commonly used in the
configuration table conf.c as a placeholder for a device driver routine
that should be ignored (e.g. an open routine for a device that does not
require any special open processing).
.sp 1m
.ne 10
.
.LP
.LG
.B passc
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
passc (char)
.br
int char;
.sp 1n
.
.LP
.I RETURNS
.
.LP
Zero when the character has been passed; a -1 on error or the completion of
a read request.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Places a single character into the requester's I/O buffer during processing
of a read system call.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
During processing of a read system call, passc is used to move a single
character "char" from the system I/O area to the requester's I/O buffer
(u_base). In performing this duty, passc must know whether the requester's
buffer is in system or user space (as determined by u_segflg). After moving
the character, the file offset (u_offset) and address of the I/O buffer
(u_base) are increased by one and the number of bytes requested by the read
system call (u_count) is decreased by one. A return value of zero indicates
that the character was successfully passed. A -1 return indicates that the
read system call byte count was satisfied by the character just passed or
that an error occurred passing the character. In the latter case, an error
bit is set in u_error.
