.hpf hyphen.local
.P1
.de PT
.tl 'SIG01 - SIGNAL'\*[CH]'PD-1C301-01'
.tl 'File: sig.c''Section 13'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B core
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
core()
.sp 1n
.
.LP
.I RETURNS
.
.LP
A one is returned if a core image is successfully produced.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Produces a core image as a result of the standard system action on
reception of certain signals.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
For program debugging purposes, it is convenient to have a system function
which makes a copy of an aborted process in a file. The format of a UNIX
core image is simply the 1024 byte U block followed by the data and stack
areas. For non-reentrant processes the data area contains the text, data
and bss areas however, for reentrant processes, the text is not included.
The DB and CDB commands under UNIX can examine these images post mortem as
an aid in debugging. The U block will contain the general purpose registers
(including virtual PC) so that all information about the state of the
program when it aborted is known.
.
.LP
All core images are produced in a file "core" in the working directory of
the aborted process. The sig.c/core function essentially simulates a create
system call followed by two writes into the file. The steps in the
produciion of the core image are as follows,
.IP 1. 3
A search is made to see if a file named "core" already exists in the
working directory of the process. The nami.c/nami function performs this
service. The file name "core" is passed to nami.c/nami by setting up
"u_dirp". (Normal-ly the trap handler sets up "u_dirp" for open, create,
link, etc. system calls.) The address of a special routine used by
nami.c/nami to fetch the string name (nami.c/schar) must be passed as an
argument to nami.c/nami. If any errors occur due to conflicts in access
permissions on an existing "core" file or if directory permissions are not
correct, the core image is aborted.
.IP 2. 3
If the file does not already exist, then an inode is allocated for it and
given read/write by all access permissions (0666).
.IP 3. 3
For an existing file with the name "core", the access permissions for the
file must be checked to see if writing is allowed (fio.c/access). There are
some serious bugs in the access checking setup for producing core images.
For the super user, access privileges are ignored so that any directory
named "core" could be overwritten.
.IP 4. 3
Once a file has been established and access granted, the file is truncated
(iget.c/itrunc).
.IP 5. 3
The U block is then written out by setting up parameters for the
rdwri.c/writei function. The file offset "u_offset" is set to zero, the
address ("u_base") where the transfer is to begin is set to the address of
the U block (0140000). "U_count" is set to the size, in bytes, of the U
block and finally a flag, "u_segflg" is set to indicate to rdwri.c/writei
that the data is within the operating system's virtual address space. (The
core image is actually produced by the terminated process. The mechanism is
such that when a process determines that there is a signal pending for
which a core image is required, it produces the core image itself before
making itself a ZOMBIE).
.IP 3. 3
The data and stack area are written into the file "core" by reloading the
User Memory Management registers s6 that they are set up as if the entire  
program was only data. (Main.c/estabur is called to setup the prototype
Memory Management registers. It calls main.c/sureg to actually load the
hardware registers.) "U_base" is set to the address (0) in the user's
virtual address space where the transfer is to begin, "u_count" is set to
the size in bytes to be written and "u_segflg" is set to zero to indicate
(to rdwri.c/writei) that the write is to occur on data located in the
user's virtual address space.
.
.LP
When the core image has been produced the inode for the "core" file updated
on the filesystern (iget.c/iput). Any errors occurring in the write
procedure above will result in only part of the core image being written
out. A successful core image is indicated by sig.c/core returning zero (to
sig.c/psig).
.sp 1m
.ne 10
.
.LP
.LG
.B issig
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
issig 0
.sp 1n
.
.LP
.I RETURNS
.
.LP
A 1 is returned if a signal has been sent to a process and some action by
the system or the user is required.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Determines whether a signal requiring action is pending for the currently
running process.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Processing of signals only occurs when the process that is sent a signal
determines that a signal is pending. Sig.c/issig is used to make this
check. Signals are posted in the "p_sig" entry of each Process Table entry.
If the entry is nonzero, a signal is pending and the value in "p_sig" is
the signal number. This is used as an index into the Signal Table
("u_signal[]") of the Per Process information area (U block). There is one
entry in this array for each possible signal and the value of the entry
determines what action is to be taken. An odd value in the table indicates
that the signal is to be ignored. Nonzero even values indicate that some
action is to be taken by the user process, while zero entries indicated
that the standard system action is to be taken.
.sp 1m
.ne 10
.
.LP
.LG
.B psig
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
psig()
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Signal processor.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Signals may be ignored or caught by a user process, or the standard system
action may be taken. The Signal Table, "u_signal[]" in the user Per Process
information area (U block) determines what the action for a particular
signal is to be. There is one entry in the "u_signal[]" array for each of
the 20 possible signals. A zero in an entry indicates that the standard
system action is to be taken, while an odd value indicates that the signal
is to be ignored. Any even value indicates that the user process is to
handle the signal and is the virtual address of a jump table in the signal
library function in the program. This jump table contains the address of
the function within the user's program to be executed when a particular
signal is received. The transfer is made through an intermediate jump table
in the user's library function so that the general purpose registers may be
saved and restored on the user's stack. In order to provide for the
continued execution of a program once the user's process has handled the
signal, there is a mechanism for returning the process to normal execution.
This is done by having sig.c/psig adjust the user's stack so that the
library functions can execute an RTT instruction. In summary, signal
processing is done as follows:
.IP 1. 3
The signal is reset (0) so that the standard system action will be taken on
the next occurrence of the same signal.
.IP 2. 3
The Program Counter and Stack Pointer, saved when the user process made a
system call, is placed on the user's stack. This is done so that when the
signal library function within the user's program has done it's work, a
return can be made to the system call that was aborted (via a RTT executed
in the user's signal library interface function). It is unfortunate that
the aborted system call is not restarted, so that some arrangement is
necessary to check that the system call was completed.
.IP 3. 3
The Program Counter saved on the stack frame is set to the value in the
appropriate Signal Table ("u_signal") entry. This is the address of a table
in the user's library interface to the signal system call and is
essentially a jump table for calling the user's signal handler.
.
.LP
The standard system action on reception of the following signaliiis to
produce a core image in the working directory of the process receiving the
signal.
.IP 1. 4
Quit
.IP 2. 4
Illegal Instruction
.IP 3. 4
Trace Trap
.IP 4. 4
IOT Instruction
.IP 5. 4
EMT Instruction
.IP 6. 4
Floating Point Exception
.IP 8. 4
Bus Error
.IP 9. 4
Segmentation Violation
.IP 10. 4
Bad System Call
.
.LP
The remaining signals, Hangup, Interrupt, Kill, and that are undefined do
not produce a core image as a standard system action, but cause, the
termination of the process.
.
.LP
Before the process is terminated, the lower 8 bits of the user process
register R0 and the type of signal received are saved in the "u_arg[0]"
entry of the U block, so that they may be found by the parent of the
terminated child. The truncated value of R0 is placed in the high byte and
the signal number in the lower byte. A successful core image is indicated
by having the high order bit in the signal byte set.
.
.LP
Determining whether a signal is pending is done at three significant points
within the system.
.IP 1. 3
On every return from a system call, sig.c/issig is called. This checks to
see if a signal is pending for active (executable) processes within the
system.
.IP 2. 3
For processes that will roadblock at a low priority (WAIT priority), a
check is made before and after the process is roadblocked to see whether a
signal is pending. This is done because the interval that the process is
roadblocked may be long, and because some of the system calls (notably wait
and sleep) will continuously roadblock a process until the desired event
has occurred. By making the check a standard part of this loop the signal
can be processed and the system call aborted if needed. This will result in
either the standard system action (termination of the process) being taken,
or preparation for allowing the user to handle the signal. If the user is
to process the signal, the system call is aborted. and a nonlocal goto
(mch.s/aretu) to the trap handler is done after the signal catcher in the
user's process is set up.
.IP 3. 3
The last check is made in the clock interrupt handler (clock.c/clock), when
it preempts CPU bound processes. This must be done to insure that CPU bound
processes (which never make system calls) can be terminated by a signal
(usually quit, interrupt or a kill sent by the kill system call).
.sp 1m
.ne 10
.
.LP
.LG
.B psignal
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
psignal(p, sig)
.br
struct proc *p;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sends the signal "sig" to process up".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Signal sending does not result in any immediate action. Rather, the signal
number("sig") is posted in the Process Table entry for that process
("psig") the process. This number is used as an index into a table in the U
block for that process ("u_signal[]"), which contains the appropriate
action to be taken for each signal.
.
.LP
Processes that are roadblocked at low software priority must be notified
that a signal is pending as the event which they are waiting for may never
occur. No wakeup is sent to the process, since the location of the process
in the Process Table (argument "p") is known ("u_uprocp" in the U block).
The process need only be made ready ("p_stat" = SRUN) and the event for
which the process was roadblocked ("p_wchan") is zeroed. A situation may
exist where there are no ready processes in memory and the process that was
awakened is resident on the swap area. The Scheduler is awakened in this
case. (The Scheduler would be roadblocked with the external variable
"runout" set to a nonzero value, if there were no ready processes in
memory.)
.sp 1m
.ne 10
.
.LP
.LG
.B signal
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
signal(tp, sig)
.br
struct tty *y$tp;
.sp 1n
.
.LP
.I RETURNS
.
.LP
No value is returned.
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Sends the signal "sig" to all processes whose controlling teletype is "tp".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Most processes spawned under UNIX are generated as a result of action at a
user's teletype. The teletype is made the controlling teletype for these
processes and has the ability to terminate these processes when either the
special characters quit or interrupt is sent by the teletype. The
sig.c/signal function is used by the teletype I/O subsystem to send the
quit and interrupt signals generated by a user at his controlling teletype
to all of the processes having that teletype as it's controlling teletype.
Since each Process Table entry contains a pointer "p_ttyp" to the
controlling teletype, the Process Table need only be scanned and all
entries having "tp" (a pointer to the teletype) as the controlling teletype
are sent (by calling sig.c/psignal) the signal "sig".
