.hpf hyphen.local
.P1
.de PT
.tl 'RDWRI01 - READ/WRITE I-NODE'\*[CH]'PD-1C301-01'
.tl 'File: rdwri.c''Section 12'
.tl '''Issue 1, January 1976'
..
.2C
.ne 10
.
.LP
.LG
.B iomove
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
iomove (bp, o, an, flag)
.br
struct buf *bp;
.br
int o, an, flag;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
lomove moves an bytes from the byte poSition "o" in the buffer pointed to
by "bp" to the users area according to "flag" (READ means from the pool to
users area; WRITE means from the users area to the pool).
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Iomove uses information in the per user control block. The variables are:
.IP u_base 10
core address of user's I/O buffer
.IP uoffset 10
byte position into the file
.IP u_count 10
number of bytes to be read/written
.IP u_segflg 10
flag for I/O; user or kernel space
.
.LP
If the source address; destination address, and count are all even in a
copy to user's space; then mch.s/copyin or mch.s/copyout is used to move
words.
.
.LP
If the addresses are not even, then subr.c/cpass or subr.c/passc are used
to move a byte at a time. The copying takes place from u_base to the buffer
pool address "bp" plus the offset "o" for "an" bytes.
.
.LP
If either copy operation fails, an error indicator EFAULT is set in the per
user control block error code (u.u_error).
.
.LP
The base pointer, u_base, is incremented by "an". The count, u_count, is
decrernented by "an".
.sp 1m
.ne 10
.
.LP
.LG
.B max
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
max (a,b)
.br
char *a, *b;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The maximum of "a" or "b".
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Return the logical maximum of two arguments "a" and "b".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Compare "a" and "b" and return the maximum.
.sp 1m
.ne 10
.
.LP
.LG
.B min
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
min(a,b)
.br
char *a, *b;
.sp 1n
.
.LP
.I RETURNS
.
.LP
The minimum of "a" or "b".
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Return the logical minimum of two arguments "a" and "b".
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Compare "a" and "b" and return the minimum.
.sp 1m
.ne 10
.
.LP
.LG
.B readi
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
readi (aip)
.br
struct inode *aip;
.sp 1n
.
.LP
.I RETURNS
.
.LP
None
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Read the file associated with the i-node pointed to by "aip". Companion
routine with writei. Both are the workhorses for file system I/O.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Readi uses information in the per user control block to help read the file
associated with the inode pointed to by "aip". The variables are:
.IP u_base 10
core address of user's I10 buffer
.IP u_offset 10
byte position into the file
.IP u_count 10
number of bytes to be read
.IP u_segfig 10
flag for I/O; user or kernel space
.
.LP
Because the offset is a 24 bit number, readi calls many auxiliary functions
to handle the arithmetic. Readi will read into a buffer from the buffer
pool, 512 bytes at a time, starting at u_offset within the file pointed to
"aip". U_count bytes are moved from the buffer pool into the user area
pointed to by u_base.
.
.LP
UNIX block I/O is read or written in multiples of 512 (one block) bytes. If
u_count is less then 512 only one block 'need be read. If u_count is not a
multiple of 512 bytes, the correct byte position within a block must be
located. If u_count plus u_offset is greater than the size of the file, all
data to the end of file must be read.
.
.LP
The i-node is first marked for updating the last-accessed time. If the
i-node is a character special file (device) then the appropriate device
read routine will be switched to using the major device number found in the
first address entry of the i-node.
.
.LP
If the offset is greater than the size of the file then the file is
position to the end-of-file and readi returns.
.
.LP
In reading block special files, readi maintains a read ahead protocol that
saves the next block number and does a read ahead.
.
.LP
The algorithm is to do repeated reads of blocks and moves to the user's
area until u_count bytes have been read.
.
.LP
Subr.c/bmap is called to get a buffer from the buffer pool. Bio.c/bread is
called to read the required block. Rdwri.c/iomove is called to move data
(either the entire block or some portion) into the buffer pointed to by
u_base. Bio.c/brelse is called to release the buffer back to the pool.
.sp 1m
.ne 10
.
.LP
.LG
.B writei
.SM
.sp 1n
.
.LP
.I CALL
.
.LP
writei (aip) struct inode *aip;
.ne 4
.sp 1n
.
.LP
.I SYNOPSIS
.
.LP
Write the file associated with the i-node pointed to by "aip". Companion
routine to readi. Both are the workhorses for file system I/O.
.ne 4
.sp 1n
.
.LP
.I DESCRIPTION
.
.LP
Writei uses information in the per user control block to help write the
file associated with the inode pointed to by "aip". The variables are:
.IP u_base 10
core address of user's I/O buffer
.IP u_offset 10
byte position into the file
.IP mount 10
number of bytes to be written
.IP u_segflg 10
flag for I/O; user of kernel space
.
.LP
Writei will move u_count bytes from the user's program at u_base to buffers
in the buffer pool. It will then write the buffers to the file pointed to
by "aip" at the position u_offset. Since UNIX I/O is block oriented, data
is written in multiples of 512 bytes. If u_offset is less than the size of
the file, then part of the file is being overwritten. The block at u offset
must then be read, the appropriate bytes replaced and the block rewritten.
.
.LP
If the file is positioned at the end-of-file, new blocks must be allocated
and written.
.
.LP
The i-node is first marked to update the last-accessed and last-modified
times. If the i-node is a character special file (device) then the
appropriate device write routine will be switched to using the major device
number found in the first address entry of the i-node.
.
.LP
The block containing the offset is read into a buffer from the buffer pool.
The minimum (N) of the number of bytes remaining in the block or the
u_count is obtained. If this minimum is exactly 512 bytes a new block must
be obtained. In either case, rdwri.c/iomove is called to move N bytes from
the user area to the buffer obtained from the buffer pool by calling
subr.c/bmap. Bio.c/fwrite is called to write the block. Bio.c/frele is
called to release the buffer.
.
.LP
If the size of the .file is less than the offset then the size is set to
tie new offset value. This is repeated until u_count bytes have been
written.
