.de hd
'sp 1
.tl ''- % -''
'sp 2
..
.de ft
'bp
..
.po 6
.lt 85
.ll 85
.pl 12i
.in 0
.nh
.ce 3
.ul
THE UNSW UNIX M6800 ASSEMBLER REFERENCE MANUAL
.sp 2
P.C. Maxwell
.sp
.ul
DEPARTMENT OF COMPUTER SCIENCE
.wh 0 hd
.wh -1i ft
.sp 4
.in +4
.ti -4
.ul
1.  INTRODUCTION
.sp
The UNIX M6800 assembler is a two-pass assembler which assembles source
programs into Minibug loader format and produces a formatted listing.
The object code is produced on a file named m.out and the listing on m.lst.
.sp 2
.ti -4
.ul
2.  ASSEMBLER SOURCE STATEMENTS
.sp
A source program is composed of a sequence of statements.  A source
statement includes from zero to four fields.  From left to right, the four
fields are:
.sp
.ti +6
(1)  label (2)  operator (mnemonic) (3)  operand (4)  comment
.sp
The comment is optional, but may be used with any source statements.
.sp
Blank lines are also recognized by the assembler and printed as such on
the listing.  A label is required for some statements which are involved
with the definition of symbols and, in some cases, as the destinations
of branch and jump instructions.  An operand field may or may not be
present depending on the nature of the operator.  The successive fields
within a statement are separated by one or more tabs and/or spaces.
Except for the label field, which may appear on a line by itself, each
source statement must appear on a single line.
.sp
An asterisk (*) in the first character position of any line causes the
entire line to be treated as a comment.  Otherwise, the comment
will be preceded in the statement by one or more fields of the other three
types, and the comment will occupy the last field in the statement.
.sp 2
.ti -4
.ul
3.  LABELS
.sp
The following rules apply to labels:
.in +4
.sp
.ti -4
1.\ \ A label consists of from 1 to 7 alphanumeric characters (upper and
lower case are distinguished), or a single digit 0 - 9 inclusive
(these are temporary labels).
.sp
.ti -4
2.\ \ The first character of a label must be alphabetic, except temporary
labels.
.sp
.ti -4
3.\ \ A label must begin in the first character position of a statement.
.sp
.ti -4
4.\ \ All labels within a program must be unique (except for temporary labels
or if the program is segmented - see under SEG).
.sp
.ti -4
5.\ \ A label must not consist of any one of the single characters A or B.
(These characters are reserved for special syntax, and refer to
"accumulator A", "accumulator B".)
.sp
.ti -4
6.\ \ A label must not be any of the mnemonics that are used for
instructions or directives.
.sp
.ti -4
7.\ \ Labels may appear on a line by themselves.
.sp
.ti -4
8.\ \ Labels may optionally be followed immediately by a colon for ease
of reading.
.in -4
.sp
.ul
Temporary Labels
.sp
These consist of a single digit [0 - 9] and are used in branch/jump
instructions in association with the characters `f' and `b'.  Thus
.sp
.in +18
.ti -8
bra\ 2b\ \ branch to the first label `2' encountered
before this instruction.
.ti -8
jmp\ 3f\ \ jump to the first label `3' encountered
following this instruction.
.in -18
.sp
From these examples it is seen that temporary labels can be multiply defined.
.sp 2
.ul
.ti -4
4.  THE OPERATOR FIELD
.sp
The mnemonic operators recognised by the assembler include 72
.ul
executable instructions,
each of which is translated by the assembler into instructions of from one
to three bytes of machine code.  The remaining mnemonic operators are
.ul
assembler directives,
of which four (FCB, FCC, FDB and ZMB) are translated into one or more
bytes of machine code.  The other assembler directives control the overall
assembly process and are not translated individually into machine code.
All operators may be written in either upper or lower case and must not
start in the first character position.
.sp 2
.ul
.ti -4
5.  OPERAND
.sp
The assembler recognises numbers, symbols and expressions in the operand
field.  The number and symbol are a degenerate form of the expression.
.sp
.ul
The Expression Constituting the Operand Field
.sp
An expression is either a symbol, a number, or combination of symbols and
numbers being separated from one another by the arithmetic operators
(+, -, *, or /), blanks and parentheses.
.sp
Numbers may be decimal, octal, hexadecimal or binary, indicated as follows:
.sp
.ti +4
.ul
Decimal
\ \ -  no prefix or suffix  e.g.  17, 29, 350 etc.
.ti +4
.ul
Octal
\ \ -  prefix of o'  e.g.  o'4     4 decimal
.ti +35
o'17    15 decimal
.ti +35
o'19    illegal
.sp
.ti +4
.ul
Hexadecimal
\ \ -  prefix of x'  e.g.  x'10    16 decimal
.ti +41
x'A     10 decimal
.sp
.ti +4
.ul
Binary
\ \ -  prefix of b'  e.g.  b'1101    13 decimal
.sp 2
.ul
Note:
the upper and lower case versions of o', x', b' are recognised.
.sp 2
Symbols normally have the value of the corresponding label appearing
elsewhere in the program.  The excepting symbol is `*' which has the
value of the PC at the location where the * is used.
.sp
The assembler evaluates expressions algebraically with the following
operator precedence:
.sp 2
.ti +14
*  /     (highest)
.ti +14
+  -
.sp2
Any expression enclosed within parentheses is evaluated independently of
preceding or succeeding operators.
.sp
A fractional result, if obtained during the evaluation of an expression,
will be truncated to an integer value.
.sp
.ul
NOTE:
The use of expressions in the
source language does not imply any capability of the microprocessor to
evaluate those expressions, since the expressions are evaluated during
assembly and not during execution of the machine language program.
.sp 2
.ul
.ti -4
6.  ADDRESSING
.sp
Most addressing modes are implicit in the type of instruction used
(e.g. LDA A addresses the accumulator A; BRA is relative).  Some,
however, need specified indicators, as follows:
.sp 2
.ul
Immediate Addressing
.sp
This mode of addressing is selected by beginning the specification of
the corresponding operand with the character `%'.
.br
With the immediate mode of addressing, the operand field of the source
statement either contains the actual value of the operand, or it includes
a symbol or an expression which has, when fully evaluated, an algebraic
value equal to the value of the operand.  The operand may be specified
in accordance with any of the following formats:
.sp
.in +14
%Number
.br
%Symbol
.br
%Expression
.br
%'
.in -14
.sp
The first 3 are self explanatory (note that the value must be in the allowed
range
to be accommodated in 8 bits for all except X and SP, in which 16 bit numbers
are allowed).  In the last of the alternative forms, %', the apostrophe
instructs the assembler to translate the next character into the corresponding
7-bit ASCII code.  The ASCII code so obtained is then the value of the operand.
Bits 0\ -\ 6 are used, with bit 7 = 0.  Commonly used special characters
used in this form are provided for as follows:
.sp
.in +24
.ti -6
Use   \\n   for linefeed
.br
\\r       carriage return
.br
\\b       backspace
.br
\\t       tab
.br
\\s       space
.br
\\0       null
.sp
.in -24
Note that character constants may be used anywhere an expression or number
is allowed.  The above special character representations may also appear
in the FCC directive.
.sp 2
.ul
Relative Addressing
.sp
Because the offset is an 8-bit signed number, the address of the destination
is limited by
.sp
.ti +20
(* + 2) - 128  <=  D  <=  (* + 2) + 127
.sp
If a branch is desired outside these limits a jump instruction must be used.
If the branch length is not known, the following substitutions may be used:
.sp
.ti +20
JBR   instead of   BRA/JMP
.ti +20
JBS   instead of   BSR/JSR
.sp
in which case the assembler will insert the appropriate form.  The
same philosophy applies to conditional branches, where `J' may be used
in place of `B' to give JEQ, JLS etc.  If the target is in range a direct
branch is inserted, otherwise the appropriate inverse branch over a jump
instruction will be generated.
.sp 2
.ul
Indexed Addressing
.sp
The data for obtaining the numerical address may be written in any of the
forms:
.sp
.in +20
()
.br
Number()
.br
Symbol()
.br
Expression()
.sp
.in -20
where the use of `()' indicates indexed addressing is to be used.  The
first form is equivalent to `0()' i.e. the operand address is the same
as the contents of the index register.  In all other cases
.sp
.ti +10
final address  =  value + contents of index register
.sp
where "value" is the 8-bit
.ul
unsigned
number obtained from evaluating
the "expression", "symbol" or "number".  Allowable values are therefore
0\ -\ 255.
.sp 2
.ul
Direct and Extended Addressing
.sp
For those instructions which may use the direct mode of addressing as
well as the extended mode, the assembler selects the mode according to
the following rule: Direct addressing will be selected if the numerical
address is in the range from zero to 255 (treating the operand as
unsigned decimal), and will select extended addressing if the unsigned
numerical address exceeds 255 (decimal).  If the address is unknown
during pass one of the assembly, the extended mode will be selected.
This means the memory locations
.ul
must
be reserved
.ul
before
the start of the program, if direct addressing is desired.
.sp 2
.ul
.ti -4
7.  ASSEMBLER DIRECTIVES
.sp
The assembler directives allow the programmer control of the assembly
of the executable instructions into machine code, including control of
the allocation of memory, and assignment of values to data, when
applicable.  The assembler directives also provide for the control
of the format of the assembler output, and for user options.
.sp
A functional calssification of the assembler directives is given below:
.sp
.in +14
.ti -9
ORG\ \ \ :\ \ Assigns origin of program counter.  Its function is to
define the numerical address of the first byte of the subsequent portion
of the coded program.
.sp
.ti -9
EQU\ \ \ :\ \ Equates a symbol to a numerical value, another symbol
or an expressions.  The value of the operand may not be determined until
pass two of the assembly process.
.sp
.ti -9
FCB\ \ \ :\ \ Form Constant Byte.  FCB places the values of its operands
in the following bytes of code.
.sp
.ti -9
FCC\ \ \ :\ \ Form Constant Character.  FCC places the ASCII value of its
string operand into the code.
.sp
.ti -9
FDB\ \ \ :\ \ Form Double Byte.  FDB places the value of its operands in
the following two-byte groups.
.sp
.ti -9
RMB\ \ \ :\ \ The assembler reserves a number of bytes of code; the number
is determined by the RMB operand.
.sp
.ti -9
ZMB\ \ \ :\ \ The same as RMB except the locations are set to zero.
.sp
.ti -12
PAG, OPT\ :\ \ Concerned with options regarding source listings.
.sp
.ti -9
SEG\ \ \ :\ \ Used to segment the program.  The code following the
directive forms a new segment.
.sp
.ti -9
TXT\ \ \ :\ \ Used to include, at this point, another source file.
.sp 2
.in -14
.ul
FCC  Form Constant Characters
.sp
The "FCC" directive translates strings of characters into their 7-bit ASCII
codes.  The format is
.sp
.ti +20
FCC     /text/
.sp
If the actual text is required to include the slash character then `\\/'
should be used.  Thus:
.sp
.ti +20
FCC     /\\//
.sp
is translated into a single byte representing the ASCII code for /.
.sp 2
.ul
FDB (FCB)  Form Double (Constant) Byte
.sp
These directives may have one or more operands separated by commas.
A 16-bit (8 for FCB) signed binary number, corresponding to the value
of each operand is stored in two (one) bytes of the object program.
Negative operands are converted into 2's complement.  Characters are
inserted if preceded by ':
.sp
.ti +10
e.g.  FCB   -2, X'AB, 'a, '\\r
.sp
would result in FE, AB, 61, 0D.
.sp 2
.ul
ORG  Origin
.sp
This defines the numerical address of the first byte of machine code
which follows the ORG statement.  The operand field may be a number,
symbol or expression.  If no ORG statement appears at the start of a
program, the default setting of the PC is 0000.
.sp 2
.ul
SEG  Segment
.sp
The segmentation implemented in this assembler provides a means of
logically splitting the source program.  The boundaries between
multiple input files are not automatically assumed to be segment boundaries.
Segmentation is achieved by use of the directive SEG.  The first
character of the first (or only) file of a segmented program must be `#'.
This should be followed by the SEG directive.  In this first occurrence
only it is necessary to specify the segmentation character as follows:
.sp
.ti +10
either  a)  SEG -C
.ti +14
or  b)  SEG C
.sp
where C is an alphanumeric character (including `$' and `_').
.sp
.in +12
.ti -4
a)\ \ defines that all identifiers beginning with C are global and all
others local, and
.ti -4
b)\ \ defines that all identifiers beginning with C are local and all others
global.
.in -12
.sp
Subsequent SEG calls effectively clear the symbol table of all local symbols.
This means the same local symbols may be used in more than one program
segment (refer point 4 under rules for labels).  Subject to certain
selectable options (see below), the listing will contain a local symbol
table at the end of each segment.
.sp
In a segmented program it is illegal to use an identifier consisting solely
of the segmentation character.
.sp
There is no restriction on jumping over segment boundaries even to temporary
labels.
.sp 2
.ul
PAG  Page
.sp
This command produces a form feed to a new page on the source listing.
.sp 2
.ul
OPT  Options
.sp
The following format statements (in upper or lower case) are recognised after
the OPT directive:
.sp
.in +12
.ti -8
FCCOFF\ \ limits the listing of the code generated by the FCC directive
to one line only (this is the default setting).
.sp
.ti -8
FCCON\ \ \ causes the full code generated by FCC directives to be listed.
.sp
.ti -8
SYMOFF\ \ suppresses the printing of all subsequent symbol tables (if any).
.sp
.ti -8
SYMON\ \ \ causes any subsequent symbol tables to be printed.
.sp
.in -12
Because a local symbol table is generated at the end of each segment
and a global symbol table at the end of the listing, the ability to
switch the listing of symbol tables on and off is not superfluous.
.sp 2
.ti -4
.ul
8.  LIMITS
.sp
The following limits apply to the assembler:
.sp
.ti +8
Symbol table   600 symbols
.sp
.ti +8
Line length    132 characters.
.sp 2
.ti -4
.ul
9.  USAGE
.sp
The assembler should be called as follows:
.sp
.ti +6
mas [-o[jack]] [-l[fred]] file [more files]
.sp
The assembler will assemble the concatenation of the given files as though
they were one file.  The -o and -l flags operate as follows:
.sp
.in +30
.ti -24
none present (default)  object code written to a file `m.out';
no listing is produced.
.sp
.ti -24
-l\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ as above for object code but a listing is
produced on a file `m.lst'.
.sp
.ti -24
-lfred\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ as for -l but m.lst is renamed `fred'.
.sp
.ti -24
-ojack\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ m.out is renamed `jack'.
.sp
.ti -24
-o\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ no object code is created.
.sp 2
.in -30
.ul
.ti -4
10.  DIAGNOSTICS
.sp
When syntactic or semantic errors occur, a self-explanatory error message
is output indicating the line-number and file in which the error occurred.
Errors in pass 1 cause the cancellation of pass 2.
.sp
The only errors that are detected in pass 2 are undefined symbols and
branch instructions whose targets are out of range.  If either of these
errors occurs, the listing and object files are still produced.
.sp
For undefined symbols, a `U' appears in column 1 of the listing against
each reference to the symbol.  The error is also indicated in the
symbol table, if any.  The value of an undefined symbol is taken to be zero.
.sp
For out-of-range branch instructions a `B' appears in column 1, and a
zero relative address is generated.
.sp
Symbol table overflow is indicated by a message.
.ti -4
.sp 3
.ul
APPENDIX  -  USE OF THE ASSEMBLER WITH THE 6800
.sp
Having successfully completed an assembly, the following sequence of
events is necessary to ensure satisfactory loading of the 6800 memory:
.sp
.in +10
.ti -4
1.\ \ Reset the processor.
.sp
.ti -4
2.\ \ Initiate the command `cat m.out' to Unix.
.sp
.ti -4
3.\ \ After the file has been listed, switch the terminal to port 2
(it is now connected to the 6800).
.sp
.ti -4
4.\ \ Enter `s9' on the keyboard.  If the program was successfully loaded
the s9 is not echoed and the `*' prompt appears.  An unsuccessful loading
results in the s9 being echoed (typically due to an incorrect ORG statement).
.sp
.ti -4
5.\ \ Commence execution of the program using the `G' command.
