/*
 * Structure of the super-block
 */
struct	filsys
{
	unsigned short s_isize;	/* size in blocks of i-list */
	daddr_t	s_fsize;   	/* size in blocks of entire volume */
	short  	s_nfree;   	/* number of addresses in s_free */
	daddr_t	s_free[NICFREE];/* free block list */
	short  	s_ninode;  	/* number of i-nodes in s_inode */
	ino_t  	s_inode[NICINOD];/* free i-node list */
	char   	s_flock;   	/* lock during free list manipulation */
	char   	s_ilock;   	/* lock during i-list manipulation */
	char   	s_fmod;    	/* super block modified flag */
	char   	s_ronly;   	/* mounted read-only flag */
	time_t 	s_time;    	/* last super block update */
	daddr_t	s_tfree;   	/* total free blocks*/
	ino_t  	s_tinode;  	/* total free inodes */
	short  	s_m;       	/* interleave factor */
	short  	s_n;		/* sectors per cylinder */
	/* remainder not maintained by this version of the system */
	char   	s_fname[6];	/* file system name */
	char   	s_fpack[6];	/* file system pack name */
	char	s_pad[72];	/* pad up to BSIZE bytes */
};

/*
 * flock/ilock codes
 */
#define	S_BUSY		01	/* locked */
#define	S_WANTED	02	/* someone is waiting for unlock */
