/ low core

.data
.globl	ZERO		/ globl'd to enable initial load from lib0
ZERO:

br4 = 200
br5 = 240
br6 = 300
br7 = 340

. = ZERO+0
.globl	start
	trap; br7+15.	/ in case of bad trap through 0

/ trap vectors
	trap; br7+0.		/ bus error
	trap; br7+1.		/ illegal instruction
	trap; br7+2.		/ bpt-trace trap
	trap; br7+3.		/ iot trap
	trap; br7+4.		/ power fail
	trap; br7+5.		/ emulator trap
	start;br7+6.		/ system  (overlaid by 'trap')

. = ZERO+44
.globl	dump
	jmp	*$dump		/ take a core dump


. = ZERO+60
	klin; br4
	klou; br4

. = ZERO+100
	kwlp; br6
	kwlp; br6

. = ZERO+114
	trap; br7+10.		/ 11/70 parity

. = ZERO+200
	lpou; br4

. = ZERO+224
	htio; br5

. = ZERO+230
	crin; br4

. = ZERO+240
	trap; br7+7.		/ programmed interrupt
	trap; br7+8.		/ floating point
	trap; br7+9.		/ segmentation violation

. = ZERO+254
	hpio; br5

/ floating vectors
. = ZERO+300
	dpin; br6
	dpou; br6

. = ZERO+310
	bfin; br5
	bfou; br5

. = ZERO+320
	dzin; br5+0.
	dzou; br5+0.
	dzin; br5+1.
	dzou; br5+1.
	dzin; br5+2.
	dzou; br5+2.
	dzin; br5+3.
	dzou; br5+3.
	dzin; br5+4.
	dzou; br5+4.

//////////////////////////////////////////////////////
/		interface code to C
//////////////////////////////////////////////////////

.text
.globl	call, trap

.globl	_klrint
klin:	jsr	r0,call; jmp _klrint
.globl	_klxint
klou:	jsr	r0,call; jmp _klxint

.globl	_clock
kwlp:	jsr	r0,call; jmp _clock


.globl	_htintr
htio:	jsr	r0,call; jmp _htintr

.globl	_crint
crin:	jsr	r0,call; jmp _crint

.globl	_hpintr
hpio:	jsr	r0,call; jmp _hpintr

.globl	_dzrint
dzin:	jsr	r0,call; jmp _dzrint
.globl	_dzxint
dzou:	jsr	r0,call; jmp _dzxint

.globl	_lpint
lpou:	jsr	r0,call; jmp _lpint

.globl	_bfirint
bfin:	jsr	r0,call; jmp _bfirint
.globl	_bfixint
bfou:	jsr	r0,call; jmp _bfixint

.globl	_eirint
dpin:	jsr	r0,call; jmp _eirint
.globl	_eixint
dpou:	jsr	r0,call; jmp _eixint
